/*
 * Decompiled with CFR 0.152.
 */
package de._4geeks.robots.movement.buffers;

import de._4geeks.robots.movement.manager.SurferWave;
import de._4geeks.robots.utils.Pair;
import de._4geeks.robots.utils.SUtils;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import robocode.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SurferFlattener {
    private static final double HISTORY = 10.0;
    private double[][][][][] stats1;
    private double[][][][] stats2;
    private double[][][][] stats3;
    private double[][][] stats4;
    private double[] unseg;
    private int bins;
    private double[] LATERAL_SEG = new double[]{-4.5, -1.5, 1.5, 4.5};
    private double[] ADV_SEG = new double[]{-4.5, -1.5, 1.5, 4.5};
    private double[] DIST_SEG = new double[]{100.0, 200.0, 400.0};
    private double[] DCHANGE_SEG = new double[]{5.0, 10.0, 25.0, 50.0};
    private double[] WALL_SEG = new double[]{70.0, 100.0, 200.0};
    private double[] ACC_SEG = new double[]{-0.5, 0.5};

    public SurferFlattener(int bins) {
        this.bins = bins;
        this.stats1 = new double[this.LATERAL_SEG.length + 1][this.ADV_SEG.length + 1][this.DIST_SEG.length + 1][this.DCHANGE_SEG.length + 1][bins];
        this.stats2 = new double[this.LATERAL_SEG.length + 1][this.DIST_SEG.length + 1][this.WALL_SEG.length + 1][bins];
        this.stats3 = new double[this.LATERAL_SEG.length + 1][this.DIST_SEG.length + 1][this.ACC_SEG.length + 1][bins];
        this.stats4 = new double[this.LATERAL_SEG.length + 1][this.DIST_SEG.length + 1][bins];
        this.unseg = new double[bins];
    }

    public void logHit(SurferWave wave, Point2D.Double loc) {
        int lslice = SUtils.indexSlice(this.LATERAL_SEG, wave.scan.lateralVelocity);
        int aslice = SUtils.indexSlice(this.ADV_SEG, wave.scan.advancingVelocity);
        int dslice = SUtils.indexSlice(this.DIST_SEG, wave.scan.distance);
        int cslice = SUtils.indexSlice(this.DCHANGE_SEG, wave.scan.timeSinceDirChange);
        int wslice = SUtils.indexSlice(this.WALL_SEG, wave.scan.wallDistance);
        int accslice = SUtils.indexSlice(this.ACC_SEG, wave.scan.acceleration);
        int index = this.getFactorIndex(wave, loc);
        int i = 0;
        while (i < this.bins) {
            this.stats1[lslice][aslice][dslice][cslice][i] = SUtils.rollingAvg(this.stats1[lslice][aslice][dslice][cslice][i], 1.0 / (Math.pow(index - i, 2.0) + 1.0), 10.0, 1.0);
            this.stats2[lslice][dslice][wslice][i] = SUtils.rollingAvg(this.stats2[lslice][dslice][wslice][i], 1.0 / (Math.pow(index - i, 2.0) + 1.0), 10.0, 1.0);
            this.stats3[lslice][dslice][accslice][i] = SUtils.rollingAvg(this.stats2[lslice][dslice][accslice][i], 1.0 / (Math.pow(index - i, 2.0) + 1.0), 10.0, 1.0);
            this.stats4[lslice][dslice][i] = SUtils.rollingAvg(this.stats4[lslice][dslice][i], 1.0 / (Math.pow(index - i, 2.0) + 1.0), 10.0, 1.0);
            this.unseg[i] = SUtils.rollingAvg(this.unseg[i], 1.0 / (Math.pow(index - i, 2.0) + 1.0), 10.0, 1.0);
            ++i;
        }
    }

    public double[] getStats(SurferWave wave) {
        int lslice = SUtils.indexSlice(this.LATERAL_SEG, wave.scan.lateralVelocity);
        int aslice = SUtils.indexSlice(this.ADV_SEG, wave.scan.advancingVelocity);
        int dslice = SUtils.indexSlice(this.DIST_SEG, wave.scan.distance);
        int cslice = SUtils.indexSlice(this.DCHANGE_SEG, wave.scan.timeSinceDirChange);
        return this.stats1[lslice][aslice][dslice][cslice];
    }

    public void getDanger(Pair<SurferWave> wave, ArrayList<Point2D.Double> positions, double[] dangerP) {
        int lslice = SUtils.indexSlice(this.LATERAL_SEG, ((SurferWave)wave.item).scan.lateralVelocity);
        int aslice = SUtils.indexSlice(this.ADV_SEG, ((SurferWave)wave.item).scan.advancingVelocity);
        int dslice = SUtils.indexSlice(this.DIST_SEG, ((SurferWave)wave.item).scan.distance);
        int cslice = SUtils.indexSlice(this.DCHANGE_SEG, ((SurferWave)wave.item).scan.timeSinceDirChange);
        int wslice = SUtils.indexSlice(this.WALL_SEG, ((SurferWave)wave.item).scan.wallDistance);
        int accslice = SUtils.indexSlice(this.ACC_SEG, ((SurferWave)wave.item).scan.acceleration);
        int i = 0;
        while (i < dangerP.length) {
            int index = this.getFactorIndex((SurferWave)wave.item, positions.get(i));
            int n = i;
            dangerP[n] = dangerP[n] + 1.0 / wave.val * this.stats1[lslice][aslice][dslice][cslice][index];
            int n2 = i;
            dangerP[n2] = dangerP[n2] + 1.0 / wave.val * this.stats2[lslice][dslice][wslice][index];
            int n3 = i;
            dangerP[n3] = dangerP[n3] + 1.0 / wave.val * this.stats3[lslice][dslice][accslice][index];
            int n4 = i;
            dangerP[n4] = dangerP[n4] + 1.0 / wave.val * this.stats4[lslice][dslice][index];
            int n5 = i++;
            dangerP[n5] = dangerP[n5] + 1.0 / wave.val * this.unseg[index];
        }
    }

    public int getFactorIndex(SurferWave ew, Point2D.Double targetLocation) {
        double offsetAngle = SUtils.absoluteBearing(ew.fireLocation, targetLocation) - ew.scan.absBearing + Math.PI;
        double factor = Utils.normalRelativeAngle((double)offsetAngle) / SUtils.maxEscapeAngle(ew.bulletVelocity) * (double)ew.scan.direction;
        return (int)SUtils.limit(factor * (double)((this.bins - 1) / 2) + (double)((this.bins - 1) / 2), 0.0, this.bins - 1);
    }
}

