/*
 * Decompiled with CFR 0.152.
 */
package catcat20.core.gun.perceptual;

import ags.utils.dataStructures.trees.thirdGenKD.DistanceFunction;
import ags.utils.dataStructures.trees.thirdGenKD.KdTree;
import ags.utils.dataStructures.trees.thirdGenKD.NearestNeighborIterator;
import ags.utils.dataStructures.trees.thirdGenKD.WeightedManhattanDistanceFunction;
import catcat20.core.bot.Bot;
import catcat20.core.gun.Gun;
import catcat20.core.gun.waveGun.GunWave;
import catcat20.core.radar.Radar;
import catcat20.core.utils.LConstants;
import catcat20.core.utils.LUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import robocode.RoundEndedEvent;
import robocode.TeamRobot;

public class AntiSurferFirstShot
extends Gun {
    public static KdTree<Double> tree;
    public static DistanceFunction distanceFunction;
    public static double[] weights;
    public GunWave lastWave;

    public AntiSurferFirstShot(TeamRobot _robot) {
        super(_robot);
        weights = new double[]{6.952372047333122, 1.0475256192360582, 2.05437116741384, 7.709552510787828, 5.067102659281984, 3.8884332820273197, 3.629674519941239, 7.28027977815246};
        tree = new KdTree(8);
        distanceFunction = new WeightedManhattanDistanceFunction(weights);
        double precise = 100.0;
        for (int i = 0; i < GFs.guessFactors.length; ++i) {
            double[] dataPoint = new double[]{BFTs.bfts[i] / precise, LVs.latVels[i] / precise, Accels.accels[i] / precise, DCTs.dirChangeTimes[i] / precise, DLs.dist16Lasts[i] / precise, WDs.wallDistances[i] / precise, RWDs.revWallDistances[i] / precise, Ticks.ticks[i] / precise / 120.0};
            tree.addPoint(dataPoint, (Object)(GFs.guessFactors[i] / precise));
        }
    }

    public double[] dataPoint(GunWave w) {
        double distance = w.myState.distance(w.enState.x, w.enState.y);
        double latVel = Bot.lateralVelocity(w.myState, w.enState);
        double oldLatVel = Bot.lateralVelocity(w.oldMyState, w.oldEnState);
        double accel = LUtils.accel(latVel, oldLatVel);
        Point2D.Double enPos = new Point2D.Double(w.enState.x, w.enState.y);
        Point2D.Double myPos = new Point2D.Double(w.myState.x, w.myState.y);
        double wallDistance = this.orbitalWallDistance(enPos, myPos, w.bulletPower, LUtils.sign(latVel));
        double revWallDistance = this.orbitalWallDistance(enPos, myPos, w.bulletPower, -LUtils.sign(latVel));
        return new double[]{distance / w.bulletVelocity / 91.0, (latVel + 8.0) / 16.0, (accel + 1.0) / 3.0, LUtils.limit(0.0, w.dirChangeTime / 4.0, 30.0) / 30.0, w.dist16 / 128.0, wallDistance / 2.0, revWallDistance / 2.0, (double)w.fireTime / 120.0};
    }

    public double orbitalWallDistance(Point2D.Double sourceLocation, Point2D.Double targetLocation, double bulletPower, int direction) {
        double absBearing = LUtils.absoluteBearing(sourceLocation, targetLocation);
        double distance = sourceLocation.distance(targetLocation);
        double maxEscapeAngle = Math.asin(8.0 / (20.0 - 3.0 * bulletPower));
        double wallDistance = 2.0;
        for (int x = 0; x < 200; ++x) {
            if (LConstants.field.contains(sourceLocation.x + Math.sin(absBearing + (double)direction * ((double)x / 100.0) * maxEscapeAngle) * distance, sourceLocation.y + Math.cos(absBearing + (double)direction * ((double)x / 100.0) * maxEscapeAngle) * distance)) continue;
            wallDistance = (double)x / 100.0;
            break;
        }
        return wallDistance;
    }

    @Override
    public void init() {
    }

    @Override
    public void execute() {
    }

    @Override
    public void onRoundEnded(RoundEndedEvent e) {
    }

    @Override
    public double getAngle(double power) {
        Point2D.Double _myPos = new Point2D.Double(this._robot.getX(), this._robot.getY());
        Bot en = Radar.nearestBot;
        if (this.lastWave != null && en != null && en.currentState != null && en.isAlive) {
            double[] dataPoint = this.dataPoint(this.lastWave);
            int k = (int)LUtils.limit(1.0, Math.sqrt(tree.size()), 64.0);
            NearestNeighborIterator<Double> nearestNeighborIterator = tree.getNearestNeighborIterator(dataPoint, k, distanceFunction);
            double absBearing = LUtils.absoluteBearing(_myPos.x, _myPos.y, en.currentState.x, en.currentState.y);
            Graphics2D g = this._robot.getGraphics();
            ArrayList<Angle> angles = new ArrayList<Angle>();
            for (Double data : nearestNeighborIterator) {
                Angle angle = new Angle();
                angle.angle = LUtils.limit(-1.1, data, 1.1) * LUtils.maxEscapeAngle(this.lastWave.bulletVelocity) * (double)LUtils.sign(this.lastWave.direction);
                angle.weight = 1.0 / nearestNeighborIterator.distance();
                angles.add(angle);
                g.setColor(new Color(1.0f, 1.0f, 0.0f, 0.35f));
                Point2D.Double pos = LUtils.project(_myPos, absBearing + angle.angle, 180.0);
                g.drawLine((int)_myPos.x, (int)_myPos.y, (int)pos.x, (int)pos.y);
            }
            double bestAngle = 0.0;
            double bestDensity = 0.0;
            double bandwidth = 36.0 / en.currentState.distance(_myPos.x, _myPos.y);
            for (Angle angle : angles) {
                double density = 0.0;
                for (Angle angle2 : angles) {
                    if (angle == angle2) continue;
                    double ux = (angle.angle - angle2.angle) / bandwidth;
                    density += Math.exp(-0.5 * ux * ux) * angle2.weight;
                }
                if (!(density > bestDensity)) continue;
                bestAngle = angle.angle;
                bestDensity = density;
            }
            g.setColor(this.getColor());
            Point2D.Double pos = LUtils.project(_myPos, absBearing + bestAngle, 230.0);
            g.drawLine((int)_myPos.x, (int)_myPos.y, (int)pos.x, (int)pos.y);
            g.setColor(Color.orange);
            pos = LUtils.project(_myPos, absBearing, 300.0);
            g.drawLine((int)_myPos.x, (int)_myPos.y, (int)pos.x, (int)pos.y);
            return absBearing + bestAngle;
        }
        return LUtils.absoluteBearing(_myPos, LConstants.fieldCenter);
    }

    @Override
    public Color getColor() {
        return Color.green;
    }

    @Override
    public String getLabel() {
        return "FirstShot";
    }

    @Override
    public void onPaint(Graphics2D g) {
    }

    static {
        weights = new double[]{8.0, 4.0, 3.0, 2.0, 3.0, 8.0, 8.0, 3.0};
    }

    public static class GFs {
        public static final double[] guessFactors = new double[]{82.0, 84.0, 85.0, 90.0, 91.0, 91.0, 93.0, 95.0, 93.0, 94.0, 92.0, 94.0, 95.0, 93.0, 95.0, 93.0, 92.0, 90.0, 91.0, 90.0, 89.0, 87.0, 86.0, 84.0, 83.0, 82.0, 82.0, 82.0, 81.0, 79.0, 79.0, 79.0, 76.0, 76.0, 76.0, 76.0, 76.0, 73.0, 73.0, 73.0, 70.0, 70.0, 70.0, 67.0, 67.0, 64.0, 63.0, 63.0, 59.0, 59.0, 56.0, 56.0, 55.0, 52.0, 51.0, 50.0, 47.0, 45.0, 43.0, 39.0, 37.0, 34.0, 30.0, 26.0, 21.0, 16.0, 10.0, 8.0, 2.0, -3.0, -9.0, -15.0, -21.0, -27.0, -33.0, -37.0, -39.0, -42.0, -44.0, -46.0, -46.0, -46.0, -46.0, -44.0, 41.0, 37.0, 34.0, 28.0, 22.0, 14.0, 9.0, 1.0, -6.0, -13.0, -19.0, -24.0, -27.0, -27.0, -26.0, -23.0, -16.0, 10.0, 5.0, -4.0, -8.0, -12.0, -16.0, -18.0, -20.0, -22.0, -22.0, -21.0, -14.0, -9.0, -5.0, 1.0, -3.0, -5.0, -6.0, -7.0, 74.0, 77.0, 79.0, 86.0, 87.0, 87.0, 91.0, 90.0, 92.0, 90.0, 88.0, 90.0, 88.0, 89.0, 87.0, 85.0, 83.0, 81.0, 82.0, 79.0, 77.0, 75.0, 73.0, 71.0, 69.0, 67.0, 65.0, 65.0, 64.0, 61.0, 60.0, 58.0, 56.0, 53.0, 50.0, 47.0, 43.0, 39.0, 35.0, 29.0, 24.0, 18.0, 11.0, 5.0, 0.0, -5.0, -11.0, -19.0, -23.0, -25.0, -27.0, -27.0, -28.0, -28.0, -28.0, -27.0, -25.0, -22.0, -15.0, -12.0, 9.0, 7.0, 5.0, 3.0, 2.0, 0.0, 0.0, -3.0, -3.0, -4.0, -6.0, -7.0, -9.0, -10.0, -11.0, -11.0, -11.0, 10.0, 9.0, 7.0, 5.0, 4.0, 2.0, 0.0, -1.0, -3.0, -5.0, -7.0, -7.0, -7.0, -7.0, -7.0, 6.0, 5.0, 3.0, 3.0, 2.0, 1.0, 0.0, 0.0, 1.0, 3.0, 5.0, 8.0, 11.0, 14.0, 17.0, 20.0, 23.0, 26.0, 29.0, 32.0, -35.0, -39.0, -44.0, -47.0, -50.0, -53.0, -56.0, -59.0, 62.0, 62.0, 61.0, 59.0, 58.0, 55.0, 52.0, 48.0, 42.0, 38.0, 33.0, 24.0, 19.0, 11.0, 6.0, 0.0, -7.0, -12.0, -17.0, -24.0, -29.0, -34.0, -39.0, -43.0, -48.0, -53.0, -60.0, -64.0, -69.0, -73.0, -77.0, -81.0, -84.0, -86.0, 85.0, 87.0, 89.0, 90.0, 90.0, 91.0, 91.0, 93.0, 92.0, 90.0, 87.0, 84.0, 80.0, 76.0, 72.0, 65.0, 60.0, 57.0, 54.0, 51.0, 47.0, 44.0, 41.0, 38.0, 35.0, 33.0, 30.0, 27.0, 24.0, 22.0, 19.0, 17.0, 14.0, 12.0, 9.0, 7.0, 5.0, 3.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, -1.0, -3.0, -4.0, -6.0, -8.0, -8.0, -8.0, -8.0, -8.0, -8.0, -8.0, -7.0, -6.0, -5.0, -4.0, -3.0, -2.0, 0.0, 1.0, 3.0, 6.0, 8.0, 11.0, 14.0, 17.0, 19.0, 20.0, -22.0, -23.0, -23.0, -24.0, -25.0, -25.0, -25.0, -24.0, -23.0, -21.0, -20.0, -19.0, 77.0, 79.0, 81.0, 82.0, 86.0, 86.0, 86.0, 88.0, 87.0, 86.0, 88.0, 87.0, 87.0, 89.0, 88.0, 90.0, 89.0, 91.0, 90.0, 89.0, 91.0, 90.0, 92.0, 91.0, 92.0, 90.0, 88.0, 85.0, 82.0, 79.0, 75.0, 71.0, 66.0, 61.0, 59.0, 53.0, 49.0, 45.0, 42.0, 39.0, 36.0, 33.0, 30.0, 27.0, 24.0, 21.0, 19.0, 16.0, 13.0, 11.0, 8.0, 6.0, 3.0, 0.0, -2.0, -5.0, -7.0, -10.0, -11.0, -12.0, -12.0, -11.0, 11.0, 10.0, 8.0, 6.0, 4.0, 2.0, 1.0, 1.0, 2.0, 4.0, 6.0, 12.0, 15.0, 18.0, 21.0, 24.0, 27.0, 30.0, -33.0, -34.0, -35.0, -35.0, -34.0, -34.0, -32.0, -31.0, -29.0, -27.0, -24.0, -22.0, -21.0, -19.0, -19.0, -19.0, -19.0, -19.0, 18.0, 17.0, 15.0, 13.0, 11.0, 9.0, 6.0, 3.0, 0.0, -2.0, -4.0, -6.0, -7.0, -8.0, -8.0, -4.0, -1.0, 1.0, -4.0, -8.0, -11.0, -14.0, 45.0, 43.0, 41.0, 38.0, 35.0, 33.0, 29.0, 25.0, 21.0, 17.0, 15.0, 11.0, 7.0, 3.0, -1.0, -5.0, -9.0, -14.0, -18.0, -20.0, -24.0, -28.0, -31.0, -34.0, -40.0, -43.0, -46.0, -49.0, -50.0, -52.0, -55.0, -58.0, -61.0, -61.0, -64.0, -67.0, -69.0, -70.0, -72.0, 75.0, 74.0, 77.0, 76.0, 79.0, 81.0, 80.0, 81.0, 80.0, 80.0, 81.0, 79.0, 80.0, 78.0, 77.0, 77.0, 74.0, 74.0, 72.0, 71.0, 72.0, 70.0, 69.0, 68.0, 66.0, 64.0, 62.0, 60.0, 57.0, 55.0, 52.0, 47.0, 43.0, 39.0, 36.0, 34.0, 31.0, 29.0, 27.0, 26.0, 25.0, 25.0, 26.0, 27.0, 26.0, 23.0, 24.0, 27.0, 28.0, 26.0, 26.0, 27.0, 30.0, 33.0, 36.0, -44.0, -48.0, -55.0, -58.0, -60.0, -61.0, -61.0, -63.0, 64.0, 64.0, 61.0, 58.0, 54.0, 47.0, 41.0, 36.0, 33.0, 29.0, 24.0, 20.0, 15.0, 10.0, 5.0, 0.0, -4.0, -9.0, 60.0, 62.0, 63.0, 65.0, 66.0, 69.0, 70.0, 72.0, 75.0, 76.0, 79.0, 78.0, 78.0, 76.0, 74.0, 72.0, 69.0, 67.0, 64.0, 60.0, 55.0, 53.0, 50.0, 47.0, 43.0, 40.0, 38.0, 35.0, 33.0, 30.0, 26.0, 23.0, 22.0, 20.0, 17.0, 16.0, 13.0, 9.0, 8.0, 3.0, 0.0, -2.0, -7.0, -11.0, -14.0, -18.0, -23.0, -28.0, -31.0, -36.0, -41.0, -44.0, -50.0, -52.0, -56.0, -60.0, -61.0, -64.0, -67.0, -68.0, 70.0, 74.0, 75.0, 75.0, 78.0, 79.0, 80.0, 81.0, 84.0, 84.0, 87.0, 90.0, 91.0, 94.0, 94.0, 95.0, 97.0, 96.0, 96.0, 97.0, 97.0, 96.0, 96.0, 96.0, 97.0, 97.0, 97.0, 96.0, 95.0, 94.0, 92.0, 91.0, 90.0, 89.0, 87.0, 85.0, 84.0, 82.0, 79.0, 77.0, 75.0, 73.0, 72.0, 70.0, 68.0, 67.0, 65.0, 64.0, 62.0, 61.0, 60.0, 58.0, 57.0, 55.0, 53.0, 52.0, 50.0, 48.0, 46.0, 45.0, -11.0, -11.0, -11.0, -10.0, -10.0, -10.0, -10.0, -10.0, -11.0, -31.0, -33.0, -35.0, -37.0, -40.0, -42.0, -42.0, -44.0, -46.0, -49.0, -49.0, -52.0, 54.0, 59.0, 61.0, 61.0, 61.0, 61.0, 60.0, 59.0, -58.0, -57.0, 57.0, 54.0, 47.0, 51.0, 41.0, 48.0, 47.0, 34.0, 43.0, 28.0, 38.0, 22.0, 33.0, 31.0, 15.0, 27.0, 9.0, 23.0, 3.0, 0.0, -3.0, -7.0, -10.0, -13.0, -15.0, -17.0, -19.0, -19.0, -18.0, -16.0, -13.0, -12.0, 10.0, 9.0, 6.0, 3.0, 0.0, -3.0, -8.0, -11.0, -15.0, -19.0, -21.0, -22.0, -20.0, -18.0, -16.0, -13.0, 9.0, 4.0, 0.0, -7.0, -12.0, -17.0, -22.0, -24.0, -29.0, -32.0, -34.0, -35.0, -36.0, -37.0, -37.0, -37.0, -36.0, -35.0, -33.0, -32.0, -29.0, -26.0, 24.0, 22.0, 20.0, 19.0, 17.0, 15.0, 13.0, 11.0, 10.0, 12.0, 12.0, 11.0, 10.0, 8.0, 5.0, 2.0, 0.0, -2.0, -4.0, 0.0, 0.0, 0.0, -1.0, -1.0, 1.0, 1.0, 0.0, 0.0, -1.0, -3.0, -5.0, -8.0, -10.0, -13.0, -17.0, -20.0, -24.0, 31.0, 34.0, 37.0, 44.0, -50.0, -53.0, -59.0, -61.0, -67.0, -70.0, 73.0, 75.0, 78.0, 80.0, 82.0, 84.0, 86.0, 87.0, 87.0, 90.0, 90.0, 89.0, 88.0, 87.0, 85.0, 84.0, 83.0, 82.0, 82.0, 84.0, 84.0, 84.0, 84.0, 83.0, 83.0, 83.0, 83.0, 83.0, 84.0, 85.0, 85.0, 82.0, 83.0, 84.0, 82.0, 83.0, 80.0, 81.0, 78.0, 79.0, 77.0, 79.0, 76.0, 74.0, 76.0, 73.0, 75.0, 72.0, 74.0, 71.0, 73.0, 70.0, 72.0, 69.0, 69.0, 66.0, 66.0, 62.0, 60.0, 57.0, 55.0, 51.0, 49.0, 46.0, 45.0, 40.0, 35.0, 32.0, 27.0, 23.0, 20.0, 15.0, 14.0, 15.0, 15.0, 16.0, 14.0, 12.0, 6.0, -2.0, -14.0, -27.0, -41.0, -51.0, -54.0, -54.0, 52.0, 49.0, 43.0, 37.0, 25.0, 16.0, -7.0, -5.0, 3.0, 0.0, -1.0, -4.0, -6.0, -9.0, -12.0, -17.0, -19.0, -22.0, -25.0, -28.0, -30.0, -36.0, -39.0, -41.0, -44.0, -47.0, -53.0, -56.0, -59.0, -62.0, -65.0, -68.0, -71.0, -74.0, -77.0, -80.0, -82.0, 82.0, 84.0, 86.0, 85.0, 86.0, 85.0, 86.0, 87.0, 85.0, 85.0, 83.0, 82.0, 80.0, 79.0, 77.0, 75.0, 72.0, 69.0, 67.0, 64.0, 62.0, 58.0, 55.0, 52.0, 48.0, 44.0, 39.0, 34.0, 29.0, 24.0, 19.0, 15.0, 12.0, 8.0, 5.0, 2.0, -1.0, -4.0, -8.0, -12.0, -16.0, -20.0, -24.0, -28.0, -31.0, -32.0, -34.0, 37.0, 39.0, 40.0, 45.0, 47.0, 48.0, 48.0, 51.0, 51.0, 55.0, 56.0, 58.0, 63.0, 64.0, 66.0, 67.0, 68.0, 68.0, 68.0, 67.0, 65.0, 63.0, 60.0, 56.0, 50.0, 44.0, 38.0, 31.0, 25.0, 18.0, 11.0, 5.0, -1.0, -7.0, -14.0, -20.0, -27.0, -33.0, -42.0, -48.0, -54.0, -62.0, -51.0, -58.0, -61.0, -67.0, -69.0, -71.0, -71.0, -71.0, -70.0, 68.0, 65.0, 63.0, 58.0, 53.0, 48.0, 41.0, 34.0, 28.0, 21.0, 14.0, 10.0, 3.0, -2.0, -12.0, -19.0, -26.0, -33.0, -39.0, -45.0, -50.0, -53.0, -54.0, -55.0, -54.0, -52.0, 50.0, 47.0, 43.0, 38.0, 32.0, 26.0, 21.0, 16.0, 12.0, 8.0, 3.0, -1.0, -7.0, -13.0, -20.0, -27.0, -34.0, -44.0, -51.0, -57.0, -62.0, -66.0, -69.0, -71.0, 74.0, 76.0, 77.0, 78.0, 79.0, 79.0, 83.0, 82.0, 83.0, 85.0, 87.0, 89.0, 89.0, 88.0, 86.0, 83.0, 79.0, 75.0, 70.0, 65.0, 59.0, 53.0, 47.0, 40.0, 33.0, 28.0, 23.0, 15.0, 8.0, 2.0, -4.0, -10.0, -17.0, -23.0, -29.0, -36.0, -45.0, -51.0, -56.0, -65.0, -68.0, -72.0, -77.0, -80.0, 82.0, 83.0, 85.0, 86.0, 86.0, 89.0, 89.0, 89.0, 89.0, 89.0, 89.0, 88.0, 86.0, 83.0, 79.0, 75.0, 71.0, 48.0, 50.0, 52.0, 54.0, 56.0, 58.0, 59.0, 60.0, 63.0, 64.0, 65.0, 66.0, 67.0, 67.0, 68.0, 68.0, 68.0, 69.0, 67.0, 67.0, 68.0, 68.0, 69.0, 69.0, 70.0, 71.0, 72.0, 72.0, -72.0, 70.0, 69.0, 67.0, 64.0, 60.0, 55.0, 51.0, 43.0, 38.0, 33.0, 28.0, 23.0, 16.0, 11.0, 6.0, 1.0, -2.0, -9.0, -14.0, -18.0, -22.0, -27.0, -31.0, -37.0, -41.0, -45.0, -48.0, -52.0, -56.0, -60.0, -64.0, -67.0, -71.0, -72.0, -75.0, -77.0, -80.0, 82.0, 83.0, 84.0, 85.0, 86.0, 87.0, 87.0, 88.0, 88.0, 86.0, 86.0, 87.0, 85.0, 86.0, 87.0, 85.0, 83.0, 84.0, 83.0, 83.0, 82.0, 82.0, 81.0, 79.0, 80.0, 79.0, 77.0, 78.0, 77.0, 77.0, 75.0, 74.0, 72.0, 70.0, 68.0, 65.0, 62.0, 60.0, 56.0, 49.0, 44.0, 38.0, 35.0, 29.0, 23.0, 16.0, 13.0, 7.0, 0.0, -3.0, -10.0, -13.0, -21.0, -25.0, 78.0, 81.0, 86.0, 88.0, 84.0, 79.0, 74.0, 69.0, 66.0, 63.0, 63.0, 64.0, 66.0, 65.0, 67.0, 69.0, 68.0, 67.0, 70.0, 69.0, 69.0, 69.0, 70.0, 72.0, 75.0, 78.0, 82.0, 84.0, 90.0, 91.0, 93.0, 94.0, 94.0, 95.0, 95.0, 95.0, 96.0, 96.0, 97.0, 95.0, 95.0, 95.0, 96.0, 96.0, 96.0, 96.0, 96.0, 96.0, 96.0, 96.0, 96.0, 96.0, 96.0, 96.0, 97.0, 94.0, 95.0, 97.0, 94.0, 95.0, 93.0, 94.0, 95.0, 96.0, 94.0, 95.0, 96.0, 97.0, 96.0, 93.0, 90.0, 86.0, 82.0, 79.0, 75.0, 72.0, 69.0, 66.0, 62.0, 58.0, 54.0, 49.0, 45.0, 41.0, 36.0, 31.0, 24.0, 18.0, 9.0, 0.0, -5.0, -14.0, -18.0, -23.0, -25.0, -29.0, -30.0, -33.0, -36.0, -38.0, -39.0, -40.0, -41.0, -40.0, -39.0, -38.0, -36.0, -33.0, -31.0, -28.0, -25.0, 21.0, 18.0, 14.0, 9.0, 4.0, 0.0, -5.0, -11.0, -16.0, 81.0, 81.0, 80.0, 77.0, 74.0, 70.0, 65.0, 62.0, 56.0, 50.0, 43.0, 36.0, 28.0, 17.0, 8.0, -4.0, -16.0, -25.0, -33.0, -38.0, -42.0, -43.0, -43.0, -42.0, 39.0, 38.0, 36.0, 35.0, 33.0, 31.0, 30.0, 28.0, 25.0, 23.0, 22.0, 26.0, 25.0, 26.0, 32.0, 35.0, 39.0, 43.0, -48.0, -56.0, -60.0, -62.0, -62.0, -61.0, 61.0, 60.0, 60.0, 63.0, 64.0, 65.0, 65.0, 66.0, 66.0, 66.0, 67.0, 67.0, 66.0, 65.0, 62.0, 61.0, 59.0, 59.0, 60.0, 63.0, 66.0, 69.0, 76.0, 76.0, 75.0, 72.0, 68.0, 63.0, 57.0, 51.0, 45.0, 39.0, 33.0, 25.0, 19.0, 11.0, 3.0, -2.0, -9.0, -13.0, -16.0, -19.0, -21.0, -23.0, -24.0, -25.0, -25.0, -21.0, -19.0, -16.0, -14.0, -12.0, -11.0, 11.0, 11.0, 11.0, 12.0, 12.0, 10.0, 8.0, 5.0, 1.0, -5.0, -9.0, -15.0, -20.0, -25.0, -30.0, -37.0, -39.0, -41.0, -41.0, -4.0, -3.0, -1.0, 0.0, 0.0, 4.0, 4.0, 4.0, 2.0, 0.0, -1.0, -2.0, -3.0, -3.0, -3.0, 2.0, 1.0, 0.0, -2.0, -5.0, -9.0, -13.0, -15.0, -18.0, -21.0, -23.0, -26.0, -27.0, -29.0, -30.0, -31.0, 31.0, 31.0, 29.0, 27.0, 24.0, 21.0, 17.0, 12.0, 8.0, 0.0, -3.0, -6.0, -9.0, -12.0, -17.0, -19.0, -22.0, -24.0, -27.0, -29.0, -32.0, -35.0, -40.0, -42.0, -44.0, -43.0, -43.0, 43.0, -43.0, 44.0, -45.0, -47.0, -50.0, -53.0, -56.0, -58.0, -61.0, -63.0, -66.0, 67.0, 69.0, 70.0, 68.0, 68.0, 69.0, 68.0, 68.0, 66.0, 65.0, 63.0, 60.0, 58.0, 55.0, 52.0, 49.0, 47.0, 44.0, 42.0, 40.0, 38.0, 37.0, 37.0, 36.0, 38.0, 38.0, 41.0, 41.0, 40.0, 40.0, 38.0, 37.0, 35.0, 33.0, 31.0, 28.0, 26.0, 23.0, 20.0, 18.0, 16.0, 13.0, 11.0, 8.0, 7.0, 5.0, 5.0, 4.0, -5.0, -28.0, 26.0, 24.0, 21.0, 20.0, 17.0, 13.0, 10.0, 7.0, 2.0, -5.0, -9.0, -15.0, -24.0, -29.0, -33.0, -40.0, 44.0, -47.0, -54.0, 56.0, 63.0, -65.0, 71.0, -73.0, 75.0, 79.0, 81.0, 82.0, 83.0, 83.0, 86.0, 86.0, 85.0, 84.0, 83.0, 81.0, 80.0, 79.0, 76.0, 75.0, 74.0, 72.0, 70.0, 68.0, 67.0, 64.0, 62.0, 60.0, 58.0, 55.0, 54.0, 52.0, 49.0, 47.0, 46.0, 45.0, 42.0, 41.0, 40.0, 39.0, 38.0, 38.0, 38.0, 36.0, 36.0, 36.0, 37.0, 37.0, 37.0, 38.0, 37.0, 38.0, 39.0, 37.0, 38.0, 40.0, 39.0, 40.0, 42.0, 44.0, 47.0, 49.0, 51.0, 54.0, 57.0, 59.0, 61.0, 63.0, 65.0, 66.0, 68.0, 73.0, 74.0, 75.0, 80.0, 80.0, 84.0, 83.0, 87.0, 86.0, 89.0, 87.0, 86.0, 88.0, 86.0, 85.0, 84.0, 82.0, 83.0, 81.0, 79.0, 77.0, 76.0, 74.0, 72.0, 71.0, 70.0, 69.0, 70.0, 74.0, 81.0, 86.0, 85.0, 87.0, 85.0, 79.0, 72.0, 66.0, 57.0, 49.0, 41.0, 32.0, 19.0, 11.0, 3.0, -8.0, -16.0, -24.0, -35.0, -41.0, -52.0, -61.0, -66.0, -74.0, -78.0, -81.0, -87.0, 89.0, 91.0, 93.0, 94.0, 94.0, 94.0, 92.0, 91.0, 90.0, 89.0, 87.0, 85.0, 84.0, 81.0, 79.0, 78.0, 78.0, 78.0, 78.0, 78.0, 78.0, 78.0, 77.0, 76.0, 75.0, 74.0, 72.0, 70.0, 67.0, 64.0, 63.0, 62.0, 61.0, 61.0, 66.0, 67.0, 68.0, 72.0, 73.0, 74.0, 76.0, 76.0, 77.0, 76.0, 75.0, 75.0, 75.0, 75.0, 76.0, 77.0, 76.0, 78.0, 79.0, 81.0, 81.0, 83.0, 84.0, 85.0, 86.0, 83.0, 83.0, 83.0, 83.0, 82.0, 79.0, 78.0, 78.0, 77.0, 76.0, 76.0, 75.0, 75.0, 74.0, 72.0, 69.0, 64.0, 60.0, 54.0, 49.0, 45.0, 41.0, 39.0, 36.0, 33.0, 31.0, 29.0, 28.0, 26.0, 24.0, 23.0, 23.0, 23.0, 78.0, 84.0, 86.0, 87.0, 91.0, 91.0, 93.0, 92.0, 94.0, 95.0, 94.0, 96.0, 95.0, 94.0, 96.0, 95.0, 95.0, 94.0, 93.0, 93.0, 92.0, 91.0, 91.0, 90.0, 89.0, 88.0, 88.0, 87.0, 84.0, 82.0, 80.0, 77.0, 73.0, 68.0, 64.0, 59.0, 53.0, 44.0, 38.0, 29.0, 23.0, 17.0, 8.0, 2.0, -2.0, -7.0, -10.0, -12.0, -14.0, -16.0, -17.0, -16.0, -16.0, -16.0, -16.0, -16.0, -18.0, -16.0, -14.0, -12.0, -11.0, 9.0, 8.0, 7.0, 6.0, 5.0, 4.0, 3.0, 2.0, 0.0, 1.0, 1.0, 1.0, 0.0, 0.0, -2.0, -4.0, -6.0, -7.0, -8.0, -9.0, 10.0, 11.0, 12.0, 12.0, 12.0, 12.0, 12.0, 12.0, 10.0, 8.0, 6.0, 3.0, 1.0, 0.0, -1.0, -2.0, 2.0, 3.0, 4.0, 4.0, 5.0, 6.0, 7.0, 7.0, 6.0, 4.0, 2.0, 0.0, -1.0, -2.0, -1.0, 2.0, 3.0, 3.0, 4.0, 4.0, 5.0, 5.0, 8.0, -15.0, -14.0, -12.0, -10.0, 5.0, 2.0, 0.0, -6.0, -9.0, -13.0, -19.0, -24.0, -28.0, -32.0, -36.0, -42.0, -46.0, -50.0, -53.0, -57.0, -61.0, -65.0, -66.0, -70.0, -73.0, -75.0, -77.0, -78.0, -78.0, -78.0, -79.0, 79.0, 79.0, 79.0, 79.0, 78.0, 78.0, 76.0, 75.0, 74.0, 72.0, 70.0, 68.0, 67.0, 65.0, 64.0, 63.0, 61.0, 60.0, 58.0, 57.0, 56.0, 54.0, 53.0, 51.0, 50.0, 49.0, 47.0, 46.0, 45.0, 43.0, 42.0, 40.0, 38.0, 36.0, 33.0, 30.0, 27.0, 24.0, 20.0, 18.0, 13.0, 9.0, 5.0, 2.0, 0.0, -2.0, 5.0, -8.0, -11.0, -15.0, -19.0, -23.0, -26.0, -27.0, -30.0, 33.0, -36.0, -40.0, -44.0, -45.0, -49.0, -54.0, -56.0, -60.0, -65.0, -70.0, -72.0, -77.0, -81.0, -85.0, -88.0, 91.0, 91.0, 93.0, 94.0, 95.0, 96.0, 96.0, 96.0, 95.0, 95.0, 95.0, 92.0, 88.0, 84.0, 80.0, 75.0, 70.0, 65.0, 77.0, 80.0, 77.0, 73.0, 66.0, 62.0, 57.0, 53.0, 52.0, 46.0, 43.0, 43.0, 40.0, 43.0, 46.0, 50.0, 53.0, 52.0, 56.0, 57.0, 60.0, 63.0, 71.0, -76.0, -80.0, -83.0, 86.0, 88.0, 90.0, 90.0, 88.0, 84.0, 79.0, 72.0, 66.0, 57.0, 47.0, 39.0, 29.0, 21.0, 16.0, 13.0, 10.0, 8.0, 6.0, 5.0, 4.0, 2.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, 4.0, 7.0, 10.0, -14.0, -18.0, -22.0, -27.0, -32.0, -37.0, -43.0, -49.0, -55.0, -61.0, -66.0, -70.0, -74.0, -77.0, -80.0, 82.0, 84.0, 86.0, 87.0, 88.0, 89.0, 91.0, 91.0, 92.0, 91.0, 91.0, 91.0, 91.0, 90.0, 90.0, 89.0, 86.0, 86.0, 85.0, 85.0, 84.0, 83.0, 83.0, 82.0, 81.0, 80.0, 79.0, 78.0, 75.0, 74.0, 74.0, 74.0, 74.0, 73.0, 73.0, 72.0, 71.0, 71.0, 71.0, 70.0, 73.0, 73.0, 73.0, 73.0, 73.0, 72.0, 73.0, 0.0, -1.0, -2.0, 3.0, -5.0, -7.0, -9.0, 11.0, 14.0, 16.0, -19.0, 22.0, -24.0, 24.0, -27.0, 29.0, -31.0, 34.0, -37.0, 39.0, -42.0, 44.0, -47.0, 49.0, 49.0, -51.0, 54.0, -56.0, 58.0, 60.0, 63.0, 63.0, 65.0, 68.0, 70.0, 73.0, 75.0, 77.0, 79.0, 80.0, 81.0, 81.0, 81.0, 79.0, 76.0, 72.0, 68.0, 65.0, 58.0, 54.0, 49.0, 42.0, 37.0, 32.0, 28.0, 23.0, 21.0, 16.0, 11.0, 7.0, 4.0, 0.0, -4.0, -9.0, -14.0, -18.0, -22.0, -26.0, -29.0, -32.0, -35.0, -37.0, -39.0, -40.0, -41.0, -44.0, -44.0, -43.0, -42.0, -39.0, -39.0, 36.0, 32.0, 31.0, 28.0, 24.0, 22.0, 19.0, 17.0, 15.0, 13.0, 12.0, 10.0, 9.0, 8.0, 8.0, 5.0, 5.0, 6.0, 3.0, 3.0, 4.0, 4.0, 3.0, 4.0, 6.0, 5.0, 8.0, 11.0, -11.0, -15.0, -17.0, -21.0, -25.0, -28.0, -31.0, -34.0, -36.0, -37.0, -37.0, 25.0, 26.0, 25.0, 23.0, 20.0, 16.0, -11.0, -5.0, 0.0, -5.0, 11.0, 15.0, 20.0, 27.0, 31.0, 35.0, 39.0, 41.0, 45.0, 49.0, 53.0, 56.0, 60.0, 63.0, -66.0, 66.0, -68.0, 70.0, -72.0, 74.0, 76.0, 77.0, 78.0, 79.0, 80.0, 81.0, 82.0, 83.0, 84.0, 83.0, 84.0, 85.0, 86.0, 87.0, 87.0, 88.0, 86.0, 86.0, 86.0, 86.0, 87.0, 87.0, 87.0, 87.0, 85.0, 85.0, 85.0, 83.0, 83.0, 83.0, 81.0, 81.0, 82.0, 79.0, 80.0, 77.0, 78.0, 76.0, 76.0, 74.0, 75.0, 72.0, 73.0, 71.0, 72.0, 70.0, 70.0, 71.0, 72.0, 73.0, 71.0, 72.0, 73.0, 74.0, 75.0, 73.0, 73.0, 72.0, 71.0, 68.0, 65.0, 62.0, 58.0, 54.0, 50.0, 44.0, 41.0, 36.0, 29.0, 26.0, 18.0, 11.0, 3.0, -3.0, -11.0, -19.0, -27.0, -35.0, -46.0, -53.0, -61.0, -66.0, -71.0, -76.0, 77.0, 78.0, 76.0, 73.0, 69.0, 65.0, 36.0, 39.0, 44.0, 47.0, -51.0, -58.0, -63.0, -68.0, -73.0, -78.0, -82.0, -85.0, -87.0, 90.0, 91.0, 93.0, 94.0, 93.0, 91.0, 89.0, 87.0, 84.0, 80.0, 77.0, 72.0, 68.0, 63.0, 58.0, 53.0, 45.0, 40.0, 34.0, 29.0, 21.0, 15.0, 10.0, 4.0, 0.0, -8.0, -14.0, -20.0, -25.0, -31.0, -36.0, -42.0, -47.0, -55.0, -60.0, -66.0, -71.0, -75.0, -79.0, -82.0, -85.0, -87.0, 88.0, 90.0, 91.0, 91.0, 91.0, 89.0, 86.0, 84.0, 81.0, 78.0, 76.0, 73.0, 71.0, 68.0, 66.0, 64.0, 61.0, 59.0, 56.0, 54.0, 51.0, 49.0, 46.0, 44.0, 42.0, 39.0, 37.0, 36.0, 35.0, 32.0, 30.0, 28.0, 26.0, 23.0, 20.0, 18.0, 16.0, 13.0, 11.0, 10.0, 9.0, 8.0, 8.0, 9.0, 9.0, 9.0, 10.0, 10.0, 10.0, 10.0, 10.0, 9.0, 10.0, 10.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 16.0, 15.0, 17.0, 16.0, 65.0, 71.0, 64.0, 59.0, 58.0, 58.0, 60.0, 63.0, 67.0, 68.0, 70.0, 69.0, 74.0, 71.0, 77.0, 77.0, 80.0, 83.0, 85.0, 84.0, 86.0, 88.0, 89.0, 91.0, 91.0, 93.0, 93.0, 96.0, 96.0, 96.0, 96.0, 96.0, 96.0, 96.0, 96.0, 96.0, 96.0, 96.0, 95.0, 93.0, 90.0, 87.0, 84.0, 80.0, 76.0, 72.0, 69.0, 64.0, 59.0, 53.0, 47.0, 44.0, 37.0, 32.0, 26.0, 20.0, 13.0, 7.0, 1.0, -5.0, -11.0, -17.0, -24.0, -33.0, -38.0, -43.0, -47.0, -50.0, -52.0, -53.0, -53.0, -52.0, -48.0, -44.0, 40.0, 36.0, 31.0, 27.0, 23.0, 19.0, 15.0, 11.0, 8.0, 6.0, 3.0, 0.0, -2.0, -4.0, -7.0, -9.0, -12.0, -15.0, -17.0, -19.0, -20.0, -20.0, -19.0, -17.0, -17.0, 14.0, 10.0, 5.0, 1.0, -3.0, -6.0, -10.0, -13.0, -15.0, -18.0, -18.0, -18.0, -17.0, -19.0, -18.0, -15.0, -13.0, -9.0, -6.0, -3.0, 0.0, 41.0, 45.0, 49.0, 54.0, 59.0, 61.0, 66.0, 68.0, 69.0, 70.0, 71.0, 71.0, 72.0, 72.0, 73.0, 77.0, 77.0, 78.0, 78.0, 81.0, 81.0, 81.0, 84.0, 84.0, 84.0, 85.0, 85.0, 86.0, 87.0, 88.0, 88.0, 89.0, 88.0, 88.0, 87.0, 87.0, 86.0, 87.0, 85.0, 85.0, 83.0, 81.0, 81.0, 79.0, 77.0, 76.0, 73.0, 71.0, 68.0, 64.0, 61.0, 57.0, 53.0, 49.0, 44.0, 37.0, 27.0, 19.0, 12.0, 4.0, -1.0, -7.0, -11.0, -14.0, -17.0, -20.0, -23.0, -25.0, -27.0, -27.0, -27.0, -25.0, -23.0, 20.0, 16.0, 12.0, 8.0, 4.0, 1.0, -2.0, -6.0, -9.0, -12.0, -13.0, -12.0, -12.0, -12.0, 10.0, 8.0, 6.0, 3.0, 0.0, -1.0, -3.0, -7.0, -14.0, -19.0, -25.0, -33.0, -37.0, -40.0, -42.0, -44.0, -45.0, -46.0, -48.0, -49.0, -49.0, 48.0, 47.0, 46.0, 46.0, 46.0, 45.0, 43.0, 40.0, 38.0, 36.0, 33.0, 33.0, 74.0, 73.0, 70.0, 66.0, 61.0, 56.0, 49.0, 38.0, 31.0, 23.0, 16.0, 10.0, 3.0, -2.0, -9.0, -15.0, -21.0, -31.0, -36.0, -41.0, -45.0, -49.0, -51.0, -53.0, -53.0, -53.0, -53.0, 53.0, 53.0, 53.0, 53.0, 52.0, 49.0, 47.0, 44.0, 42.0, 39.0, 36.0, 33.0, 30.0, 26.0, 22.0, 18.0, 14.0, 9.0, 4.0, 0.0, -4.0, -8.0, -12.0, -15.0, -19.0, -25.0, -29.0, -32.0, -35.0, -39.0, -43.0, -47.0, -51.0, -55.0, -61.0, -65.0, -66.0, -69.0, -72.0, -75.0, -79.0, -81.0, 84.0, 86.0, 87.0, 86.0, 84.0, 81.0, 78.0, 75.0, 71.0, 68.0, 64.0, 61.0, 58.0, 54.0, 52.0, 51.0, 49.0, 48.0, 50.0, 50.0, 52.0, 51.0, 53.0, 52.0, 50.0, 48.0, 46.0, 43.0, 42.0, 40.0, 39.0, 39.0, 38.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 39.0, 39.0, 38.0, 38.0, 37.0, -72.0, 79.0, 81.0, 86.0, 89.0, 92.0, 89.0, 86.0, 82.0, 78.0, 73.0, 68.0, 64.0, 60.0, 57.0, 57.0, 56.0, 58.0, 57.0, 60.0, 59.0, 61.0, 60.0, 63.0, 63.0, 67.0, 69.0, 69.0, 68.0, 68.0, 71.0, 72.0, 71.0, 70.0, 68.0, 66.0, 64.0, 61.0, 58.0, 55.0, 53.0, 51.0, 50.0, 49.0, 49.0, 49.0, 52.0, 52.0, 52.0, 52.0, 49.0, 49.0, 50.0, 52.0, 55.0, 57.0, 55.0, 55.0, 56.0, 56.0, 55.0, 55.0, 53.0, 51.0, 48.0, 45.0, 41.0, 34.0, 29.0, 21.0, 12.0, 6.0, 0.0, -8.0, -14.0, -23.0, -29.0, -37.0, -43.0, -49.0, -57.0, -62.0, -70.0, -75.0, -78.0, -84.0, -86.0, -89.0, 91.0, 94.0, 94.0, 96.0, 96.0, 97.0, 96.0, 96.0, 95.0, 93.0, 91.0, 89.0, 87.0, 84.0, 82.0, 78.0, 76.0, 73.0, 69.0, 65.0, 60.0, 56.0, 53.0, 48.0, 44.0, 39.0, 34.0, 29.0, 24.0, 22.0, 17.0, 12.0, 85.0, 87.0, 88.0, 91.0, 91.0, 93.0, 93.0, 93.0, 95.0, 95.0, 95.0, 95.0, 97.0, 97.0, 96.0, 96.0, 96.0, 96.0, 96.0, 96.0, 96.0, 94.0, 93.0, 90.0, 87.0, 85.0, 82.0, 79.0, 76.0, 74.0, 70.0, 67.0, 65.0, 61.0, 59.0, 55.0, 53.0, 49.0, 46.0, 42.0, 37.0, 35.0, 30.0, 28.0, 23.0, 18.0, 13.0, 10.0, 5.0, 0.0, -4.0, -10.0, -12.0, -18.0, -23.0, -28.0, -32.0, -35.0, -38.0, -41.0, -43.0, -45.0, -46.0, -47.0, -48.0, -47.0, -45.0, -42.0, 38.0, 35.0, 30.0, 26.0, 21.0, 16.0, 10.0, 5.0, 0.0, -2.0, -8.0, -13.0, -19.0, -24.0, -30.0, -35.0, -41.0, -46.0, -50.0, -53.0, -57.0, -59.0, -61.0, -61.0, -61.0, -61.0, 61.0, 60.0, 59.0, 57.0, 55.0, 53.0, 49.0, 46.0, 41.0, 37.0, 34.0, 29.0, 23.0, 19.0, 15.0, 12.0, 9.0, 6.0, 2.0, 0.0, -2.0, -4.0, -6.0, -7.0, -7.0, -8.0, 0.0, -1.0, -2.0, -4.0, -5.0, -10.0, -13.0, -16.0, -19.0, -22.0, -25.0, -28.0, -31.0, -37.0, -40.0, -43.0, -46.0, -52.0, -54.0, -59.0, -62.0, -67.0, -69.0, -71.0, -76.0, -79.0, -81.0, -84.0, -89.0, 91.0, 92.0, 94.0, 95.0, 96.0, 96.0, 96.0, 94.0, 94.0, 94.0, 94.0, 94.0, 93.0, 91.0, 88.0, 85.0, 82.0, 79.0, 76.0, 73.0, 69.0, 65.0, 63.0, 58.0, 53.0, 50.0, 45.0, 42.0, 36.0, 30.0, 24.0, 17.0, 15.0, 8.0, 2.0, -3.0, -9.0, -15.0, -18.0, -24.0, -30.0, -37.0, -42.0, -47.0, -50.0, -54.0, -56.0, -57.0, -57.0, -56.0, 56.0, 55.0, 53.0, 51.0, 48.0, 44.0, 39.0, 33.0, 27.0, 20.0, 16.0, 9.0, 6.0, -1.0, -8.0, -12.0, -20.0, -28.0, -35.0, -42.0, -48.0, -53.0, -53.0, -56.0, 60.0, -64.0, 67.0, 70.0, -72.0, 71.0, 70.0, 66.0, 61.0, 56.0, 47.0, 39.0, 28.0, 20.0, 13.0, 2.0, -4.0, -2.0, -3.0, -5.0, -7.0, -10.0, -13.0, -15.0, -18.0, -21.0, -24.0, -26.0, -29.0, -32.0, -35.0, -37.0, -40.0, -43.0, -46.0, -49.0, -51.0, -54.0, -54.0, -57.0, -60.0, -60.0, -62.0, -65.0, -68.0, -68.0, 70.0, 72.0, 74.0, 72.0, 74.0, 75.0, 76.0, 77.0, 74.0, 75.0, 76.0, 77.0, 77.0, 78.0, 78.0, 77.0, 75.0, 72.0, 68.0, 64.0, 60.0, 56.0, 50.0, 45.0, 39.0, 33.0, 26.0, 19.0, 13.0, 4.0, 0.0, -4.0, -7.0, -11.0, -14.0, -17.0, -19.0, -21.0, -25.0, -26.0, -29.0, -30.0, -31.0, -33.0, 34.0, 35.0, 37.0, 42.0, 44.0, 45.0, 46.0, 47.0, 47.0, 50.0, 49.0, 49.0, 47.0, 46.0, 45.0, 45.0, 45.0, 45.0, 46.0, -48.0, -50.0, -53.0, -56.0, -59.0, 62.0, 64.0, 65.0, 65.0, 64.0, 63.0, 60.0, 57.0, 55.0, 53.0, 51.0, 50.0, 47.0, 47.0, 46.0, 43.0, 44.0, 42.0, 43.0, 44.0, 47.0, 46.0, 49.0, -57.0, -60.0, -63.0, -69.0, -72.0, -74.0, 80.0, 82.0, 84.0, 85.0, 89.0, 90.0, 91.0, 91.0, 92.0, 92.0, 92.0, 92.0, 92.0, 89.0, 88.0, 88.0, 87.0, 85.0, 82.0, 80.0, 78.0, 76.0, 73.0, 70.0, 66.0, 62.0, 56.0, 51.0, 47.0, 42.0, 37.0, 33.0, 27.0, 23.0, 18.0, 13.0, 8.0, 0.0, -5.0, -10.0, -15.0, -23.0, -28.0, -33.0, -37.0, -42.0, -47.0, -52.0, -56.0, -58.0, -59.0, -59.0, -59.0, -59.0, 58.0, 57.0, 56.0, 56.0, 54.0, 53.0, 51.0, 48.0, 45.0, 42.0, 39.0, 35.0, 32.0, 30.0, 25.0, 20.0, 15.0, 11.0, 7.0, 4.0, 1.0, 0.0, -2.0, -3.0, -5.0, -6.0, -6.0, -6.0, -6.0, -6.0, -7.0, -5.0, -2.0, 0.0, 2.0, 5.0, 7.0, 8.0, 9.0, 11.0, 11.0, 13.0, -14.0, -16.0, -19.0, -22.0, -26.0, -31.0, -37.0, -42.0, -49.0, -54.0, -56.0, -58.0, -58.0, -57.0, -56.0, 54.0, 51.0, 45.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 4.0, 8.0, 13.0, 19.0, 28.0, 34.0, 40.0, 43.0, 49.0, 54.0, 60.0, 63.0, 69.0, 71.0, 77.0, 80.0, 83.0, 85.0, 89.0, 91.0, 91.0, 91.0, 91.0, 91.0, 90.0, 89.0, 88.0, 87.0, 86.0, 85.0, 84.0, 83.0, 84.0, 82.0, 80.0, 77.0, 73.0, 69.0, 65.0, 61.0, 57.0, 53.0, 51.0, 48.0, 46.0, 44.0, 43.0, 41.0, 40.0, 37.0, 36.0, 35.0, 34.0, 32.0, 31.0, 30.0, 27.0, 27.0, 26.0, 25.0, 23.0, 22.0, 22.0, 22.0, 21.0, 22.0, 23.0, 25.0, 27.0, 30.0, -33.0, -36.0, -40.0, -47.0, -51.0, -54.0, -57.0, -60.0, -62.0, 64.0, 68.0, 70.0, 71.0, 72.0, 73.0, 77.0, 77.0, 78.0, 78.0, 78.0, 78.0, 80.0, 80.0, 80.0, 79.0, 78.0, 78.0, 77.0, 76.0, 75.0, 73.0, 70.0, 67.0, 62.0, 58.0, 52.0, 47.0, -69.0, -71.0, -73.0, -78.0, -80.0, -84.0, -87.0, -89.0, 91.0, 92.0, 95.0, 96.0, 97.0, 97.0, 96.0, 96.0, 98.0, 97.0, 97.0, 97.0, 96.0, 96.0, 96.0, 96.0, 95.0, 97.0, 97.0, 97.0, 97.0, 97.0, 97.0, 96.0, 96.0, 96.0, 98.0, 97.0, 96.0, 96.0, 95.0, 96.0, 95.0, 94.0, 92.0, 91.0, 91.0, 90.0, 89.0, 88.0, 86.0, 85.0, 84.0, 83.0, 81.0, 80.0, 79.0, 77.0, 75.0, 73.0, 72.0, 70.0, 69.0, 69.0, 69.0, 68.0, 68.0, 68.0, 68.0, 67.0, 67.0, 65.0, 64.0, 62.0, 61.0, 60.0, 59.0, 59.0, 58.0, 56.0, 56.0, 56.0, 56.0, 55.0, 54.0, 52.0, 50.0, 49.0, 47.0, 46.0, 45.0, 45.0, 45.0, 45.0, 45.0, 46.0, 46.0, 48.0, 48.0, 48.0, 46.0, 45.0, 44.0, 42.0, 41.0, 37.0, 34.0, 30.0, 25.0, 22.0, 17.0, 13.0, 10.0, 4.0, 1.0, 0.0, -3.0, -6.0, -8.0, -10.0, -12.0, -17.0, 0.0, -1.0, 0.0, -1.0, -1.0, -1.0, -1.0, 0.0, 0.0, 2.0, -4.0, 10.0, -14.0, 22.0, -29.0, 33.0, -40.0, 47.0, -53.0, 55.0, -61.0, 66.0, -71.0, 76.0, -80.0, 82.0, -86.0, 88.0, 92.0, 93.0, 94.0, 95.0, 95.0, 95.0, 94.0, 93.0, 93.0, 93.0, 90.0, 89.0, 89.0, 88.0, 88.0, 86.0, 86.0, 85.0, 82.0, 80.0, 78.0, 76.0, 74.0, 71.0, 70.0, 67.0, 65.0, 61.0, 58.0, 54.0, 50.0, 46.0, 41.0, 33.0, 27.0, 21.0, 15.0, 6.0, 1.0, -3.0, -11.0, -16.0, -18.0, -25.0, -30.0, -39.0, -44.0, -49.0, -53.0, -59.0, -62.0, -66.0, -70.0, -73.0, -78.0, -81.0, 82.0, 84.0, 85.0, 86.0, 86.0, 87.0, 87.0, 87.0, 87.0, 87.0, 87.0, 87.0, 87.0, 87.0, 86.0, 85.0, 81.0, 83.0, 78.0, 75.0, 71.0, 67.0, 62.0, 57.0, 52.0, 49.0, 44.0, 39.0, 33.0, 28.0, 22.0, 17.0, 11.0, 6.0, 0.0, -4.0, 58.0, 66.0, 69.0, 74.0, 79.0, 83.0, 86.0, 88.0, 90.0, 89.0, 92.0, 92.0, 91.0, 91.0, 94.0, 94.0, 94.0, 94.0, 94.0, 94.0, 94.0, 95.0, 95.0, 96.0, 96.0, 97.0, 94.0, 95.0, 94.0, 92.0, 88.0, 84.0, 80.0, 75.0, 68.0, 62.0, 55.0, 47.0, 40.0, 28.0, 20.0, 13.0, 5.0, -4.0, -10.0, -15.0, -20.0, -23.0, -27.0, -29.0, -32.0, -35.0, -37.0, -38.0, -38.0, -37.0, -34.0, -31.0, 28.0, 25.0, 23.0, 21.0, 18.0, 16.0, 12.0, 9.0, 7.0, 5.0, 5.0, 5.0, 4.0, 3.0, 2.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0, -4.0, -6.0, -7.0, -7.0, -7.0, -7.0, -7.0, -7.0, -7.0, 6.0, 5.0, 5.0, 4.0, 3.0, 2.0, 3.0, 4.0, 7.0, 10.0, 13.0, 16.0, -19.0, -23.0, -27.0, -30.0, -33.0, -36.0, -39.0, -41.0, -42.0, -42.0, -42.0, -42.0, -42.0, -42.0, -5.0, -7.0, -10.0, -10.0, -13.0, -13.0, -16.0, -20.0, -23.0, -26.0, -29.0, -32.0, -35.0, -39.0, -42.0, -45.0, -48.0, -52.0, -55.0, -58.0, -61.0, -65.0, -68.0, -71.0, -74.0, -78.0, -81.0, 81.0, 84.0, 87.0, 90.0, 89.0, 91.0, 89.0, 91.0, 89.0, 90.0, 91.0, 88.0, 88.0, 85.0, 84.0, 81.0, 78.0, 75.0, 72.0, 68.0, 65.0, 60.0, 57.0, 51.0, 47.0, 40.0, 32.0, 23.0, 14.0, 4.0, -5.0, -15.0, -29.0, -38.0, -47.0, -60.0, -66.0, -71.0, -74.0, -81.0, 81.0, 79.0, 76.0, 72.0, 67.0, 61.0, 51.0, 43.0, 35.0, 26.0, 18.0, 9.0, 1.0, -6.0, -13.0, -19.0, -23.0, -27.0, -29.0, -31.0, -29.0, -27.0, -25.0, -21.0, -12.0, 7.0, 2.0, -2.0, -6.0, -10.0, -13.0, -15.0, -17.0, -19.0, -20.0, -20.0, -19.0, -17.0, -14.0, -10.0, -6.0, 2.0, -6.0, -10.0, -14.0, -17.0, -19.0, -21.0, -23.0, -22.0, -22.0, -22.0, -21.0, 3.0, 5.0, 8.0, 10.0, 13.0, 19.0, 22.0, 25.0, 28.0, 31.0, 34.0, 37.0, 40.0, 43.0, 46.0, 49.0, 52.0, 55.0, 57.0, 63.0, 65.0, 68.0, 71.0, 73.0, 76.0, 78.0, 81.0, 83.0, 82.0, 84.0, 85.0, 83.0, 83.0, 81.0, 81.0, 78.0, 76.0, 75.0, 73.0, 72.0, 70.0, 69.0, 66.0, 64.0, 62.0, 59.0, 56.0, 54.0, 50.0, 47.0, 43.0, 40.0, 35.0, 31.0, 25.0, 18.0, 11.0, 3.0, -4.0, -17.0, -25.0, -33.0, -41.0, -48.0, -55.0, -66.0, -70.0, -71.0, -71.0, 69.0, 66.0, 61.0, 56.0, 46.0, 38.0, 29.0, 20.0, 11.0, 2.0, -5.0, -14.0, -21.0, -25.0, -32.0, -37.0, -40.0, -42.0, -42.0, -38.0, -35.0, 30.0, 25.0, 18.0, 10.0, 0.0, -6.0, -11.0, -15.0, -17.0, -19.0, -21.0, -21.0, -16.0, -13.0, -8.0, -4.0, 0.0, -5.0, -11.0, -16.0, -21.0, -25.0, -29.0, -32.0, -35.0, -36.0, -36.0, -34.0, -31.0, -27.0, 57.0, 59.0, 61.0, 62.0, 63.0, 64.0, 66.0, 69.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 68.0, 70.0, 72.0, 75.0, -78.0, -81.0, -80.0, 82.0, 84.0, 85.0, 86.0, 87.0, 88.0, 88.0, 89.0, 89.0, 90.0, 90.0, 90.0, 90.0, 87.0, 87.0, 87.0, 87.0, 85.0, 83.0, 80.0, 76.0, 72.0, 68.0, 61.0, 56.0, 50.0, 45.0, 39.0, 34.0, 29.0, 23.0, 18.0, 13.0, 8.0, 6.0, 2.0, -1.0, -3.0, -6.0, -8.0, -9.0, -11.0, -12.0, -12.0, -12.0, -12.0, -12.0, -12.0, -14.0, -12.0, -10.0, -7.0, -4.0, 0.0, -3.0, -5.0, -10.0, -15.0, -20.0, -26.0, -32.0, -37.0, -41.0, -44.0, -47.0, -49.0, -51.0, -53.0, -53.0, -51.0, -49.0, -46.0, 43.0, 38.0, 34.0, 30.0, 26.0, 22.0, 19.0, 16.0, 14.0, 12.0, 10.0, 9.0, 8.0, 8.0, 8.0, 8.0, 8.0, 8.0, 8.0, 9.0, 9.0, 11.0, 13.0, 81.0, 83.0, 89.0, 90.0, 90.0, 89.0, 88.0, 83.0, 77.0, 69.0, 62.0, 52.0, 45.0, 33.0, 22.0, 15.0, 5.0, -1.0, -11.0, -18.0, -24.0, -34.0, -40.0, -46.0, -53.0, -59.0, -65.0, -71.0, -75.0, -76.0, -80.0, -82.0, 85.0, 87.0, 89.0, 90.0, 91.0, 91.0, 91.0, 91.0, 89.0, 87.0, 84.0, 80.0, 77.0, 72.0, 68.0, 63.0, 59.0, 54.0, 48.0, 42.0, 35.0, 29.0, 22.0, 16.0, 9.0, 3.0, -3.0, -9.0, -16.0, -22.0, -27.0, -31.0, -34.0, -38.0, -41.0, -44.0, -46.0, -47.0, -47.0, -47.0, -47.0, 46.0, 44.0, 42.0, 38.0, 34.0, 29.0, 23.0, 16.0, 10.0, 3.0, -2.0, -9.0, -15.0, -19.0, -25.0, -30.0, -36.0, -40.0, -44.0, -47.0, -51.0, -54.0, -54.0, 56.0, 57.0, 58.0, 59.0, -60.0, -60.0, 60.0, 60.0, 59.0, 57.0, 55.0, 52.0, 49.0, 45.0, 42.0, 38.0, 35.0, 33.0, 30.0, 28.0, 23.0, 18.0, 13.0, 4.0};
    }

    public static class BFTs {
        public static final double[] bfts = new double[]{28.0, 28.0, 28.0, 29.0, 29.0, 30.0, 30.0, 31.0, 31.0, 32.0, 32.0, 33.0, 34.0, 34.0, 35.0, 36.0, 36.0, 37.0, 37.0, 38.0, 39.0, 39.0, 40.0, 40.0, 41.0, 41.0, 41.0, 41.0, 41.0, 41.0, 41.0, 41.0, 41.0, 41.0, 41.0, 41.0, 41.0, 41.0, 41.0, 41.0, 41.0, 41.0, 41.0, 41.0, 41.0, 41.0, 41.0, 41.0, 40.0, 40.0, 40.0, 40.0, 39.0, 39.0, 39.0, 38.0, 38.0, 37.0, 37.0, 36.0, 36.0, 35.0, 34.0, 34.0, 33.0, 33.0, 32.0, 31.0, 31.0, 30.0, 29.0, 29.0, 28.0, 27.0, 26.0, 26.0, 25.0, 24.0, 23.0, 22.0, 21.0, 21.0, 21.0, 21.0, 21.0, 21.0, 21.0, 21.0, 21.0, 22.0, 22.0, 22.0, 22.0, 23.0, 23.0, 23.0, 23.0, 23.0, 23.0, 23.0, 24.0, 24.0, 24.0, 24.0, 24.0, 24.0, 24.0, 24.0, 24.0, 24.0, 24.0, 25.0, 25.0, 25.0, 26.0, 26.0, 27.0, 27.0, 27.0, 28.0, 22.0, 22.0, 22.0, 22.0, 22.0, 23.0, 23.0, 24.0, 24.0, 25.0, 25.0, 26.0, 26.0, 27.0, 28.0, 28.0, 29.0, 29.0, 30.0, 31.0, 31.0, 32.0, 32.0, 33.0, 34.0, 34.0, 35.0, 35.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 35.0, 35.0, 34.0, 34.0, 34.0, 34.0, 33.0, 33.0, 32.0, 32.0, 31.0, 31.0, 31.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 29.0, 30.0, 30.0, 31.0, 31.0, 31.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 38.0, 38.0, 38.0, 38.0, 38.0, 37.0, 37.0, 37.0, 37.0, 37.0, 37.0, 37.0, 37.0, 37.0, 37.0, 37.0, 37.0, 37.0, 37.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 37.0, 37.0, 37.0, 37.0, 37.0, 38.0, 38.0, 38.0, 38.0, 38.0, 39.0, 39.0, 39.0, 39.0, 40.0, 40.0, 40.0, 40.0, 40.0, 41.0, 41.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 28.0, 29.0, 29.0, 29.0, 29.0, 29.0, 30.0, 30.0, 31.0, 31.0, 31.0, 32.0, 32.0, 32.0, 33.0, 33.0, 33.0, 34.0, 34.0, 34.0, 35.0, 35.0, 35.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 35.0, 35.0, 35.0, 35.0, 34.0, 34.0, 33.0, 33.0, 33.0, 33.0, 33.0, 32.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 37.0, 37.0, 37.0, 37.0, 37.0, 38.0, 38.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 38.0, 38.0, 44.0, 44.0, 44.0, 45.0, 45.0, 45.0, 46.0, 46.0, 46.0, 46.0, 47.0, 47.0, 47.0, 48.0, 48.0, 48.0, 48.0, 49.0, 49.0, 49.0, 49.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 49.0, 49.0, 49.0, 49.0, 48.0, 48.0, 47.0, 47.0, 47.0, 46.0, 46.0, 46.0, 45.0, 45.0, 45.0, 45.0, 44.0, 44.0, 44.0, 43.0, 43.0, 43.0, 42.0, 42.0, 42.0, 41.0, 41.0, 41.0, 40.0, 40.0, 39.0, 39.0, 38.0, 38.0, 37.0, 37.0, 36.0, 36.0, 35.0, 35.0, 34.0, 34.0, 33.0, 33.0, 33.0, 33.0, 33.0, 32.0, 32.0, 32.0, 32.0, 31.0, 31.0, 30.0, 30.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 30.0, 30.0, 31.0, 31.0, 32.0, 32.0, 32.0, 33.0, 33.0, 33.0, 34.0, 34.0, 34.0, 35.0, 35.0, 36.0, 36.0, 36.0, 36.0, 37.0, 37.0, 37.0, 37.0, 38.0, 38.0, 49.0, 50.0, 50.0, 50.0, 50.0, 51.0, 51.0, 51.0, 51.0, 51.0, 51.0, 51.0, 51.0, 51.0, 51.0, 50.0, 50.0, 50.0, 50.0, 49.0, 49.0, 49.0, 49.0, 49.0, 49.0, 49.0, 49.0, 49.0, 49.0, 49.0, 49.0, 48.0, 48.0, 48.0, 48.0, 47.0, 47.0, 47.0, 46.0, 46.0, 46.0, 46.0, 45.0, 45.0, 44.0, 44.0, 43.0, 42.0, 42.0, 42.0, 41.0, 41.0, 40.0, 40.0, 39.0, 39.0, 38.0, 37.0, 37.0, 36.0, 36.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 36.0, 36.0, 36.0, 36.0, 36.0, 37.0, 37.0, 37.0, 37.0, 37.0, 37.0, 37.0, 37.0, 37.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 37.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 37.0, 37.0, 37.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 39.0, 39.0, 39.0, 44.0, 44.0, 43.0, 43.0, 42.0, 42.0, 41.0, 41.0, 40.0, 50.0, 49.0, 49.0, 48.0, 47.0, 46.0, 46.0, 45.0, 44.0, 43.0, 42.0, 41.0, 41.0, 40.0, 39.0, 39.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 30.0, 38.0, 30.0, 38.0, 39.0, 29.0, 39.0, 29.0, 39.0, 29.0, 39.0, 39.0, 28.0, 38.0, 28.0, 38.0, 28.0, 27.0, 27.0, 26.0, 26.0, 26.0, 25.0, 25.0, 25.0, 25.0, 25.0, 25.0, 25.0, 25.0, 25.0, 26.0, 26.0, 26.0, 27.0, 27.0, 28.0, 28.0, 28.0, 28.0, 29.0, 29.0, 29.0, 29.0, 30.0, 30.0, 30.0, 30.0, 30.0, 31.0, 31.0, 31.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 31.0, 31.0, 31.0, 31.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 19.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 26.0, 27.0, 28.0, 29.0, 30.0, 32.0, 33.0, 34.0, 34.0, 35.0, 35.0, 36.0, 36.0, 37.0, 37.0, 37.0, 37.0, 37.0, 37.0, 36.0, 36.0, 35.0, 35.0, 34.0, 33.0, 33.0, 32.0, 31.0, 31.0, 31.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 31.0, 31.0, 32.0, 32.0, 33.0, 33.0, 33.0, 34.0, 34.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 34.0, 34.0, 33.0, 33.0, 32.0, 32.0, 31.0, 31.0, 30.0, 29.0, 29.0, 28.0, 28.0, 27.0, 26.0, 26.0, 25.0, 24.0, 24.0, 23.0, 23.0, 22.0, 21.0, 21.0, 20.0, 19.0, 18.0, 18.0, 17.0, 16.0, 16.0, 15.0, 14.0, 13.0, 13.0, 12.0, 12.0, 12.0, 12.0, 12.0, 12.0, 12.0, 12.0, 12.0, 12.0, 11.0, 11.0, 11.0, 12.0, 12.0, 12.0, 13.0, 13.0, 14.0, 15.0, 15.0, 16.0, 23.0, 24.0, 24.0, 25.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 37.0, 38.0, 39.0, 40.0, 41.0, 41.0, 42.0, 43.0, 43.0, 44.0, 44.0, 44.0, 44.0, 44.0, 44.0, 44.0, 43.0, 43.0, 43.0, 42.0, 42.0, 42.0, 41.0, 41.0, 40.0, 40.0, 40.0, 39.0, 39.0, 38.0, 38.0, 37.0, 37.0, 37.0, 36.0, 36.0, 35.0, 34.0, 34.0, 33.0, 33.0, 33.0, 32.0, 32.0, 31.0, 31.0, 31.0, 31.0, 30.0, 30.0, 30.0, 29.0, 29.0, 29.0, 28.0, 27.0, 27.0, 26.0, 26.0, 25.0, 25.0, 24.0, 24.0, 24.0, 24.0, 23.0, 23.0, 24.0, 24.0, 24.0, 25.0, 25.0, 25.0, 25.0, 25.0, 26.0, 26.0, 26.0, 26.0, 26.0, 27.0, 27.0, 27.0, 28.0, 28.0, 28.0, 29.0, 29.0, 30.0, 30.0, 30.0, 31.0, 31.0, 31.0, 32.0, 32.0, 32.0, 32.0, 33.0, 33.0, 33.0, 33.0, 33.0, 24.0, 25.0, 25.0, 25.0, 25.0, 25.0, 26.0, 26.0, 26.0, 27.0, 27.0, 27.0, 28.0, 28.0, 28.0, 29.0, 29.0, 29.0, 30.0, 30.0, 30.0, 31.0, 31.0, 31.0, 32.0, 32.0, 32.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 32.0, 32.0, 32.0, 32.0, 31.0, 31.0, 31.0, 30.0, 30.0, 30.0, 30.0, 30.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 28.0, 28.0, 28.0, 28.0, 29.0, 29.0, 28.0, 28.0, 28.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 31.0, 31.0, 31.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 33.0, 49.0, 49.0, 49.0, 48.0, 48.0, 47.0, 47.0, 47.0, 46.0, 46.0, 45.0, 45.0, 44.0, 44.0, 44.0, 43.0, 43.0, 43.0, 42.0, 42.0, 42.0, 42.0, 41.0, 41.0, 41.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 43.0, 43.0, 43.0, 43.0, 44.0, 44.0, 44.0, 45.0, 45.0, 46.0, 46.0, 47.0, 47.0, 48.0, 48.0, 48.0, 49.0, 49.0, 49.0, 49.0, 49.0, 50.0, 50.0, 50.0, 50.0, 50.0, 49.0, 49.0, 49.0, 49.0, 49.0, 49.0, 49.0, 48.0, 48.0, 48.0, 48.0, 47.0, 47.0, 47.0, 46.0, 46.0, 45.0, 45.0, 44.0, 44.0, 43.0, 43.0, 42.0, 41.0, 41.0, 40.0, 40.0, 39.0, 38.0, 37.0, 37.0, 37.0, 36.0, 36.0, 35.0, 35.0, 35.0, 34.0, 34.0, 34.0, 33.0, 33.0, 33.0, 32.0, 32.0, 31.0, 31.0, 30.0, 29.0, 28.0, 27.0, 27.0, 26.0, 25.0, 16.0, 16.0, 16.0, 17.0, 17.0, 18.0, 18.0, 19.0, 20.0, 20.0, 21.0, 22.0, 22.0, 23.0, 24.0, 24.0, 25.0, 25.0, 26.0, 26.0, 27.0, 27.0, 27.0, 27.0, 27.0, 27.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 27.0, 27.0, 27.0, 27.0, 27.0, 26.0, 26.0, 26.0, 26.0, 25.0, 25.0, 24.0, 24.0, 24.0, 24.0, 24.0, 24.0, 24.0, 24.0, 24.0, 25.0, 25.0, 25.0, 26.0, 26.0, 26.0, 27.0, 27.0, 28.0, 29.0, 29.0, 30.0, 31.0, 32.0, 32.0, 33.0, 34.0, 35.0, 35.0, 36.0, 37.0, 37.0, 37.0, 37.0, 37.0, 36.0, 36.0, 36.0, 36.0, 36.0, 35.0, 35.0, 35.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 37.0, 37.0, 37.0, 37.0, 37.0, 37.0, 15.0, 15.0, 15.0, 15.0, 15.0, 16.0, 16.0, 16.0, 16.0, 16.0, 16.0, 16.0, 17.0, 17.0, 17.0, 17.0, 18.0, 18.0, 18.0, 18.0, 19.0, 19.0, 19.0, 19.0, 18.0, 18.0, 18.0, 19.0, 19.0, 19.0, 19.0, 19.0, 20.0, 20.0, 20.0, 20.0, 21.0, 21.0, 21.0, 21.0, 21.0, 21.0, 20.0, 20.0, 20.0, 20.0, 20.0, 20.0, 20.0, 20.0, 20.0, 20.0, 20.0, 20.0, 21.0, 21.0, 21.0, 22.0, 22.0, 22.0, 22.0, 22.0, 22.0, 22.0, 22.0, 22.0, 22.0, 22.0, 22.0, 22.0, 22.0, 23.0, 23.0, 23.0, 23.0, 24.0, 24.0, 25.0, 25.0, 26.0, 26.0, 27.0, 27.0, 28.0, 28.0, 28.0, 29.0, 29.0, 30.0, 30.0, 30.0, 31.0, 32.0, 32.0, 33.0, 33.0, 33.0, 33.0, 34.0, 34.0, 34.0, 34.0, 34.0, 35.0, 35.0, 35.0, 35.0, 36.0, 36.0, 36.0, 36.0, 37.0, 37.0, 37.0, 37.0, 37.0, 38.0, 38.0, 38.0, 38.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 37.0, 37.0, 37.0, 37.0, 37.0, 37.0, 37.0, 36.0, 37.0, 37.0, 37.0, 37.0, 37.0, 37.0, 38.0, 38.0, 38.0, 38.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 40.0, 40.0, 40.0, 40.0, 41.0, 41.0, 41.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 41.0, 41.0, 41.0, 41.0, 41.0, 40.0, 40.0, 39.0, 39.0, 39.0, 38.0, 38.0, 37.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 35.0, 35.0, 35.0, 34.0, 34.0, 33.0, 32.0, 31.0, 31.0, 30.0, 29.0, 29.0, 28.0, 21.0, 21.0, 21.0, 21.0, 22.0, 22.0, 22.0, 23.0, 23.0, 24.0, 24.0, 25.0, 25.0, 26.0, 26.0, 26.0, 27.0, 27.0, 28.0, 28.0, 29.0, 29.0, 29.0, 30.0, 30.0, 31.0, 31.0, 31.0, 32.0, 32.0, 32.0, 32.0, 33.0, 33.0, 33.0, 33.0, 34.0, 34.0, 34.0, 34.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 37.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 35.0, 35.0, 34.0, 34.0, 33.0, 33.0, 32.0, 31.0, 31.0, 31.0, 30.0, 30.0, 29.0, 29.0, 29.0, 29.0, 28.0, 28.0, 28.0, 28.0, 28.0, 27.0, 27.0, 27.0, 27.0, 27.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 29.0, 29.0, 29.0, 30.0, 30.0, 30.0, 30.0, 31.0, 31.0, 32.0, 32.0, 33.0, 33.0, 33.0, 34.0, 34.0, 35.0, 35.0, 13.0, 13.0, 14.0, 14.0, 15.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 21.0, 22.0, 23.0, 24.0, 24.0, 25.0, 25.0, 26.0, 27.0, 27.0, 28.0, 28.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 30.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 29.0, 29.0, 29.0, 29.0, 30.0, 30.0, 31.0, 31.0, 32.0, 32.0, 33.0, 33.0, 34.0, 34.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 34.0, 34.0, 34.0, 34.0, 18.0, 18.0, 18.0, 19.0, 19.0, 19.0, 20.0, 21.0, 22.0, 22.0, 23.0, 24.0, 25.0, 25.0, 26.0, 27.0, 27.0, 28.0, 29.0, 29.0, 30.0, 30.0, 31.0, 31.0, 32.0, 32.0, 32.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 34.0, 34.0, 34.0, 34.0, 34.0, 35.0, 35.0, 35.0, 36.0, 36.0, 36.0, 37.0, 37.0, 37.0, 37.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 37.0, 37.0, 37.0, 37.0, 37.0, 37.0, 37.0, 37.0, 37.0, 37.0, 37.0, 37.0, 37.0, 37.0, 37.0, 37.0, 36.0, 36.0, 36.0, 36.0, 36.0, 35.0, 35.0, 35.0, 34.0, 34.0, 35.0, 35.0, 35.0, 41.0, 41.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 43.0, 43.0, 43.0, 44.0, 44.0, 45.0, 45.0, 46.0, 46.0, 47.0, 47.0, 48.0, 48.0, 49.0, 49.0, 49.0, 50.0, 50.0, 50.0, 51.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 49.0, 49.0, 49.0, 49.0, 49.0, 49.0, 49.0, 49.0, 48.0, 48.0, 48.0, 48.0, 48.0, 48.0, 48.0, 48.0, 48.0, 47.0, 47.0, 47.0, 47.0, 47.0, 47.0, 47.0, 47.0, 47.0, 47.0, 46.0, 46.0, 46.0, 45.0, 45.0, 45.0, 44.0, 43.0, 43.0, 43.0, 43.0, 43.0, 43.0, 43.0, 43.0, 43.0, 43.0, 42.0, 42.0, 42.0, 42.0, 41.0, 41.0, 41.0, 40.0, 39.0, 38.0, 37.0, 36.0, 35.0, 35.0, 33.0, 32.0, 31.0, 31.0, 30.0, 30.0, 29.0, 29.0, 29.0, 28.0, 28.0, 27.0, 27.0, 27.0, 26.0, 26.0, 26.0, 27.0, 27.0, 27.0, 27.0, 27.0, 28.0, 28.0, 8.0, 9.0, 10.0, 11.0, 12.0, 12.0, 13.0, 14.0, 15.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 20.0, 21.0, 22.0, 23.0, 23.0, 23.0, 24.0, 24.0, 24.0, 24.0, 24.0, 24.0, 24.0, 25.0, 25.0, 25.0, 25.0, 26.0, 26.0, 26.0, 27.0, 27.0, 28.0, 28.0, 29.0, 29.0, 30.0, 30.0, 31.0, 31.0, 31.0, 32.0, 32.0, 32.0, 32.0, 32.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 34.0, 34.0, 34.0, 34.0, 34.0, 35.0, 35.0, 35.0, 35.0, 35.0, 36.0, 36.0, 36.0, 37.0, 37.0, 37.0, 37.0, 38.0, 38.0, 39.0, 39.0, 39.0, 40.0, 40.0, 40.0, 41.0, 41.0, 41.0, 25.0, 26.0, 26.0, 26.0, 27.0, 27.0, 28.0, 28.0, 29.0, 29.0, 30.0, 31.0, 31.0, 32.0, 33.0, 33.0, 34.0, 34.0, 35.0, 36.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 41.0, 42.0, 42.0, 43.0, 43.0, 43.0, 43.0, 43.0, 43.0, 43.0, 43.0, 43.0, 43.0, 43.0, 43.0, 43.0, 43.0, 43.0, 43.0, 43.0, 44.0, 44.0, 44.0, 44.0, 43.0, 43.0, 43.0, 43.0, 43.0, 43.0, 43.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 41.0, 41.0, 41.0, 41.0, 41.0, 41.0, 41.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 39.0, 39.0, 39.0, 38.0, 38.0, 37.0, 37.0, 36.0, 36.0, 36.0, 35.0, 35.0, 35.0, 35.0, 35.0, 34.0, 34.0, 34.0, 34.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 34.0, 34.0, 34.0, 19.0, 19.0, 19.0, 19.0, 19.0, 19.0, 19.0, 19.0, 20.0, 20.0, 21.0, 21.0, 22.0, 23.0, 23.0, 24.0, 24.0, 25.0, 26.0, 26.0, 27.0, 28.0, 28.0, 29.0, 30.0, 30.0, 31.0, 31.0, 32.0, 33.0, 33.0, 34.0, 34.0, 35.0, 35.0, 35.0, 36.0, 36.0, 36.0, 37.0, 37.0, 37.0, 37.0, 37.0, 38.0, 38.0, 39.0, 39.0, 39.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 41.0, 41.0, 41.0, 41.0, 41.0, 41.0, 41.0, 41.0, 40.0, 40.0, 40.0, 40.0, 39.0, 39.0, 39.0, 38.0, 38.0, 37.0, 37.0, 36.0, 36.0, 35.0, 35.0, 35.0, 34.0, 34.0, 34.0, 33.0, 33.0, 33.0, 32.0, 32.0, 31.0, 31.0, 30.0, 30.0, 30.0, 29.0, 29.0, 28.0, 27.0, 27.0, 26.0, 25.0, 25.0, 24.0, 24.0, 23.0, 22.0, 21.0, 21.0, 20.0, 19.0, 19.0, 18.0, 18.0, 18.0, 18.0, 18.0, 18.0, 18.0, 19.0, 19.0, 20.0, 20.0, 30.0, 30.0, 30.0, 30.0, 30.0, 31.0, 31.0, 31.0, 31.0, 32.0, 32.0, 32.0, 32.0, 32.0, 33.0, 33.0, 33.0, 34.0, 34.0, 34.0, 34.0, 35.0, 35.0, 35.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 37.0, 37.0, 37.0, 37.0, 37.0, 37.0, 38.0, 38.0, 38.0, 38.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 38.0, 38.0, 38.0, 38.0, 37.0, 37.0, 37.0, 36.0, 36.0, 36.0, 35.0, 35.0, 34.0, 34.0, 33.0, 33.0, 32.0, 32.0, 32.0, 31.0, 31.0, 31.0, 31.0, 31.0, 32.0, 32.0, 32.0, 32.0, 33.0, 33.0, 33.0, 33.0, 34.0, 34.0, 34.0, 34.0, 4.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 11.0, 13.0, 12.0, 14.0, 14.0, 16.0, 15.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 27.0, 28.0, 28.0, 28.0, 29.0, 29.0, 29.0, 30.0, 30.0, 30.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 33.0, 33.0, 33.0, 34.0, 34.0, 34.0, 34.0, 35.0, 35.0, 35.0, 36.0, 36.0, 36.0, 37.0, 37.0, 37.0, 37.0, 37.0, 37.0, 37.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 34.0, 34.0, 34.0, 34.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 17.0, 17.0, 17.0, 17.0, 17.0, 18.0, 18.0, 18.0, 19.0, 19.0, 20.0, 20.0, 21.0, 21.0, 22.0, 22.0, 23.0, 24.0, 24.0, 25.0, 25.0, 26.0, 26.0, 27.0, 27.0, 28.0, 28.0, 29.0, 29.0, 30.0, 30.0, 31.0, 31.0, 31.0, 32.0, 32.0, 32.0, 32.0, 32.0, 31.0, 31.0, 31.0, 31.0, 30.0, 30.0, 29.0, 29.0, 29.0, 29.0, 29.0, 28.0, 28.0, 28.0, 27.0, 27.0, 27.0, 27.0, 27.0, 27.0, 27.0, 26.0, 26.0, 26.0, 26.0, 26.0, 25.0, 25.0, 25.0, 25.0, 25.0, 25.0, 26.0, 26.0, 27.0, 27.0, 28.0, 28.0, 28.0, 29.0, 29.0, 30.0, 30.0, 30.0, 30.0, 31.0, 31.0, 31.0, 31.0, 31.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 32.0, 32.0, 32.0, 32.0, 33.0, 33.0, 33.0, 33.0, 34.0, 34.0, 34.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 23.0, 23.0, 23.0, 23.0, 24.0, 24.0, 25.0, 25.0, 26.0, 27.0, 27.0, 28.0, 28.0, 29.0, 30.0, 30.0, 30.0, 31.0, 31.0, 32.0, 32.0, 33.0, 33.0, 33.0, 33.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 33.0, 33.0, 33.0, 33.0, 32.0, 32.0, 32.0, 32.0, 32.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 32.0, 32.0, 32.0, 32.0, 32.0, 31.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 33.0, 33.0, 33.0, 34.0, 34.0, 34.0, 34.0, 35.0, 35.0, 35.0, 36.0, 36.0, 36.0, 37.0, 37.0, 37.0, 37.0, 37.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 39.0, 39.0, 39.0, 39.0, 39.0, 12.0, 12.0, 12.0, 13.0, 13.0, 14.0, 14.0, 15.0, 16.0, 16.0, 17.0, 17.0, 18.0, 18.0, 19.0, 19.0, 20.0, 21.0, 21.0, 21.0, 22.0, 22.0, 23.0, 23.0, 24.0, 24.0, 24.0, 25.0, 25.0, 25.0, 25.0, 25.0, 25.0, 25.0, 25.0, 25.0, 25.0, 25.0, 26.0, 26.0, 26.0, 26.0, 27.0, 27.0, 27.0, 28.0, 28.0, 28.0, 28.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 29.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 31.0, 31.0, 31.0, 31.0, 32.0, 32.0, 32.0, 32.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 34.0, 34.0, 34.0, 35.0, 35.0, 35.0, 35.0, 35.0, 36.0, 36.0, 36.0, 36.0, 37.0, 37.0, 37.0, 37.0, 37.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 30.0, 31.0, 31.0, 32.0, 33.0, 33.0, 34.0, 35.0, 35.0, 36.0, 37.0, 37.0, 38.0, 38.0, 38.0, 39.0, 39.0, 39.0, 40.0, 40.0, 40.0, 40.0, 40.0, 41.0, 41.0, 41.0, 41.0, 41.0, 41.0, 42.0, 41.0, 41.0, 41.0, 41.0, 41.0, 41.0, 41.0, 41.0, 41.0, 41.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 38.0, 39.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 37.0, 37.0, 37.0, 37.0, 36.0, 36.0, 36.0, 35.0, 35.0, 35.0, 34.0, 34.0, 34.0, 33.0, 33.0, 33.0, 33.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 31.0, 31.0, 31.0, 31.0, 31.0, 32.0, 32.0, 32.0, 33.0, 33.0, 33.0, 33.0, 34.0, 34.0, 34.0, 34.0, 34.0, 35.0, 35.0, 35.0, 35.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 31.0, 31.0, 31.0, 30.0, 30.0, 30.0, 29.0, 29.0, 29.0, 28.0, 28.0, 27.0, 27.0, 26.0, 26.0, 26.0, 26.0, 26.0, 26.0, 26.0, 26.0, 26.0, 26.0, 26.0, 26.0, 26.0, 26.0, 26.0, 26.0, 27.0, 27.0, 27.0, 27.0, 27.0, 28.0, 28.0, 28.0, 29.0, 29.0, 30.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 34.0, 34.0, 34.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 34.0, 34.0, 34.0, 33.0, 33.0, 33.0, 33.0, 33.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 31.0, 31.0, 31.0, 31.0, 32.0, 32.0, 32.0, 32.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 32.0, 32.0, 32.0, 32.0, 32.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 25.0, 25.0, 25.0, 26.0, 26.0, 26.0, 27.0, 27.0, 28.0, 29.0, 29.0, 30.0, 31.0, 32.0, 33.0, 33.0, 34.0, 35.0, 35.0, 36.0, 36.0, 37.0, 37.0, 37.0, 37.0, 37.0, 37.0, 37.0, 37.0, 37.0, 37.0, 37.0, 37.0, 37.0, 37.0, 37.0, 37.0, 37.0, 37.0, 37.0, 38.0, 38.0, 38.0, 38.0, 39.0, 39.0, 39.0, 40.0, 40.0, 40.0, 40.0, 41.0, 41.0, 41.0, 41.0, 41.0, 41.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 42.0, 41.0, 41.0, 41.0, 41.0, 41.0, 41.0, 41.0, 41.0, 41.0, 41.0, 41.0, 41.0, 40.0, 40.0, 40.0, 40.0, 40.0, 39.0, 39.0, 39.0, 39.0, 39.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 37.0, 37.0, 37.0, 37.0, 37.0, 37.0, 37.0, 37.0, 37.0, 17.0, 17.0, 17.0, 17.0, 17.0, 17.0, 18.0, 18.0, 19.0, 19.0, 19.0, 20.0, 20.0, 21.0, 21.0, 21.0, 22.0, 22.0, 23.0, 23.0, 24.0, 24.0, 24.0, 25.0, 25.0, 26.0, 26.0, 26.0, 26.0, 26.0, 26.0, 27.0, 27.0, 27.0, 27.0, 27.0, 27.0, 28.0, 28.0, 28.0, 29.0, 29.0, 29.0, 30.0, 30.0, 31.0, 31.0, 31.0, 32.0, 32.0, 33.0, 33.0, 34.0, 34.0, 34.0, 35.0, 35.0, 36.0, 36.0, 36.0, 37.0, 37.0, 37.0, 37.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 39.0, 39.0, 39.0, 39.0, 39.0, 40.0, 40.0, 40.0, 41.0, 41.0, 42.0, 42.0, 42.0, 43.0, 43.0, 44.0, 44.0, 44.0, 45.0, 45.0, 45.0, 45.0, 45.0, 44.0, 44.0, 44.0, 44.0, 44.0, 44.0, 44.0, 44.0, 44.0, 44.0, 44.0, 44.0, 44.0, 44.0, 44.0, 44.0, 44.0, 44.0, 44.0, 44.0, 44.0, 45.0, 35.0, 35.0, 35.0, 35.0, 35.0, 36.0, 36.0, 36.0, 36.0, 37.0, 37.0, 37.0, 37.0, 37.0, 37.0, 38.0, 38.0, 38.0, 39.0, 39.0, 39.0, 39.0, 39.0, 40.0, 40.0, 40.0, 40.0, 40.0, 41.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 41.0, 41.0, 41.0, 41.0, 41.0, 42.0, 42.0, 42.0, 43.0, 43.0, 44.0, 44.0, 44.0, 45.0, 45.0, 45.0, 46.0, 47.0, 47.0, 48.0, 48.0, 49.0, 49.0, 50.0, 50.0, 51.0, 51.0, 52.0, 52.0, 53.0, 53.0, 53.0, 53.0, 54.0, 54.0, 54.0, 54.0, 54.0, 55.0, 55.0, 55.0, 55.0, 54.0, 54.0, 54.0, 55.0, 55.0, 55.0, 55.0, 55.0, 55.0, 55.0, 55.0, 55.0, 55.0, 55.0, 55.0, 55.0, 55.0, 55.0, 56.0, 56.0, 56.0, 56.0, 56.0, 56.0, 56.0, 56.0, 55.0, 56.0, 55.0, 55.0, 55.0, 55.0, 55.0, 55.0, 55.0, 55.0, 55.0, 55.0, 17.0, 17.0, 18.0, 18.0, 18.0, 19.0, 19.0, 20.0, 20.0, 21.0, 21.0, 22.0, 22.0, 23.0, 23.0, 24.0, 24.0, 25.0, 25.0, 26.0, 26.0, 26.0, 27.0, 27.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 29.0, 29.0, 29.0, 29.0, 30.0, 30.0, 30.0, 30.0, 31.0, 31.0, 31.0, 31.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 35.0, 35.0, 35.0, 35.0, 36.0, 36.0, 37.0, 37.0, 37.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 37.0, 37.0, 37.0, 37.0, 37.0, 37.0, 36.0, 36.0, 36.0, 36.0, 35.0, 35.0, 14.0, 14.0, 14.0, 15.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 20.0, 20.0, 21.0, 21.0, 22.0, 22.0, 23.0, 23.0, 24.0, 24.0, 24.0, 24.0, 25.0, 25.0, 25.0, 25.0, 25.0, 25.0, 25.0, 25.0, 25.0, 25.0, 25.0, 25.0, 25.0, 25.0, 25.0, 25.0, 25.0, 25.0, 25.0, 25.0, 25.0, 26.0, 26.0, 26.0, 27.0, 27.0, 27.0, 28.0, 28.0, 29.0, 29.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 32.0, 32.0, 32.0, 32.0, 33.0, 33.0, 33.0, 34.0, 34.0, 34.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 36.0, 35.0, 35.0, 35.0, 35.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 33.0, 33.0, 32.0, 32.0, 31.0, 31.0, 30.0, 30.0, 29.0, 29.0, 28.0, 28.0, 28.0, 27.0, 27.0, 26.0, 26.0, 26.0, 25.0, 25.0, 24.0, 24.0, 23.0, 22.0, 22.0, 21.0, 21.0, 21.0, 20.0, 20.0, 20.0, 20.0, 20.0, 21.0, 21.0, 21.0, 21.0, 22.0, 22.0, 23.0, 23.0, 23.0, 24.0, 24.0, 24.0, 25.0, 25.0, 25.0, 26.0, 26.0, 26.0, 26.0, 26.0, 26.0, 26.0, 26.0, 25.0, 25.0, 25.0, 25.0, 25.0, 25.0, 25.0, 25.0, 25.0, 26.0, 26.0, 26.0, 26.0, 26.0, 27.0, 27.0, 28.0, 28.0, 29.0, 29.0, 30.0, 30.0, 30.0, 30.0, 30.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 32.0, 32.0, 32.0, 33.0, 33.0, 33.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 35.0, 35.0, 35.0, 35.0, 35.0, 35.0, 36.0, 35.0, 35.0, 36.0, 36.0, 36.0, 36.0, 35.0, 35.0, 35.0, 35.0, 34.0, 34.0, 34.0, 33.0, 33.0, 32.0, 32.0, 31.0, 31.0, 30.0, 30.0, 29.0, 28.0, 28.0, 27.0, 27.0, 26.0, 25.0, 24.0, 24.0, 23.0, 23.0, 22.0, 22.0, 22.0, 21.0, 21.0, 21.0, 20.0, 20.0, 20.0, 20.0, 21.0, 21.0, 21.0, 22.0, 22.0, 23.0, 23.0, 23.0, 23.0, 24.0, 24.0, 24.0, 24.0, 24.0, 23.0, 23.0, 23.0, 23.0, 23.0, 23.0, 23.0, 23.0, 23.0, 22.0, 23.0, 23.0, 23.0, 23.0, 23.0, 24.0, 24.0, 24.0, 25.0, 25.0, 25.0, 26.0, 26.0, 26.0, 27.0, 27.0, 27.0, 27.0, 27.0, 27.0, 27.0, 27.0, 27.0, 26.0, 26.0, 26.0, 27.0, 27.0, 27.0, 37.0, 37.0, 37.0, 37.0, 38.0, 38.0, 38.0, 38.0, 39.0, 39.0, 39.0, 39.0, 39.0, 38.0, 38.0, 38.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 40.0, 40.0, 39.0, 39.0, 39.0, 39.0, 39.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 38.0, 37.0, 37.0, 37.0, 37.0, 36.0, 36.0, 36.0, 35.0, 35.0, 34.0, 34.0, 34.0, 33.0, 33.0, 33.0, 33.0, 32.0, 33.0, 33.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 33.0, 33.0, 33.0, 33.0, 33.0, 34.0, 34.0, 34.0, 34.0, 34.0, 21.0, 22.0, 22.0, 22.0, 23.0, 23.0, 24.0, 24.0, 25.0, 26.0, 26.0, 27.0, 27.0, 28.0, 28.0, 28.0, 29.0, 29.0, 30.0, 30.0, 30.0, 31.0, 31.0, 31.0, 31.0, 32.0, 32.0, 32.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 33.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 30.0, 30.0, 30.0, 30.0, 30.0, 29.0, 29.0, 29.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 29.0, 29.0, 29.0, 29.0, 29.0, 30.0, 30.0, 30.0, 31.0, 31.0, 31.0, 31.0, 31.0, 32.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 31.0, 32.0, 32.0, 32.0, 32.0, 33.0, 33.0, 33.0, 34.0, 34.0, 35.0, 35.0};
    }

    public static class LVs {
        public static final double[] latVels = new double[]{62.0, 64.0, 65.0, 66.0, 67.0, 74.0, 81.0, 87.0, 93.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 98.0, 97.0, 96.0, 95.0, 94.0, 92.0, 91.0, 89.0, 88.0, 86.0, 85.0, 84.0, 82.0, 81.0, 80.0, 79.0, 78.0, 77.0, 76.0, 75.0, 74.0, 73.0, 73.0, 72.0, 72.0, 71.0, 71.0, 71.0, 70.0, 70.0, 69.0, 68.0, 68.0, 66.0, 62.0, 57.0, 50.0, 44.0, 38.0, 32.0, 25.0, 19.0, 13.0, 7.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.0, 25.0, 37.0, 50.0, 55.0, 61.0, 67.0, 74.0, 80.0, 86.0, 92.0, 98.0, 98.0, 98.0, 86.0, 74.0, 62.0, 50.0, 43.0, 37.0, 31.0, 25.0, 18.0, 53.0, 59.0, 66.0, 67.0, 68.0, 74.0, 81.0, 87.0, 93.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 98.0, 98.0, 96.0, 96.0, 94.0, 93.0, 91.0, 89.0, 88.0, 86.0, 84.0, 84.0, 83.0, 83.0, 83.0, 83.0, 83.0, 83.0, 83.0, 84.0, 84.0, 78.0, 70.0, 61.0, 50.0, 43.0, 37.0, 31.0, 25.0, 19.0, 13.0, 7.0, 1.0, 2.0, 1.0, 0.0, 1.0, 1.0, 13.0, 25.0, 37.0, 50.0, 56.0, 62.0, 68.0, 74.0, 81.0, 87.0, 93.0, 99.0, 99.0, 99.0, 87.0, 74.0, 62.0, 50.0, 50.0, 43.0, 37.0, 31.0, 25.0, 37.0, 31.0, 25.0, 19.0, 31.0, 25.0, 37.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 56.0, 62.0, 68.0, 74.0, 62.0, 50.0, 50.0, 50.0, 62.0, 68.0, 74.0, 81.0, 87.0, 93.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 98.0, 98.0, 97.0, 97.0, 96.0, 95.0, 94.0, 93.0, 92.0, 91.0, 90.0, 89.0, 89.0, 88.0, 80.0, 71.0, 61.0, 50.0, 43.0, 37.0, 31.0, 25.0, 18.0, 12.0, 6.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 2.0, 2.0, 2.0, 13.0, 25.0, 37.0, 50.0, 56.0, 62.0, 68.0, 74.0, 81.0, 87.0, 74.0, 62.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 43.0, 37.0, 31.0, 25.0, 19.0, 13.0, 25.0, 37.0, 50.0, 50.0, 50.0, 50.0, 73.0, 65.0, 66.0, 67.0, 74.0, 81.0, 87.0, 93.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 100.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 98.0, 98.0, 98.0, 98.0, 98.0, 98.0, 97.0, 97.0, 97.0, 97.0, 97.0, 96.0, 96.0, 85.0, 73.0, 61.0, 50.0, 44.0, 38.0, 32.0, 26.0, 20.0, 15.0, 9.0, 20.0, 32.0, 44.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 56.0, 62.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 43.0, 37.0, 31.0, 25.0, 18.0, 12.0, 6.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.0, 25.0, 37.0, 50.0, 56.0, 62.0, 68.0, 74.0, 61.0, 65.0, 72.0, 79.0, 84.0, 88.0, 95.0, 96.0, 97.0, 96.0, 94.0, 93.0, 91.0, 92.0, 94.0, 95.0, 96.0, 97.0, 96.0, 95.0, 93.0, 91.0, 82.0, 72.0, 68.0, 68.0, 68.0, 68.0, 68.0, 67.0, 66.0, 64.0, 63.0, 61.0, 59.0, 57.0, 55.0, 52.0, 50.0, 51.0, 53.0, 56.0, 58.0, 60.0, 62.0, 63.0, 70.0, 77.0, 83.0, 89.0, 94.0, 94.0, 94.0, 94.0, 94.0, 94.0, 94.0, 94.0, 94.0, 94.0, 94.0, 94.0, 94.0, 94.0, 94.0, 94.0, 92.0, 90.0, 88.0, 86.0, 84.0, 83.0, 86.0, 89.0, 91.0, 94.0, 96.0, 97.0, 96.0, 95.0, 94.0, 93.0, 91.0, 90.0, 93.0, 94.0, 82.0, 70.0, 78.0, 85.0, 92.0, 80.0, 67.0, 55.0, 47.0, 41.0, 36.0, 30.0, 24.0, 19.0, 30.0, 41.0, 51.0, 57.0, 63.0, 69.0, 75.0, 82.0, 89.0, 95.0, 99.0, 87.0, 93.0, 99.0, 99.0, 99.0, 99.0, 99.0, 98.0, 97.0, 55.0, 61.0, 67.0, 68.0, 68.0, 68.0, 68.0, 68.0, 67.0, 71.0, 75.0, 80.0, 86.0, 92.0, 92.0, 93.0, 94.0, 94.0, 95.0, 96.0, 98.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 98.0, 99.0, 86.0, 74.0, 62.0, 68.0, 74.0, 80.0, 87.0, 93.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 98.0, 99.0, 99.0, 99.0, 99.0, 99.0, 98.0, 99.0, 87.0, 75.0, 62.0, 50.0, 50.0, 50.0, 43.0, 37.0, 31.0, 25.0, 18.0, 12.0, 25.0, 37.0, 31.0, 25.0, 19.0, 31.0, 43.0, 37.0, 31.0, 25.0, 19.0, 13.0, 6.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 2.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 2.0, 2.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 2.0, 4.0, 3.0, 2.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 3.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 51.0, 51.0, 51.0, 51.0, 51.0, 51.0, 51.0, 51.0, 51.0, 51.0, 51.0, 51.0, 51.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 52.0, 48.0, 44.0, 0.0, 38.0, 1.0, 31.0, 24.0, 1.0, 17.0, 2.0, 10.0, 2.0, 3.0, 0.0, 2.0, 0.0, 3.0, 0.0, 3.0, 3.0, 4.0, 4.0, 4.0, 5.0, 4.0, 4.0, 4.0, 4.0, 15.0, 26.0, 38.0, 50.0, 55.0, 61.0, 67.0, 73.0, 79.0, 85.0, 90.0, 96.0, 84.0, 91.0, 98.0, 86.0, 74.0, 62.0, 50.0, 56.0, 46.0, 41.0, 36.0, 33.0, 29.0, 23.0, 16.0, 9.0, 20.0, 31.0, 41.0, 50.0, 44.0, 37.0, 31.0, 43.0, 37.0, 31.0, 43.0, 37.0, 31.0, 43.0, 53.0, 59.0, 65.0, 71.0, 78.0, 84.0, 90.0, 96.0, 99.0, 99.0, 99.0, 99.0, 99.0, 87.0, 93.0, 99.0, 87.0, 74.0, 62.0, 50.0, 49.0, 49.0, 49.0, 49.0, 49.0, 49.0, 49.0, 49.0, 49.0, 49.0, 49.0, 49.0, 49.0, 49.0, 49.0, 49.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 53.0, 57.0, 60.0, 64.0, 69.0, 73.0, 77.0, 81.0, 85.0, 88.0, 91.0, 94.0, 96.0, 98.0, 99.0, 99.0, 99.0, 99.0, 98.0, 96.0, 94.0, 93.0, 93.0, 94.0, 94.0, 94.0, 94.0, 94.0, 94.0, 84.0, 91.0, 98.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 98.0, 98.0, 96.0, 95.0, 94.0, 93.0, 94.0, 94.0, 94.0, 94.0, 94.0, 94.0, 94.0, 93.0, 93.0, 93.0, 92.0, 92.0, 91.0, 91.0, 90.0, 90.0, 89.0, 89.0, 88.0, 87.0, 77.0, 81.0, 86.0, 85.0, 86.0, 86.0, 85.0, 84.0, 77.0, 68.0, 59.0, 62.0, 64.0, 66.0, 67.0, 69.0, 71.0, 70.0, 69.0, 66.0, 59.0, 50.0, 44.0, 39.0, 33.0, 28.0, 22.0, 16.0, 48.0, 50.0, 51.0, 52.0, 54.0, 55.0, 57.0, 58.0, 60.0, 62.0, 63.0, 63.0, 64.0, 64.0, 65.0, 62.0, 66.0, 66.0, 63.0, 67.0, 68.0, 64.0, 63.0, 67.0, 64.0, 64.0, 67.0, 65.0, 62.0, 57.0, 50.0, 44.0, 38.0, 32.0, 25.0, 19.0, 14.0, 8.0, 2.0, 2.0, 2.0, 3.0, 3.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 6.0, 5.0, 5.0, 5.0, 5.0, 5.0, 4.0, 4.0, 4.0, 4.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 16.0, 27.0, 38.0, 50.0, 55.0, 60.0, 66.0, 69.0, 62.0, 67.0, 72.0, 78.0, 82.0, 85.0, 78.0, 71.0, 64.0, 59.0, 59.0, 50.0, 50.0, 55.0, 50.0, 55.0, 61.0, 67.0, 73.0, 79.0, 85.0, 91.0, 97.0, 98.0, 98.0, 98.0, 98.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 94.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 43.0, 37.0, 31.0, 25.0, 18.0, 12.0, 6.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.0, 25.0, 38.0, 50.0, 55.0, 60.0, 66.0, 71.0, 77.0, 82.0, 89.0, 95.0, 95.0, 95.0, 96.0, 96.0, 96.0, 97.0, 97.0, 97.0, 98.0, 98.0, 98.0, 98.0, 86.0, 74.0, 62.0, 50.0, 43.0, 37.0, 31.0, 25.0, 18.0, 12.0, 6.0, 0.0, 0.0, 12.0, 25.0, 37.0, 31.0, 25.0, 18.0, 12.0, 6.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 13.0, 6.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.0, 15.0, 28.0, 40.0, 51.0, 57.0, 63.0, 68.0, 74.0, 79.0, 84.0, 89.0, 92.0, 92.0, 86.0, 76.0, 83.0, 90.0, 97.0, 97.0, 97.0, 50.0, 49.0, 47.0, 43.0, 37.0, 31.0, 27.0, 23.0, 16.0, 15.0, 15.0, 14.0, 14.0, 11.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 12.0, 13.0, 21.0, 29.0, 39.0, 50.0, 50.0, 56.0, 46.0, 40.0, 34.0, 28.0, 21.0, 15.0, 9.0, 3.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 14.0, 7.0, 0.0, 0.0, 13.0, 6.0, 19.0, 12.0, 25.0, 38.0, 50.0, 55.0, 61.0, 67.0, 73.0, 79.0, 85.0, 91.0, 97.0, 97.0, 97.0, 97.0, 97.0, 97.0, 97.0, 96.0, 97.0, 97.0, 97.0, 97.0, 97.0, 96.0, 96.0, 96.0, 96.0, 96.0, 96.0, 96.0, 95.0, 95.0, 95.0, 95.0, 95.0, 97.0, 96.0, 96.0, 96.0, 97.0, 96.0, 97.0, 97.0, 97.0, 97.0, 97.0, 97.0, 98.0, 98.0, 98.0, 98.0, 98.0, 97.0, 96.0, 95.0, 93.0, 92.0, 50.0, 54.0, 59.0, 66.0, 72.0, 79.0, 86.0, 92.0, 97.0, 97.0, 97.0, 97.0, 97.0, 97.0, 97.0, 97.0, 98.0, 98.0, 98.0, 98.0, 98.0, 98.0, 98.0, 85.0, 74.0, 62.0, 50.0, 50.0, 56.0, 61.0, 67.0, 73.0, 79.0, 86.0, 92.0, 98.0, 98.0, 98.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 98.0, 98.0, 98.0, 97.0, 95.0, 93.0, 93.0, 93.0, 93.0, 93.0, 92.0, 83.0, 73.0, 61.0, 50.0, 56.0, 62.0, 67.0, 72.0, 76.0, 79.0, 68.0, 57.0, 61.0, 53.0, 57.0, 50.0, 53.0, 50.0, 45.0, 39.0, 33.0, 26.0, 19.0, 12.0, 6.0, 0.0, 0.0, 32.0, 28.0, 25.0, 22.0, 17.0, 11.0, 9.0, 7.0, 6.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 16.0, 27.0, 38.0, 50.0, 55.0, 62.0, 68.0, 68.0, 68.0, 73.0, 78.0, 83.0, 88.0, 94.0, 94.0, 95.0, 94.0, 95.0, 83.0, 72.0, 61.0, 50.0, 43.0, 37.0, 31.0, 25.0, 37.0, 50.0, 56.0, 62.0, 68.0, 68.0, 72.0, 76.0, 80.0, 86.0, 91.0, 92.0, 93.0, 94.0, 95.0, 96.0, 97.0, 97.0, 98.0, 98.0, 86.0, 74.0, 62.0, 50.0, 56.0, 62.0, 68.0, 73.0, 79.0, 85.0, 90.0, 96.0, 93.0, 92.0, 92.0, 91.0, 91.0, 81.0, 70.0, 77.0, 82.0, 71.0, 76.0, 82.0, 86.0, 91.0, 91.0, 91.0, 92.0, 82.0, 72.0, 61.0, 50.0, 50.0, 50.0, 44.0, 37.0, 31.0, 43.0, 37.0, 31.0, 25.0, 18.0, 12.0, 6.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.0, 25.0, 37.0, 50.0, 50.0, 56.0, 62.0, 68.0, 74.0, 80.0, 86.0, 92.0, 98.0, 98.0, 86.0, 74.0, 62.0, 50.0, 43.0, 37.0, 31.0, 25.0, 19.0, 13.0, 6.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.0, 25.0, 37.0, 50.0, 56.0, 62.0, 68.0, 73.0, 79.0, 85.0, 91.0, 96.0, 96.0, 96.0, 96.0, 84.0, 72.0, 61.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 55.0, 60.0, 66.0, 71.0, 60.0, 50.0, 44.0, 52.0, 45.0, 53.0, 58.0, 63.0, 70.0, 76.0, 65.0, 53.0, 50.0, 50.0, 43.0, 37.0, 31.0, 25.0, 18.0, 12.0, 6.0, 0.0, 12.0, 6.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 13.0, 25.0, 37.0, 50.0, 50.0, 43.0, 37.0, 31.0, 25.0, 19.0, 13.0, 7.0, 0.0, 1.0, 1.0, 1.0, 2.0, 3.0, 16.0, 12.0, 9.0, 11.0, 22.0, 33.0, 43.0, 50.0, 53.0, 50.0, 43.0, 37.0, 31.0, 25.0, 37.0, 31.0, 25.0, 37.0, 31.0, 25.0, 18.0, 31.0, 25.0, 37.0, 31.0, 43.0, 53.0, 45.0, 39.0, 50.0, 57.0, 47.0, 54.0, 46.0, 54.0, 60.0, 66.0, 54.0, 60.0, 66.0, 73.0, 79.0, 85.0, 91.0, 97.0, 99.0, 98.0, 98.0, 98.0, 98.0, 98.0, 98.0, 99.0, 99.0, 99.0, 98.0, 98.0, 99.0, 98.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 98.0, 98.0, 97.0, 96.0, 95.0, 95.0, 94.0, 93.0, 91.0, 90.0, 89.0, 87.0, 85.0, 83.0, 81.0, 79.0, 76.0, 73.0, 70.0, 70.0, 73.0, 73.0, 74.0, 75.0, 75.0, 76.0, 77.0, 80.0, 81.0, 81.0, 82.0, 85.0, 86.0, 86.0, 87.0, 89.0, 90.0, 91.0, 91.0, 93.0, 93.0, 94.0, 95.0, 95.0, 97.0, 97.0, 98.0, 98.0, 98.0, 98.0, 98.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 55.0, 60.0, 66.0, 71.0, 76.0, 81.0, 85.0, 90.0, 90.0, 90.0, 91.0, 93.0, 94.0, 95.0, 96.0, 96.0, 96.0, 97.0, 98.0, 97.0, 97.0, 97.0, 97.0, 97.0, 86.0, 74.0, 62.0, 50.0, 43.0, 37.0, 31.0, 25.0, 18.0, 12.0, 6.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0, 12.0, 25.0, 19.0, 12.0, 25.0, 18.0, 31.0, 25.0, 18.0, 12.0, 6.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.0, 25.0, 18.0, 12.0, 25.0, 37.0, 31.0, 25.0, 18.0, 12.0, 6.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.0, 7.0, 19.0, 13.0, 7.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.0, 6.0, 0.0, 0.0, 0.0, 0.0, 1.0, 2.0, 3.0, 4.0, 50.0, 55.0, 61.0, 67.0, 72.0, 78.0, 83.0, 89.0, 94.0, 94.0, 94.0, 95.0, 96.0, 96.0, 95.0, 95.0, 95.0, 95.0, 96.0, 97.0, 98.0, 98.0, 98.0, 98.0, 98.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 87.0, 74.0, 62.0, 50.0, 43.0, 37.0, 31.0, 25.0, 18.0, 12.0, 6.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.0, 25.0, 37.0, 50.0, 56.0, 62.0, 68.0, 74.0, 81.0, 87.0, 93.0, 99.0, 99.0, 99.0, 99.0, 99.0, 87.0, 74.0, 62.0, 50.0, 43.0, 37.0, 31.0, 25.0, 18.0, 31.0, 25.0, 18.0, 12.0, 6.0, 0.0, 12.0, 25.0, 37.0, 50.0, 56.0, 62.0, 68.0, 74.0, 80.0, 87.0, 93.0, 81.0, 44.0, 38.0, 32.0, 43.0, 53.0, 59.0, 64.0, 69.0, 75.0, 80.0, 85.0, 90.0, 92.0, 91.0, 90.0, 90.0, 89.0, 88.0, 87.0, 87.0, 86.0, 86.0, 85.0, 84.0, 84.0, 84.0, 84.0, 77.0, 69.0, 60.0, 50.0, 43.0, 37.0, 31.0, 25.0, 18.0, 12.0, 6.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 2.0, 4.0, 5.0, 15.0, 26.0, 37.0, 50.0, 56.0, 46.0, 40.0, 35.0, 31.0, 27.0, 25.0, 32.0, 41.0, 51.0, 45.0, 41.0, 38.0, 37.0, 37.0, 34.0, 31.0, 28.0, 31.0, 31.0, 28.0, 31.0, 35.0, 42.0, 50.0, 55.0, 61.0, 68.0, 74.0, 79.0, 85.0, 91.0, 96.0, 96.0, 96.0, 97.0, 97.0, 97.0, 97.0, 97.0, 97.0, 97.0, 97.0, 32.0, 30.0, 27.0, 23.0, 23.0, 20.0, 22.0, 19.0, 21.0, 18.0, 16.0, 14.0, 12.0, 11.0, 9.0, 7.0, 6.0, 5.0, 3.0, 14.0, 25.0, 37.0, 50.0, 55.0, 61.0, 50.0, 43.0, 37.0, 32.0, 26.0, 20.0, 14.0, 9.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 13.0, 25.0, 37.0, 50.0, 56.0, 62.0, 67.0, 74.0, 79.0, 85.0, 91.0, 98.0, 99.0, 99.0, 99.0, 87.0, 74.0, 62.0, 50.0, 44.0, 38.0, 32.0, 26.0, 20.0, 14.0, 25.0, 20.0, 14.0, 8.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 2.0, 3.0, 2.0, 2.0, 2.0, 3.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 50.0, 50.0, 50.0, 50.0, 52.0, 50.0, 50.0, 50.0, 53.0, 50.0, 53.0, 50.0, 52.0, 50.0, 52.0, 50.0, 52.0, 50.0, 52.0, 51.0, 51.0, 52.0, 50.0, 53.0, 50.0, 51.0, 51.0, 51.0, 52.0, 55.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 56.0, 62.0, 68.0, 74.0, 81.0, 87.0, 93.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 87.0, 74.0, 62.0, 50.0, 43.0, 37.0, 31.0, 25.0, 18.0, 12.0, 6.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 2.0, 2.0, 3.0, 4.0, 4.0, 4.0, 5.0, 5.0, 15.0, 10.0, 20.0, 31.0, 26.0, 38.0, 50.0, 56.0, 62.0, 68.0, 74.0, 80.0, 86.0, 92.0, 98.0, 98.0, 98.0, 85.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 48.0, 47.0, 48.0, 48.0, 46.0, 49.0, 43.0, 45.0, 47.0, 49.0, 45.0, 47.0, 49.0, 45.0, 47.0, 49.0, 45.0, 48.0, 48.0, 48.0, 48.0, 48.0, 47.0, 49.0, 46.0, 44.0, 41.0, 39.0, 37.0, 34.0, 32.0, 30.0, 28.0, 26.0, 24.0, 22.0, 20.0, 18.0, 16.0, 14.0, 12.0, 10.0, 8.0, 7.0, 5.0, 4.0, 3.0, 2.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 2.0, 2.0, 2.0, 3.0, 4.0, 5.0, 6.0, 6.0, 6.0, 6.0, 7.0, 6.0, 6.0, 7.0, 7.0, 7.0, 7.0, 7.0, 7.0, 6.0, 8.0, 7.0, 7.0, 6.0, 6.0, 6.0, 7.0, 7.0, 7.0, 7.0, 8.0, 7.0, 8.0, 7.0, 7.0, 7.0, 7.0, 8.0, 7.0, 7.0, 7.0, 6.0, 17.0, 28.0, 39.0, 50.0, 55.0, 60.0, 66.0, 71.0, 76.0, 82.0, 50.0, 50.0, 50.0, 50.0, 44.0, 37.0, 31.0, 25.0, 19.0, 13.0, 25.0, 37.0, 50.0, 56.0, 62.0, 68.0, 74.0, 81.0, 87.0, 93.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 87.0, 74.0, 62.0, 50.0, 43.0, 37.0, 31.0, 25.0, 18.0, 12.0, 6.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.0, 26.0, 38.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 45.0, 41.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 45.0, 40.0, 35.0, 30.0, 25.0, 31.0, 25.0, 19.0, 17.0, 16.0, 17.0, 21.0, 26.0, 34.0, 31.0, 35.0, 32.0, 36.0, 33.0, 36.0, 37.0, 35.0, 33.0, 31.0, 29.0, 27.0, 26.0, 24.0, 22.0, 20.0, 18.0, 16.0, 14.0, 12.0, 10.0, 8.0, 7.0, 5.0, 4.0, 2.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.0, 25.0, 37.0, 50.0, 56.0, 62.0, 68.0, 74.0, 80.0, 86.0, 92.0, 98.0, 98.0, 86.0, 92.0, 98.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 87.0, 74.0, 62.0, 50.0, 43.0, 37.0, 31.0, 25.0, 18.0, 12.0, 6.0, 0.0, 0.0, 0.0, 12.0, 25.0, 37.0, 31.0, 25.0, 37.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 56.0, 62.0, 68.0, 73.0, 77.0, 80.0, 82.0, 84.0, 80.0, 77.0, 73.0, 69.0, 67.0, 67.0, 67.0, 68.0, 68.0, 68.0, 68.0, 69.0, 69.0, 69.0, 70.0, 71.0, 74.0, 77.0, 79.0, 82.0, 84.0, 86.0, 88.0, 91.0, 92.0, 94.0, 96.0, 97.0, 98.0, 98.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 98.0, 98.0, 97.0, 96.0, 95.0, 95.0, 94.0, 93.0, 92.0, 91.0, 90.0, 79.0, 68.0, 58.0, 50.0, 44.0, 38.0, 31.0, 25.0, 18.0, 12.0, 6.0, 0.0, 0.0, 0.0, 12.0, 25.0, 37.0, 50.0, 56.0, 61.0, 50.0, 50.0, 54.0, 60.0, 65.0, 70.0, 76.0, 81.0, 87.0, 92.0, 81.0, 71.0, 60.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 43.0, 37.0, 31.0, 43.0, 50.0, 43.0, 37.0, 31.0, 25.0, 18.0, 12.0, 25.0, 50.0, 55.0, 61.0, 67.0, 73.0, 79.0, 86.0, 92.0, 98.0, 98.0, 97.0, 95.0, 93.0, 95.0, 96.0, 97.0, 98.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 87.0, 74.0, 62.0, 50.0, 43.0, 37.0, 31.0, 25.0, 20.0, 13.0, 6.0, 0.0, 0.0, 0.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 7.0, 19.0, 30.0, 25.0, 35.0, 45.0, 50.0, 45.0, 50.0, 45.0, 50.0, 45.0, 41.0, 37.0, 34.0, 30.0, 38.0, 46.0, 42.0, 38.0, 46.0, 50.0, 46.0, 50.0, 54.0, 60.0, 66.0, 73.0, 80.0, 86.0, 92.0, 98.0, 98.0, 98.0, 98.0, 98.0, 98.0, 98.0, 98.0, 98.0, 98.0, 98.0, 98.0, 98.0, 98.0, 98.0, 98.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 87.0, 74.0, 62.0, 50.0, 56.0, 50.0, 56.0, 50.0, 56.0, 50.0, 50.0, 50.0, 50.0, 50.0, 56.0, 62.0, 68.0, 74.0, 81.0, 50.0, 45.0, 39.0, 32.0, 26.0, 21.0, 15.0, 9.0, 3.0, 3.0, 3.0, 3.0, 3.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 13.0, 25.0, 37.0, 31.0, 25.0, 37.0, 50.0, 43.0, 38.0, 31.0, 25.0, 19.0, 13.0, 7.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 13.0, 25.0, 37.0, 31.0, 25.0, 19.0, 31.0, 43.0, 37.0, 50.0, 43.0, 37.0, 50.0, 43.0, 37.0, 31.0, 25.0, 19.0, 13.0, 7.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 12.0, 25.0, 37.0, 50.0, 56.0, 62.0, 68.0, 74.0, 80.0, 86.0, 93.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 47.0, 43.0, 38.0, 32.0, 26.0, 18.0, 14.0, 16.0, 13.0, 11.0, 9.0, 7.0, 5.0, 4.0, 2.0, 1.0, 2.0, 1.0, 2.0, 1.0, 1.0, 1.0, 3.0, 2.0, 1.0, 2.0, 4.0, 3.0, 2.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.0, 26.0, 38.0, 50.0, 55.0, 61.0, 67.0, 73.0, 79.0, 85.0, 92.0, 98.0, 98.0, 98.0, 98.0, 98.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 87.0, 74.0, 61.0, 50.0, 44.0, 38.0, 33.0, 27.0, 21.0, 16.0, 10.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 4.0, 4.0, 4.0, 4.0, 3.0, 3.0, 3.0, 1.0, 0.0, 12.0, 25.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 44.0, 37.0, 31.0, 25.0, 19.0, 13.0, 6.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.0, 25.0, 37.0, 50.0, 56.0, 62.0, 68.0, 74.0, 81.0, 87.0, 93.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 87.0, 74.0, 62.0, 50.0, 43.0, 53.0, 45.0, 39.0, 50.0, 44.0, 37.0, 31.0, 25.0, 19.0, 12.0, 6.0, 0.0, 0.0, 0.0, 0.0, 0.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 44.0, 37.0, 31.0, 25.0, 18.0, 12.0, 6.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.0, 25.0, 37.0, 50.0, 56.0, 62.0, 68.0, 56.0, 62.0, 68.0, 74.0, 80.0, 86.0, 93.0, 99.0, 99.0, 99.0, 99.0, 87.0, 74.0, 62.0, 50.0, 56.0, 46.0, 40.0, 34.0, 28.0, 40.0, 51.0, 57.0, 63.0, 70.0, 76.0, 82.0, 88.0, 94.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 87.0, 93.0, 81.0, 68.0, 56.0, 62.0, 50.0, 50.0, 50.0, 50.0, 50.0, 48.0, 51.0, 54.0, 59.0, 63.0, 66.0, 70.0, 74.0, 79.0, 84.0, 87.0, 89.0, 91.0, 93.0, 95.0, 96.0, 97.0, 98.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 98.0, 87.0, 74.0, 62.0, 68.0, 56.0, 47.0, 41.0, 35.0, 29.0, 23.0, 17.0, 29.0, 23.0, 17.0, 11.0, 23.0, 17.0, 28.0, 23.0, 16.0, 9.0, 3.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 13.0, 25.0, 37.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 44.0, 38.0, 50.0, 56.0, 62.0, 68.0, 74.0, 81.0, 87.0, 93.0, 99.0, 99.0, 99.0, 99.0, 87.0, 74.0, 62.0, 50.0, 43.0, 37.0, 31.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 56.0, 61.0, 65.0, 70.0, 74.0, 79.0, 84.0, 88.0, 88.0, 88.0, 87.0, 87.0, 87.0, 87.0, 86.0, 86.0, 86.0, 85.0, 85.0, 86.0, 85.0, 85.0, 86.0, 86.0, 87.0, 87.0, 87.0, 88.0, 88.0, 88.0, 90.0, 92.0, 93.0, 94.0, 95.0, 96.0, 97.0, 98.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 98.0, 98.0, 86.0, 74.0, 62.0, 50.0, 43.0, 37.0, 31.0, 25.0, 18.0, 12.0, 25.0, 38.0, 50.0, 55.0, 60.0, 65.0, 70.0, 76.0, 81.0, 87.0, 93.0, 93.0, 94.0, 94.0, 94.0, 95.0, 95.0, 95.0, 96.0, 96.0, 96.0, 97.0, 97.0, 97.0, 98.0, 98.0, 98.0, 98.0, 99.0, 99.0, 99.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 46.0, 40.0, 34.0, 27.0, 20.0, 13.0, 6.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 5.0, 5.0, 6.0, 6.0, 7.0, 7.0, 7.0, 7.0, 9.0, 9.0, 9.0, 9.0, 9.0, 7.0, 6.0, 6.0, 6.0, 6.0, 5.0, 4.0, 3.0, 2.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.0, 6.0, 0.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 13.0, 8.0, 19.0, 31.0, 25.0, 20.0, 31.0, 43.0, 38.0, 32.0, 26.0, 20.0, 14.0, 8.0, 1.0, 13.0, 7.0, 0.0, 0.0, 12.0, 25.0, 37.0, 50.0, 43.0, 37.0, 31.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 56.0, 46.0, 40.0, 51.0, 44.0, 53.0, 45.0, 53.0, 45.0, 54.0, 45.0, 54.0, 45.0, 54.0, 45.0, 54.0, 45.0, 54.0, 45.0, 53.0, 45.0, 53.0, 59.0, 65.0, 71.0, 77.0, 83.0, 89.0, 95.0, 97.0, 98.0, 98.0, 98.0, 98.0, 98.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 100.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 87.0, 92.0, 80.0, 86.0, 91.0, 80.0, 86.0, 91.0, 96.0, 95.0, 85.0, 74.0, 62.0, 68.0, 73.0, 77.0, 67.0, 56.0, 46.0, 40.0, 34.0, 28.0, 22.0, 15.0, 9.0, 3.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.0, 18.0, 15.0, 12.0, 6.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 50.0, 50.0, 50.0, 53.0, 57.0, 61.0, 65.0, 70.0, 75.0, 81.0, 86.0, 87.0, 88.0, 89.0, 89.0, 90.0, 91.0, 92.0, 93.0, 94.0, 95.0, 96.0, 97.0, 97.0, 98.0, 98.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 99.0, 97.0, 95.0, 92.0, 89.0, 89.0, 88.0, 88.0, 88.0, 88.0, 88.0, 88.0, 88.0, 89.0, 80.0, 71.0, 61.0, 50.0, 43.0, 37.0, 31.0, 25.0, 18.0, 12.0, 6.0, 0.0, 1.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 13.0, 25.0, 37.0, 50.0, 50.0, 55.0, 50.0, 54.0, 59.0, 64.0, 68.0, 75.0, 81.0, 88.0, 77.0, 66.0, 55.0, 50.0, 50.0, 50.0, 50.0, 44.0, 37.0, 31.0, 25.0, 19.0, 12.0, 6.0, 18.0, 31.0, 43.0, 50.0, 50.0, 56.0, 50.0, 56.0, 62.0, 50.0, 56.0, 62.0, 68.0, 74.0, 62.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 48.0, 45.0, 40.0, 34.0, 28.0, 20.0, 13.0, 6.0, 4.0, 3.0, 2.0, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 3.0, 3.0, 3.0, 4.0, 4.0, 3.0, 2.0, 1.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 12.0, 25.0, 37.0, 50.0, 56.0, 62.0, 68.0, 74.0, 80.0, 87.0, 93.0, 99.0, 99.0, 99.0, 99.0, 98.0, 98.0, 98.0, 97.0, 97.0, 96.0, 96.0, 95.0, 95.0, 94.0, 82.0, 72.0, 61.0, 50.0, 44.0, 38.0, 32.0, 26.0, 21.0, 15.0, 10.0, 5.0, 5.0, 6.0, 6.0, 6.0, 16.0, 27.0, 38.0, 50.0, 56.0, 62.0, 68.0, 73.0, 79.0, 85.0, 91.0, 97.0, 96.0, 96.0, 95.0, 95.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 55.0, 61.0, 67.0, 74.0, 81.0, 87.0, 93.0, 98.0, 98.0, 98.0, 98.0, 98.0, 98.0, 98.0, 98.0, 98.0, 98.0, 98.0, 98.0, 98.0, 98.0, 98.0, 98.0, 98.0, 97.0, 96.0, 94.0, 93.0, 92.0, 90.0, 89.0, 87.0, 86.0, 84.0, 82.0, 81.0, 79.0, 77.0, 73.0, 68.0, 60.0, 50.0, 43.0, 37.0, 31.0, 25.0, 18.0, 12.0, 6.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 13.0, 25.0, 37.0, 50.0, 56.0, 62.0, 68.0, 74.0, 80.0, 87.0, 93.0, 99.0, 99.0, 100.0, 99.0, 99.0, 87.0, 74.0, 62.0, 50.0, 43.0, 37.0, 31.0, 25.0, 19.0, 13.0, 7.0, 1.0, 1.0, 0.0, 12.0, 25.0, 37.0, 50.0, 48.0, 43.0, 38.0, 31.0, 24.0, 17.0, 10.0, 4.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.0, 25.0, 37.0, 50.0, 55.0, 60.0, 50.0, 43.0, 37.0, 31.0, 25.0, 19.0, 12.0, 6.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.0, 25.0, 38.0, 50.0, 55.0, 61.0, 67.0, 73.0, 79.0, 84.0, 90.0, 95.0, 95.0, 95.0, 95.0, 95.0, 95.0, 95.0, 94.0, 84.0, 74.0, 62.0, 50.0, 43.0, 37.0, 31.0, 25.0, 19.0, 13.0, 7.0, 1.0, 1.0, 2.0, 2.0, 2.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 14.0, 25.0, 56.0, 62.0, 67.0, 73.0, 79.0, 84.0, 91.0, 98.0, 98.0, 98.0, 98.0, 98.0, 98.0, 98.0, 98.0, 99.0, 99.0, 98.0, 98.0, 98.0, 98.0, 98.0, 98.0, 98.0, 99.0, 99.0, 97.0, 96.0, 85.0, 73.0, 62.0, 50.0, 43.0, 37.0, 31.0, 25.0, 18.0, 12.0, 6.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 13.0, 26.0, 38.0, 50.0, 55.0, 61.0, 67.0, 73.0, 79.0, 85.0, 90.0, 96.0, 96.0, 95.0, 95.0, 94.0, 94.0, 95.0, 95.0, 96.0, 97.0, 85.0, 73.0, 62.0, 50.0, 56.0, 50.0, 43.0, 37.0, 31.0, 43.0, 53.0, 59.0, 48.0, 42.0, 36.0, 29.0, 23.0, 17.0, 11.0, 5.0, 1.0, 1.0, 1.0, 2.0, 14.0, 25.0, 20.0, 15.0, 8.0, 1.0};
    }

    public static class Accels {
        public static final double[] accels = new double[]{100.0, 66.0, 66.0, 66.0, 66.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 66.0, 100.0, 100.0, 100.0, 100.0, 0.0, 100.0, 100.0, 100.0, 0.0, 100.0, 0.0, 0.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 100.0, 100.0, 100.0, 100.0, 0.0, 0.0, 66.0, 66.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 0.0, 0.0, 0.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 0.0, 0.0, 0.0, 66.0, 66.0, 66.0, 100.0, 0.0, 33.0, 66.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 0.0, 0.0, 0.0, 33.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 100.0, 100.0, 0.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 33.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 100.0, 100.0, 100.0, 0.0, 0.0, 0.0, 16.0, 100.0, 100.0, 100.0, 100.0, 100.0, 0.0, 0.0, 8.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 91.0, 0.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 66.0, 66.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 0.0, 0.0, 100.0, 100.0, 100.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 16.0, 100.0, 66.0, 100.0, 66.0, 100.0, 100.0, 66.0, 100.0, 66.0, 100.0, 66.0, 100.0, 83.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 0.0, 100.0, 100.0, 0.0, 0.0, 0.0, 0.0, 100.0, 16.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 0.0, 0.0, 0.0, 16.0, 100.0, 100.0, 100.0, 0.0, 100.0, 100.0, 0.0, 100.0, 100.0, 0.0, 16.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 83.0, 66.0, 66.0, 66.0, 66.0, 0.0, 100.0, 100.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 88.0, 25.0, 100.0, 100.0, 100.0, 100.0, 88.0, 16.0, 20.0, 22.0, 34.0, 63.0, 6.0, 66.0, 100.0, 33.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 39.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 50.0, 0.0, 0.0, 0.0, 8.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 91.0, 66.0, 33.0, 0.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 66.0, 100.0, 16.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 83.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 100.0, 100.0, 66.0, 0.0, 100.0, 0.0, 100.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 66.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 0.0, 0.0, 100.0, 0.0, 100.0, 0.0, 100.0, 33.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 66.0, 66.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 0.0, 0.0, 100.0, 100.0, 100.0, 66.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 100.0, 100.0, 0.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 66.0, 66.0, 100.0, 100.0, 100.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 66.0, 66.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 100.0, 100.0, 100.0, 100.0, 0.0, 0.0, 100.0, 16.0, 25.0, 20.0, 100.0, 100.0, 100.0, 100.0, 0.0, 0.0, 45.0, 66.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 0.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 66.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 100.0, 100.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 66.0, 100.0, 100.0, 100.0, 100.0, 0.0, 100.0, 100.0, 0.0, 100.0, 100.0, 100.0, 0.0, 100.0, 0.0, 100.0, 0.0, 16.0, 25.0, 100.0, 4.0, 100.0, 14.0, 26.0, 20.0, 23.0, 100.0, 100.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 76.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 100.0, 100.0, 0.0, 100.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 100.0, 100.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 100.0, 0.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 77.0, 88.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 0.0, 100.0, 100.0, 100.0, 0.0, 16.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 83.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 16.0, 100.0, 100.0, 100.0, 100.0, 100.0, 0.0, 0.0, 8.0, 29.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 0.0, 100.0, 100.0, 0.0, 0.0, 0.0, 2.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 97.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 0.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 100.0, 0.0, 0.0, 100.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 0.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 100.0, 100.0, 0.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 0.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 0.0, 0.0, 0.0, 100.0, 100.0, 0.0, 0.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 0.0, 66.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 0.0, 0.0, 0.0, 0.0, 66.0, 66.0, 66.0, 66.0, 66.0, 100.0, 100.0, 100.0, 0.0, 33.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 0.0, 66.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 100.0, 0.0, 0.0, 33.0, 100.0, 33.0, 100.0, 33.0, 100.0, 100.0, 100.0, 100.0, 100.0, 0.0, 0.0, 100.0, 100.0, 0.0, 33.0, 100.0, 33.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 33.0, 100.0, 33.0, 100.0, 33.0, 66.0, 66.0, 66.0, 66.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 83.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 100.0, 100.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 0.0, 0.0, 100.0, 0.0, 100.0, 100.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 83.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 16.0, 25.0, 100.0, 4.0, 31.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 68.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 16.0, 100.0, 100.0, 100.0, 0.0, 8.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 91.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 100.0, 0.0, 0.0, 0.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 100.0, 16.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 83.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 100.0, 0.0, 16.0, 100.0, 100.0, 100.0, 100.0, 100.0, 0.0, 100.0, 100.0, 100.0, 0.0, 100.0, 0.0, 100.0, 100.0, 100.0, 100.0, 83.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 66.0, 66.0, 66.0, 66.0, 66.0, 100.0, 100.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 100.0, 0.0, 0.0, 100.0, 100.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 0.0, 100.0, 100.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 100.0, 16.0, 100.0, 8.0, 29.0, 18.0, 23.0, 21.0, 22.0, 22.0, 22.0, 22.0, 22.0, 22.0, 22.0, 22.0, 22.0, 22.0, 22.0, 22.0, 22.0, 22.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 77.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 100.0, 0.0, 100.0, 100.0, 0.0, 100.0, 100.0, 100.0, 66.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 0.0, 0.0, 16.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 83.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 33.0, 16.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 66.0, 100.0, 33.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 0.0, 0.0, 0.0, 33.0, 66.0, 66.0, 66.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 0.0, 0.0, 0.0, 33.0, 66.0, 100.0, 33.0, 100.0, 100.0, 0.0, 100.0, 100.0, 100.0, 100.0, 0.0, 0.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 83.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 83.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 66.0, 0.0, 0.0, 0.0, 0.0, 100.0, 33.0, 100.0, 100.0, 100.0, 0.0, 16.0, 100.0, 8.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 91.0, 66.0, 66.0, 66.0, 0.0, 0.0, 100.0, 100.0, 100.0, 100.0};
    }

    public static class DCTs {
        public static final double[] dirChangeTimes = new double[]{22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 29.0, 30.0, 31.0, 33.0, 34.0, 35.0, 37.0, 38.0, 40.0, 40.0, 41.0, 42.0, 44.0, 45.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 50.0, 51.0, 52.0, 52.0, 53.0, 54.0, 54.0, 55.0, 55.0, 56.0, 57.0, 57.0, 58.0, 59.0, 59.0, 60.0, 60.0, 60.0, 61.0, 61.0, 62.0, 63.0, 63.0, 64.0, 64.0, 65.0, 65.0, 65.0, 66.0, 67.0, 67.0, 68.0, 69.0, 70.0, 70.0, 0.0, 0.0, 1.0, 2.0, 3.0, 4.0, 4.0, 5.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 10.0, 11.0, 12.0, 13.0, 0.0, 0.0, 0.0, 1.0, 2.0, 3.0, 3.0, 4.0, 5.0, 5.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 0.0, 1.0, 2.0, 4.0, 5.0, 5.0, 7.0, 8.0, 9.0, 10.0, 0.0, 0.0, 1.0, 2.0, 3.0, 5.0, 5.0, 6.0, 7.0, 9.0, 10.0, 10.0, 0.0, 16.0, 17.0, 18.0, 20.0, 20.0, 21.0, 23.0, 24.0, 25.0, 26.0, 27.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 40.0, 41.0, 42.0, 43.0, 45.0, 45.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 50.0, 0.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 5.0, 6.0, 7.0, 8.0, 10.0, 10.0, 11.0, 12.0, 0.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 0.0, 0.0, 1.0, 2.0, 4.0, 5.0, 5.0, 6.0, 7.0, 9.0, 10.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 15.0, 0.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 0.0, 0.0, 2.0, 3.0, 4.0, 5.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 15.0, 16.0, 17.0, 18.0, 24.0, 25.0, 25.0, 25.0, 27.0, 28.0, 0.0, 0.0, 2.0, 3.0, 4.0, 5.0, 6.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 15.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 25.0, 26.0, 27.0, 27.0, 28.0, 29.0, 30.0, 30.0, 31.0, 32.0, 34.0, 35.0, 35.0, 36.0, 37.0, 0.0, 0.0, 1.0, 3.0, 4.0, 5.0, 5.0, 6.0, 8.0, 9.0, 10.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 20.0, 21.0, 22.0, 0.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 5.0, 6.0, 7.0, 7.0, 8.0, 9.0, 10.0, 10.0, 11.0, 12.0, 13.0, 13.0, 14.0, 15.0, 0.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 0.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 5.0, 6.0, 20.0, 20.0, 21.0, 22.0, 24.0, 25.0, 25.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 34.0, 35.0, 36.0, 37.0, 39.0, 40.0, 40.0, 42.0, 43.0, 45.0, 45.0, 47.0, 48.0, 49.0, 50.0, 50.0, 0.0, 0.0, 1.0, 2.0, 3.0, 3.0, 4.0, 5.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 11.0, 11.0, 12.0, 13.0, 14.0, 0.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 5.0, 6.0, 7.0, 8.0, 8.0, 9.0, 10.0, 10.0, 11.0, 12.0, 13.0, 14.0, 0.0, 0.0, 1.0, 2.0, 3.0, 5.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 11.0, 12.0, 13.0, 14.0, 0.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 5.0, 7.0, 8.0, 9.0, 10.0, 10.0, 11.0, 13.0, 14.0, 15.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 0.0, 0.0, 1.0, 2.0, 4.0, 5.0, 5.0, 6.0, 7.0, 8.0, 9.0, 3.0, 4.0, 5.0, 5.0, 6.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 15.0, 16.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 24.0, 25.0, 25.0, 26.0, 27.0, 27.0, 28.0, 29.0, 30.0, 30.0, 30.0, 31.0, 31.0, 32.0, 32.0, 33.0, 34.0, 34.0, 35.0, 35.0, 35.0, 36.0, 36.0, 37.0, 37.0, 38.0, 39.0, 39.0, 40.0, 40.0, 40.0, 41.0, 41.0, 42.0, 43.0, 43.0, 44.0, 44.0, 45.0, 0.0, 0.0, 0.0, 2.0, 3.0, 4.0, 5.0, 5.0, 0.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 5.0, 6.0, 6.0, 7.0, 8.0, 9.0, 9.0, 10.0, 10.0, 11.0, 12.0, 13.0, 15.0, 15.0, 17.0, 18.0, 19.0, 20.0, 21.0, 23.0, 24.0, 25.0, 26.0, 0.0, 1.0, 3.0, 4.0, 5.0, 6.0, 7.0, 9.0, 10.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 33.0, 34.0, 35.0, 35.0, 36.0, 38.0, 39.0, 40.0, 41.0, 42.0, 44.0, 45.0, 46.0, 47.0, 48.0, 50.0, 0.0, 0.0, 1.0, 2.0, 4.0, 5.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 11.0, 12.0, 13.0, 13.0, 14.0, 15.0, 15.0, 15.0, 16.0, 16.0, 17.0, 18.0, 18.0, 19.0, 20.0, 20.0, 20.0, 21.0, 22.0, 22.0, 23.0, 24.0, 24.0, 25.0, 25.0, 25.0, 26.0, 26.0, 27.0, 28.0, 28.0, 29.0, 30.0, 31.0, 32.0, 34.0, 35.0, 35.0, 36.0, 38.0, 39.0, 40.0, 42.0, 43.0, 45.0, 45.0, 46.0, 48.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 60.0, 60.0, 61.0, 62.0, 62.0, 63.0, 64.0, 65.0, 65.0, 66.0, 66.0, 67.0, 68.0, 68.0, 69.0, 69.0, 70.0, 70.0, 70.0, 71.0, 72.0, 72.0, 73.0, 74.0, 74.0, 75.0, 75.0, 75.0, 76.0, 77.0, 5.0, 5.0, 0.0, 0.0, 0.0, 0.0, 1.0, 2.0, 3.0, 11.0, 12.0, 13.0, 14.0, 15.0, 15.0, 15.0, 16.0, 17.0, 18.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 25.0, 25.0, 0.0, 0.0, 1.0, 2.0, 2.0, 3.0, 3.0, 4.0, 4.0, 5.0, 5.0, 5.0, 5.0, 5.0, 6.0, 6.0, 7.0, 7.0, 7.0, 8.0, 8.0, 9.0, 9.0, 10.0, 10.0, 11.0, 12.0, 0.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 5.0, 6.0, 8.0, 9.0, 10.0, 10.0, 11.0, 12.0, 14.0, 15.0, 15.0, 16.0, 17.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 5.0, 6.0, 8.0, 9.0, 10.0, 10.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 15.0, 0.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 5.0, 6.0, 7.0, 8.0, 8.0, 9.0, 0.0, 0.0, 1.0, 2.0, 4.0, 5.0, 5.0, 6.0, 7.0, 8.0, 9.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 2.0, 3.0, 4.0, 0.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 14.0, 15.0, 16.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 35.0, 36.0, 37.0, 38.0, 40.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 45.0, 46.0, 47.0, 48.0, 49.0, 49.0, 50.0, 50.0, 50.0, 51.0, 51.0, 52.0, 52.0, 53.0, 53.0, 54.0, 54.0, 54.0, 55.0, 55.0, 55.0, 55.0, 56.0, 56.0, 57.0, 57.0, 58.0, 58.0, 59.0, 59.0, 60.0, 60.0, 60.0, 60.0, 61.0, 61.0, 62.0, 62.0, 63.0, 63.0, 63.0, 64.0, 64.0, 65.0, 65.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 70.0, 0.0, 2.0, 4.0, 5.0, 7.0, 9.0, 10.0, 11.0, 12.0, 0.0, 0.0, 1.0, 3.0, 4.0, 2.0, 3.0, 4.0, 5.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 30.0, 30.0, 31.0, 31.0, 32.0, 32.0, 33.0, 34.0, 34.0, 35.0, 35.0, 35.0, 35.0, 36.0, 37.0, 37.0, 38.0, 0.0, 0.0, 0.0, 0.0, 1.0, 2.0, 2.0, 3.0, 4.0, 5.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 15.0, 16.0, 16.0, 17.0, 18.0, 19.0, 19.0, 20.0, 20.0, 21.0, 22.0, 24.0, 25.0, 25.0, 26.0, 28.0, 29.0, 30.0, 31.0, 32.0, 34.0, 35.0, 35.0, 36.0, 37.0, 38.0, 39.0, 0.0, 0.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 19.0, 12.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 0.0, 0.0, 1.0, 1.0, 2.0, 3.0, 4.0, 5.0, 5.0, 6.0, 7.0, 8.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 15.0, 16.0, 17.0, 18.0, 19.0, 0.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 25.0, 26.0, 28.0, 29.0, 30.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 35.0, 0.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 5.0, 6.0, 7.0, 8.0, 10.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 15.0, 16.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 25.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 35.0, 36.0, 37.0, 38.0, 0.0, 0.0, 1.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 11.0, 12.0, 14.0, 15.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 20.0, 21.0, 21.0, 22.0, 23.0, 24.0, 25.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 0.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 20.0, 22.0, 23.0, 24.0, 25.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 30.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 40.0, 40.0, 41.0, 41.0, 42.0, 43.0, 43.0, 43.0, 44.0, 44.0, 45.0, 45.0, 45.0, 45.0, 45.0, 46.0, 46.0, 46.0, 47.0, 47.0, 48.0, 48.0, 49.0, 50.0, 50.0, 50.0, 51.0, 0.0, 0.0, 0.0, 2.0, 3.0, 4.0, 4.0, 5.0, 5.0, 6.0, 6.0, 7.0, 8.0, 8.0, 9.0, 9.0, 10.0, 10.0, 15.0, 15.0, 17.0, 19.0, 20.0, 20.0, 22.0, 23.0, 25.0, 25.0, 27.0, 29.0, 30.0, 31.0, 33.0, 35.0, 35.0, 36.0, 38.0, 39.0, 40.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 45.0, 47.0, 48.0, 49.0, 50.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 55.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 65.0, 66.0, 67.0, 68.0, 68.0, 69.0, 70.0, 70.0, 70.0, 70.0, 71.0, 72.0, 73.0, 73.0, 74.0, 75.0, 75.0, 76.0, 77.0, 78.0, 79.0, 80.0, 80.0, 81.0, 82.0, 83.0, 84.0, 85.0, 85.0, 87.0, 88.0, 89.0, 90.0, 91.0, 0.0, 2.0, 3.0, 5.0, 6.0, 7.0, 9.0, 10.0, 11.0, 12.0, 14.0, 15.0, 15.0, 16.0, 17.0, 18.0, 19.0, 0.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 11.0, 12.0, 13.0, 14.0, 16.0, 17.0, 18.0, 19.0, 19.0, 20.0, 0.0, 0.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 8.0, 10.0, 10.0, 11.0, 12.0, 13.0, 14.0, 0.0, 0.0, 1.0, 1.0, 2.0, 3.0, 4.0, 0.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 9.0, 10.0, 10.0, 11.0, 12.0, 14.0, 15.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 30.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 35.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 0.0, 0.0, 2.0, 3.0, 4.0, 5.0, 6.0, 8.0, 10.0, 10.0, 12.0, 13.0, 14.0, 15.0, 15.0, 0.0, 1.0, 2.0, 3.0, 5.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 0.0, 0.0, 1.0, 2.0, 4.0, 0.0, 0.0, 1.0, 3.0, 4.0, 5.0, 5.0, 6.0, 7.0, 9.0, 10.0, 10.0, 11.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 20.0, 21.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 2.0, 3.0, 5.0, 5.0, 6.0, 0.0, 0.0, 1.0, 2.0, 3.0, 5.0, 5.0, 6.0, 7.0, 8.0, 10.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 15.0, 17.0, 18.0, 19.0, 20.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 30.0, 31.0, 32.0, 33.0, 33.0, 34.0, 35.0, 35.0, 36.0, 36.0, 37.0, 38.0, 39.0, 40.0, 40.0, 0.0, 0.0, 1.0, 1.0, 2.0, 0.0, 0.0, 0.0, 1.0, 1.0, 2.0, 2.0, 4.0, 4.0, 4.0, 5.0, 5.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 10.0, 0.0, 0.0, 0.0, 1.0, 2.0, 2.0, 3.0, 3.0, 4.0, 4.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 9.0, 10.0, 10.0, 12.0, 13.0, 14.0, 15.0, 16.0, 18.0, 19.0, 20.0, 21.0, 22.0, 24.0, 25.0, 25.0, 26.0, 27.0, 29.0, 30.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 35.0, 35.0, 36.0, 37.0, 37.0, 38.0, 39.0, 39.0, 40.0, 40.0, 41.0, 41.0, 42.0, 43.0, 43.0, 44.0, 45.0, 45.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 50.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 55.0, 55.0, 56.0, 57.0, 57.0, 58.0, 59.0, 59.0, 60.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 70.0, 72.0, 73.0, 74.0, 75.0, 76.0, 78.0, 79.0, 80.0, 81.0, 83.0, 84.0, 85.0, 86.0, 87.0, 88.0, 89.0, 90.0, 91.0, 92.0, 93.0, 94.0, 95.0, 95.0, 96.0, 97.0, 98.0, 99.0, 100.0, 14.0, 15.0, 17.0, 18.0, 20.0, 21.0, 22.0, 23.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 9.0, 10.0, 10.0, 12.0, 13.0, 15.0, 16.0, 17.0, 19.0, 20.0, 20.0, 22.0, 23.0, 24.0, 25.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 30.0, 31.0, 32.0, 33.0, 33.0, 34.0, 35.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 45.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 54.0, 55.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 60.0, 61.0, 62.0, 63.0, 64.0, 64.0, 65.0, 65.0, 66.0, 66.0, 67.0, 68.0, 69.0, 70.0, 70.0, 70.0, 71.0, 72.0, 73.0, 73.0, 74.0, 75.0, 75.0, 76.0, 77.0, 78.0, 79.0, 80.0, 80.0, 81.0, 83.0, 0.0, 1.0, 2.0, 4.0, 5.0, 6.0, 0.0, 0.0, 2.0, 3.0, 4.0, 5.0, 5.0, 5.0, 6.0, 7.0, 19.0, 20.0, 21.0, 22.0, 24.0, 25.0, 26.0, 27.0, 29.0, 30.0, 31.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 45.0, 46.0, 47.0, 47.0, 48.0, 49.0, 50.0, 0.0, 0.0, 1.0, 2.0, 3.0, 5.0, 5.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 14.0, 15.0, 15.0, 0.0, 0.0, 1.0, 3.0, 4.0, 5.0, 5.0, 6.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 11.0, 12.0, 0.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 11.0, 0.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 11.0, 0.0, 0.0, 1.0, 2.0, 2.0, 3.0, 4.0, 5.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 11.0, 0.0, 0.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 5.0, 6.0, 8.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 19.0, 20.0, 20.0, 22.0, 23.0, 24.0, 25.0, 25.0, 27.0, 28.0, 29.0, 30.0, 30.0, 31.0, 32.0, 32.0, 33.0, 34.0, 35.0, 35.0, 36.0, 37.0, 0.0, 0.0, 0.0, 0.0, 1.0, 2.0, 2.0, 3.0, 3.0, 4.0, 5.0, 5.0, 5.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 2.0, 2.0, 3.0, 4.0, 4.0, 5.0, 5.0, 5.0, 6.0, 6.0, 7.0, 8.0, 8.0, 9.0, 10.0, 10.0, 11.0, 0.0, 0.0, 0.0, 1.0, 2.0, 2.0, 3.0, 4.0, 5.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 11.0, 12.0, 13.0, 13.0, 14.0, 15.0, 15.0, 16.0, 17.0, 17.0, 18.0, 19.0, 19.0, 20.0, 20.0, 21.0, 21.0, 22.0, 23.0, 24.0, 25.0, 25.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 30.0, 31.0, 32.0, 34.0, 35.0, 35.0, 36.0, 0.0, 0.0, 1.0, 2.0, 12.0, 14.0, 15.0, 16.0, 17.0, 18.0, 0.0, 0.0, 1.0, 1.0, 0.0, 2.0, 3.0, 5.0, 6.0, 8.0, 10.0, 10.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 20.0, 21.0, 22.0, 23.0, 25.0, 25.0, 0.0, 1.0, 3.0, 5.0, 5.0, 7.0, 9.0, 10.0, 10.0, 0.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 35.0, 36.0, 37.0, 38.0, 38.0, 39.0, 40.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 45.0, 46.0, 47.0, 47.0, 48.0, 49.0, 50.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 55.0, 56.0, 58.0, 59.0, 60.0, 60.0, 61.0, 62.0, 63.0, 7.0, 9.0, 10.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 15.0, 16.0, 17.0, 18.0, 18.0, 19.0, 20.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 25.0, 26.0, 26.0, 27.0, 28.0, 29.0, 30.0, 30.0, 31.0, 31.0, 32.0, 33.0, 34.0, 35.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0, 0.0, 1.0, 2.0, 4.0, 5.0, 5.0, 7.0, 8.0, 9.0, 10.0, 10.0, 10.0, 11.0, 12.0, 13.0, 13.0, 14.0, 15.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 20.0, 21.0, 22.0, 0.0, 0.0, 1.0, 1.0, 2.0, 3.0, 4.0, 5.0, 5.0, 5.0, 6.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 0.0, 0.0, 1.0, 1.0, 2.0, 3.0, 4.0, 4.0, 5.0, 5.0, 5.0, 6.0, 7.0, 8.0, 8.0, 9.0, 10.0, 10.0, 10.0, 11.0, 11.0, 12.0, 12.0, 13.0, 14.0, 15.0, 15.0, 16.0, 0.0, 0.0, 1.0, 0.0, 0.0, 2.0, 5.0, 6.0, 8.0, 10.0, 11.0, 13.0, 14.0, 15.0, 16.0, 17.0, 19.0, 20.0, 20.0, 21.0, 21.0, 22.0, 23.0, 24.0, 25.0, 25.0, 26.0, 27.0, 27.0, 28.0, 29.0, 30.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 35.0, 36.0, 37.0, 38.0, 38.0, 39.0, 40.0, 40.0, 41.0, 42.0, 43.0, 43.0, 44.0, 45.0, 45.0, 46.0, 47.0, 48.0, 49.0, 49.0, 50.0, 50.0, 50.0, 51.0, 52.0, 52.0, 53.0, 54.0, 54.0, 55.0, 55.0, 55.0, 55.0, 56.0, 56.0, 57.0, 57.0, 58.0, 58.0, 59.0, 59.0, 60.0, 60.0, 61.0, 62.0, 62.0, 63.0, 64.0, 65.0, 65.0, 65.0, 66.0, 67.0, 68.0, 68.0, 69.0, 70.0, 0.0, 0.0, 1.0, 2.0, 2.0, 3.0, 4.0, 4.0, 5.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 12.0, 13.0, 15.0, 15.0, 17.0, 19.0, 20.0, 21.0, 22.0, 23.0, 0.0, 0.0, 15.0, 15.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 30.0, 30.0, 31.0, 32.0, 33.0, 34.0, 0.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 10.0, 10.0, 11.0, 12.0, 13.0, 15.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 20.0, 22.0, 23.0, 24.0, 25.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 50.0, 50.0, 51.0, 52.0, 52.0, 53.0, 53.0, 54.0, 55.0, 55.0, 55.0, 56.0, 56.0, 57.0, 58.0, 58.0, 58.0, 59.0, 59.0, 60.0, 60.0, 60.0, 61.0, 61.0, 62.0, 64.0, 65.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 70.0, 71.0, 72.0, 73.0, 74.0, 75.0, 75.0, 4.0, 7.0, 10.0, 13.0, 16.0, 19.0, 21.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 30.0, 31.0, 33.0, 35.0, 36.0, 37.0, 39.0, 40.0, 42.0, 44.0, 45.0, 46.0, 47.0, 49.0, 50.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 60.0, 60.0, 0.0, 0.0, 1.0, 1.0, 2.0, 3.0, 4.0, 5.0, 5.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 0.0, 0.0, 1.0, 3.0, 4.0, 5.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 11.0, 12.0, 14.0, 15.0, 15.0, 16.0, 17.0, 0.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 5.0, 6.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 11.0, 12.0, 13.0, 14.0, 14.0, 0.0, 0.0, 1.0, 1.0, 2.0, 3.0, 4.0, 5.0, 5.0, 6.0, 7.0, 20.0, 22.0, 24.0, 25.0, 27.0, 28.0, 30.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 35.0, 36.0, 38.0, 39.0, 40.0, 40.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 50.0, 51.0, 52.0, 53.0, 53.0, 54.0, 54.0, 55.0, 55.0, 55.0, 55.0, 56.0, 56.0, 56.0, 57.0, 57.0, 57.0, 58.0, 58.0, 59.0, 60.0, 60.0, 60.0, 0.0, 0.0, 0.0, 1.0, 2.0, 4.0, 5.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 0.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 11.0, 13.0, 14.0, 15.0, 16.0, 0.0, 0.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 9.0, 10.0, 10.0, 11.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 25.0, 27.0, 28.0, 29.0, 30.0, 30.0, 0.0, 0.0, 1.0, 2.0, 3.0, 21.0, 22.0, 0.0, 0.0, 1.0, 2.0, 3.0, 5.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 11.0, 12.0, 14.0, 15.0, 15.0, 16.0, 17.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 25.0, 26.0, 27.0, 28.0, 29.0, 29.0, 30.0, 30.0, 31.0, 32.0, 33.0, 34.0, 0.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 5.0, 6.0, 7.0, 8.0, 10.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 15.0, 16.0, 18.0, 19.0, 19.0, 20.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 25.0, 26.0, 27.0, 28.0, 30.0, 30.0, 31.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 40.0, 40.0, 41.0, 43.0, 44.0, 45.0, 46.0, 48.0, 49.0, 50.0, 50.0, 52.0, 53.0, 54.0, 55.0, 55.0, 56.0, 57.0, 59.0, 60.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 65.0, 66.0, 67.0, 67.0, 68.0, 69.0, 70.0, 70.0, 71.0, 72.0, 10.0, 12.0, 13.0, 15.0, 16.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 29.0, 30.0, 31.0, 32.0, 34.0, 35.0, 36.0, 37.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 63.0, 64.0, 65.0, 65.0, 66.0, 67.0, 67.0, 68.0, 69.0, 70.0, 70.0, 71.0, 0.0, 0.0, 2.0, 3.0, 4.0, 5.0, 6.0, 8.0, 10.0, 10.0, 11.0, 13.0, 14.0, 15.0, 16.0, 18.0, 19.0, 20.0, 21.0, 22.0, 24.0, 25.0, 25.0, 27.0, 28.0, 30.0, 30.0, 32.0, 33.0, 35.0, 35.0, 37.0, 38.0, 40.0, 40.0, 41.0, 42.0, 42.0, 43.0, 44.0, 0.0, 0.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 5.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 10.0, 11.0, 33.0, 34.0, 35.0, 36.0, 37.0, 39.0, 40.0, 40.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 55.0, 56.0, 0.0, 0.0, 1.0, 2.0, 2.0, 3.0, 4.0, 4.0, 5.0, 5.0, 5.0, 5.0, 6.0, 6.0, 7.0, 8.0, 8.0, 9.0, 9.0, 10.0, 10.0, 11.0, 11.0, 12.0, 13.0, 14.0, 15.0, 15.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 20.0, 0.0, 0.0, 1.0, 2.0, 2.0, 3.0, 4.0, 5.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 11.0, 12.0, 12.0, 13.0, 14.0, 15.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 25.0, 25.0, 26.0, 27.0, 28.0, 29.0, 29.0, 0.0, 0.0, 1.0, 2.0, 2.0, 3.0, 4.0, 5.0, 5.0, 6.0, 7.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 2.0, 3.0, 3.0, 24.0, 0.0, 0.0, 1.0, 2.0, 4.0, 5.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 18.0, 19.0, 20.0, 21.0, 22.0, 24.0, 25.0, 25.0, 26.0, 28.0, 29.0, 30.0, 30.0, 31.0, 32.0, 33.0, 34.0, 34.0, 35.0, 35.0, 36.0, 37.0, 38.0, 39.0, 39.0, 40.0, 40.0, 0.0, 0.0, 0.0, 1.0, 2.0, 2.0, 3.0, 4.0, 4.0, 5.0, 5.0, 5.0, 6.0, 7.0, 8.0, 8.0, 9.0, 10.0, 10.0, 11.0, 12.0, 12.0, 13.0, 14.0, 15.0, 15.0, 16.0, 16.0, 17.0, 18.0, 19.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 5.0, 5.0, 5.0, 6.0, 7.0, 7.0, 8.0, 9.0, 10.0, 10.0, 11.0, 12.0, 12.0, 13.0, 14.0, 15.0, 15.0, 16.0, 17.0, 18.0, 19.0, 0.0, 0.0, 1.0, 3.0, 4.0, 5.0, 6.0, 7.0, 9.0, 10.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 15.0, 16.0, 17.0, 17.0, 18.0, 19.0, 19.0, 20.0, 20.0, 21.0, 21.0, 22.0, 23.0, 24.0, 24.0, 25.0, 25.0, 26.0, 27.0, 27.0, 28.0, 29.0, 30.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 0.0, 0.0, 1.0, 2.0, 4.0, 5.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 0.0, 0.0, 1.0, 1.0, 2.0, 0.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 12.0, 13.0, 14.0, 15.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 30.0, 30.0, 31.0, 32.0, 33.0, 33.0, 34.0, 35.0, 35.0, 35.0, 35.0, 36.0, 37.0, 38.0, 38.0, 39.0, 20.0, 20.0, 21.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 35.0, 36.0, 37.0, 37.0, 38.0, 39.0, 40.0, 40.0, 40.0, 41.0, 42.0, 43.0, 44.0, 0.0, 0.0, 1.0, 3.0, 4.0, 5.0, 5.0, 6.0, 7.0, 9.0, 10.0, 10.0, 11.0, 12.0, 14.0, 15.0, 15.0, 16.0, 18.0, 19.0, 20.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 29.0, 29.0, 30.0, 30.0, 31.0, 32.0, 33.0, 34.0, 0.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 5.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 11.0, 0.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 5.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 11.0, 12.0, 13.0, 13.0, 14.0, 15.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 20.0, 22.0, 23.0, 24.0, 25.0, 25.0, 0.0, 0.0, 1.0, 2.0, 4.0, 12.0, 13.0, 14.0, 15.0, 15.0, 17.0, 18.0, 19.0, 20.0, 21.0, 23.0, 24.0, 25.0, 26.0, 28.0, 30.0, 31.0, 34.0, 35.0, 37.0, 38.0, 40.0, 41.0, 43.0, 44.0, 45.0, 46.0, 48.0, 49.0, 50.0, 50.0, 52.0, 53.0, 54.0, 55.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 60.0, 61.0, 62.0, 63.0, 65.0, 65.0, 66.0, 67.0, 68.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 5.0, 6.0, 0.0, 0.0, 1.0, 2.0, 2.0, 3.0, 4.0, 5.0, 5.0, 5.0, 6.0, 6.0, 7.0, 8.0, 9.0, 9.0, 10.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 25.0, 27.0, 28.0, 29.0, 30.0, 30.0, 32.0, 33.0, 34.0, 35.0, 35.0, 36.0, 38.0, 39.0, 40.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 45.0, 47.0, 0.0, 1.0, 2.0, 4.0, 5.0, 22.0, 23.0, 24.0, 25.0, 26.0, 28.0, 29.0, 30.0, 30.0, 31.0, 33.0, 34.0, 35.0, 35.0, 36.0, 37.0, 39.0, 40.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 45.0, 47.0, 48.0, 49.0, 50.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 70.0, 71.0, 72.0, 74.0, 75.0, 75.0, 76.0, 77.0, 79.0, 80.0, 80.0, 81.0, 82.0, 83.0, 84.0, 85.0, 85.0, 86.0, 87.0, 88.0, 89.0, 90.0, 90.0, 91.0, 92.0, 93.0, 94.0, 94.0, 95.0, 95.0, 96.0, 97.0, 98.0, 99.0, 100.0, 0.0, 0.0, 0.0, 1.0, 3.0, 4.0, 5.0, 5.0, 6.0, 7.0, 9.0, 10.0, 10.0, 11.0, 0.0, 0.0, 1.0, 2.0, 4.0, 5.0, 5.0, 7.0, 8.0, 10.0, 10.0, 11.0, 13.0, 14.0, 15.0, 15.0, 17.0, 18.0, 19.0, 20.0, 21.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 3.0, 4.0, 5.0, 7.0, 8.0, 10.0, 11.0, 13.0, 14.0, 15.0, 17.0, 19.0, 20.0, 22.0, 23.0, 25.0, 25.0, 27.0, 28.0, 29.0, 30.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 35.0, 35.0, 36.0, 37.0, 38.0, 38.0, 39.0, 40.0, 40.0, 40.0, 41.0, 42.0, 43.0, 43.0, 44.0, 45.0, 45.0, 46.0, 46.0, 0.0, 0.0, 1.0, 2.0, 4.0, 5.0, 5.0, 6.0, 8.0, 9.0, 10.0, 11.0, 13.0, 13.0, 15.0, 15.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 40.0, 42.0, 42.0, 0.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 5.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 11.0, 12.0, 13.0, 15.0, 16.0, 17.0, 19.0, 20.0, 22.0, 24.0, 25.0, 27.0, 28.0, 30.0, 30.0, 31.0, 32.0, 34.0, 35.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 40.0, 41.0, 42.0, 43.0, 43.0, 44.0, 45.0, 45.0, 46.0, 47.0, 48.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 15.0, 0.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 11.0, 12.0, 0.0, 0.0, 2.0, 3.0, 4.0, 5.0, 5.0, 7.0, 8.0, 9.0, 0.0, 0.0, 1.0, 2.0, 4.0, 5.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 15.0, 16.0, 0.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 15.0, 16.0, 17.0, 18.0, 19.0, 3.0, 4.0, 5.0, 5.0, 5.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 20.0, 21.0, 22.0, 23.0, 23.0, 24.0, 25.0, 25.0, 25.0, 26.0, 26.0, 27.0, 27.0, 28.0, 29.0, 29.0, 30.0, 30.0, 30.0, 30.0, 31.0, 31.0, 32.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 2.0, 3.0, 4.0, 5.0, 5.0, 6.0, 7.0, 9.0, 10.0, 10.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 0.0, 0.0, 2.0, 3.0, 4.0, 5.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 0.0, 0.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 12.0, 0.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 5.0, 6.0, 7.0, 8.0, 10.0, 10.0, 11.0, 12.0, 14.0, 0.0, 0.0, 2.0, 3.0, 4.0, 5.0, 25.0, 25.0, 26.0, 27.0, 28.0, 30.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 40.0, 42.0, 43.0, 44.0, 45.0, 45.0, 46.0, 47.0, 48.0, 49.0, 49.0, 50.0, 50.0, 50.0, 51.0, 51.0, 52.0, 52.0, 52.0, 53.0, 53.0, 54.0, 54.0, 55.0, 55.0, 55.0, 55.0, 55.0, 56.0, 56.0, 57.0, 57.0, 0.0, 0.0, 0.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 12.0, 13.0, 14.0, 15.0, 15.0, 16.0, 0.0, 0.0, 2.0, 3.0, 4.0, 5.0, 5.0, 6.0, 7.0, 8.0, 9.0, 9.0, 10.0, 10.0, 11.0, 12.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 5.0, 7.0, 8.0, 9.0, 10.0, 0.0, 0.0, 1.0, 2.0, 4.0, 5.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 11.0, 12.0, 13.0, 0.0, 0.0, 1.0, 2.0, 3.0, 4.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 12.0, 14.0, 14.0, 15.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 25.0, 26.0, 26.0, 27.0, 28.0, 29.0, 30.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 35.0, 36.0, 37.0, 37.0, 38.0, 39.0, 40.0, 40.0, 41.0, 43.0, 0.0, 0.0, 1.0, 3.0, 4.0, 5.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 11.0, 11.0, 12.0, 13.0, 14.0, 15.0, 0.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 5.0, 6.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 11.0, 11.0, 12.0, 13.0, 14.0, 15.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 0.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 0.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 11.0, 17.0, 18.0, 20.0, 20.0, 21.0, 22.0, 24.0, 25.0, 26.0, 0.0, 1.0, 3.0, 4.0, 5.0, 7.0, 8.0, 10.0, 10.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 20.0, 21.0, 21.0, 22.0, 23.0, 24.0, 25.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 30.0, 31.0, 32.0, 33.0, 0.0, 0.0, 1.0, 2.0, 2.0, 3.0, 4.0, 5.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 15.0, 16.0, 17.0, 18.0, 0.0, 0.0, 1.0, 2.0, 0.0, 0.0, 0.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 15.0, 16.0, 16.0, 17.0, 18.0, 19.0, 20.0, 20.0, 21.0, 22.0, 24.0, 25.0, 25.0, 26.0, 27.0, 29.0, 30.0, 30.0, 31.0, 33.0, 34.0, 35.0, 0.0, 1.0, 2.0, 3.0, 5.0};
    }

    public static class DLs {
        public static final double[] dist16Lasts = new double[]{79.0, 77.0, 75.0, 73.0, 70.0, 66.0, 61.0, 56.0, 49.0, 43.0, 37.0, 31.0, 24.0, 18.0, 12.0, 6.0, 0.0, 6.0, 12.0, 18.0, 24.0, 31.0, 37.0, 43.0, 49.0, 56.0, 62.0, 68.0, 74.0, 81.0, 87.0, 93.0, 99.0, 105.0, 112.0, 118.0, 124.0, 130.0, 136.0, 143.0, 149.0, 155.0, 161.0, 167.0, 173.0, 179.0, 185.0, 191.0, 197.0, 202.0, 207.0, 213.0, 218.0, 223.0, 228.0, 233.0, 237.0, 242.0, 247.0, 251.0, 256.0, 260.0, 265.0, 269.0, 274.0, 278.0, 282.0, 287.0, 291.0, 296.0, 300.0, 305.0, 309.0, 314.0, 318.0, 323.0, 328.0, 332.0, 337.0, 341.0, 344.0, 345.0, 345.0, 344.0, 343.0, 340.0, 337.0, 334.0, 329.0, 324.0, 318.0, 313.0, 307.0, 302.0, 297.0, 293.0, 289.0, 286.0, 285.0, 285.0, 286.0, 287.0, 289.0, 292.0, 296.0, 301.0, 306.0, 313.0, 319.0, 325.0, 330.0, 333.0, 334.0, 334.0, 334.0, 332.0, 330.0, 327.0, 323.0, 318.0, 79.0, 77.0, 75.0, 72.0, 69.0, 65.0, 61.0, 55.0, 49.0, 43.0, 37.0, 31.0, 24.0, 18.0, 12.0, 6.0, 0.0, 6.0, 12.0, 18.0, 24.0, 31.0, 37.0, 43.0, 49.0, 56.0, 62.0, 68.0, 74.0, 80.0, 86.0, 93.0, 99.0, 104.0, 110.0, 116.0, 121.0, 127.0, 132.0, 137.0, 142.0, 147.0, 151.0, 156.0, 160.0, 164.0, 168.0, 173.0, 177.0, 181.0, 185.0, 189.0, 193.0, 198.0, 202.0, 205.0, 208.0, 209.0, 209.0, 208.0, 207.0, 204.0, 201.0, 197.0, 193.0, 187.0, 181.0, 175.0, 169.0, 163.0, 157.0, 151.0, 146.0, 143.0, 141.0, 141.0, 142.0, 144.0, 146.0, 149.0, 153.0, 158.0, 163.0, 169.0, 175.0, 182.0, 186.0, 189.0, 190.0, 190.0, 190.0, 190.0, 188.0, 186.0, 183.0, 181.0, 179.0, 176.0, 172.0, 169.0, 166.0, 165.0, 165.0, 165.0, 165.0, 165.0, 165.0, 165.0, 165.0, 165.0, 165.0, 165.0, 167.0, 169.0, 172.0, 174.0, 174.0, 174.0, 174.0, 174.0, 89.0, 86.0, 82.0, 78.0, 73.0, 67.0, 61.0, 55.0, 49.0, 43.0, 37.0, 31.0, 24.0, 18.0, 12.0, 6.0, 0.0, 6.0, 12.0, 18.0, 24.0, 31.0, 37.0, 43.0, 49.0, 55.0, 61.0, 67.0, 73.0, 77.0, 80.0, 82.0, 82.0, 81.0, 80.0, 78.0, 75.0, 71.0, 67.0, 63.0, 58.0, 53.0, 49.0, 45.0, 42.0, 40.0, 39.0, 39.0, 40.0, 42.0, 45.0, 48.0, 52.0, 57.0, 62.0, 67.0, 73.0, 78.0, 84.0, 90.0, 96.0, 102.0, 108.0, 114.0, 120.0, 126.0, 132.0, 139.0, 145.0, 151.0, 157.0, 164.0, 170.0, 176.0, 182.0, 187.0, 190.0, 192.0, 192.0, 191.0, 189.0, 187.0, 184.0, 180.0, 176.0, 173.0, 171.0, 171.0, 171.0, 171.0, 171.0, 171.0, 171.0, 171.0, 171.0, 171.0, 171.0, 171.0, 171.0, 171.0, 171.0, 171.0, 171.0, 171.0, 171.0, 171.0, 171.0, 172.0, 173.0, 176.0, 179.0, 182.0, 187.0, 190.0, 191.0, 191.0, 191.0, 191.0, 191.0, 191.0, 83.0, 81.0, 79.0, 76.0, 72.0, 67.0, 62.0, 56.0, 49.0, 43.0, 37.0, 31.0, 24.0, 18.0, 12.0, 6.0, 0.0, 6.0, 12.0, 18.0, 24.0, 31.0, 37.0, 43.0, 49.0, 56.0, 62.0, 68.0, 74.0, 80.0, 86.0, 93.0, 99.0, 105.0, 111.0, 117.0, 123.0, 129.0, 136.0, 142.0, 148.0, 154.0, 160.0, 166.0, 172.0, 178.0, 184.0, 190.0, 196.0, 202.0, 208.0, 214.0, 220.0, 226.0, 232.0, 238.0, 244.0, 248.0, 251.0, 253.0, 253.0, 252.0, 250.0, 248.0, 245.0, 241.0, 237.0, 231.0, 228.0, 225.0, 225.0, 225.0, 225.0, 225.0, 225.0, 225.0, 225.0, 225.0, 225.0, 225.0, 227.0, 227.0, 227.0, 227.0, 227.0, 227.0, 227.0, 227.0, 227.0, 227.0, 227.0, 227.0, 227.0, 227.0, 227.0, 227.0, 227.0, 226.0, 225.0, 222.0, 219.0, 215.0, 211.0, 205.0, 199.0, 193.0, 186.0, 180.0, 174.0, 168.0, 162.0, 157.0, 154.0, 153.0, 153.0, 153.0, 155.0, 157.0, 160.0, 164.0, 91.0, 88.0, 84.0, 80.0, 74.0, 68.0, 62.0, 55.0, 49.0, 43.0, 37.0, 31.0, 24.0, 18.0, 12.0, 6.0, 0.0, 6.0, 12.0, 18.0, 24.0, 29.0, 32.0, 35.0, 37.0, 39.0, 41.0, 43.0, 45.0, 46.0, 48.0, 49.0, 50.0, 51.0, 51.0, 52.0, 52.0, 52.0, 52.0, 51.0, 51.0, 50.0, 49.0, 48.0, 46.0, 44.0, 41.0, 38.0, 35.0, 32.0, 30.0, 29.0, 29.0, 31.0, 34.0, 37.0, 41.0, 46.0, 51.0, 56.0, 62.0, 67.0, 73.0, 79.0, 85.0, 91.0, 97.0, 103.0, 109.0, 116.0, 122.0, 128.0, 134.0, 140.0, 147.0, 153.0, 159.0, 165.0, 171.0, 177.0, 183.0, 190.0, 196.0, 202.0, 208.0, 213.0, 216.0, 220.0, 225.0, 230.0, 234.0, 236.0, 237.0, 237.0, 236.0, 234.0, 231.0, 227.0, 223.0, 220.0, 219.0, 219.0, 220.0, 222.0, 225.0, 228.0, 232.0, 237.0, 243.0, 249.0, 253.0, 259.0, 265.0, 271.0, 277.0, 284.0, 290.0, 296.0, 302.0, 308.0, 61.0, 60.0, 58.0, 56.0, 54.0, 52.0, 50.0, 48.0, 45.0, 41.0, 36.0, 31.0, 25.0, 18.0, 12.0, 6.0, 0.0, 6.0, 12.0, 18.0, 24.0, 31.0, 37.0, 43.0, 49.0, 55.0, 62.0, 68.0, 74.0, 80.0, 86.0, 91.0, 94.0, 96.0, 98.0, 101.0, 105.0, 109.0, 115.0, 121.0, 127.0, 133.0, 140.0, 146.0, 152.0, 158.0, 164.0, 171.0, 177.0, 183.0, 189.0, 195.0, 202.0, 206.0, 209.0, 211.0, 211.0, 211.0, 211.0, 210.0, 209.0, 206.0, 203.0, 199.0, 195.0, 191.0, 190.0, 188.0, 184.0, 181.0, 178.0, 177.0, 176.0, 174.0, 171.0, 167.0, 162.0, 157.0, 150.0, 144.0, 138.0, 132.0, 125.0, 119.0, 113.0, 107.0, 101.0, 94.0, 88.0, 82.0, 76.0, 70.0, 63.0, 57.0, 51.0, 45.0, 39.0, 32.0, 26.0, 20.0, 14.0, 8.0, 1.0, 4.0, 10.0, 16.0, 23.0, 29.0, 35.0, 41.0, 47.0, 54.0, 60.0, 66.0, 72.0, 78.0, 84.0, 91.0, 97.0, 103.0, 92.0, 88.0, 85.0, 80.0, 74.0, 68.0, 62.0, 56.0, 49.0, 43.0, 37.0, 31.0, 24.0, 18.0, 12.0, 6.0, 0.0, 6.0, 12.0, 18.0, 24.0, 31.0, 37.0, 43.0, 49.0, 54.0, 57.0, 59.0, 59.0, 60.0, 59.0, 58.0, 57.0, 74.0, 56.0, 80.0, 54.0, 54.0, 85.0, 54.0, 91.0, 55.0, 97.0, 57.0, 61.0, 103.0, 65.0, 109.0, 69.0, 115.0, 121.0, 127.0, 133.0, 140.0, 146.0, 152.0, 158.0, 164.0, 169.0, 172.0, 174.0, 174.0, 173.0, 171.0, 169.0, 166.0, 162.0, 157.0, 152.0, 146.0, 141.0, 136.0, 130.0, 125.0, 122.0, 120.0, 120.0, 120.0, 120.0, 121.0, 122.0, 124.0, 126.0, 129.0, 132.0, 137.0, 141.0, 143.0, 144.0, 144.0, 145.0, 146.0, 149.0, 150.0, 151.0, 153.0, 154.0, 156.0, 158.0, 159.0, 159.0, 157.0, 155.0, 153.0, 149.0, 145.0, 140.0, 134.0, 128.0, 122.0, 116.0, 110.0, 104.0, 100.0, 95.0, 89.0, 85.0, 82.0, 81.0, 81.0, 79.0, 75.0, 71.0, 65.0, 59.0, 53.0, 46.0, 40.0, 34.0, 28.0, 21.0, 15.0, 9.0, 4.0, 1.0, 0.0, 0.0, 0.0, 2.0, 4.0, 7.0, 11.0, 16.0, 21.0, 28.0, 34.0, 40.0, 46.0, 53.0, 59.0, 65.0, 71.0, 77.0, 83.0, 88.0, 94.0, 100.0, 105.0, 110.0, 115.0, 120.0, 125.0, 130.0, 135.0, 139.0, 143.0, 147.0, 151.0, 155.0, 159.0, 164.0, 169.0, 174.0, 179.0, 184.0, 190.0, 194.0, 199.0, 205.0, 212.0, 218.0, 224.0, 230.0, 237.0, 243.0, 249.0, 255.0, 260.0, 266.0, 271.0, 277.0, 282.0, 288.0, 294.0, 299.0, 305.0, 311.0, 316.0, 322.0, 327.0, 333.0, 339.0, 344.0, 349.0, 355.0, 360.0, 366.0, 371.0, 376.0, 382.0, 387.0, 391.0, 395.0, 401.0, 406.0, 411.0, 416.0, 421.0, 426.0, 430.0, 432.0, 434.0, 435.0, 437.0, 439.0, 441.0, 442.0, 444.0, 445.0, 446.0, 447.0, 448.0, 448.0, 448.0, 447.0, 445.0, 444.0, 441.0, 439.0, 436.0, 78.0, 77.0, 75.0, 73.0, 70.0, 66.0, 61.0, 56.0, 49.0, 43.0, 37.0, 31.0, 24.0, 18.0, 12.0, 6.0, 0.0, 6.0, 12.0, 18.0, 24.0, 31.0, 37.0, 43.0, 49.0, 56.0, 60.0, 63.0, 65.0, 65.0, 64.0, 63.0, 62.0, 60.0, 59.0, 57.0, 55.0, 54.0, 53.0, 52.0, 53.0, 54.0, 56.0, 58.0, 61.0, 64.0, 67.0, 71.0, 75.0, 80.0, 84.0, 89.0, 94.0, 99.0, 104.0, 109.0, 115.0, 120.0, 126.0, 131.0, 137.0, 142.0, 148.0, 154.0, 159.0, 165.0, 171.0, 177.0, 182.0, 188.0, 194.0, 200.0, 206.0, 210.0, 213.0, 214.0, 214.0, 213.0, 212.0, 210.0, 207.0, 206.0, 203.0, 200.0, 196.0, 191.0, 186.0, 182.0, 179.0, 177.0, 176.0, 175.0, 175.0, 175.0, 174.0, 174.0, 173.0, 172.0, 170.0, 167.0, 163.0, 159.0, 154.0, 148.0, 142.0, 137.0, 131.0, 125.0, 119.0, 113.0, 107.0, 101.0, 95.0, 89.0, 83.0, 77.0, 71.0, 65.0, 60.0, 56.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 34.0, 33.0, 32.0, 29.0, 26.0, 22.0, 17.0, 12.0, 6.0, 0.0, 6.0, 12.0, 18.0, 24.0, 31.0, 37.0, 43.0, 49.0, 56.0, 62.0, 68.0, 74.0, 81.0, 85.0, 89.0, 90.0, 90.0, 89.0, 88.0, 86.0, 83.0, 80.0, 76.0, 71.0, 66.0, 61.0, 57.0, 53.0, 49.0, 46.0, 43.0, 42.0, 41.0, 41.0, 42.0, 44.0, 47.0, 49.0, 51.0, 52.0, 52.0, 51.0, 51.0, 50.0, 49.0, 48.0, 47.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 54.0, 56.0, 60.0, 63.0, 68.0, 73.0, 78.0, 84.0, 89.0, 94.0, 100.0, 106.0, 111.0, 116.0, 121.0, 127.0, 133.0, 140.0, 146.0, 152.0, 158.0, 165.0, 171.0, 177.0, 183.0, 190.0, 196.0, 202.0, 206.0, 209.0, 210.0, 210.0, 209.0, 207.0, 204.0, 201.0, 197.0, 193.0, 187.0, 181.0, 175.0, 170.0, 166.0, 161.0, 156.0, 150.0, 143.0, 137.0, 131.0, 82.0, 81.0, 80.0, 76.0, 72.0, 67.0, 62.0, 56.0, 49.0, 43.0, 37.0, 31.0, 25.0, 18.0, 12.0, 6.0, 0.0, 6.0, 12.0, 18.0, 24.0, 31.0, 35.0, 39.0, 40.0, 40.0, 40.0, 39.0, 40.0, 41.0, 42.0, 45.0, 48.0, 51.0, 56.0, 62.0, 67.0, 73.0, 79.0, 86.0, 92.0, 98.0, 104.0, 110.0, 116.0, 123.0, 129.0, 135.0, 141.0, 148.0, 154.0, 160.0, 166.0, 173.0, 177.0, 183.0, 189.0, 195.0, 200.0, 205.0, 209.0, 213.0, 217.0, 218.0, 218.0, 217.0, 217.0, 213.0, 210.0, 206.0, 202.0, 196.0, 190.0, 184.0, 177.0, 171.0, 165.0, 159.0, 153.0, 146.0, 140.0, 134.0, 128.0, 121.0, 115.0, 109.0, 103.0, 97.0, 90.0, 84.0, 78.0, 72.0, 66.0, 60.0, 55.0, 49.0, 44.0, 38.0, 33.0, 29.0, 25.0, 23.0, 22.0, 23.0, 25.0, 29.0, 33.0, 38.0, 44.0, 49.0, 55.0, 60.0, 66.0, 72.0, 78.0, 84.0, 91.0, 97.0, 103.0, 109.0, 83.0, 81.0, 79.0, 76.0, 72.0, 67.0, 62.0, 56.0, 49.0, 43.0, 37.0, 31.0, 24.0, 18.0, 12.0, 6.0, 0.0, 6.0, 12.0, 18.0, 24.0, 31.0, 35.0, 39.0, 40.0, 40.0, 40.0, 41.0, 42.0, 45.0, 48.0, 52.0, 57.0, 62.0, 68.0, 74.0, 81.0, 87.0, 93.0, 99.0, 106.0, 112.0, 118.0, 124.0, 130.0, 136.0, 142.0, 148.0, 154.0, 160.0, 167.0, 172.0, 178.0, 184.0, 190.0, 196.0, 202.0, 208.0, 214.0, 221.0, 227.0, 233.0, 239.0, 245.0, 251.0, 257.0, 262.0, 268.0, 274.0, 280.0, 286.0, 292.0, 298.0, 304.0, 310.0, 316.0, 322.0, 327.0, 333.0, 339.0, 345.0, 350.0, 356.0, 362.0, 367.0, 373.0, 379.0, 385.0, 391.0, 397.0, 403.0, 409.0, 413.0, 416.0, 417.0, 417.0, 418.0, 418.0, 419.0, 420.0, 420.0, 420.0, 420.0, 419.0, 419.0, 418.0, 418.0, 418.0, 418.0, 418.0, 418.0, 418.0, 417.0, 416.0, 415.0, 413.0, 410.0, 406.0, 402.0, 399.0, 93.0, 90.0, 85.0, 80.0, 74.0, 68.0, 62.0, 55.0, 49.0, 43.0, 37.0, 31.0, 24.0, 18.0, 12.0, 6.0, 0.0, 6.0, 12.0, 17.0, 20.0, 21.0, 21.0, 21.0, 19.0, 17.0, 16.0, 15.0, 15.0, 16.0, 18.0, 21.0, 26.0, 31.0, 37.0, 42.0, 48.0, 52.0, 55.0, 56.0, 56.0, 56.0, 55.0, 53.0, 52.0, 52.0, 52.0, 52.0, 52.0, 54.0, 56.0, 58.0, 62.0, 66.0, 71.0, 77.0, 83.0, 88.0, 94.0, 100.0, 105.0, 111.0, 116.0, 122.0, 127.0, 132.0, 134.0, 136.0, 136.0, 136.0, 138.0, 140.0, 142.0, 146.0, 150.0, 154.0, 160.0, 165.0, 171.0, 177.0, 182.0, 188.0, 192.0, 195.0, 198.0, 202.0, 204.0, 207.0, 211.0, 215.0, 220.0, 225.0, 230.0, 234.0, 238.0, 240.0, 240.0, 240.0, 240.0, 240.0, 240.0, 239.0, 239.0, 238.0, 238.0, 237.0, 236.0, 236.0, 236.0, 236.0, 235.0, 235.0, 235.0, 235.0, 235.0, 235.0, 235.0, 235.0, 235.0, 235.0, 39.0, 38.0, 37.0, 34.0, 31.0, 27.0, 23.0, 17.0, 11.0, 5.0, 1.0, 3.0, 4.0, 4.0, 3.0, 2.0, 0.0, 3.0, 7.0, 11.0, 17.0, 23.0, 29.0, 35.0, 42.0, 48.0, 53.0, 56.0, 57.0, 57.0, 56.0, 55.0, 53.0, 50.0, 47.0, 42.0, 38.0, 32.0, 27.0, 23.0, 19.0, 18.0, 17.0, 17.0, 17.0, 17.0, 17.0, 17.0, 17.0, 17.0, 17.0, 17.0, 17.0, 17.0, 18.0, 19.0, 19.0, 19.0, 19.0, 18.0, 19.0, 19.0, 20.0, 21.0, 23.0, 24.0, 25.0, 25.0, 25.0, 24.0, 24.0, 23.0, 22.0, 22.0, 23.0, 25.0, 28.0, 30.0, 35.0, 40.0, 45.0, 51.0, 56.0, 62.0, 68.0, 73.0, 79.0, 85.0, 91.0, 97.0, 103.0, 107.0, 110.0, 111.0, 111.0, 111.0, 112.0, 114.0, 116.0, 119.0, 123.0, 127.0, 133.0, 139.0, 145.0, 151.0, 156.0, 162.0, 168.0, 172.0, 176.0, 181.0, 186.0, 190.0, 192.0, 193.0, 193.0, 192.0, 191.0, 34.0, 33.0, 30.0, 27.0, 26.0, 23.0, 20.0, 19.0, 16.0, 13.0, 9.0, 7.0, 4.0, 2.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 2.0, 3.0, 4.0, 6.0, 9.0, 13.0, 17.0, 23.0, 29.0, 35.0, 41.0, 47.0, 53.0, 60.0, 66.0, 72.0, 78.0, 85.0, 91.0, 97.0, 103.0, 109.0, 115.0, 121.0, 127.0, 133.0, 139.0, 145.0, 150.0, 156.0, 161.0, 166.0, 171.0, 175.0, 180.0, 184.0, 188.0, 192.0, 195.0, 199.0, 202.0, 205.0, 207.0, 210.0, 212.0, 214.0, 216.0, 217.0, 218.0, 219.0, 220.0, 222.0, 223.0, 225.0, 227.0, 229.0, 231.0, 233.0, 236.0, 238.0, 241.0, 244.0, 247.0, 250.0, 253.0, 256.0, 260.0, 263.0, 267.0, 270.0, 274.0, 278.0, 282.0, 286.0, 290.0, 294.0, 299.0, 303.0, 307.0, 312.0, 316.0, 321.0, 325.0, 330.0, 335.0, 339.0, 344.0, 349.0, 354.0, 359.0, 364.0, 369.0, 374.0, 379.0, 87.0, 84.0, 81.0, 78.0, 73.0, 68.0, 61.0, 55.0, 49.0, 43.0, 37.0, 31.0, 24.0, 18.0, 12.0, 6.0, 0.0, 6.0, 12.0, 18.0, 25.0, 31.0, 37.0, 42.0, 45.0, 46.0, 46.0, 46.0, 44.0, 42.0, 39.0, 35.0, 30.0, 25.0, 19.0, 14.0, 9.0, 7.0, 10.0, 15.0, 20.0, 26.0, 32.0, 38.0, 44.0, 50.0, 56.0, 63.0, 69.0, 75.0, 81.0, 87.0, 94.0, 100.0, 106.0, 112.0, 118.0, 125.0, 131.0, 137.0, 143.0, 148.0, 151.0, 155.0, 160.0, 163.0, 167.0, 169.0, 172.0, 176.0, 181.0, 186.0, 192.0, 198.0, 205.0, 211.0, 217.0, 222.0, 225.0, 229.0, 233.0, 237.0, 238.0, 240.0, 244.0, 247.0, 252.0, 258.0, 264.0, 270.0, 276.0, 283.0, 289.0, 295.0, 301.0, 307.0, 314.0, 318.0, 324.0, 328.0, 332.0, 338.0, 344.0, 350.0, 356.0, 362.0, 368.0, 373.0, 379.0, 383.0, 388.0, 393.0, 397.0, 402.0, 406.0, 410.0, 414.0, 418.0, 421.0, 424.0, 84.0, 81.0, 79.0, 76.0, 72.0, 67.0, 62.0, 56.0, 49.0, 43.0, 37.0, 31.0, 24.0, 18.0, 12.0, 6.0, 0.0, 6.0, 12.0, 18.0, 24.0, 31.0, 37.0, 43.0, 49.0, 56.0, 62.0, 68.0, 74.0, 81.0, 87.0, 93.0, 99.0, 105.0, 111.0, 118.0, 124.0, 130.0, 136.0, 142.0, 148.0, 153.0, 159.0, 165.0, 171.0, 176.0, 182.0, 187.0, 193.0, 198.0, 203.0, 208.0, 213.0, 217.0, 222.0, 227.0, 230.0, 233.0, 234.0, 234.0, 234.0, 232.0, 230.0, 228.0, 225.0, 221.0, 216.0, 211.0, 206.0, 201.0, 196.0, 191.0, 186.0, 181.0, 176.0, 171.0, 168.0, 166.0, 165.0, 165.0, 165.0, 166.0, 168.0, 170.0, 172.0, 175.0, 178.0, 182.0, 186.0, 189.0, 193.0, 197.0, 200.0, 202.0, 203.0, 203.0, 202.0, 201.0, 200.0, 198.0, 195.0, 194.0, 192.0, 189.0, 186.0, 183.0, 179.0, 176.0, 175.0, 174.0, 174.0, 174.0, 175.0, 177.0, 178.0, 181.0, 184.0, 187.0, 189.0, 192.0, 59.0, 61.0, 62.0, 62.0, 60.0, 58.0, 56.0, 52.0, 48.0, 43.0, 37.0, 31.0, 24.0, 18.0, 12.0, 6.0, 0.0, 6.0, 12.0, 18.0, 24.0, 31.0, 37.0, 43.0, 49.0, 56.0, 60.0, 64.0, 65.0, 65.0, 64.0, 63.0, 62.0, 60.0, 57.0, 54.0, 51.0, 49.0, 47.0, 45.0, 45.0, 46.0, 47.0, 49.0, 51.0, 55.0, 59.0, 63.0, 67.0, 72.0, 77.0, 82.0, 87.0, 92.0, 98.0, 103.0, 109.0, 115.0, 120.0, 126.0, 132.0, 137.0, 143.0, 149.0, 155.0, 160.0, 166.0, 172.0, 177.0, 182.0, 187.0, 192.0, 196.0, 199.0, 200.0, 200.0, 199.0, 200.0, 201.0, 202.0, 204.0, 207.0, 209.0, 211.0, 212.0, 212.0, 212.0, 213.0, 215.0, 216.0, 217.0, 219.0, 221.0, 224.0, 226.0, 229.0, 232.0, 235.0, 237.0, 238.0, 238.0, 237.0, 235.0, 233.0, 230.0, 226.0, 221.0, 216.0, 209.0, 203.0, 197.0, 191.0, 184.0, 178.0, 172.0, 166.0, 160.0, 154.0, 148.0, 142.0, 89.0, 89.0, 84.0, 78.0, 72.0, 55.0, 67.0, 49.0, 61.0, 43.0, 37.0, 31.0, 24.0, 18.0, 12.0, 6.0, 0.0, 6.0, 10.0, 14.0, 15.0, 15.0, 14.0, 13.0, 13.0, 14.0, 15.0, 18.0, 21.0, 25.0, 29.0, 35.0, 41.0, 47.0, 54.0, 60.0, 66.0, 72.0, 78.0, 84.0, 90.0, 96.0, 102.0, 108.0, 114.0, 119.0, 125.0, 131.0, 137.0, 143.0, 149.0, 154.0, 160.0, 164.0, 167.0, 168.0, 168.0, 168.0, 167.0, 166.0, 164.0, 162.0, 160.0, 157.0, 154.0, 151.0, 147.0, 144.0, 141.0, 139.0, 138.0, 138.0, 139.0, 140.0, 142.0, 144.0, 147.0, 150.0, 152.0, 155.0, 158.0, 162.0, 166.0, 170.0, 174.0, 178.0, 182.0, 186.0, 190.0, 194.0, 198.0, 202.0, 205.0, 209.0, 213.0, 216.0, 220.0, 224.0, 227.0, 230.0, 234.0, 237.0, 240.0, 243.0, 246.0, 250.0, 253.0, 256.0, 259.0, 262.0, 264.0, 267.0, 269.0, 271.0, 273.0, 274.0, 276.0, 276.0, 277.0, 277.0, 77.0, 77.0, 75.0, 73.0, 70.0, 67.0, 61.0, 56.0, 49.0, 43.0, 37.0, 31.0, 24.0, 18.0, 12.0, 6.0, 0.0, 6.0, 12.0, 18.0, 24.0, 31.0, 37.0, 43.0, 49.0, 56.0, 62.0, 68.0, 74.0, 79.0, 79.0, 79.0, 79.0, 79.0, 79.0, 79.0, 79.0, 79.0, 79.0, 79.0, 80.0, 80.0, 80.0, 81.0, 82.0, 83.0, 85.0, 87.0, 89.0, 91.0, 93.0, 96.0, 99.0, 102.0, 105.0, 108.0, 112.0, 115.0, 119.0, 122.0, 126.0, 130.0, 134.0, 138.0, 143.0, 147.0, 151.0, 155.0, 159.0, 163.0, 167.0, 171.0, 175.0, 179.0, 183.0, 187.0, 190.0, 192.0, 193.0, 193.0, 193.0, 192.0, 190.0, 188.0, 186.0, 183.0, 180.0, 176.0, 171.0, 167.0, 162.0, 157.0, 152.0, 148.0, 143.0, 138.0, 133.0, 128.0, 123.0, 118.0, 113.0, 109.0, 105.0, 103.0, 101.0, 99.0, 98.0, 98.0, 99.0, 99.0, 101.0, 102.0, 104.0, 106.0, 109.0, 113.0, 116.0, 120.0, 123.0, 126.0, 52.0, 52.0, 52.0, 52.0, 52.0, 52.0, 50.0, 48.0, 45.0, 41.0, 36.0, 31.0, 24.0, 18.0, 12.0, 6.0, 0.0, 6.0, 12.0, 18.0, 24.0, 31.0, 37.0, 43.0, 49.0, 56.0, 62.0, 68.0, 74.0, 81.0, 87.0, 93.0, 99.0, 105.0, 111.0, 117.0, 122.0, 128.0, 133.0, 139.0, 144.0, 149.0, 153.0, 158.0, 162.0, 166.0, 170.0, 174.0, 178.0, 181.0, 184.0, 187.0, 190.0, 193.0, 195.0, 197.0, 199.0, 201.0, 203.0, 205.0, 208.0, 210.0, 213.0, 215.0, 217.0, 218.0, 220.0, 221.0, 223.0, 224.0, 225.0, 227.0, 228.0, 229.0, 230.0, 232.0, 233.0, 235.0, 236.0, 238.0, 239.0, 240.0, 242.0, 244.0, 245.0, 247.0, 249.0, 251.0, 253.0, 255.0, 257.0, 260.0, 262.0, 264.0, 267.0, 269.0, 272.0, 275.0, 278.0, 280.0, 283.0, 286.0, 289.0, 292.0, 296.0, 299.0, 302.0, 306.0, 309.0, 312.0, 313.0, 314.0, 314.0, 314.0, 313.0, 312.0, 310.0, 308.0, 305.0, 302.0, 10.0, 10.0, 10.0, 10.0, 9.0, 7.0, 5.0, 4.0, 7.0, 10.0, 11.0, 11.0, 10.0, 9.0, 7.0, 3.0, 0.0, 4.0, 10.0, 16.0, 22.0, 28.0, 35.0, 41.0, 47.0, 53.0, 60.0, 66.0, 72.0, 78.0, 85.0, 91.0, 97.0, 103.0, 109.0, 116.0, 122.0, 128.0, 134.0, 140.0, 146.0, 152.0, 158.0, 164.0, 170.0, 176.0, 181.0, 187.0, 193.0, 198.0, 202.0, 205.0, 206.0, 206.0, 206.0, 204.0, 202.0, 200.0, 196.0, 193.0, 188.0, 183.0, 178.0, 172.0, 167.0, 162.0, 157.0, 152.0, 147.0, 142.0, 137.0, 132.0, 127.0, 122.0, 118.0, 113.0, 109.0, 104.0, 100.0, 97.0, 93.0, 89.0, 86.0, 83.0, 81.0, 79.0, 77.0, 76.0, 75.0, 75.0, 76.0, 77.0, 78.0, 79.0, 80.0, 80.0, 80.0, 80.0, 80.0, 80.0, 80.0, 80.0, 80.0, 80.0, 80.0, 80.0, 79.0, 79.0, 79.0, 79.0, 79.0, 79.0, 79.0, 79.0, 79.0, 79.0, 78.0, 77.0, 76.0, 76.0, 26.0, 47.0, 61.0, 81.0, 74.0, 68.0, 62.0, 56.0, 31.0, 49.0, 24.0, 43.0, 18.0, 37.0, 12.0, 6.0, 0.0, 6.0, 12.0, 18.0, 24.0, 31.0, 37.0, 43.0, 49.0, 55.0, 61.0, 67.0, 72.0, 78.0, 84.0, 89.0, 94.0, 100.0, 105.0, 110.0, 115.0, 119.0, 124.0, 129.0, 134.0, 139.0, 144.0, 149.0, 154.0, 160.0, 165.0, 171.0, 176.0, 181.0, 187.0, 192.0, 198.0, 204.0, 209.0, 215.0, 221.0, 226.0, 232.0, 238.0, 243.0, 249.0, 255.0, 261.0, 266.0, 272.0, 277.0, 283.0, 288.0, 292.0, 295.0, 296.0, 296.0, 295.0, 294.0, 292.0, 289.0, 286.0, 281.0, 276.0, 271.0, 265.0, 261.0, 256.0, 251.0, 245.0, 240.0, 234.0, 229.0, 224.0, 218.0, 213.0, 208.0, 202.0, 199.0, 196.0, 195.0, 195.0, 195.0, 196.0, 198.0, 200.0, 203.0, 206.0, 210.0, 214.0, 218.0, 222.0, 225.0, 227.0, 228.0, 229.0, 231.0, 232.0, 232.0, 232.0, 232.0, 232.0, 232.0, 232.0, 63.0, 63.0, 63.0, 62.0, 61.0, 59.0, 56.0, 53.0, 48.0, 43.0, 37.0, 31.0, 24.0, 18.0, 12.0, 6.0, 0.0, 6.0, 12.0, 18.0, 24.0, 31.0, 37.0, 43.0, 49.0, 55.0, 62.0, 68.0, 74.0, 80.0, 85.0, 91.0, 97.0, 102.0, 108.0, 113.0, 118.0, 123.0, 128.0, 133.0, 137.0, 141.0, 146.0, 150.0, 154.0, 159.0, 163.0, 168.0, 173.0, 177.0, 182.0, 187.0, 191.0, 196.0, 200.0, 204.0, 208.0, 211.0, 214.0, 218.0, 220.0, 223.0, 225.0, 227.0, 229.0, 230.0, 232.0, 233.0, 233.0, 233.0, 233.0, 233.0, 233.0, 232.0, 231.0, 229.0, 227.0, 224.0, 220.0, 216.0, 213.0, 209.0, 206.0, 204.0, 204.0, 204.0, 204.0, 204.0, 204.0, 204.0, 204.0, 203.0, 203.0, 202.0, 201.0, 200.0, 199.0, 198.0, 197.0, 196.0, 196.0, 196.0, 196.0, 196.0, 196.0, 196.0, 196.0, 196.0, 196.0, 195.0, 195.0, 195.0, 195.0, 195.0, 194.0, 194.0, 193.0, 193.0, 193.0, 193.0, 83.0, 81.0, 80.0, 76.0, 72.0, 67.0, 62.0, 55.0, 49.0, 43.0, 37.0, 31.0, 24.0, 18.0, 12.0, 6.0, 0.0, 6.0, 12.0, 18.0, 24.0, 31.0, 35.0, 38.0, 40.0, 40.0, 39.0, 38.0, 35.0, 32.0, 28.0, 24.0, 18.0, 12.0, 6.0, 0.0, 5.0, 12.0, 18.0, 24.0, 30.0, 37.0, 43.0, 49.0, 55.0, 60.0, 63.0, 67.0, 69.0, 70.0, 70.0, 70.0, 70.0, 71.0, 71.0, 72.0, 73.0, 76.0, 79.0, 83.0, 85.0, 86.0, 87.0, 90.0, 90.0, 90.0, 91.0, 91.0, 90.0, 89.0, 86.0, 84.0, 80.0, 77.0, 73.0, 68.0, 64.0, 61.0, 58.0, 57.0, 56.0, 56.0, 57.0, 59.0, 61.0, 64.0, 68.0, 73.0, 77.0, 83.0, 88.0, 93.0, 99.0, 105.0, 111.0, 117.0, 123.0, 129.0, 135.0, 141.0, 146.0, 149.0, 151.0, 151.0, 152.0, 152.0, 152.0, 152.0, 153.0, 153.0, 153.0, 153.0, 153.0, 153.0, 154.0, 155.0, 158.0, 161.0, 165.0, 169.0, 71.0, 81.0, 79.0, 76.0, 72.0, 67.0, 62.0, 56.0, 49.0, 43.0, 37.0, 31.0, 24.0, 18.0, 12.0, 6.0, 0.0, 6.0, 12.0, 18.0, 24.0, 31.0, 37.0, 43.0, 48.0, 51.0, 52.0, 55.0, 58.0, 59.0, 59.0, 60.0, 62.0, 64.0, 67.0, 71.0, 76.0, 81.0, 88.0, 94.0, 100.0, 106.0, 113.0, 119.0, 125.0, 131.0, 138.0, 144.0, 150.0, 156.0, 163.0, 169.0, 173.0, 177.0, 178.0, 180.0, 184.0, 187.0, 190.0, 191.0, 192.0, 192.0, 193.0, 194.0, 194.0, 195.0, 197.0, 199.0, 202.0, 206.0, 211.0, 216.0, 222.0, 228.0, 234.0, 239.0, 245.0, 251.0, 256.0, 261.0, 266.0, 271.0, 276.0, 279.0, 281.0, 282.0, 282.0, 281.0, 280.0, 279.0, 277.0, 275.0, 272.0, 269.0, 265.0, 262.0, 258.0, 255.0, 252.0, 249.0, 246.0, 243.0, 240.0, 237.0, 234.0, 232.0, 230.0, 227.0, 225.0, 223.0, 222.0, 220.0, 218.0, 217.0, 216.0, 215.0, 214.0, 214.0, 213.0, 213.0, 90.0, 87.0, 83.0, 80.0, 73.0, 67.0, 61.0, 55.0, 49.0, 43.0, 37.0, 31.0, 24.0, 18.0, 12.0, 6.0, 0.0, 6.0, 12.0, 18.0, 24.0, 31.0, 37.0, 43.0, 49.0, 56.0, 62.0, 68.0, 74.0, 80.0, 87.0, 93.0, 99.0, 105.0, 111.0, 117.0, 123.0, 129.0, 135.0, 141.0, 147.0, 154.0, 160.0, 166.0, 172.0, 178.0, 184.0, 191.0, 197.0, 203.0, 209.0, 215.0, 222.0, 228.0, 234.0, 240.0, 246.0, 253.0, 259.0, 265.0, 271.0, 278.0, 284.0, 288.0, 292.0, 293.0, 293.0, 292.0, 291.0, 288.0, 285.0, 281.0, 277.0, 271.0, 265.0, 259.0, 253.0, 246.0, 240.0, 234.0, 228.0, 221.0, 215.0, 209.0, 203.0, 196.0, 190.0, 184.0, 178.0, 173.0, 170.0, 168.0, 168.0, 169.0, 171.0, 173.0, 176.0, 179.0, 184.0, 189.0, 195.0, 201.0, 207.0, 213.0, 219.0, 225.0, 231.0, 237.0, 243.0, 249.0, 255.0, 261.0, 267.0, 273.0, 279.0, 285.0, 292.0, 296.0, 299.0, 301.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, 4.0, 7.0, 11.0, 16.0, 21.0, 27.0, 34.0, 40.0, 46.0, 52.0, 59.0, 65.0, 71.0, 77.0, 84.0, 90.0, 96.0, 102.0, 109.0, 115.0, 121.0, 127.0, 133.0, 140.0, 146.0, 152.0, 158.0, 165.0, 171.0, 177.0, 183.0, 190.0, 196.0, 202.0, 208.0, 215.0, 221.0, 227.0, 233.0, 239.0, 246.0, 252.0, 258.0, 264.0, 269.0, 272.0, 273.0, 273.0, 272.0, 271.0, 269.0, 266.0, 262.0, 257.0, 252.0, 246.0, 241.0, 235.0, 229.0, 223.0, 218.0, 212.0, 207.0, 202.0, 197.0, 192.0, 188.0, 183.0, 180.0, 178.0, 177.0, 177.0, 178.0, 177.0, 178.0, 179.0, 179.0, 179.0, 180.0, 182.0, 184.0, 187.0, 190.0, 195.0, 200.0, 205.0, 211.0, 217.0, 223.0, 228.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, 4.0, 7.0, 11.0, 16.0, 21.0, 27.0, 33.0, 40.0, 46.0, 52.0, 58.0, 64.0, 70.0, 76.0, 82.0, 88.0, 94.0, 100.0, 106.0, 112.0, 118.0, 124.0, 129.0, 135.0, 141.0, 146.0, 152.0, 157.0, 163.0, 169.0, 174.0, 180.0, 185.0, 191.0, 196.0, 202.0, 207.0, 213.0, 217.0, 220.0, 221.0, 221.0, 221.0, 219.0, 217.0, 216.0, 215.0, 212.0, 209.0, 206.0, 201.0, 196.0, 190.0, 184.0, 179.0, 173.0, 169.0, 166.0, 165.0, 165.0, 164.0, 164.0, 165.0, 167.0, 169.0, 170.0, 169.0, 169.0, 167.0, 165.0, 162.0, 158.0, 153.0, 148.0, 143.0, 137.0, 131.0, 126.0, 121.0, 115.0, 110.0, 105.0, 100.0, 97.0, 93.0, 90.0, 89.0, 89.0, 88.0, 88.0, 48.0, 48.0, 48.0, 48.0, 49.0, 49.0, 48.0, 46.0, 43.0, 39.0, 35.0, 30.0, 24.0, 18.0, 12.0, 6.0, 0.0, 6.0, 12.0, 18.0, 24.0, 31.0, 37.0, 43.0, 49.0, 55.0, 61.0, 67.0, 73.0, 79.0, 85.0, 91.0, 97.0, 103.0, 109.0, 115.0, 121.0, 127.0, 133.0, 139.0, 145.0, 151.0, 157.0, 163.0, 169.0, 175.0, 180.0, 186.0, 191.0, 196.0, 202.0, 206.0, 211.0, 215.0, 219.0, 222.0, 223.0, 225.0, 226.0, 225.0, 224.0, 222.0, 220.0, 216.0, 212.0, 210.0, 206.0, 202.0, 197.0, 194.0, 190.0, 187.0, 184.0, 180.0, 175.0, 170.0, 164.0, 158.0, 153.0, 147.0, 141.0, 136.0, 130.0, 125.0, 119.0, 113.0, 108.0, 102.0, 97.0, 93.0, 90.0, 89.0, 89.0, 89.0, 89.0, 89.0, 89.0, 89.0, 89.0, 87.0, 87.0, 88.0, 89.0, 91.0, 93.0, 95.0, 98.0, 101.0, 105.0, 109.0, 114.0, 118.0, 122.0, 124.0, 125.0, 125.0, 125.0, 123.0, 122.0, 119.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, 4.0, 7.0, 11.0, 16.0, 21.0, 28.0, 34.0, 40.0, 46.0, 52.0, 59.0, 65.0, 71.0, 77.0, 83.0, 90.0, 96.0, 102.0, 108.0, 114.0, 120.0, 126.0, 132.0, 138.0, 144.0, 150.0, 156.0, 162.0, 168.0, 173.0, 179.0, 184.0, 189.0, 194.0, 199.0, 203.0, 208.0, 212.0, 216.0, 219.0, 223.0, 226.0, 229.0, 232.0, 234.0, 236.0, 238.0, 240.0, 241.0, 242.0, 242.0, 242.0, 241.0, 240.0, 239.0, 237.0, 235.0, 234.0, 234.0, 234.0, 234.0, 234.0, 233.0, 233.0, 232.0, 231.0, 230.0, 229.0, 229.0, 228.0, 227.0, 227.0, 226.0, 226.0, 226.0, 226.0, 226.0, 227.0, 227.0, 228.0, 228.0, 229.0, 230.0, 231.0, 232.0, 234.0, 235.0, 237.0, 239.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 39.0, 38.0, 37.0, 35.0, 32.0, 28.0, 24.0, 18.0, 12.0, 6.0, 0.0, 6.0, 12.0, 18.0, 24.0, 31.0, 37.0, 43.0, 49.0, 56.0, 62.0, 68.0, 74.0, 81.0, 87.0, 93.0, 99.0, 106.0, 112.0, 118.0, 124.0, 130.0, 137.0, 143.0, 149.0, 155.0, 161.0, 168.0, 174.0, 180.0, 186.0, 193.0, 199.0, 205.0, 211.0, 217.0, 224.0, 230.0, 236.0, 242.0, 249.0, 255.0, 261.0, 267.0, 273.0, 280.0, 286.0, 292.0, 298.0, 305.0, 311.0, 317.0, 323.0, 329.0, 335.0, 341.0, 347.0, 353.0, 359.0, 365.0, 370.0, 376.0, 381.0, 386.0, 390.0, 395.0, 399.0, 403.0, 406.0, 409.0, 412.0, 416.0, 418.0, 421.0, 423.0, 426.0, 428.0, 430.0, 432.0, 434.0, 435.0, 436.0, 438.0, 439.0, 439.0, 440.0, 441.0, 442.0, 443.0, 444.0, 446.0, 449.0, 451.0, 453.0, 455.0, 458.0, 460.0, 461.0, 462.0, 462.0, 462.0, 463.0, 464.0, 465.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 3.0, 6.0, 9.0, 14.0, 19.0, 25.0, 31.0, 38.0, 44.0, 50.0, 56.0, 62.0, 69.0, 75.0, 81.0, 87.0, 93.0, 100.0, 106.0, 112.0, 118.0, 124.0, 130.0, 136.0, 143.0, 149.0, 155.0, 161.0, 167.0, 173.0, 179.0, 186.0, 192.0, 198.0, 204.0, 210.0, 215.0, 220.0, 225.0, 228.0, 232.0, 237.0, 240.0, 244.0, 248.0, 253.0, 257.0, 261.0, 263.0, 264.0, 266.0, 268.0, 271.0, 272.0, 273.0, 273.0, 272.0, 270.0, 268.0, 265.0, 261.0, 257.0, 252.0, 247.0, 241.0, 236.0, 230.0, 225.0, 219.0, 214.0, 210.0, 206.0, 199.0, 204.0, 194.0, 189.0, 183.0, 177.0, 171.0, 166.0, 160.0, 154.0, 148.0, 142.0, 137.0, 131.0, 125.0, 120.0, 114.0, 109.0, 103.0, 98.0, 70.0, 70.0, 70.0, 68.0, 66.0, 63.0, 59.0, 55.0, 49.0, 43.0, 37.0, 31.0, 24.0, 18.0, 12.0, 6.0, 0.0, 6.0, 12.0, 18.0, 24.0, 31.0, 37.0, 43.0, 49.0, 55.0, 62.0, 68.0, 74.0, 80.0, 86.0, 92.0, 98.0, 104.0, 110.0, 116.0, 122.0, 128.0, 134.0, 140.0, 146.0, 152.0, 158.0, 164.0, 170.0, 177.0, 183.0, 189.0, 195.0, 201.0, 207.0, 213.0, 219.0, 224.0, 226.0, 228.0, 228.0, 227.0, 226.0, 225.0, 224.0, 222.0, 219.0, 216.0, 213.0, 210.0, 206.0, 203.0, 200.0, 198.0, 196.0, 195.0, 193.0, 192.0, 192.0, 192.0, 192.0, 192.0, 192.0, 192.0, 193.0, 195.0, 197.0, 199.0, 201.0, 203.0, 205.0, 206.0, 206.0, 206.0, 206.0, 206.0, 206.0, 206.0, 206.0, 205.0, 205.0, 205.0, 205.0, 205.0, 206.0, 206.0, 206.0, 206.0, 206.0, 206.0, 206.0, 206.0, 206.0, 206.0, 206.0, 206.0, 205.0, 205.0, 205.0, 205.0, 205.0, 205.0, 205.0, 205.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, 4.0, 7.0, 11.0, 16.0, 21.0, 27.0, 33.0, 39.0, 45.0, 51.0, 57.0, 63.0, 69.0, 75.0, 81.0, 87.0, 93.0, 100.0, 106.0, 112.0, 118.0, 125.0, 131.0, 137.0, 143.0, 150.0, 156.0, 162.0, 168.0, 175.0, 181.0, 187.0, 193.0, 199.0, 204.0, 207.0, 209.0, 209.0, 208.0, 206.0, 204.0, 201.0, 197.0, 192.0, 187.0, 181.0, 175.0, 168.0, 162.0, 156.0, 150.0, 144.0, 138.0, 132.0, 126.0, 120.0, 114.0, 109.0, 103.0, 99.0, 97.0, 95.0, 95.0, 96.0, 98.0, 100.0, 103.0, 107.0, 111.0, 116.0, 123.0, 129.0, 135.0, 141.0, 148.0, 152.0, 155.0, 157.0, 157.0, 156.0, 155.0, 152.0, 149.0, 146.0, 141.0, 136.0, 130.0, 124.0, 118.0, 112.0, 106.0, 102.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, 4.0, 7.0, 11.0, 16.0, 21.0, 27.0, 33.0, 39.0, 45.0, 51.0, 58.0, 64.0, 70.0, 76.0, 82.0, 89.0, 95.0, 101.0, 107.0, 114.0, 120.0, 126.0, 132.0, 138.0, 144.0, 150.0, 156.0, 161.0, 167.0, 172.0, 177.0, 182.0, 187.0, 191.0, 196.0, 200.0, 203.0, 206.0, 207.0, 207.0, 206.0, 205.0, 202.0, 199.0, 195.0, 191.0, 185.0, 179.0, 173.0, 167.0, 162.0, 156.0, 150.0, 145.0, 139.0, 134.0, 129.0, 126.0, 123.0, 122.0, 122.0, 123.0, 124.0, 126.0, 129.0, 133.0, 137.0, 142.0, 149.0, 155.0, 161.0, 167.0, 174.0, 178.0, 181.0, 183.0, 183.0, 182.0, 181.0, 178.0, 175.0, 171.0, 167.0, 161.0, 155.0, 149.0, 143.0, 138.0, 135.0, 133.0, 133.0, 134.0, 82.0, 81.0, 78.0, 75.0, 72.0, 67.0, 61.0, 55.0, 49.0, 43.0, 37.0, 31.0, 24.0, 18.0, 12.0, 6.0, 0.0, 4.0, 7.0, 9.0, 9.0, 8.0, 7.0, 7.0, 8.0, 9.0, 12.0, 15.0, 19.0, 23.0, 29.0, 35.0, 41.0, 47.0, 54.0, 60.0, 66.0, 72.0, 79.0, 85.0, 91.0, 97.0, 103.0, 110.0, 116.0, 122.0, 128.0, 134.0, 140.0, 147.0, 153.0, 159.0, 165.0, 171.0, 177.0, 183.0, 189.0, 195.0, 201.0, 207.0, 213.0, 219.0, 225.0, 231.0, 237.0, 243.0, 249.0, 255.0, 260.0, 266.0, 271.0, 277.0, 282.0, 286.0, 289.0, 291.0, 291.0, 290.0, 289.0, 286.0, 283.0, 280.0, 275.0, 270.0, 264.0, 258.0, 252.0, 245.0, 239.0, 233.0, 227.0, 221.0, 216.0, 213.0, 212.0, 212.0, 213.0, 214.0, 216.0, 219.0, 222.0, 226.0, 231.0, 236.0, 241.0, 247.0, 252.0, 258.0, 263.0, 269.0, 274.0, 279.0, 285.0, 290.0, 295.0, 301.0, 306.0, 310.0, 312.0, 313.0, 86.0, 83.0, 81.0, 77.0, 73.0, 67.0, 61.0, 55.0, 49.0, 43.0, 37.0, 31.0, 24.0, 18.0, 12.0, 6.0, 0.0, 6.0, 12.0, 18.0, 24.0, 31.0, 37.0, 43.0, 49.0, 55.0, 62.0, 66.0, 69.0, 71.0, 71.0, 70.0, 69.0, 67.0, 64.0, 60.0, 56.0, 51.0, 46.0, 41.0, 36.0, 31.0, 27.0, 24.0, 22.0, 22.0, 23.0, 25.0, 29.0, 33.0, 38.0, 43.0, 48.0, 54.0, 59.0, 65.0, 71.0, 76.0, 82.0, 88.0, 94.0, 100.0, 106.0, 112.0, 118.0, 124.0, 130.0, 136.0, 141.0, 144.0, 145.0, 145.0, 145.0, 143.0, 141.0, 138.0, 134.0, 130.0, 125.0, 119.0, 113.0, 107.0, 101.0, 95.0, 89.0, 83.0, 77.0, 71.0, 65.0, 60.0, 57.0, 55.0, 55.0, 55.0, 55.0, 55.0, 57.0, 59.0, 60.0, 60.0, 58.0, 59.0, 60.0, 61.0, 64.0, 67.0, 71.0, 76.0, 82.0, 88.0, 94.0, 101.0, 107.0, 111.0, 115.0, 118.0, 123.0, 129.0, 135.0, 141.0};
    }

    public static class WDs {
        public static final double[] wallDistances = new double[]{100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 99.0, 94.0, 90.0, 86.0, 82.0, 78.0, 75.0, 71.0, 68.0, 65.0, 62.0, 58.0, 56.0, 54.0, 51.0, 49.0, 47.0, 45.0, 43.0, 41.0, 40.0, 38.0, 37.0, 36.0, 35.0, 34.0, 32.0, 31.0, 30.0, 29.0, 28.0, 26.0, 25.0, 24.0, 22.0, 21.0, 20.0, 18.0, 17.0, 16.0, 15.0, 13.0, 12.0, 11.0, 11.0, 10.0, 9.0, 8.0, 8.0, 7.0, 7.0, 6.0, 6.0, 5.0, 5.0, 5.0, 4.0, 4.0, 4.0, 4.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 1.0, 1.0, 2.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 25.0, 25.0, 24.0, 24.0, 23.0, 22.0, 21.0, 20.0, 19.0, 18.0, 17.0, 17.0, 17.0, 17.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 98.0, 95.0, 92.0, 89.0, 85.0, 81.0, 77.0, 73.0, 70.0, 66.0, 63.0, 60.0, 56.0, 54.0, 51.0, 48.0, 46.0, 43.0, 41.0, 38.0, 36.0, 34.0, 32.0, 30.0, 28.0, 26.0, 25.0, 23.0, 22.0, 21.0, 19.0, 18.0, 17.0, 16.0, 15.0, 14.0, 13.0, 12.0, 11.0, 10.0, 9.0, 9.0, 8.0, 8.0, 7.0, 7.0, 6.0, 6.0, 6.0, 5.0, 5.0, 5.0, 4.0, 4.0, 4.0, 4.0, 4.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 98.0, 97.0, 97.0, 97.0, 97.0, 29.0, 28.0, 27.0, 26.0, 25.0, 23.0, 22.0, 20.0, 19.0, 18.0, 18.0, 18.0, 18.0, 18.0, 19.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 73.0, 72.0, 71.0, 71.0, 71.0, 71.0, 71.0, 71.0, 34.0, 33.0, 32.0, 31.0, 30.0, 28.0, 27.0, 26.0, 24.0, 23.0, 22.0, 20.0, 19.0, 18.0, 17.0, 15.0, 14.0, 13.0, 12.0, 11.0, 10.0, 10.0, 9.0, 8.0, 8.0, 7.0, 7.0, 6.0, 6.0, 5.0, 5.0, 5.0, 5.0, 5.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 99.0, 98.0, 98.0, 98.0, 98.0, 98.0, 52.0, 52.0, 52.0, 51.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 51.0, 51.0, 51.0, 51.0, 51.0, 52.0, 52.0, 52.0, 52.0, 52.0, 52.0, 52.0, 52.0, 52.0, 52.0, 52.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 98.0, 95.0, 93.0, 90.0, 88.0, 86.0, 84.0, 82.0, 80.0, 78.0, 77.0, 75.0, 73.0, 72.0, 71.0, 69.0, 68.0, 66.0, 64.0, 62.0, 60.0, 58.0, 57.0, 55.0, 52.0, 51.0, 49.0, 47.0, 45.0, 44.0, 42.0, 41.0, 39.0, 38.0, 36.0, 35.0, 33.0, 32.0, 31.0, 30.0, 28.0, 27.0, 26.0, 25.0, 24.0, 23.0, 22.0, 22.0, 22.0, 22.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 99.0, 97.0, 95.0, 93.0, 91.0, 27.0, 27.0, 27.0, 27.0, 27.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 27.0, 27.0, 27.0, 27.0, 27.0, 84.0, 84.0, 83.0, 82.0, 82.0, 80.0, 79.0, 78.0, 76.0, 75.0, 74.0, 73.0, 71.0, 70.0, 69.0, 69.0, 69.0, 69.0, 39.0, 38.0, 38.0, 37.0, 34.0, 33.0, 32.0, 31.0, 29.0, 27.0, 26.0, 24.0, 23.0, 21.0, 20.0, 18.0, 17.0, 15.0, 14.0, 13.0, 11.0, 10.0, 9.0, 7.0, 6.0, 5.0, 5.0, 4.0, 4.0, 3.0, 3.0, 3.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 3.0, 3.0, 31.0, 31.0, 31.0, 31.0, 30.0, 30.0, 29.0, 28.0, 28.0, 27.0, 27.0, 26.0, 26.0, 25.0, 25.0, 24.0, 24.0, 23.0, 23.0, 22.0, 22.0, 22.0, 21.0, 21.0, 20.0, 20.0, 20.0, 20.0, 21.0, 22.0, 23.0, 25.0, 27.0, 29.0, 31.0, 33.0, 36.0, 44.0, 57.0, 56.0, 54.0, 52.0, 51.0, 50.0, 49.0, 48.0, 47.0, 47.0, 47.0, 45.0, 44.0, 43.0, 42.0, 42.0, 41.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 41.0, 40.0, 39.0, 38.0, 37.0, 35.0, 34.0, 32.0, 31.0, 29.0, 28.0, 26.0, 25.0, 23.0, 22.0, 20.0, 19.0, 17.0, 12.0, 11.0, 11.0, 10.0, 10.0, 10.0, 10.0, 10.0, 11.0, 12.0, 13.0, 15.0, 17.0, 22.0, 42.0, 41.0, 41.0, 40.0, 39.0, 38.0, 37.0, 36.0, 35.0, 34.0, 33.0, 32.0, 31.0, 30.0, 29.0, 28.0, 27.0, 26.0, 26.0, 26.0, 26.0, 25.0, 25.0, 24.0, 23.0, 22.0, 21.0, 20.0, 19.0, 18.0, 17.0, 16.0, 15.0, 14.0, 13.0, 12.0, 11.0, 10.0, 9.0, 8.0, 7.0, 7.0, 7.0, 7.0, 8.0, 8.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 95.0, 91.0, 87.0, 83.0, 79.0, 76.0, 74.0, 71.0, 69.0, 67.0, 65.0, 63.0, 61.0, 60.0, 58.0, 56.0, 54.0, 52.0, 51.0, 49.0, 48.0, 46.0, 45.0, 43.0, 42.0, 40.0, 38.0, 37.0, 35.0, 33.0, 32.0, 30.0, 29.0, 28.0, 26.0, 25.0, 23.0, 22.0, 54.0, 54.0, 54.0, 54.0, 54.0, 54.0, 54.0, 54.0, 54.0, 41.0, 41.0, 41.0, 41.0, 41.0, 42.0, 42.0, 42.0, 43.0, 43.0, 44.0, 44.0, 58.0, 63.0, 69.0, 85.0, 84.0, 84.0, 84.0, 84.0, 46.0, 46.0, 85.0, 85.0, 58.0, 85.0, 57.0, 68.0, 63.0, 55.0, 58.0, 53.0, 55.0, 51.0, 52.0, 50.0, 50.0, 48.0, 48.0, 46.0, 47.0, 45.0, 44.0, 43.0, 41.0, 40.0, 39.0, 38.0, 37.0, 37.0, 36.0, 36.0, 36.0, 36.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 98.0, 96.0, 94.0, 92.0, 91.0, 91.0, 90.0, 57.0, 58.0, 58.0, 57.0, 55.0, 52.0, 48.0, 45.0, 44.0, 42.0, 42.0, 41.0, 40.0, 38.0, 37.0, 37.0, 35.0, 35.0, 34.0, 34.0, 34.0, 34.0, 100.0, 100.0, 100.0, 100.0, 100.0, 99.0, 98.0, 96.0, 94.0, 92.0, 90.0, 88.0, 87.0, 85.0, 84.0, 82.0, 81.0, 81.0, 80.0, 100.0, 100.0, 100.0, 100.0, 100.0, 78.0, 69.0, 61.0, 56.0, 51.0, 47.0, 44.0, 41.0, 39.0, 37.0, 36.0, 35.0, 35.0, 74.0, 73.0, 72.0, 71.0, 34.0, 34.0, 35.0, 35.0, 36.0, 37.0, 71.0, 72.0, 73.0, 74.0, 74.0, 75.0, 76.0, 76.0, 77.0, 78.0, 78.0, 78.0, 78.0, 78.0, 78.0, 77.0, 76.0, 74.0, 72.0, 70.0, 67.0, 65.0, 62.0, 60.0, 57.0, 55.0, 52.0, 50.0, 48.0, 46.0, 44.0, 42.0, 40.0, 38.0, 37.0, 35.0, 34.0, 32.0, 31.0, 30.0, 30.0, 29.0, 28.0, 28.0, 27.0, 26.0, 26.0, 25.0, 24.0, 23.0, 23.0, 22.0, 22.0, 21.0, 21.0, 20.0, 20.0, 19.0, 19.0, 18.0, 18.0, 18.0, 17.0, 17.0, 17.0, 17.0, 17.0, 17.0, 17.0, 18.0, 19.0, 19.0, 20.0, 21.0, 22.0, 25.0, 30.0, 42.0, 57.0, 54.0, 51.0, 47.0, 45.0, 43.0, 41.0, 40.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 70.0, 54.0, 46.0, 41.0, 36.0, 32.0, 29.0, 26.0, 24.0, 22.0, 20.0, 18.0, 16.0, 15.0, 13.0, 12.0, 11.0, 11.0, 11.0, 11.0, 17.0, 16.0, 16.0, 15.0, 15.0, 14.0, 13.0, 13.0, 12.0, 11.0, 11.0, 10.0, 10.0, 9.0, 9.0, 9.0, 8.0, 8.0, 8.0, 7.0, 7.0, 7.0, 6.0, 6.0, 6.0, 6.0, 6.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 80.0, 72.0, 66.0, 61.0, 57.0, 53.0, 50.0, 47.0, 45.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 99.0, 96.0, 93.0, 90.0, 87.0, 85.0, 82.0, 80.0, 79.0, 78.0, 78.0, 78.0, 78.0, 43.0, 43.0, 42.0, 42.0, 42.0, 41.0, 41.0, 41.0, 40.0, 40.0, 39.0, 38.0, 38.0, 37.0, 37.0, 36.0, 35.0, 34.0, 33.0, 33.0, 32.0, 32.0, 32.0, 32.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 98.0, 97.0, 95.0, 93.0, 91.0, 89.0, 87.0, 86.0, 84.0, 82.0, 80.0, 78.0, 76.0, 74.0, 72.0, 70.0, 68.0, 65.0, 63.0, 61.0, 59.0, 57.0, 55.0, 53.0, 52.0, 50.0, 49.0, 48.0, 48.0, 48.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 99.0, 98.0, 97.0, 95.0, 93.0, 92.0, 90.0, 58.0, 58.0, 57.0, 58.0, 58.0, 58.0, 58.0, 57.0, 57.0, 57.0, 56.0, 56.0, 56.0, 55.0, 54.0, 54.0, 53.0, 52.0, 52.0, 51.0, 50.0, 50.0, 49.0, 48.0, 48.0, 47.0, 47.0, 47.0, 44.0, 47.0, 47.0, 46.0, 46.0, 45.0, 44.0, 43.0, 42.0, 41.0, 39.0, 38.0, 37.0, 36.0, 35.0, 33.0, 32.0, 31.0, 30.0, 28.0, 27.0, 26.0, 25.0, 23.0, 22.0, 21.0, 20.0, 19.0, 18.0, 16.0, 16.0, 15.0, 14.0, 13.0, 12.0, 12.0, 12.0, 12.0, 67.0, 66.0, 66.0, 65.0, 65.0, 64.0, 63.0, 62.0, 61.0, 60.0, 59.0, 58.0, 58.0, 57.0, 56.0, 56.0, 55.0, 55.0, 54.0, 54.0, 53.0, 52.0, 52.0, 52.0, 51.0, 51.0, 50.0, 50.0, 49.0, 48.0, 48.0, 47.0, 46.0, 45.0, 44.0, 43.0, 42.0, 40.0, 39.0, 38.0, 36.0, 35.0, 34.0, 33.0, 32.0, 30.0, 29.0, 28.0, 27.0, 26.0, 25.0, 24.0, 23.0, 22.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 99.0, 98.0, 96.0, 95.0, 94.0, 93.0, 91.0, 89.0, 88.0, 87.0, 86.0, 85.0, 84.0, 84.0, 83.0, 83.0, 82.0, 82.0, 81.0, 80.0, 80.0, 79.0, 78.0, 77.0, 75.0, 73.0, 71.0, 69.0, 67.0, 65.0, 62.0, 59.0, 57.0, 54.0, 51.0, 49.0, 46.0, 43.0, 41.0, 38.0, 36.0, 33.0, 31.0, 29.0, 27.0, 25.0, 23.0, 21.0, 20.0, 19.0, 18.0, 18.0, 18.0, 18.0, 17.0, 17.0, 16.0, 15.0, 15.0, 15.0, 14.0, 14.0, 14.0, 14.0, 14.0, 14.0, 14.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 97.0, 93.0, 90.0, 100.0, 100.0, 100.0, 100.0, 100.0, 99.0, 99.0, 98.0, 98.0, 97.0, 95.0, 92.0, 89.0, 86.0, 83.0, 80.0, 77.0, 73.0, 70.0, 68.0, 66.0, 64.0, 64.0, 64.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 87.0, 87.0, 87.0, 87.0, 87.0, 88.0, 100.0, 100.0, 100.0, 100.0, 98.0, 97.0, 95.0, 93.0, 91.0, 89.0, 87.0, 86.0, 85.0, 84.0, 82.0, 81.0, 79.0, 78.0, 77.0, 76.0, 76.0, 75.0, 74.0, 73.0, 71.0, 69.0, 66.0, 63.0, 61.0, 58.0, 55.0, 52.0, 50.0, 48.0, 46.0, 45.0, 43.0, 42.0, 41.0, 39.0, 38.0, 36.0, 34.0, 32.0, 30.0, 28.0, 27.0, 26.0, 25.0, 26.0, 26.0, 26.0, 26.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 99.0, 49.0, 49.0, 49.0, 48.0, 47.0, 46.0, 45.0, 44.0, 42.0, 41.0, 40.0, 39.0, 38.0, 38.0, 39.0, 78.0, 78.0, 77.0, 76.0, 74.0, 73.0, 71.0, 68.0, 67.0, 65.0, 63.0, 62.0, 61.0, 60.0, 59.0, 58.0, 51.0, 51.0, 50.0, 50.0, 49.0, 47.0, 46.0, 45.0, 43.0, 42.0, 41.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 39.0, 38.0, 38.0, 38.0, 39.0, 55.0, 39.0, 54.0, 38.0, 38.0, 37.0, 36.0, 36.0, 36.0, 36.0, 36.0, 36.0, 56.0, 55.0, 55.0, 54.0, 53.0, 52.0, 51.0, 50.0, 49.0, 48.0, 47.0, 45.0, 44.0, 43.0, 42.0, 41.0, 40.0, 39.0, 38.0, 37.0, 36.0, 35.0, 35.0, 35.0, 35.0, 36.0, 36.0, 36.0, 36.0, 36.0, 35.0, 34.0, 32.0, 31.0, 30.0, 28.0, 27.0, 26.0, 25.0, 24.0, 23.0, 23.0, 22.0, 21.0, 21.0, 21.0, 22.0, 22.0, 100.0, 88.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 74.0, 100.0, 100.0, 70.0, 69.0, 100.0, 66.0, 100.0, 63.0, 62.0, 61.0, 60.0, 58.0, 57.0, 55.0, 54.0, 52.0, 50.0, 48.0, 46.0, 44.0, 43.0, 41.0, 40.0, 38.0, 37.0, 35.0, 34.0, 32.0, 30.0, 29.0, 27.0, 26.0, 24.0, 23.0, 22.0, 20.0, 19.0, 17.0, 16.0, 15.0, 13.0, 12.0, 11.0, 10.0, 9.0, 8.0, 7.0, 6.0, 5.0, 4.0, 4.0, 3.0, 2.0, 2.0, 2.0, 2.0, 1.0, 2.0, 2.0, 2.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 4.0, 5.0, 5.0, 7.0, 11.0, 51.0, 49.0, 47.0, 45.0, 43.0, 41.0, 39.0, 37.0, 35.0, 33.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 84.0, 74.0, 67.0, 61.0, 55.0, 51.0, 46.0, 42.0, 39.0, 35.0, 33.0, 31.0, 31.0, 30.0, 31.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 19.0, 16.0, 14.0, 13.0, 12.0, 11.0, 10.0, 9.0, 9.0, 8.0, 8.0, 7.0, 7.0, 8.0, 8.0, 8.0, 9.0, 12.0, 92.0, 91.0, 91.0, 90.0, 89.0, 88.0, 86.0, 84.0, 81.0, 79.0, 77.0, 74.0, 73.0, 71.0, 70.0, 68.0, 67.0, 66.0, 8.0, 8.0, 9.0, 62.0, 60.0, 58.0, 57.0, 55.0, 53.0, 51.0, 49.0, 48.0, 46.0, 43.0, 42.0, 40.0, 39.0, 37.0, 35.0, 33.0, 31.0, 29.0, 28.0, 26.0, 24.0, 22.0, 21.0, 20.0, 18.0, 17.0, 16.0, 15.0, 14.0, 13.0, 12.0, 11.0, 11.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 98.0, 96.0, 93.0, 91.0, 89.0, 87.0, 85.0, 84.0, 82.0, 80.0, 79.0, 77.0, 75.0, 74.0, 72.0, 70.0, 69.0, 67.0, 65.0, 63.0, 62.0, 60.0, 58.0, 57.0, 55.0, 53.0, 52.0, 50.0, 49.0, 47.0, 46.0, 45.0, 44.0, 43.0, 42.0, 42.0, 42.0, 42.0, 59.0, 58.0, 58.0, 57.0, 56.0, 55.0, 54.0, 52.0, 51.0, 50.0, 49.0, 47.0, 46.0, 44.0, 43.0, 42.0, 41.0, 41.0, 41.0, 41.0, 64.0, 64.0, 64.0, 64.0, 65.0, 65.0, 65.0, 65.0, 66.0, 66.0, 67.0, 67.0, 67.0, 68.0, 70.0, 71.0, 55.0, 55.0, 54.0, 53.0, 52.0, 52.0, 51.0, 50.0, 49.0, 47.0, 46.0, 46.0, 46.0, 46.0, 47.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 76.0, 74.0, 73.0, 72.0, 36.0, 35.0, 35.0, 34.0, 33.0, 32.0, 31.0, 30.0, 29.0, 28.0, 26.0, 25.0, 24.0, 23.0, 22.0, 21.0, 20.0, 19.0, 18.0, 17.0, 16.0, 15.0, 15.0, 14.0, 14.0, 14.0, 14.0, 61.0, 60.0, 60.0, 58.0, 58.0, 57.0, 56.0, 55.0, 54.0, 53.0, 52.0, 51.0, 50.0, 49.0, 48.0, 47.0, 46.0, 45.0, 44.0, 43.0, 42.0, 41.0, 40.0, 39.0, 38.0, 37.0, 36.0, 35.0, 34.0, 33.0, 32.0, 31.0, 30.0, 29.0, 28.0, 27.0, 26.0, 25.0, 24.0, 23.0, 22.0, 22.0, 21.0, 21.0, 21.0, 21.0, 72.0, 21.0, 21.0, 20.0, 20.0, 19.0, 19.0, 19.0, 19.0, 81.0, 19.0, 19.0, 19.0, 19.0, 19.0, 19.0, 19.0, 19.0, 18.0, 18.0, 18.0, 18.0, 18.0, 18.0, 19.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 70.0, 70.0, 70.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 99.0, 97.0, 96.0, 94.0, 92.0, 91.0, 89.0, 87.0, 86.0, 85.0, 85.0, 84.0, 82.0, 81.0, 80.0, 79.0, 78.0, 77.0, 75.0, 74.0, 73.0, 71.0, 71.0, 71.0, 71.0, 71.0, 72.0, 92.0, 92.0, 91.0, 90.0, 89.0, 89.0, 88.0, 87.0, 86.0, 84.0, 83.0, 81.0, 80.0, 78.0, 77.0, 76.0, 74.0, 73.0, 71.0, 70.0, 68.0, 67.0, 65.0, 64.0, 62.0, 61.0, 59.0, 58.0, 57.0, 55.0, 53.0, 52.0, 50.0, 49.0, 47.0, 46.0, 44.0, 43.0, 41.0, 40.0, 39.0, 37.0, 36.0, 35.0, 34.0, 33.0, 32.0, 66.0, 65.0, 64.0, 100.0, 62.0, 61.0, 60.0, 98.0, 92.0, 88.0, 56.0, 81.0, 53.0, 75.0, 52.0, 71.0, 50.0, 67.0, 48.0, 63.0, 47.0, 58.0, 45.0, 55.0, 52.0, 43.0, 50.0, 41.0, 48.0, 48.0, 48.0, 48.0, 48.0, 48.0, 48.0, 0.0, 49.0, 49.0, 49.0, 49.0, 49.0, 48.0, 48.0, 47.0, 46.0, 45.0, 45.0, 44.0, 43.0, 43.0, 42.0, 42.0, 41.0, 41.0, 40.0, 40.0, 40.0, 40.0, 39.0, 39.0, 39.0, 38.0, 37.0, 35.0, 34.0, 33.0, 31.0, 30.0, 29.0, 28.0, 27.0, 26.0, 25.0, 25.0, 24.0, 24.0, 24.0, 24.0, 24.0, 25.0, 27.0, 34.0, 34.0, 32.0, 31.0, 30.0, 29.0, 27.0, 26.0, 25.0, 24.0, 23.0, 22.0, 21.0, 21.0, 20.0, 19.0, 18.0, 18.0, 17.0, 17.0, 16.0, 16.0, 15.0, 15.0, 14.0, 14.0, 14.0, 14.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 63.0, 63.0, 63.0, 63.0, 62.0, 62.0, 100.0, 100.0, 100.0, 60.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 48.0, 100.0, 47.0, 98.0, 45.0, 91.0, 89.0, 87.0, 85.0, 84.0, 83.0, 83.0, 82.0, 82.0, 81.0, 81.0, 81.0, 82.0, 80.0, 77.0, 73.0, 69.0, 65.0, 61.0, 58.0, 56.0, 53.0, 51.0, 48.0, 46.0, 44.0, 42.0, 40.0, 38.0, 36.0, 33.0, 31.0, 30.0, 28.0, 26.0, 25.0, 24.0, 23.0, 22.0, 20.0, 20.0, 19.0, 18.0, 17.0, 17.0, 16.0, 16.0, 15.0, 15.0, 14.0, 14.0, 13.0, 13.0, 13.0, 13.0, 12.0, 12.0, 12.0, 11.0, 11.0, 11.0, 11.0, 11.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 38.0, 38.0, 37.0, 36.0, 35.0, 34.0, 34.0, 34.0, 34.0, 87.0, 85.0, 83.0, 81.0, 79.0, 77.0, 74.0, 72.0, 70.0, 68.0, 66.0, 64.0, 62.0, 60.0, 58.0, 57.0, 55.0, 54.0, 52.0, 51.0, 50.0, 49.0, 47.0, 46.0, 45.0, 44.0, 42.0, 41.0, 40.0, 38.0, 37.0, 36.0, 35.0, 33.0, 32.0, 31.0, 29.0, 28.0, 28.0, 28.0, 28.0, 28.0, 72.0, 71.0, 70.0, 69.0, 68.0, 67.0, 66.0, 64.0, 63.0, 62.0, 60.0, 59.0, 58.0, 57.0, 55.0, 54.0, 52.0, 51.0, 50.0, 49.0, 47.0, 46.0, 45.0, 43.0, 42.0, 41.0, 39.0, 38.0, 37.0, 36.0, 35.0, 33.0, 32.0, 31.0, 30.0, 29.0, 28.0, 26.0, 25.0, 25.0, 24.0, 24.0, 25.0, 25.0, 25.0, 26.0, 26.0, 26.0, 26.0, 26.0, 26.0, 26.0, 26.0, 26.0, 25.0, 25.0, 25.0, 25.0, 25.0, 24.0, 24.0, 24.0, 23.0, 22.0, 22.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 75.0, 23.0, 19.0, 18.0, 16.0, 15.0, 15.0, 15.0, 15.0, 14.0, 15.0, 17.0, 57.0, 56.0, 54.0, 52.0, 52.0, 50.0, 49.0, 48.0, 47.0, 46.0, 46.0, 46.0, 46.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 98.0, 96.0, 94.0, 92.0, 90.0, 88.0, 87.0, 85.0, 84.0, 82.0, 81.0, 79.0, 77.0, 76.0, 74.0, 73.0, 71.0, 70.0, 68.0, 67.0, 65.0, 64.0, 62.0, 61.0, 60.0, 58.0, 57.0, 56.0, 55.0, 54.0, 52.0, 52.0, 51.0, 50.0, 49.0, 48.0, 47.0, 46.0, 45.0, 43.0, 42.0, 40.0, 39.0, 37.0, 36.0, 34.0, 33.0, 31.0, 29.0, 27.0, 26.0, 24.0, 22.0, 21.0, 19.0, 17.0, 16.0, 14.0, 13.0, 11.0, 10.0, 10.0, 9.0, 9.0, 9.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 21.0, 22.0, 22.0, 22.0, 22.0, 22.0, 21.0, 21.0, 21.0, 21.0, 20.0, 20.0, 20.0, 20.0, 20.0, 21.0, 21.0, 21.0, 21.0, 22.0, 22.0, 100.0, 100.0, 99.0, 99.0, 98.0, 97.0, 96.0, 95.0, 94.0, 93.0, 92.0, 92.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 99.0, 96.0, 93.0, 90.0, 87.0, 85.0, 83.0, 82.0, 82.0, 82.0, 40.0, 39.0, 38.0, 36.0, 35.0, 33.0, 31.0, 29.0, 27.0, 25.0, 24.0, 22.0, 21.0, 20.0, 19.0, 18.0, 17.0, 17.0, 16.0, 15.0, 15.0, 15.0, 14.0, 14.0, 14.0, 14.0, 13.0, 13.0, 13.0, 13.0, 12.0, 12.0, 12.0, 12.0, 12.0, 11.0, 11.0, 11.0, 11.0, 11.0, 11.0, 11.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 86.0, 80.0, 76.0, 72.0, 68.0, 65.0, 62.0, 46.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 99.0, 98.0, 98.0, 98.0, 98.0, 97.0, 95.0, 93.0, 91.0, 88.0, 84.0, 81.0, 78.0, 75.0, 72.0, 69.0, 66.0, 63.0, 61.0, 58.0, 56.0, 54.0, 52.0, 50.0, 49.0, 48.0, 47.0, 47.0, 46.0, 44.0, 44.0, 44.0, 43.0, 43.0, 43.0, 42.0, 42.0, 42.0, 42.0, 41.0, 40.0, 39.0, 38.0, 36.0, 35.0, 33.0, 31.0, 29.0, 28.0, 26.0, 24.0, 23.0, 21.0, 19.0, 18.0, 17.0, 16.0, 16.0, 16.0, 16.0, 100.0, 100.0, 100.0, 100.0, 98.0, 96.0, 93.0, 91.0, 88.0, 86.0, 83.0, 81.0, 79.0, 77.0, 75.0, 73.0, 72.0, 70.0, 68.0, 66.0, 65.0, 63.0, 62.0, 60.0, 58.0, 57.0, 56.0, 54.0, 52.0, 52.0, 51.0, 50.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 90.0, 83.0, 78.0, 75.0, 71.0, 68.0, 65.0, 63.0, 60.0, 58.0, 56.0, 54.0, 51.0, 49.0, 48.0, 46.0, 44.0, 42.0, 40.0, 39.0, 37.0, 36.0, 34.0, 33.0, 31.0, 30.0, 28.0, 27.0, 26.0, 26.0, 26.0, 26.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 99.0, 98.0, 97.0, 96.0, 95.0, 94.0, 92.0, 91.0, 90.0, 90.0, 90.0, 90.0, 91.0, 56.0, 55.0, 54.0, 54.0, 52.0, 52.0, 51.0, 50.0, 49.0, 48.0, 46.0, 45.0, 44.0, 43.0, 42.0, 41.0, 41.0, 40.0, 39.0, 38.0, 37.0, 36.0, 34.0, 33.0, 33.0, 32.0, 42.0, 42.0, 42.0, 41.0, 40.0, 40.0, 39.0, 38.0, 38.0, 38.0, 37.0, 37.0, 36.0, 36.0, 35.0, 35.0, 35.0, 34.0, 34.0, 33.0, 33.0, 33.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 80.0, 79.0, 78.0, 76.0, 74.0, 72.0, 70.0, 68.0, 66.0, 64.0, 62.0, 60.0, 58.0, 56.0, 55.0, 52.0, 51.0, 50.0, 48.0, 47.0, 45.0, 44.0, 43.0, 41.0, 40.0, 38.0, 37.0, 36.0, 34.0, 33.0, 31.0, 30.0, 29.0, 27.0, 26.0, 24.0, 23.0, 22.0, 20.0, 19.0, 18.0, 16.0, 15.0, 13.0, 12.0, 11.0, 10.0, 10.0, 10.0, 10.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 46.0, 100.0, 45.0, 45.0, 100.0, 44.0, 43.0, 42.0, 40.0, 39.0, 37.0, 35.0, 32.0, 30.0, 28.0, 26.0, 24.0, 76.0, 76.0, 76.0, 76.0, 76.0, 76.0, 75.0, 75.0, 74.0, 73.0, 73.0, 73.0, 72.0, 72.0, 72.0, 72.0, 72.0, 73.0, 73.0, 73.0, 73.0, 73.0, 73.0, 73.0, 73.0, 73.0, 73.0, 73.0, 73.0, 85.0, 84.0, 83.0, 83.0, 82.0, 80.0, 79.0, 78.0, 76.0, 75.0, 74.0, 72.0, 71.0, 69.0, 68.0, 67.0, 65.0, 64.0, 63.0, 62.0, 60.0, 58.0, 58.0, 56.0, 55.0, 54.0, 52.0, 51.0, 50.0, 48.0, 47.0, 46.0, 44.0, 43.0, 41.0, 40.0, 38.0, 37.0, 35.0, 34.0, 33.0, 33.0, 33.0, 33.0, 94.0, 92.0, 90.0, 89.0, 87.0, 85.0, 83.0, 81.0, 79.0, 77.0, 75.0, 73.0, 72.0, 70.0, 69.0, 69.0, 69.0, 69.0, 69.0, 54.0, 53.0, 52.0, 52.0, 52.0, 71.0, 70.0, 69.0, 69.0, 68.0, 66.0, 65.0, 63.0, 62.0, 60.0, 58.0, 57.0, 56.0, 55.0, 54.0, 52.0, 52.0, 50.0, 50.0, 49.0, 49.0, 48.0, 48.0, 63.0, 63.0, 62.0, 62.0, 62.0, 62.0, 95.0, 91.0, 88.0, 84.0, 81.0, 78.0, 75.0, 72.0, 69.0, 66.0, 64.0, 61.0, 59.0, 57.0, 55.0, 53.0, 51.0, 49.0, 48.0, 46.0, 45.0, 44.0, 42.0, 41.0, 40.0, 38.0, 37.0, 36.0, 35.0, 33.0, 32.0, 31.0, 29.0, 28.0, 26.0, 25.0, 24.0, 22.0, 21.0, 19.0, 18.0, 17.0, 16.0, 14.0, 13.0, 12.0, 11.0, 10.0, 9.0, 8.0, 8.0, 8.0, 8.0, 8.0, 83.0, 82.0, 81.0, 81.0, 80.0, 80.0, 79.0, 79.0, 78.0, 77.0, 77.0, 76.0, 75.0, 75.0, 74.0, 73.0, 71.0, 70.0, 69.0, 68.0, 67.0, 66.0, 65.0, 64.0, 63.0, 62.0, 61.0, 60.0, 58.0, 58.0, 58.0, 58.0, 58.0, 58.0, 58.0, 58.0, 58.0, 58.0, 58.0, 58.0, 58.0, 58.0, 59.0, 58.0, 57.0, 55.0, 53.0, 51.0, 49.0, 47.0, 45.0, 43.0, 41.0, 40.0, 39.0, 38.0, 38.0, 70.0, 70.0, 69.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 98.0, 95.0, 92.0, 90.0, 88.0, 86.0, 84.0, 83.0, 81.0, 80.0, 79.0, 78.0, 78.0, 77.0, 77.0, 76.0, 75.0, 74.0, 73.0, 71.0, 70.0, 68.0, 66.0, 65.0, 63.0, 62.0, 60.0, 58.0, 56.0, 55.0, 53.0, 51.0, 50.0, 48.0, 46.0, 45.0, 43.0, 41.0, 39.0, 37.0, 36.0, 34.0, 32.0, 30.0, 29.0, 27.0, 26.0, 24.0, 22.0, 21.0, 19.0, 18.0, 17.0, 15.0, 14.0, 13.0, 11.0, 10.0, 9.0, 8.0, 7.0, 6.0, 5.0, 4.0, 4.0, 4.0, 4.0, 100.0, 100.0, 100.0, 100.0, 45.0, 40.0, 36.0, 34.0, 33.0, 8.0, 8.0, 8.0, 7.0, 7.0, 7.0, 7.0, 7.0, 7.0, 7.0, 7.0, 7.0, 7.0, 7.0, 6.0, 6.0, 6.0, 6.0, 7.0, 7.0, 7.0, 7.0, 7.0, 8.0, 8.0, 9.0, 10.0, 13.0, 26.0, 26.0, 25.0, 25.0, 25.0, 25.0, 25.0, 25.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 98.0, 95.0, 92.0, 90.0, 87.0, 85.0, 83.0, 82.0, 81.0, 79.0, 78.0, 77.0, 76.0, 75.0, 74.0, 73.0, 72.0, 72.0, 71.0, 70.0, 69.0, 68.0, 67.0, 66.0, 65.0, 64.0, 63.0, 61.0, 60.0, 58.0, 57.0, 55.0, 54.0, 52.0, 50.0, 49.0, 47.0, 46.0, 44.0, 42.0, 40.0, 39.0, 37.0, 35.0, 34.0, 32.0, 30.0, 29.0, 27.0, 26.0, 24.0, 23.0, 21.0, 20.0, 19.0, 18.0, 16.0, 15.0, 14.0, 13.0, 13.0, 12.0, 11.0, 11.0, 10.0, 9.0, 9.0, 9.0, 8.0, 8.0, 8.0, 8.0, 8.0, 7.0, 7.0, 7.0, 7.0, 7.0, 7.0, 7.0, 7.0, 7.0, 7.0, 7.0, 7.0, 7.0, 7.0, 7.0, 7.0, 7.0, 7.0, 7.0, 7.0, 7.0, 8.0, 8.0, 8.0, 8.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 83.0, 100.0, 71.0, 100.0, 63.0, 100.0, 58.0, 100.0, 54.0, 100.0, 50.0, 100.0, 47.0, 100.0, 45.0, 100.0, 44.0, 100.0, 100.0, 100.0, 100.0, 100.0, 98.0, 94.0, 89.0, 85.0, 81.0, 77.0, 74.0, 71.0, 68.0, 65.0, 62.0, 60.0, 57.0, 55.0, 52.0, 50.0, 48.0, 46.0, 44.0, 42.0, 40.0, 39.0, 37.0, 35.0, 34.0, 32.0, 30.0, 29.0, 27.0, 26.0, 24.0, 23.0, 21.0, 20.0, 19.0, 18.0, 17.0, 16.0, 15.0, 14.0, 13.0, 12.0, 11.0, 10.0, 9.0, 9.0, 9.0, 8.0, 8.0, 7.0, 7.0, 7.0, 98.0, 96.0, 95.0, 93.0, 91.0, 90.0, 89.0, 87.0, 86.0, 85.0, 83.0, 82.0, 81.0, 79.0, 78.0, 77.0, 76.0, 77.0, 75.0, 73.0, 72.0, 71.0, 70.0, 68.0, 67.0, 66.0, 65.0, 25.0, 21.0, 19.0, 17.0, 16.0, 15.0, 14.0, 13.0, 12.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 99.0, 98.0, 96.0, 94.0, 92.0, 90.0, 88.0, 86.0, 84.0, 82.0, 80.0, 78.0, 76.0, 74.0, 72.0, 70.0, 68.0, 66.0, 64.0, 62.0, 60.0, 58.0, 56.0, 54.0, 52.0, 50.0, 48.0, 46.0, 45.0, 45.0, 45.0, 45.0, 88.0, 86.0, 83.0, 81.0, 79.0, 76.0, 74.0, 72.0, 69.0, 67.0, 65.0, 63.0, 61.0, 58.0, 57.0, 56.0, 55.0, 55.0, 54.0, 54.0, 85.0, 86.0, 88.0, 89.0, 91.0, 94.0, 100.0, 100.0, 99.0, 97.0, 97.0, 96.0, 96.0, 95.0, 95.0, 96.0, 55.0, 55.0, 54.0, 53.0, 52.0, 51.0, 50.0, 50.0, 49.0, 49.0, 50.0, 50.0, 100.0, 100.0, 100.0, 91.0, 86.0, 82.0, 79.0, 77.0, 76.0, 75.0, 75.0, 75.0, 75.0, 74.0, 67.0, 67.0, 68.0, 68.0, 69.0, 70.0, 70.0, 70.0, 70.0, 70.0, 70.0, 70.0, 70.0, 70.0, 70.0, 70.0, 70.0, 70.0, 71.0, 71.0, 70.0, 71.0, 70.0, 71.0, 71.0, 71.0, 71.0, 86.0, 87.0, 87.0, 87.0, 88.0, 88.0, 88.0, 88.0, 87.0, 87.0, 87.0, 86.0, 86.0, 86.0, 85.0, 85.0, 84.0, 84.0, 84.0, 84.0, 83.0, 83.0, 83.0, 82.0, 82.0, 82.0, 80.0, 79.0, 76.0, 74.0, 71.0, 68.0, 65.0, 61.0, 58.0, 55.0, 52.0, 51.0, 49.0, 49.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 71.0, 70.0, 69.0, 67.0, 66.0, 64.0, 61.0, 59.0, 57.0, 55.0, 52.0, 51.0, 50.0, 50.0, 50.0, 50.0, 80.0, 78.0, 76.0, 74.0, 72.0, 70.0, 68.0, 66.0, 64.0, 63.0, 61.0, 60.0, 67.0, 66.0, 66.0, 65.0, 64.0, 64.0, 22.0, 19.0, 17.0, 16.0, 15.0, 14.0, 14.0, 14.0, 15.0, 15.0, 15.0, 16.0, 17.0, 18.0, 19.0, 21.0, 23.0, 58.0, 58.0, 58.0, 58.0, 21.0, 17.0, 14.0, 12.0, 11.0, 10.0, 9.0, 9.0, 9.0, 8.0, 8.0, 8.0, 8.0, 8.0, 8.0, 8.0, 8.0, 8.0, 8.0, 8.0, 8.0, 9.0, 10.0, 13.0, 35.0, 34.0, 33.0, 32.0, 30.0, 29.0, 27.0, 26.0, 25.0, 23.0, 22.0, 21.0, 20.0, 19.0, 18.0, 18.0, 18.0, 18.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 52.0, 51.0, 50.0, 49.0, 47.0, 46.0, 44.0, 42.0, 40.0, 38.0, 36.0, 35.0, 34.0, 33.0, 33.0, 33.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 99.0, 97.0, 96.0, 95.0, 94.0, 92.0, 91.0, 90.0, 88.0, 86.0, 84.0, 83.0, 81.0, 80.0, 79.0, 78.0, 23.0, 23.0, 23.0, 76.0, 75.0, 74.0, 74.0, 73.0, 73.0, 72.0, 72.0, 71.0, 71.0, 70.0, 69.0, 68.0, 67.0, 66.0, 65.0, 63.0, 62.0, 61.0, 60.0, 60.0, 58.0, 58.0, 58.0, 58.0, 58.0, 58.0, 58.0, 59.0, 60.0, 61.0, 64.0, 66.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 43.0, 43.0, 42.0, 41.0, 40.0, 39.0, 38.0, 37.0, 36.0, 36.0, 35.0, 35.0, 34.0, 34.0, 33.0, 33.0, 32.0, 32.0, 32.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 98.0, 96.0, 93.0, 90.0, 87.0, 83.0, 79.0, 75.0, 72.0, 68.0, 65.0, 62.0, 59.0, 56.0, 54.0, 51.0, 49.0, 47.0, 44.0, 42.0, 40.0, 38.0, 36.0, 34.0, 33.0, 31.0, 30.0, 29.0, 28.0, 29.0, 29.0, 100.0, 99.0, 98.0, 97.0, 96.0, 95.0, 94.0, 93.0, 91.0, 90.0, 88.0, 86.0, 84.0, 82.0, 80.0, 79.0, 77.0, 76.0, 74.0, 73.0, 71.0, 69.0, 68.0, 66.0, 65.0, 63.0, 61.0, 58.0, 56.0, 54.0, 52.0, 50.0, 48.0, 46.0, 45.0, 43.0, 42.0, 41.0, 41.0, 41.0, 41.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 98.0, 96.0, 94.0, 93.0, 92.0, 90.0, 89.0, 89.0, 87.0, 86.0, 84.0, 84.0, 83.0, 83.0, 83.0, 82.0, 81.0, 55.0, 55.0, 55.0, 55.0, 76.0, 75.0, 57.0, 56.0, 56.0, 56.0, 55.0, 54.0, 52.0, 51.0, 50.0, 48.0, 46.0, 45.0, 45.0, 44.0, 42.0, 41.0, 39.0, 38.0};
    }

    public static class RWDs {
        public static final double[] revWallDistances = new double[]{39.0, 39.0, 39.0, 39.0, 39.0, 40.0, 40.0, 41.0, 41.0, 42.0, 43.0, 43.0, 44.0, 45.0, 45.0, 46.0, 47.0, 47.0, 48.0, 48.0, 49.0, 49.0, 50.0, 50.0, 51.0, 52.0, 53.0, 54.0, 56.0, 57.0, 58.0, 60.0, 61.0, 62.0, 63.0, 65.0, 66.0, 67.0, 68.0, 70.0, 71.0, 72.0, 73.0, 75.0, 76.0, 77.0, 79.0, 80.0, 82.0, 83.0, 85.0, 86.0, 88.0, 90.0, 92.0, 94.0, 96.0, 98.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 2.0, 3.0, 4.0, 5.0, 7.0, 9.0, 11.0, 13.0, 15.0, 17.0, 19.0, 22.0, 24.0, 25.0, 25.0, 25.0, 25.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 18.0, 19.0, 20.0, 22.0, 24.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 96.0, 93.0, 91.0, 89.0, 88.0, 87.0, 86.0, 87.0, 87.0, 89.0, 91.0, 93.0, 96.0, 99.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 4.0, 5.0, 6.0, 7.0, 9.0, 10.0, 13.0, 15.0, 17.0, 19.0, 21.0, 23.0, 25.0, 27.0, 28.0, 28.0, 29.0, 97.0, 98.0, 98.0, 99.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 19.0, 21.0, 23.0, 24.0, 26.0, 29.0, 32.0, 34.0, 38.0, 44.0, 74.0, 74.0, 74.0, 74.0, 74.0, 74.0, 74.0, 74.0, 74.0, 73.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 5.0, 6.0, 7.0, 7.0, 9.0, 10.0, 11.0, 12.0, 14.0, 15.0, 16.0, 18.0, 19.0, 20.0, 21.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 52.0, 52.0, 52.0, 52.0, 99.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 52.0, 52.0, 54.0, 55.0, 56.0, 57.0, 57.0, 58.0, 58.0, 58.0, 58.0, 58.0, 14.0, 15.0, 16.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 41.0, 42.0, 44.0, 45.0, 46.0, 48.0, 49.0, 51.0, 52.0, 54.0, 56.0, 57.0, 59.0, 61.0, 62.0, 64.0, 66.0, 68.0, 70.0, 72.0, 74.0, 76.0, 78.0, 81.0, 83.0, 86.0, 89.0, 92.0, 96.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 22.0, 23.0, 24.0, 24.0, 25.0, 26.0, 27.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 28.0, 90.0, 88.0, 87.0, 86.0, 85.0, 84.0, 84.0, 84.0, 83.0, 83.0, 83.0, 83.0, 84.0, 84.0, 84.0, 84.0, 84.0, 84.0, 27.0, 27.0, 27.0, 28.0, 29.0, 30.0, 31.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 39.0, 39.0, 39.0, 39.0, 70.0, 70.0, 71.0, 71.0, 25.0, 24.0, 24.0, 23.0, 22.0, 21.0, 21.0, 22.0, 21.0, 20.0, 19.0, 18.0, 17.0, 16.0, 16.0, 16.0, 16.0, 16.0, 16.0, 16.0, 15.0, 15.0, 15.0, 16.0, 16.0, 17.0, 18.0, 19.0, 21.0, 22.0, 23.0, 24.0, 26.0, 27.0, 28.0, 29.0, 30.0, 30.0, 31.0, 3.0, 4.0, 4.0, 5.0, 5.0, 6.0, 7.0, 8.0, 9.0, 11.0, 12.0, 14.0, 16.0, 18.0, 20.0, 22.0, 24.0, 27.0, 30.0, 32.0, 35.0, 39.0, 43.0, 47.0, 53.0, 61.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 41.0, 41.0, 41.0, 42.0, 42.0, 42.0, 42.0, 42.0, 100.0, 100.0, 100.0, 100.0, 97.0, 93.0, 91.0, 88.0, 86.0, 85.0, 85.0, 84.0, 84.0, 84.0, 84.0, 84.0, 84.0, 84.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 31.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 59.0, 61.0, 63.0, 65.0, 67.0, 69.0, 72.0, 75.0, 78.0, 81.0, 84.0, 88.0, 91.0, 95.0, 99.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 8.0, 9.0, 10.0, 11.0, 12.0, 12.0, 13.0, 13.0, 14.0, 15.0, 15.0, 16.0, 16.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 24.0, 25.0, 27.0, 28.0, 29.0, 30.0, 32.0, 33.0, 34.0, 36.0, 37.0, 39.0, 40.0, 42.0, 43.0, 44.0, 46.0, 47.0, 48.0, 49.0, 51.0, 52.0, 54.0, 56.0, 58.0, 59.0, 61.0, 63.0, 64.0, 65.0, 66.0, 67.0, 68.0, 69.0, 71.0, 72.0, 73.0, 74.0, 75.0, 76.0, 44.0, 45.0, 46.0, 47.0, 48.0, 50.0, 51.0, 52.0, 53.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 51.0, 52.0, 55.0, 45.0, 45.0, 45.0, 46.0, 46.0, 46.0, 46.0, 46.0, 84.0, 84.0, 46.0, 46.0, 79.0, 47.0, 81.0, 48.0, 48.0, 84.0, 49.0, 87.0, 51.0, 90.0, 52.0, 54.0, 94.0, 56.0, 98.0, 57.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 37.0, 38.0, 38.0, 39.0, 41.0, 41.0, 42.0, 43.0, 45.0, 47.0, 48.0, 50.0, 51.0, 52.0, 54.0, 55.0, 90.0, 90.0, 90.0, 90.0, 91.0, 91.0, 92.0, 93.0, 94.0, 94.0, 94.0, 95.0, 96.0, 97.0, 98.0, 99.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 34.0, 35.0, 35.0, 36.0, 37.0, 38.0, 40.0, 41.0, 43.0, 45.0, 46.0, 48.0, 49.0, 50.0, 52.0, 54.0, 55.0, 57.0, 57.0, 100.0, 100.0, 100.0, 100.0, 96.0, 100.0, 100.0, 100.0, 100.0, 95.0, 91.0, 87.0, 84.0, 81.0, 79.0, 78.0, 76.0, 75.0, 34.0, 34.0, 34.0, 34.0, 71.0, 70.0, 70.0, 69.0, 70.0, 70.0, 39.0, 41.0, 42.0, 44.0, 46.0, 48.0, 50.0, 51.0, 53.0, 55.0, 56.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 67.0, 68.0, 69.0, 69.0, 70.0, 71.0, 72.0, 73.0, 74.0, 75.0, 77.0, 79.0, 80.0, 82.0, 84.0, 87.0, 89.0, 92.0, 94.0, 97.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 40.0, 40.0, 40.0, 40.0, 41.0, 42.0, 100.0, 100.0, 100.0, 99.0, 97.0, 95.0, 93.0, 91.0, 89.0, 88.0, 86.0, 85.0, 84.0, 82.0, 81.0, 80.0, 80.0, 79.0, 78.0, 77.0, 77.0, 38.0, 33.0, 29.0, 25.0, 21.0, 19.0, 18.0, 17.0, 17.0, 17.0, 12.0, 13.0, 14.0, 15.0, 16.0, 18.0, 20.0, 22.0, 24.0, 26.0, 28.0, 31.0, 33.0, 36.0, 40.0, 43.0, 47.0, 52.0, 58.0, 67.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 6.0, 5.0, 5.0, 5.0, 4.0, 4.0, 4.0, 4.0, 4.0, 3.0, 3.0, 3.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 5.0, 5.0, 5.0, 6.0, 6.0, 7.0, 8.0, 8.0, 10.0, 11.0, 12.0, 14.0, 15.0, 17.0, 20.0, 23.0, 27.0, 74.0, 75.0, 76.0, 77.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 9.0, 10.0, 11.0, 12.0, 13.0, 15.0, 17.0, 18.0, 20.0, 22.0, 24.0, 25.0, 27.0, 29.0, 30.0, 32.0, 34.0, 36.0, 37.0, 39.0, 41.0, 42.0, 42.0, 43.0, 43.0, 43.0, 79.0, 79.0, 80.0, 82.0, 83.0, 85.0, 87.0, 89.0, 91.0, 93.0, 95.0, 97.0, 99.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 33.0, 33.0, 34.0, 35.0, 36.0, 38.0, 39.0, 41.0, 42.0, 43.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 50.0, 51.0, 52.0, 54.0, 56.0, 57.0, 58.0, 58.0, 60.0, 61.0, 62.0, 64.0, 67.0, 69.0, 72.0, 76.0, 79.0, 83.0, 88.0, 95.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 49.0, 50.0, 51.0, 52.0, 53.0, 55.0, 56.0, 58.0, 58.0, 60.0, 61.0, 62.0, 63.0, 64.0, 66.0, 67.0, 69.0, 19.0, 19.0, 19.0, 20.0, 21.0, 21.0, 22.0, 23.0, 24.0, 26.0, 27.0, 28.0, 29.0, 30.0, 32.0, 33.0, 34.0, 36.0, 37.0, 38.0, 40.0, 41.0, 43.0, 43.0, 44.0, 44.0, 44.0, 44.0, 47.0, 44.0, 44.0, 45.0, 45.0, 46.0, 47.0, 48.0, 48.0, 49.0, 50.0, 51.0, 52.0, 52.0, 53.0, 54.0, 55.0, 55.0, 56.0, 57.0, 57.0, 58.0, 58.0, 59.0, 60.0, 60.0, 61.0, 61.0, 62.0, 63.0, 64.0, 64.0, 65.0, 66.0, 66.0, 67.0, 67.0, 67.0, 13.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 20.0, 21.0, 23.0, 24.0, 26.0, 27.0, 29.0, 31.0, 33.0, 36.0, 38.0, 41.0, 43.0, 47.0, 50.0, 54.0, 58.0, 64.0, 71.0, 85.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 36.0, 37.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0, 45.0, 46.0, 47.0, 48.0, 48.0, 49.0, 50.0, 51.0, 52.0, 54.0, 55.0, 56.0, 57.0, 58.0, 58.0, 58.0, 58.0, 58.0, 58.0, 58.0, 59.0, 60.0, 61.0, 62.0, 64.0, 65.0, 67.0, 69.0, 71.0, 72.0, 74.0, 76.0, 78.0, 80.0, 82.0, 84.0, 86.0, 87.0, 90.0, 91.0, 93.0, 95.0, 97.0, 99.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 14.0, 15.0, 15.0, 16.0, 17.0, 18.0, 20.0, 21.0, 22.0, 68.0, 70.0, 72.0, 75.0, 77.0, 80.0, 83.0, 86.0, 90.0, 92.0, 95.0, 97.0, 99.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 71.0, 73.0, 75.0, 76.0, 78.0, 80.0, 82.0, 83.0, 85.0, 86.0, 86.0, 87.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 89.0, 90.0, 91.0, 92.0, 93.0, 94.0, 95.0, 96.0, 98.0, 99.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 26.0, 27.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 35.0, 36.0, 38.0, 40.0, 41.0, 43.0, 45.0, 46.0, 46.0, 47.0, 73.0, 73.0, 74.0, 74.0, 75.0, 75.0, 76.0, 77.0, 77.0, 78.0, 78.0, 79.0, 79.0, 79.0, 79.0, 39.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0, 46.0, 47.0, 48.0, 50.0, 51.0, 51.0, 52.0, 52.0, 52.0, 58.0, 58.0, 58.0, 58.0, 58.0, 58.0, 58.0, 58.0, 58.0, 58.0, 59.0, 58.0, 58.0, 58.0, 58.0, 57.0, 57.0, 57.0, 56.0, 56.0, 56.0, 56.0, 55.0, 55.0, 55.0, 55.0, 55.0, 39.0, 54.0, 39.0, 55.0, 55.0, 55.0, 56.0, 56.0, 56.0, 56.0, 56.0, 56.0, 36.0, 37.0, 37.0, 38.0, 39.0, 40.0, 42.0, 43.0, 44.0, 46.0, 48.0, 49.0, 51.0, 53.0, 56.0, 58.0, 61.0, 64.0, 67.0, 70.0, 74.0, 76.0, 79.0, 83.0, 86.0, 92.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 23.0, 100.0, 89.0, 89.0, 89.0, 88.0, 87.0, 86.0, 85.0, 83.0, 83.0, 82.0, 81.0, 80.0, 79.0, 78.0, 77.0, 75.0, 100.0, 73.0, 71.0, 100.0, 100.0, 67.0, 100.0, 65.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 9.0, 5.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 31.0, 32.0, 33.0, 34.0, 36.0, 38.0, 40.0, 42.0, 44.0, 47.0, 49.0, 52.0, 54.0, 57.0, 60.0, 63.0, 66.0, 70.0, 74.0, 78.0, 84.0, 90.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 5.0, 3.0, 3.0, 2.0, 2.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 12.0, 13.0, 15.0, 17.0, 19.0, 22.0, 25.0, 28.0, 31.0, 16.0, 17.0, 17.0, 18.0, 19.0, 19.0, 20.0, 21.0, 21.0, 21.0, 22.0, 23.0, 24.0, 24.0, 25.0, 26.0, 26.0, 27.0, 28.0, 30.0, 31.0, 32.0, 34.0, 35.0, 36.0, 38.0, 39.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 46.0, 47.0, 47.0, 47.0, 48.0, 48.0, 48.0, 48.0, 49.0, 49.0, 50.0, 50.0, 51.0, 51.0, 52.0, 52.0, 52.0, 54.0, 54.0, 55.0, 56.0, 57.0, 58.0, 58.0, 59.0, 59.0, 59.0, 59.0, 42.0, 43.0, 43.0, 44.0, 45.0, 47.0, 48.0, 49.0, 51.0, 52.0, 54.0, 55.0, 57.0, 58.0, 60.0, 61.0, 62.0, 63.0, 63.0, 64.0, 41.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 48.0, 49.0, 51.0, 52.0, 53.0, 54.0, 55.0, 55.0, 55.0, 74.0, 77.0, 80.0, 81.0, 81.0, 80.0, 79.0, 80.0, 82.0, 85.0, 88.0, 94.0, 100.0, 100.0, 100.0, 48.0, 49.0, 50.0, 51.0, 52.0, 54.0, 55.0, 56.0, 36.0, 36.0, 36.0, 36.0, 71.0, 69.0, 68.0, 67.0, 66.0, 65.0, 64.0, 63.0, 62.0, 62.0, 61.0, 61.0, 61.0, 60.0, 60.0, 60.0, 60.0, 60.0, 60.0, 60.0, 60.0, 61.0, 61.0, 61.0, 61.0, 61.0, 61.0, 14.0, 15.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 23.0, 24.0, 25.0, 26.0, 28.0, 29.0, 30.0, 32.0, 33.0, 34.0, 35.0, 37.0, 38.0, 39.0, 41.0, 42.0, 43.0, 45.0, 46.0, 47.0, 48.0, 50.0, 51.0, 52.0, 54.0, 55.0, 57.0, 58.0, 61.0, 63.0, 65.0, 68.0, 70.0, 71.0, 72.0, 72.0, 72.0, 21.0, 73.0, 73.0, 74.0, 76.0, 77.0, 78.0, 79.0, 80.0, 19.0, 83.0, 86.0, 89.0, 94.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 20.0, 21.0, 22.0, 23.0, 25.0, 27.0, 29.0, 32.0, 34.0, 36.0, 38.0, 40.0, 42.0, 43.0, 45.0, 47.0, 49.0, 50.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 91.0, 82.0, 77.0, 74.0, 73.0, 71.0, 71.0, 71.0, 71.0, 71.0, 71.0, 70.0, 100.0, 100.0, 100.0, 70.0, 70.0, 70.0, 69.0, 69.0, 68.0, 68.0, 68.0, 67.0, 67.0, 67.0, 67.0, 68.0, 68.0, 68.0, 69.0, 69.0, 70.0, 71.0, 72.0, 73.0, 75.0, 76.0, 77.0, 78.0, 80.0, 81.0, 82.0, 82.0, 82.0, 82.0, 82.0, 84.0, 85.0, 85.0, 86.0, 87.0, 88.0, 89.0, 90.0, 91.0, 92.0, 93.0, 93.0, 93.0, 93.0, 93.0, 73.0, 74.0, 76.0, 78.0, 80.0, 81.0, 57.0, 53.0, 51.0, 49.0, 48.0, 47.0, 47.0, 47.0, 47.0, 47.0, 47.0, 47.0, 47.0, 48.0, 48.0, 49.0, 49.0, 50.0, 50.0, 51.0, 51.0, 52.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 57.0, 58.0, 58.0, 59.0, 60.0, 61.0, 62.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 100.0, 100.0, 100.0, 63.0, 100.0, 100.0, 100.0, 58.0, 58.0, 57.0, 84.0, 54.0, 78.0, 52.0, 73.0, 50.0, 69.0, 49.0, 65.0, 47.0, 61.0, 46.0, 56.0, 44.0, 43.0, 51.0, 42.0, 49.0, 41.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 2.0, 3.0, 3.0, 4.0, 5.0, 6.0, 7.0, 7.0, 8.0, 9.0, 10.0, 11.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 26.0, 27.0, 28.0, 30.0, 31.0, 33.0, 34.0, 36.0, 36.0, 37.0, 36.0, 36.0, 35.0, 29.0, 32.0, 36.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 14.0, 15.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 62.0, 61.0, 61.0, 100.0, 59.0, 58.0, 58.0, 57.0, 56.0, 55.0, 55.0, 54.0, 53.0, 52.0, 51.0, 51.0, 50.0, 49.0, 100.0, 48.0, 100.0, 46.0, 94.0, 45.0, 44.0, 44.0, 44.0, 44.0, 45.0, 45.0, 46.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 72.0, 73.0, 74.0, 75.0, 77.0, 78.0, 80.0, 81.0, 83.0, 84.0, 86.0, 88.0, 90.0, 92.0, 94.0, 96.0, 98.0, 99.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 39.0, 39.0, 39.0, 39.0, 100.0, 98.0, 97.0, 95.0, 94.0, 93.0, 92.0, 90.0, 89.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 41.0, 42.0, 44.0, 45.0, 47.0, 49.0, 50.0, 52.0, 54.0, 55.0, 56.0, 58.0, 58.0, 60.0, 61.0, 62.0, 63.0, 63.0, 64.0, 65.0, 65.0, 66.0, 67.0, 68.0, 68.0, 69.0, 70.0, 71.0, 71.0, 72.0, 73.0, 73.0, 73.0, 73.0, 73.0, 72.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 37.0, 38.0, 39.0, 41.0, 42.0, 43.0, 45.0, 46.0, 48.0, 49.0, 51.0, 52.0, 54.0, 56.0, 58.0, 59.0, 61.0, 63.0, 65.0, 67.0, 69.0, 72.0, 75.0, 78.0, 82.0, 87.0, 92.0, 96.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 32.0, 100.0, 27.0, 40.0, 23.0, 30.0, 20.0, 18.0, 16.0, 15.0, 14.0, 14.0, 13.0, 13.0, 13.0, 14.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 23.0, 24.0, 25.0, 27.0, 29.0, 30.0, 32.0, 34.0, 36.0, 37.0, 39.0, 41.0, 43.0, 44.0, 46.0, 48.0, 50.0, 52.0, 54.0, 56.0, 58.0, 61.0, 63.0, 65.0, 67.0, 69.0, 70.0, 72.0, 73.0, 75.0, 76.0, 77.0, 78.0, 79.0, 80.0, 80.0, 81.0, 80.0, 80.0, 79.0, 78.0, 76.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 46.0, 47.0, 47.0, 48.0, 21.0, 18.0, 17.0, 17.0, 17.0, 17.0, 17.0, 17.0, 17.0, 17.0, 17.0, 16.0, 16.0, 16.0, 16.0, 16.0, 16.0, 95.0, 94.0, 93.0, 92.0, 92.0, 91.0, 91.0, 90.0, 90.0, 91.0, 91.0, 92.0, 92.0, 93.0, 93.0, 93.0, 94.0, 94.0, 95.0, 96.0, 97.0, 99.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 10.0, 10.0, 11.0, 12.0, 13.0, 15.0, 16.0, 18.0, 20.0, 21.0, 22.0, 22.0, 22.0, 22.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 23.0, 24.0, 24.0, 25.0, 25.0, 26.0, 27.0, 29.0, 30.0, 32.0, 33.0, 33.0, 13.0, 13.0, 13.0, 14.0, 15.0, 16.0, 17.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 30.0, 31.0, 33.0, 35.0, 36.0, 38.0, 39.0, 40.0, 40.0, 40.0, 82.0, 82.0, 83.0, 84.0, 85.0, 86.0, 87.0, 88.0, 90.0, 91.0, 92.0, 94.0, 95.0, 97.0, 98.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 12.0, 12.0, 13.0, 13.0, 14.0, 15.0, 17.0, 18.0, 19.0, 20.0, 21.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 30.0, 31.0, 32.0, 33.0, 34.0, 36.0, 37.0, 38.0, 39.0, 41.0, 42.0, 43.0, 45.0, 46.0, 47.0, 48.0, 48.0, 48.0, 48.0, 48.0, 48.0, 48.0, 48.0, 48.0, 48.0, 48.0, 48.0, 48.0, 48.0, 48.0, 49.0, 49.0, 50.0, 51.0, 100.0, 46.0, 46.0, 47.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 54.0, 55.0, 57.0, 58.0, 60.0, 61.0, 63.0, 64.0, 66.0, 67.0, 69.0, 71.0, 73.0, 75.0, 77.0, 79.0, 82.0, 85.0, 88.0, 89.0, 89.0, 89.0, 87.0, 87.0, 87.0, 88.0, 90.0, 92.0, 95.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 16.0, 17.0, 17.0, 18.0, 19.0, 20.0, 22.0, 23.0, 24.0, 26.0, 27.0, 29.0, 30.0, 32.0, 33.0, 35.0, 36.0, 38.0, 39.0, 41.0, 42.0, 44.0, 46.0, 47.0, 49.0, 51.0, 52.0, 55.0, 57.0, 60.0, 63.0, 66.0, 35.0, 35.0, 35.0, 36.0, 36.0, 37.0, 23.0, 12.0, 8.0, 5.0, 4.0, 2.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 2.0, 4.0, 5.0, 6.0, 8.0, 9.0, 11.0, 13.0, 15.0, 17.0, 20.0, 24.0, 79.0, 81.0, 82.0, 84.0, 86.0, 88.0, 90.0, 91.0, 93.0, 95.0, 97.0, 99.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 26.0, 27.0, 28.0, 29.0, 30.0, 32.0, 34.0, 36.0, 38.0, 39.0, 41.0, 43.0, 44.0, 46.0, 47.0, 49.0, 50.0, 52.0, 53.0, 55.0, 56.0, 57.0, 57.0, 57.0, 57.0, 56.0, 93.0, 95.0, 97.0, 99.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 87.0, 86.0, 86.0, 86.0, 85.0, 85.0, 84.0, 84.0, 83.0, 83.0, 83.0, 83.0, 82.0, 82.0, 82.0, 82.0, 82.0, 81.0, 81.0, 81.0, 81.0, 81.0, 81.0, 81.0, 82.0, 82.0, 82.0, 82.0, 81.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 39.0, 40.0, 42.0, 43.0, 45.0, 46.0, 48.0, 50.0, 51.0, 52.0, 55.0, 56.0, 58.0, 60.0, 62.0, 64.0, 66.0, 69.0, 71.0, 74.0, 77.0, 79.0, 82.0, 85.0, 88.0, 90.0, 92.0, 94.0, 95.0, 97.0, 99.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 10.0, 11.0, 12.0, 13.0, 14.0, 16.0, 18.0, 20.0, 22.0, 24.0, 26.0, 28.0, 30.0, 33.0, 35.0, 37.0, 39.0, 41.0, 43.0, 45.0, 46.0, 46.0, 46.0, 46.0, 100.0, 46.0, 100.0, 100.0, 45.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 99.0, 98.0, 98.0, 96.0, 95.0, 94.0, 92.0, 91.0, 90.0, 89.0, 88.0, 87.0, 86.0, 86.0, 85.0, 84.0, 84.0, 84.0, 84.0, 84.0, 84.0, 85.0, 85.0, 85.0, 85.0, 85.0, 73.0, 74.0, 75.0, 77.0, 79.0, 81.0, 83.0, 85.0, 88.0, 90.0, 93.0, 95.0, 78.0, 74.0, 73.0, 72.0, 71.0, 71.0, 71.0, 71.0, 71.0, 72.0, 72.0, 73.0, 73.0, 74.0, 75.0, 77.0, 78.0, 80.0, 82.0, 84.0, 86.0, 89.0, 91.0, 94.0, 96.0, 98.0, 99.0, 100.0, 100.0, 99.0, 98.0, 96.0, 34.0, 34.0, 35.0, 35.0, 36.0, 37.0, 38.0, 40.0, 42.0, 44.0, 46.0, 49.0, 51.0, 52.0, 54.0, 54.0, 54.0, 54.0, 54.0, 69.0, 70.0, 71.0, 71.0, 71.0, 53.0, 54.0, 55.0, 57.0, 58.0, 62.0, 65.0, 69.0, 74.0, 79.0, 88.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 98.0, 61.0, 61.0, 60.0, 59.0, 58.0, 57.0, 56.0, 56.0, 56.0, 56.0, 56.0, 56.0, 57.0, 58.0, 58.0, 60.0, 61.0, 63.0, 65.0, 67.0, 68.0, 70.0, 71.0, 73.0, 74.0, 74.0, 75.0, 76.0, 76.0, 76.0, 76.0, 77.0, 77.0, 77.0, 77.0, 78.0, 78.0, 78.0, 79.0, 79.0, 79.0, 80.0, 80.0, 81.0, 81.0, 82.0, 83.0, 84.0, 84.0, 84.0, 84.0, 84.0, 84.0, 83.0, 8.0, 8.0, 9.0, 10.0, 11.0, 11.0, 12.0, 13.0, 15.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 22.0, 23.0, 24.0, 26.0, 27.0, 29.0, 31.0, 33.0, 34.0, 36.0, 39.0, 41.0, 43.0, 46.0, 48.0, 50.0, 52.0, 53.0, 54.0, 56.0, 56.0, 56.0, 57.0, 58.0, 60.0, 60.0, 60.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 67.0, 68.0, 69.0, 70.0, 70.0, 70.0, 70.0, 38.0, 38.0, 38.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 99.0, 97.0, 95.0, 93.0, 93.0, 92.0, 93.0, 94.0, 95.0, 96.0, 98.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 5.0, 5.0, 6.0, 6.0, 7.0, 8.0, 8.0, 8.0, 8.0, 32.0, 32.0, 32.0, 32.0, 33.0, 34.0, 35.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 42.0, 43.0, 44.0, 44.0, 45.0, 46.0, 46.0, 47.0, 48.0, 48.0, 49.0, 50.0, 50.0, 51.0, 51.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 26.0, 26.0, 27.0, 28.0, 29.0, 30.0, 32.0, 33.0, 34.0, 36.0, 37.0, 38.0, 40.0, 41.0, 42.0, 44.0, 45.0, 47.0, 48.0, 50.0, 51.0, 53.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 63.0, 64.0, 64.0, 65.0, 65.0, 66.0, 66.0, 67.0, 9.0, 7.0, 6.0, 5.0, 4.0, 4.0, 4.0, 3.0, 3.0, 3.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 2.0, 3.0, 3.0, 4.0, 5.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 19.0, 20.0, 21.0, 21.0, 21.0, 22.0, 22.0, 22.0, 22.0, 22.0, 23.0, 23.0, 24.0, 25.0, 26.0, 26.0, 27.0, 28.0, 29.0, 29.0, 30.0, 30.0, 30.0, 30.0, 30.0, 30.0, 31.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 76.0, 100.0, 67.0, 100.0, 60.0, 100.0, 56.0, 100.0, 52.0, 100.0, 49.0, 100.0, 46.0, 100.0, 44.0, 100.0, 44.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 51.0, 52.0, 54.0, 55.0, 57.0, 58.0, 60.0, 62.0, 63.0, 65.0, 67.0, 69.0, 71.0, 73.0, 75.0, 77.0, 79.0, 82.0, 84.0, 87.0, 90.0, 93.0, 97.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 99.0, 7.0, 8.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 15.0, 16.0, 17.0, 19.0, 20.0, 22.0, 23.0, 23.0, 25.0, 24.0, 26.0, 28.0, 30.0, 31.0, 33.0, 35.0, 36.0, 38.0, 41.0, 43.0, 45.0, 48.0, 50.0, 53.0, 56.0, 60.0, 63.0, 67.0, 41.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 41.0, 43.0, 45.0, 47.0, 48.0, 50.0, 51.0, 52.0, 54.0, 55.0, 57.0, 58.0, 60.0, 61.0, 63.0, 64.0, 66.0, 68.0, 70.0, 72.0, 73.0, 75.0, 78.0, 80.0, 82.0, 85.0, 87.0, 90.0, 93.0, 96.0, 99.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 99.0, 96.0, 93.0, 90.0, 46.0, 47.0, 48.0, 49.0, 51.0, 52.0, 55.0, 57.0, 60.0, 62.0, 65.0, 67.0, 70.0, 73.0, 75.0, 77.0, 79.0, 80.0, 82.0, 83.0, 53.0, 53.0, 52.0, 52.0, 52.0, 53.0, 54.0, 55.0, 56.0, 56.0, 56.0, 56.0, 56.0, 56.0, 56.0, 56.0, 96.0, 96.0, 97.0, 98.0, 99.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 50.0, 50.0, 51.0, 51.0, 51.0, 52.0, 52.0, 54.0, 54.0, 54.0, 54.0, 54.0, 54.0, 54.0, 82.0, 82.0, 82.0, 83.0, 83.0, 84.0, 84.0, 84.0, 84.0, 84.0, 84.0, 84.0, 85.0, 85.0, 85.0, 85.0, 85.0, 85.0, 85.0, 85.0, 85.0, 85.0, 85.0, 85.0, 85.0, 85.0, 86.0, 71.0, 72.0, 73.0, 74.0, 75.0, 77.0, 79.0, 82.0, 84.0, 87.0, 89.0, 92.0, 95.0, 98.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 48.0, 48.0, 48.0, 48.0, 49.0, 50.0, 51.0, 52.0, 54.0, 55.0, 56.0, 58.0, 60.0, 61.0, 63.0, 64.0, 66.0, 67.0, 69.0, 71.0, 72.0, 73.0, 73.0, 72.0, 72.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 96.0, 92.0, 89.0, 87.0, 86.0, 84.0, 83.0, 82.0, 51.0, 52.0, 52.0, 54.0, 56.0, 58.0, 61.0, 63.0, 66.0, 70.0, 74.0, 77.0, 67.0, 67.0, 67.0, 66.0, 66.0, 66.0, 66.0, 67.0, 67.0, 68.0, 69.0, 69.0, 69.0, 69.0, 69.0, 68.0, 67.0, 65.0, 63.0, 61.0, 60.0, 58.0, 58.0, 57.0, 57.0, 57.0, 57.0, 57.0, 58.0, 59.0, 61.0, 63.0, 66.0, 70.0, 76.0, 82.0, 90.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 18.0, 19.0, 20.0, 21.0, 22.0, 24.0, 26.0, 28.0, 31.0, 33.0, 35.0, 38.0, 40.0, 43.0, 45.0, 48.0, 49.0, 51.0, 52.0, 52.0, 52.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 34.0, 35.0, 37.0, 38.0, 40.0, 42.0, 45.0, 47.0, 49.0, 51.0, 51.0, 51.0, 50.0, 49.0, 5.0, 5.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 14.0, 15.0, 16.0, 18.0, 19.0, 21.0, 22.0, 23.0, 23.0, 24.0, 24.0, 24.0, 78.0, 78.0, 77.0, 24.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 31.0, 32.0, 34.0, 35.0, 36.0, 38.0, 39.0, 41.0, 42.0, 43.0, 45.0, 46.0, 47.0, 48.0, 50.0, 51.0, 52.0, 53.0, 55.0, 56.0, 58.0, 59.0, 61.0, 45.0, 39.0, 38.0, 36.0, 36.0, 36.0, 37.0, 38.0, 39.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 47.0, 47.0, 46.0, 45.0, 44.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 33.0, 33.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 38.0, 39.0, 40.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 48.0, 49.0, 49.0, 100.0, 100.0, 100.0, 100.0, 100.0, 99.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 36.0, 38.0, 39.0, 41.0, 42.0, 44.0, 46.0, 48.0, 49.0, 51.0, 52.0, 54.0, 56.0, 58.0, 60.0, 62.0, 63.0, 65.0, 67.0, 69.0, 72.0, 74.0, 76.0, 79.0, 82.0, 84.0, 87.0, 91.0, 94.0, 98.0, 100.0, 100.0, 100.0, 100.0, 100.0, 41.0, 42.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 48.0, 49.0, 50.0, 51.0, 51.0, 52.0, 54.0, 55.0, 55.0, 55.0, 55.0, 56.0, 56.0, 56.0, 81.0, 80.0, 79.0, 78.0, 56.0, 56.0, 74.0, 73.0, 73.0, 73.0, 73.0, 73.0, 73.0, 74.0, 74.0, 75.0, 75.0, 75.0, 75.0, 75.0, 75.0, 76.0, 76.0, 77.0};
    }

    public static class Ticks {
        public static final double[] ticks = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 71.0, 72.0, 73.0, 74.0, 75.0, 76.0, 77.0, 78.0, 79.0, 80.0, 81.0, 82.0, 83.0, 84.0, 85.0, 86.0, 87.0, 88.0, 89.0, 90.0, 91.0, 92.0, 93.0, 94.0, 95.0, 96.0, 97.0, 98.0, 99.0, 100.0, 101.0, 102.0, 103.0, 104.0, 105.0, 106.0, 107.0, 108.0, 109.0, 110.0, 111.0, 112.0, 113.0, 114.0, 115.0, 116.0, 117.0, 118.0, 119.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 71.0, 72.0, 73.0, 74.0, 75.0, 76.0, 77.0, 78.0, 79.0, 80.0, 81.0, 82.0, 83.0, 84.0, 85.0, 86.0, 87.0, 88.0, 89.0, 90.0, 91.0, 92.0, 93.0, 94.0, 95.0, 96.0, 97.0, 98.0, 99.0, 100.0, 101.0, 102.0, 103.0, 104.0, 105.0, 106.0, 107.0, 108.0, 109.0, 110.0, 111.0, 112.0, 113.0, 114.0, 115.0, 116.0, 117.0, 118.0, 119.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 71.0, 72.0, 73.0, 74.0, 75.0, 76.0, 77.0, 78.0, 79.0, 80.0, 81.0, 82.0, 83.0, 84.0, 85.0, 86.0, 87.0, 88.0, 89.0, 90.0, 91.0, 92.0, 93.0, 94.0, 95.0, 96.0, 97.0, 98.0, 99.0, 100.0, 101.0, 102.0, 103.0, 104.0, 105.0, 106.0, 107.0, 108.0, 109.0, 110.0, 111.0, 112.0, 113.0, 114.0, 115.0, 116.0, 117.0, 118.0, 119.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 71.0, 72.0, 73.0, 74.0, 75.0, 76.0, 77.0, 78.0, 79.0, 80.0, 81.0, 82.0, 83.0, 84.0, 85.0, 86.0, 87.0, 88.0, 89.0, 90.0, 91.0, 92.0, 93.0, 94.0, 95.0, 96.0, 97.0, 98.0, 99.0, 100.0, 101.0, 102.0, 103.0, 104.0, 105.0, 106.0, 107.0, 108.0, 109.0, 110.0, 111.0, 112.0, 113.0, 114.0, 115.0, 116.0, 117.0, 118.0, 119.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 71.0, 72.0, 73.0, 74.0, 75.0, 76.0, 77.0, 78.0, 79.0, 80.0, 81.0, 82.0, 83.0, 84.0, 85.0, 86.0, 87.0, 88.0, 89.0, 90.0, 91.0, 92.0, 93.0, 94.0, 95.0, 96.0, 97.0, 98.0, 99.0, 100.0, 101.0, 102.0, 103.0, 104.0, 105.0, 106.0, 107.0, 108.0, 109.0, 110.0, 111.0, 112.0, 113.0, 114.0, 115.0, 116.0, 117.0, 118.0, 119.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 71.0, 72.0, 73.0, 74.0, 75.0, 76.0, 77.0, 78.0, 79.0, 80.0, 81.0, 82.0, 83.0, 84.0, 85.0, 86.0, 87.0, 88.0, 89.0, 90.0, 91.0, 92.0, 93.0, 94.0, 95.0, 96.0, 97.0, 98.0, 99.0, 100.0, 101.0, 102.0, 103.0, 104.0, 105.0, 106.0, 107.0, 108.0, 109.0, 110.0, 111.0, 112.0, 113.0, 114.0, 115.0, 116.0, 117.0, 118.0, 119.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 42.0, 33.0, 43.0, 34.0, 35.0, 44.0, 36.0, 45.0, 37.0, 46.0, 38.0, 39.0, 47.0, 40.0, 48.0, 41.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 71.0, 72.0, 73.0, 74.0, 75.0, 76.0, 77.0, 78.0, 79.0, 80.0, 81.0, 82.0, 83.0, 84.0, 85.0, 86.0, 87.0, 88.0, 89.0, 90.0, 91.0, 92.0, 93.0, 94.0, 95.0, 96.0, 97.0, 98.0, 99.0, 100.0, 101.0, 102.0, 103.0, 104.0, 105.0, 106.0, 107.0, 108.0, 109.0, 110.0, 111.0, 112.0, 113.0, 114.0, 115.0, 116.0, 117.0, 118.0, 119.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 71.0, 72.0, 73.0, 74.0, 75.0, 76.0, 77.0, 78.0, 79.0, 80.0, 81.0, 82.0, 83.0, 84.0, 85.0, 86.0, 87.0, 88.0, 89.0, 90.0, 91.0, 92.0, 93.0, 94.0, 95.0, 96.0, 97.0, 98.0, 99.0, 100.0, 101.0, 102.0, 103.0, 104.0, 105.0, 106.0, 107.0, 108.0, 109.0, 110.0, 111.0, 112.0, 113.0, 114.0, 115.0, 116.0, 117.0, 118.0, 119.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 71.0, 72.0, 73.0, 74.0, 75.0, 76.0, 77.0, 78.0, 79.0, 80.0, 81.0, 82.0, 83.0, 84.0, 85.0, 86.0, 87.0, 88.0, 89.0, 90.0, 91.0, 92.0, 93.0, 94.0, 95.0, 96.0, 97.0, 98.0, 99.0, 100.0, 101.0, 102.0, 103.0, 104.0, 105.0, 106.0, 107.0, 108.0, 109.0, 110.0, 111.0, 112.0, 113.0, 114.0, 115.0, 116.0, 117.0, 118.0, 119.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 71.0, 72.0, 73.0, 74.0, 75.0, 76.0, 77.0, 78.0, 79.0, 80.0, 81.0, 82.0, 83.0, 84.0, 85.0, 86.0, 87.0, 88.0, 89.0, 90.0, 91.0, 92.0, 93.0, 94.0, 95.0, 96.0, 97.0, 98.0, 99.0, 100.0, 101.0, 102.0, 103.0, 104.0, 105.0, 106.0, 107.0, 108.0, 109.0, 110.0, 111.0, 112.0, 113.0, 114.0, 115.0, 116.0, 117.0, 118.0, 119.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 71.0, 72.0, 73.0, 74.0, 75.0, 76.0, 77.0, 78.0, 79.0, 80.0, 81.0, 82.0, 83.0, 84.0, 85.0, 86.0, 87.0, 88.0, 89.0, 90.0, 91.0, 92.0, 93.0, 94.0, 95.0, 96.0, 97.0, 98.0, 99.0, 100.0, 101.0, 102.0, 103.0, 104.0, 105.0, 106.0, 107.0, 108.0, 109.0, 110.0, 111.0, 112.0, 113.0, 114.0, 115.0, 116.0, 117.0, 118.0, 119.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 71.0, 72.0, 73.0, 74.0, 75.0, 76.0, 77.0, 78.0, 79.0, 80.0, 81.0, 82.0, 83.0, 84.0, 85.0, 86.0, 87.0, 88.0, 89.0, 90.0, 91.0, 92.0, 93.0, 94.0, 95.0, 96.0, 97.0, 98.0, 99.0, 100.0, 101.0, 102.0, 103.0, 104.0, 105.0, 106.0, 107.0, 108.0, 109.0, 110.0, 111.0, 112.0, 113.0, 114.0, 115.0, 116.0, 117.0, 118.0, 119.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 71.0, 72.0, 73.0, 74.0, 75.0, 76.0, 77.0, 78.0, 79.0, 80.0, 81.0, 82.0, 83.0, 84.0, 85.0, 86.0, 87.0, 88.0, 89.0, 90.0, 91.0, 92.0, 93.0, 94.0, 95.0, 96.0, 97.0, 98.0, 99.0, 100.0, 101.0, 102.0, 103.0, 104.0, 105.0, 106.0, 107.0, 108.0, 109.0, 110.0, 111.0, 112.0, 113.0, 114.0, 115.0, 116.0, 117.0, 118.0, 119.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 71.0, 72.0, 73.0, 74.0, 75.0, 76.0, 77.0, 78.0, 79.0, 80.0, 81.0, 82.0, 83.0, 84.0, 85.0, 86.0, 87.0, 88.0, 89.0, 90.0, 91.0, 92.0, 93.0, 94.0, 95.0, 97.0, 98.0, 99.0, 100.0, 101.0, 102.0, 103.0, 104.0, 105.0, 106.0, 107.0, 108.0, 109.0, 110.0, 111.0, 112.0, 113.0, 114.0, 115.0, 116.0, 117.0, 118.0, 119.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 71.0, 72.0, 73.0, 74.0, 75.0, 76.0, 77.0, 78.0, 79.0, 80.0, 81.0, 82.0, 83.0, 84.0, 85.0, 86.0, 87.0, 88.0, 89.0, 90.0, 91.0, 92.0, 93.0, 94.0, 95.0, 96.0, 97.0, 98.0, 99.0, 100.0, 101.0, 102.0, 103.0, 104.0, 105.0, 106.0, 107.0, 108.0, 109.0, 110.0, 111.0, 112.0, 113.0, 114.0, 115.0, 116.0, 117.0, 118.0, 119.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 71.0, 72.0, 73.0, 74.0, 75.0, 76.0, 77.0, 78.0, 79.0, 80.0, 81.0, 82.0, 83.0, 84.0, 85.0, 86.0, 87.0, 88.0, 89.0, 90.0, 91.0, 92.0, 93.0, 94.0, 95.0, 96.0, 97.0, 98.0, 99.0, 100.0, 101.0, 102.0, 103.0, 104.0, 105.0, 106.0, 107.0, 108.0, 109.0, 110.0, 111.0, 112.0, 113.0, 114.0, 115.0, 116.0, 117.0, 118.0, 119.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 71.0, 72.0, 73.0, 74.0, 75.0, 76.0, 77.0, 78.0, 79.0, 80.0, 81.0, 82.0, 83.0, 84.0, 85.0, 86.0, 87.0, 88.0, 89.0, 90.0, 91.0, 92.0, 93.0, 94.0, 95.0, 96.0, 97.0, 98.0, 99.0, 100.0, 101.0, 102.0, 103.0, 104.0, 105.0, 106.0, 107.0, 108.0, 109.0, 110.0, 111.0, 112.0, 113.0, 114.0, 115.0, 116.0, 117.0, 118.0, 119.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 71.0, 72.0, 73.0, 74.0, 75.0, 76.0, 77.0, 78.0, 79.0, 80.0, 81.0, 82.0, 83.0, 84.0, 85.0, 86.0, 87.0, 88.0, 89.0, 90.0, 91.0, 92.0, 93.0, 94.0, 95.0, 96.0, 97.0, 98.0, 99.0, 100.0, 101.0, 102.0, 103.0, 104.0, 105.0, 106.0, 107.0, 108.0, 109.0, 110.0, 111.0, 112.0, 113.0, 114.0, 115.0, 116.0, 117.0, 118.0, 119.0, 0.0, 1.0, 2.0, 3.0, 4.0, 7.0, 5.0, 8.0, 6.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 71.0, 72.0, 73.0, 74.0, 75.0, 76.0, 77.0, 78.0, 79.0, 80.0, 81.0, 82.0, 83.0, 84.0, 85.0, 86.0, 87.0, 88.0, 89.0, 90.0, 91.0, 92.0, 93.0, 94.0, 95.0, 96.0, 97.0, 98.0, 99.0, 100.0, 101.0, 102.0, 103.0, 104.0, 105.0, 106.0, 107.0, 108.0, 109.0, 110.0, 111.0, 112.0, 113.0, 114.0, 115.0, 116.0, 117.0, 118.0, 119.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 71.0, 72.0, 73.0, 74.0, 75.0, 76.0, 77.0, 78.0, 79.0, 80.0, 81.0, 82.0, 83.0, 84.0, 85.0, 86.0, 87.0, 88.0, 89.0, 90.0, 91.0, 92.0, 93.0, 94.0, 95.0, 96.0, 97.0, 98.0, 99.0, 100.0, 101.0, 102.0, 103.0, 104.0, 105.0, 106.0, 107.0, 108.0, 109.0, 110.0, 111.0, 112.0, 113.0, 114.0, 115.0, 116.0, 117.0, 118.0, 119.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 71.0, 72.0, 73.0, 74.0, 75.0, 76.0, 77.0, 78.0, 79.0, 80.0, 81.0, 82.0, 83.0, 84.0, 85.0, 86.0, 87.0, 88.0, 89.0, 90.0, 91.0, 92.0, 93.0, 94.0, 95.0, 96.0, 97.0, 98.0, 99.0, 100.0, 101.0, 102.0, 103.0, 104.0, 105.0, 106.0, 107.0, 108.0, 109.0, 110.0, 111.0, 112.0, 113.0, 114.0, 115.0, 116.0, 117.0, 118.0, 119.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 71.0, 72.0, 73.0, 74.0, 75.0, 76.0, 77.0, 78.0, 79.0, 80.0, 81.0, 82.0, 83.0, 84.0, 85.0, 86.0, 87.0, 88.0, 89.0, 90.0, 91.0, 92.0, 93.0, 94.0, 95.0, 96.0, 97.0, 98.0, 99.0, 100.0, 101.0, 102.0, 103.0, 104.0, 105.0, 106.0, 107.0, 108.0, 109.0, 110.0, 111.0, 112.0, 113.0, 114.0, 115.0, 116.0, 117.0, 118.0, 119.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 11.0, 8.0, 12.0, 9.0, 13.0, 10.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 71.0, 72.0, 73.0, 74.0, 75.0, 76.0, 77.0, 78.0, 79.0, 80.0, 81.0, 82.0, 83.0, 84.0, 85.0, 86.0, 87.0, 88.0, 89.0, 90.0, 91.0, 92.0, 93.0, 94.0, 95.0, 96.0, 97.0, 98.0, 99.0, 100.0, 101.0, 102.0, 103.0, 104.0, 105.0, 106.0, 107.0, 108.0, 109.0, 110.0, 111.0, 112.0, 113.0, 114.0, 115.0, 116.0, 117.0, 118.0, 119.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 71.0, 72.0, 73.0, 74.0, 75.0, 76.0, 77.0, 78.0, 79.0, 80.0, 81.0, 82.0, 83.0, 84.0, 85.0, 86.0, 87.0, 88.0, 89.0, 90.0, 91.0, 92.0, 93.0, 94.0, 95.0, 96.0, 97.0, 98.0, 99.0, 100.0, 101.0, 102.0, 103.0, 104.0, 105.0, 106.0, 107.0, 108.0, 109.0, 110.0, 111.0, 112.0, 113.0, 114.0, 115.0, 116.0, 117.0, 118.0, 119.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 71.0, 72.0, 73.0, 74.0, 75.0, 76.0, 77.0, 78.0, 79.0, 80.0, 81.0, 82.0, 83.0, 84.0, 85.0, 86.0, 87.0, 88.0, 89.0, 90.0, 91.0, 92.0, 93.0, 94.0, 95.0, 96.0, 97.0, 98.0, 99.0, 100.0, 101.0, 102.0, 103.0, 104.0, 105.0, 106.0, 107.0, 108.0, 109.0, 110.0, 111.0, 112.0, 113.0, 114.0, 115.0, 116.0, 117.0, 118.0, 119.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 71.0, 72.0, 73.0, 74.0, 75.0, 76.0, 77.0, 78.0, 79.0, 80.0, 81.0, 82.0, 83.0, 84.0, 85.0, 86.0, 87.0, 88.0, 89.0, 90.0, 91.0, 92.0, 93.0, 94.0, 95.0, 96.0, 97.0, 98.0, 99.0, 100.0, 101.0, 102.0, 103.0, 104.0, 105.0, 106.0, 107.0, 108.0, 109.0, 110.0, 111.0, 112.0, 113.0, 114.0, 115.0, 116.0, 117.0, 118.0, 119.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 71.0, 72.0, 73.0, 74.0, 75.0, 76.0, 77.0, 78.0, 79.0, 80.0, 81.0, 82.0, 83.0, 84.0, 85.0, 86.0, 87.0, 88.0, 89.0, 90.0, 91.0, 92.0, 93.0, 94.0, 95.0, 96.0, 97.0, 98.0, 99.0, 100.0, 101.0, 102.0, 103.0, 104.0, 105.0, 106.0, 107.0, 108.0, 109.0, 110.0, 111.0, 112.0, 113.0, 114.0, 115.0, 116.0, 117.0, 118.0, 119.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 71.0, 72.0, 73.0, 74.0, 75.0, 76.0, 77.0, 78.0, 79.0, 80.0, 81.0, 82.0, 83.0, 84.0, 85.0, 86.0, 87.0, 88.0, 89.0, 90.0, 91.0, 92.0, 93.0, 94.0, 95.0, 96.0, 97.0, 98.0, 99.0, 100.0, 101.0, 102.0, 103.0, 104.0, 105.0, 106.0, 107.0, 108.0, 109.0, 110.0, 111.0, 112.0, 113.0, 114.0, 115.0, 116.0, 117.0, 118.0, 119.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 71.0, 72.0, 73.0, 74.0, 75.0, 76.0, 77.0, 78.0, 79.0, 80.0, 81.0, 82.0, 83.0, 84.0, 85.0, 86.0, 87.0, 88.0, 89.0, 90.0, 91.0, 92.0, 93.0, 94.0, 95.0, 96.0, 97.0, 98.0, 99.0, 100.0, 101.0, 102.0, 103.0, 104.0, 105.0, 106.0, 107.0, 108.0, 109.0, 110.0, 111.0, 112.0, 113.0, 114.0, 115.0, 116.0, 117.0, 118.0, 119.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 71.0, 72.0, 73.0, 74.0, 75.0, 76.0, 77.0, 78.0, 79.0, 80.0, 81.0, 82.0, 83.0, 84.0, 85.0, 86.0, 87.0, 88.0, 89.0, 90.0, 91.0, 92.0, 93.0, 94.0, 95.0, 96.0, 97.0, 98.0, 99.0, 100.0, 101.0, 102.0, 103.0, 104.0, 105.0, 106.0, 107.0, 108.0, 109.0, 110.0, 111.0, 112.0, 113.0, 114.0, 115.0, 116.0, 117.0, 118.0, 119.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 71.0, 72.0, 73.0, 74.0, 75.0, 76.0, 77.0, 78.0, 79.0, 80.0, 81.0, 82.0, 83.0, 84.0, 85.0, 86.0, 87.0, 88.0, 89.0, 90.0, 91.0, 92.0, 93.0, 94.0, 95.0, 96.0, 97.0, 98.0, 99.0, 100.0, 101.0, 102.0, 103.0, 104.0, 105.0, 106.0, 107.0, 108.0, 109.0, 110.0, 111.0, 112.0, 113.0, 114.0, 115.0, 116.0, 117.0, 118.0, 119.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 71.0, 72.0, 73.0, 74.0, 75.0, 76.0, 77.0, 78.0, 79.0, 80.0, 81.0, 82.0, 83.0, 84.0, 85.0, 86.0, 87.0, 88.0, 89.0, 90.0, 91.0, 92.0, 93.0, 94.0, 95.0, 96.0, 97.0, 98.0, 99.0, 100.0, 101.0, 102.0, 103.0, 104.0, 105.0, 106.0, 107.0, 108.0, 109.0, 110.0, 111.0, 112.0, 113.0, 114.0, 115.0, 116.0, 117.0, 118.0, 119.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 71.0, 72.0, 73.0, 74.0, 75.0, 76.0, 77.0, 78.0, 79.0, 80.0, 81.0, 82.0, 83.0, 84.0, 85.0, 86.0, 87.0, 88.0, 89.0, 90.0, 91.0, 92.0, 93.0, 94.0, 95.0, 96.0, 97.0, 98.0, 99.0, 101.0, 100.0, 102.0, 103.0, 104.0, 105.0, 106.0, 107.0, 108.0, 109.0, 110.0, 111.0, 112.0, 113.0, 114.0, 115.0, 116.0, 117.0, 118.0, 119.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 71.0, 72.0, 73.0, 74.0, 75.0, 76.0, 77.0, 78.0, 79.0, 80.0, 81.0, 82.0, 83.0, 84.0, 85.0, 86.0, 87.0, 88.0, 89.0, 90.0, 91.0, 92.0, 93.0, 94.0, 95.0, 96.0, 97.0, 98.0, 99.0, 100.0, 101.0, 102.0, 103.0, 104.0, 105.0, 106.0, 107.0, 108.0, 109.0, 110.0, 111.0, 112.0, 113.0, 114.0, 115.0, 116.0, 117.0, 118.0, 119.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 71.0, 72.0, 73.0, 74.0, 75.0, 76.0, 77.0, 78.0, 79.0, 80.0, 81.0, 82.0, 83.0, 84.0, 85.0, 86.0, 87.0, 88.0, 89.0, 90.0, 91.0, 92.0, 93.0, 94.0, 95.0, 96.0, 97.0, 98.0, 99.0, 100.0, 101.0, 102.0, 103.0, 104.0, 105.0, 106.0, 107.0, 108.0, 109.0, 110.0, 111.0, 112.0, 113.0, 114.0, 115.0, 116.0, 117.0, 118.0, 119.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 71.0, 72.0, 73.0, 74.0, 75.0, 76.0, 77.0, 78.0, 79.0, 80.0, 81.0, 82.0, 83.0, 84.0, 85.0, 86.0, 87.0, 88.0, 89.0, 90.0, 91.0, 92.0, 93.0, 94.0, 95.0, 96.0, 97.0, 98.0, 99.0, 100.0, 101.0, 102.0, 103.0, 104.0, 105.0, 106.0, 107.0, 108.0, 109.0, 110.0, 111.0, 112.0, 113.0, 114.0, 115.0, 116.0, 117.0, 118.0, 119.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 71.0, 72.0, 73.0, 74.0, 75.0, 76.0, 77.0, 78.0, 79.0, 80.0, 81.0, 82.0, 83.0, 84.0, 85.0, 86.0, 87.0, 88.0, 89.0, 90.0, 91.0, 92.0, 93.0, 94.0, 95.0, 96.0, 97.0, 98.0, 99.0, 100.0, 101.0, 102.0, 103.0, 104.0, 105.0, 106.0, 107.0, 108.0, 109.0, 110.0, 111.0, 112.0, 113.0, 114.0, 115.0, 116.0, 117.0, 118.0, 119.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 71.0, 72.0, 73.0, 74.0, 75.0, 76.0, 77.0, 78.0, 79.0, 80.0, 81.0, 82.0, 83.0, 84.0, 85.0, 86.0, 87.0, 88.0, 89.0, 90.0, 91.0, 92.0, 93.0, 94.0, 95.0, 96.0, 97.0, 98.0, 99.0, 100.0, 101.0, 102.0, 103.0, 104.0, 105.0, 106.0, 107.0, 108.0, 109.0, 110.0, 111.0, 112.0, 113.0, 114.0, 115.0, 116.0, 117.0, 118.0, 119.0};
    }

    public class Angle {
        public double angle;
        public double weight;
    }
}

