/*
 * Decompiled with CFR 0.152.
 */
package bigpete;

import bigpete.CustFunct;
import java.awt.geom.Point2D;

public class VirtualBullet {
    private double velocity;
    private double heading;
    private Point2D current_position;
    private Point2D origin;
    private Point2D target;
    private double move_time;

    VirtualBullet(double vel_in, double head_in, Point2D enemy_in, Point2D target_in, double time_in) {
        this.velocity = vel_in;
        this.heading = head_in;
        this.current_position = new Point2D.Double();
        this.origin = new Point2D.Double();
        this.target = new Point2D.Double();
        this.current_position.setLocation(enemy_in);
        this.origin.setLocation(enemy_in);
        this.target.setLocation(target_in);
        this.move_time = time_in - 4.0;
        this.move(time_in);
        this.move_time = time_in;
    }

    public Point2D getPosition() {
        return this.current_position;
    }

    public void move(double current_time) {
        double time_diff = current_time - this.move_time;
        this.current_position.setLocation(this.current_position.getX() + this.velocity * time_diff * Math.sin(this.heading), this.current_position.getY() + this.velocity * time_diff * Math.cos(this.heading));
        this.move_time = current_time;
    }

    public double getDistance(Point2D input) {
        double x10 = this.origin.getX() - input.getX();
        double x21 = this.target.getX() - this.origin.getX();
        double y10 = this.origin.getY() - input.getY();
        double y21 = this.target.getY() - this.origin.getY();
        double tmp = Math.abs(x21 * y10 - x10 * y21) / Math.sqrt(Math.pow(x21, 2.0) + Math.pow(y21, 2.0));
        return Math.max(tmp, 1.0E-6);
    }

    public double bulletDistanceTraveled() {
        return this.origin.distance(this.current_position);
    }

    public boolean gonePast(Point2D robot_position) {
        return robot_position.distance(this.origin) + 100.0 < this.bulletDistanceTraveled();
    }

    public double getBearingToPath(Point2D input) {
        double x1 = input.getX();
        double y1 = input.getY();
        double x2 = this.origin.getX();
        double y2 = this.origin.getY();
        double m2 = this.gradient(this.origin, this.target);
        double c2 = y2 - m2 * x2;
        double m1 = -1.0 / m2;
        double x = -(y2 - y1 + m1 * x1 - m2 * x2) / (m2 - m1);
        double y = m2 * x + c2;
        double tmp = CustFunct.pointsToBearing(input, new Point2D.Double(x, y));
        return tmp;
    }

    private double gradient(Point2D a, Point2D b) {
        return (b.getY() - a.getY()) / (b.getX() - a.getX());
    }
}

