/*
 * Decompiled with CFR 0.152.
 */
package catcat20.atom.move.surf.plan;

import catcat20.atom.move.surf.path.Path;
import catcat20.atom.move.surf.path.PathPos;
import catcat20.atom.move.surf.plan.SurfPlan;
import catcat20.atom.rader.AtomRader;
import catcat20.atom.robot.Bot;
import catcat20.atom.robot.BotState;
import catcat20.atom.utils.HConstants;
import catcat20.atom.utils.HUtils;
import catcat20.atom.utils.MovementPredictor;
import catcat20.atom.utils.PreciseWallSmooth;
import catcat20.atom.utils.Wave;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;

public class MeleePlan
implements SurfPlan {
    PreciseWallSmooth.Trig trig = new PreciseWallSmooth.Trig();
    public static final int directions = 8;
    public static final int WALL_STICK = 200;

    @Override
    public ArrayList<Path> generatePath(MovementPredictor.PredictionStatus status, Wave w) {
        ArrayList<Path> paths = new ArrayList<Path>();
        long genTime = 0L;
        long then = System.nanoTime();
        double division = 8.0;
        int start = 0;
        Bot en = AtomRader.getBot(w.enName);
        BotState enState = en.currentState;
        double enAngle = HUtils.absoluteBearing(status, enState.getPosition());
        for (int i = start; i < 360; i += (int)(360.0 / division)) {
            boolean isDangerAngle = true;
            if (!isDangerAngle || !HConstants.safeField.contains(HUtils.project(status, Math.toRadians(i), 140.0))) continue;
            Path path = new Path(this.precisePredict(HConstants.safeField, w, 8.0, status, Math.toRadians(i)));
            if (!HConstants.field.contains(path.path.get(Math.max(0, path.path.size() - 1)))) continue;
            paths.add(path);
        }
        paths.add(new Path(this.precisePredict(HConstants.safeField, w, 0.0, status, status.heading)));
        long millis = TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - then);
        genTime += millis;
        return paths;
    }

    public double wallSmoothing(Point2D.Double botLocation, double angle, int orientation) {
        double count = 1.0;
        double step = 0.0;
        double v = Math.toRadians(2.5);
        while (!HConstants.safeField.contains(HUtils.project(botLocation, angle, 200.0))) {
            count = -Math.signum(count) * (step += v);
            angle += (double)orientation * count;
        }
        return angle;
    }

    public ArrayList<PathPos> precisePredict(Rectangle2D.Double fieldRect, Wave ew, double maxVelocity, MovementPredictor.PredictionStatus status, double heading) {
        ArrayList<PathPos> cachePoss = new ArrayList<PathPos>();
        int counter = 0;
        boolean intercepted = false;
        MovementPredictor.PredictionStatus predictedStatus = (MovementPredictor.PredictionStatus)status.clone();
        do {
            this.trig.sin = Math.sin(predictedStatus.heading);
            this.trig.cos = Math.cos(predictedStatus.heading);
            if ((predictedStatus = MovementPredictor.predict(predictedStatus, heading = HConstants.preciseWallSmooth.smoothHeading(heading, this.trig, predictedStatus.x, predictedStatus.y, HUtils.sign(predictedStatus.velocity)), maxVelocity)).distance(ew) < ew.distanceTraveled + (double)counter * ew.bulletVelocity() + ew.bulletVelocity()) {
                intercepted = true;
            }
            if (!fieldRect.contains(predictedStatus.x, predictedStatus.y)) {
                intercepted = true;
            }
            if (!intercepted && counter < 29) continue;
            PathPos cachePos = new PathPos(predictedStatus.x, predictedStatus.y);
            cachePos.status = predictedStatus;
            cachePos.maxVelocity = maxVelocity;
            cachePos.goHeading = heading;
            cachePos.pathColor = ew.color;
            cachePoss.add(cachePos);
        } while (!intercepted && ++counter < 30);
        return cachePoss;
    }

    @Override
    public double eval(MovementPredictor.PredictionStatus status, Wave w) {
        return 0.0;
    }
}

