/*
 * Decompiled with CFR 0.152.
 */
package spin;

import java.awt.Color;
import java.awt.Graphics2D;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;
import spin.Enemy;
import spin.MathVector;
import spin.PredictedBullet;
import spin.RoboMath;

public class Bugstard
extends AdvancedRobot {
    Enemy myEnemy = null;
    double radarDelta = 0.0;
    double radarDeltaMax = 0.05;
    double radarSign = 0.05;
    long ticksToReach = 0L;
    MathVector finalTarget;

    public void run() {
        this.setColors(new Color(251, 209, 68), new Color(251, 209, 68), new Color(251, 209, 68));
        this.setAdjustRadarForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustGunForRobotTurn(true);
        this.setTurnRadarLeftRadians(Double.POSITIVE_INFINITY);
        while (true) {
            if (this.myEnemy != null) {
                this.mainLoop();
            }
            this.scan();
            this.execute();
        }
    }

    private void calcGoTo() {
        double distanceToEnemy = 400.0;
        this.finalTarget = new MathVector();
        this.finalTarget = this.finalTarget.sub(this.getPositionVector().sub(new MathVector(this.getBattleFieldWidth() / 2.0, this.getBattleFieldHeight() / 2.0)));
        MathVector enemySideVector = this.myEnemy.getHeadingVector().getLeftNormal().mul(distanceToEnemy);
        MathVector gotoEnemy = this.myEnemy.add(enemySideVector);
        MathVector a = this.myEnemy.sub(new MathVector(this.getBattleFieldWidth() / 2.0, this.getBattleFieldHeight() / 2.0));
        if (a.add(enemySideVector).lenght() > a.add(enemySideVector.neg()).lenght()) {
            gotoEnemy = this.myEnemy.add(enemySideVector.neg());
        }
        MathVector avoidance = this.myEnemy.getHeadingVector().mul(Math.random() - 0.5).mul(10.0);
        int i = 0;
        while (i < this.myEnemy.getBullets().size()) {
            PredictedBullet pb = this.myEnemy.getBullets().get(i);
            if (pb.sub(this.getPositionVector()).lenght() > pb.getNextPosition().sub(this.getPositionVector()).lenght()) {
                MathVector bulletSideVector = pb.getVelocity().getLeftNormal().norm();
                a = pb.sub(this.getPositionVector());
                this.finalTarget = a.add(bulletSideVector).lenght() > a.add(bulletSideVector.neg()).lenght() ? this.finalTarget.add(bulletSideVector.neg().mul(450.0)) : this.finalTarget.add(bulletSideVector.mul(450.0));
            }
            ++i;
        }
        this.finalTarget = this.finalTarget.add(avoidance);
        this.goTo(this.finalTarget.limitToSquare(this.getBattleFieldWidth(), this.getBattleFieldHeight()));
        if (this.finalTarget.sub(this.getPositionVector()).lenght() < 40.0) {
            this.setTurnRightRadians((this.getHeadingRadians() - this.myEnemy.getHeading()) % Math.PI);
        }
    }

    private void calcToAim() {
        double power = 2.0;
        this.ticksToReach = (long)(this.myEnemy.sub(new MathVector(this.getX(), this.getY())).lenght() / RoboMath.getBulletSpeed(power));
        while (this.myEnemy.getNextPositionWithAngularIn(this.ticksToReach).sub(this.getPositionVector()).lenght() / RoboMath.getBulletSpeed(power) == (double)this.ticksToReach) {
            this.ticksToReach = (long)(this.myEnemy.getNextPositionWithAngularIn(this.ticksToReach).sub(new MathVector(this.getX(), this.getY())).lenght() / RoboMath.getBulletSpeed(power));
        }
        double gunTurn = Utils.normalRelativeAngle((double)(this.myEnemy.getNextBearingRadiansWithAngularIn(this.getX(), this.getY(), this.ticksToReach) - this.getGunHeadingRadians()));
        this.setTurnGunRightRadians(gunTurn);
        if (this.getGunTurnRemainingRadians() < 0.1) {
            this.setFire(power);
        }
    }

    private void mainLoop() {
        System.out.print("Angular: ");
        System.out.println(1.0 - this.myEnemy.getAngularChangeFactor());
        System.out.print("Velocity: ");
        System.out.println(1.0 - this.myEnemy.getVeloChangeFactor());
        this.myEnemy.updateBullets(this.getTime());
        this.calcGoTo();
        this.calcToAim();
        if (this.getTime() - this.myEnemy.getUpdatedAt() > 10L) {
            this.setTurnRadarRightRadians(this.myEnemy.getBearingRadians(this.getX(), this.getY() - this.myEnemy.getNextBearingRadians(this.getX(), this.getY())) * Math.PI * 5.0);
        } else {
            this.setTurnRadarRightRadians(1.5 * Utils.normalRelativeAngle((double)(this.myEnemy.getNextBearingRadiansIn(this.getX(), this.getY(), 3L) - this.getRadarHeadingRadians())));
        }
    }

    private MathVector getPositionVector() {
        return new MathVector(this.getX(), this.getY());
    }

    private MathVector getNextPositionVectorIn(long time) {
        return new MathVector(this.getX(), this.getY()).add(new MathVector(Math.sin(this.getHeadingRadians()) * this.getVelocity(), Math.cos(this.getHeadingRadians()) * this.getVelocity()).mul(time));
    }

    private MathVector getPrevPositionVectorIn(long time) {
        return new MathVector(this.getX(), this.getY()).sub(new MathVector(Math.sin(this.getHeadingRadians()) * this.getVelocity(), Math.cos(this.getHeadingRadians()) * this.getVelocity()).mul(time));
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        if (this.myEnemy == null) {
            this.myEnemy = new Enemy(e, new MathVector(this.getX(), this.getY()), this.getHeadingRadians(), this.getTime(), this.getBattleFieldWidth(), this.getBattleFieldHeight());
        } else {
            this.myEnemy.update(e, new MathVector(this.getX(), this.getY()), this.getHeadingRadians(), this.getTime(), new MathVector(Math.sin(this.getHeadingRadians()) * this.getVelocity(), Math.cos(this.getHeadingRadians()) * this.getVelocity()));
        }
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
    }

    public void onBulletHit(BulletHitEvent e) {
        this.myEnemy.setEnergy(this.myEnemy.getEnergy() - RoboMath.getBulletDamage(e.getBullet().getPower()));
    }

    public void onPaint(Graphics2D g) {
        if (this.myEnemy != null) {
            g.setColor(new Color(255, 0, 0, 128));
            g.fillOval((int)this.finalTarget.getX() - 5, (int)this.finalTarget.getY() - 5, 10, 10);
            g.drawLine((int)(5000.0 * Math.sin(this.getGunHeadingRadians())), (int)(5000.0 * Math.cos(this.getGunHeadingRadians())), (int)this.getX(), (int)this.getY());
            g.fillRect((int)this.myEnemy.getX() - 20, (int)this.myEnemy.getY() - 20, 40, 40);
            g.setColor(new Color(255, 255, 255, 128));
            g.fillRect((int)this.myEnemy.getNextPositionWithAngularIn(this.ticksToReach).getX() - 20, (int)this.myEnemy.getNextPositionWithAngularIn(this.ticksToReach).getY() - 20, 40, 40);
            for (PredictedBullet pb : this.myEnemy.getBullets()) {
                g.fillOval((int)pb.getX() - 5, (int)pb.getY() - 5, 10, 10);
            }
        }
    }

    void goTo(MathVector location) {
        this.goTo(location.getX(), location.getY());
    }

    void goTo(double x, double y) {
        double dist = 20.0;
        double angle = Math.toDegrees(RoboMath.absbearing(this.getX(), this.getY(), x, y));
        double r = this.turnTo(angle);
        this.setAhead(dist * r);
    }

    int turnTo(double angle) {
        int dir;
        double ang = RoboMath.normaliseBearing(this.getHeading() - angle);
        if (ang > 90.0) {
            ang -= 180.0;
            dir = -1;
        } else if (ang < -90.0) {
            ang += 180.0;
            dir = -1;
        } else {
            dir = 1;
        }
        this.setTurnLeft(ang);
        return dir;
    }
}

