/*
 * Decompiled with CFR 0.152.
 */
package rdt.VirtualGuns.Guns;

import rdt.RobotData.RobotData;
import rdt.RobotData.RobotDataSnapshot;
import rdt.Utils.MathUtils;
import rdt.VirtualGuns.VirtualGun;
import rdt.VirtualGuns.VirtualGunFiringData;
import rdt.VirtualGuns.VirtualGunsFiringData;
import rdt.Waves.WaveData;
import robocode.Rules;

public class VirtualGunLinear
extends VirtualGun {
    @Override
    public String GetName() {
        return "Linear";
    }

    @Override
    public void Update() {
    }

    @Override
    public VirtualGunFiringData GetFiringData(VirtualGunsFiringData overallFiringData) {
        double absFiringAngle = this.GetFireAngle(overallFiringData);
        VirtualGunFiringData data = new VirtualGunFiringData();
        data.AddFiringAngle(absFiringAngle);
        return data;
    }

    private double GetFireAngle(VirtualGunsFiringData overallFiringData) {
        RobotData target = this._dataInterface.GetTargetData();
        RobotDataSnapshot targetSnapshot = target.Snapshots.get(this._dataInterface.GetTargetDataAge());
        double absHeading = MathUtils.GetAngle(overallFiringData.FiringLocationX, overallFiringData.FiringLocationY, targetSnapshot.LocationX, targetSnapshot.LocationY);
        return absHeading + Math.asin(targetSnapshot.VelocityAlongHeading / Rules.getBulletSpeed((double)overallFiringData.FirePower) * Math.sin(targetSnapshot.AbsoluteHeading - absHeading));
    }

    @Override
    public void OnWaveReachedTarget(WaveData wave) {
    }

    @Override
    public void OnActualHitOnTarget(WaveData wave, double hitX, double hitY) {
    }
}

