
package axeBots;


import robocode.AdvancedRobot;
//import robocode.*;
import java.awt.geom.*;

//import axeBots.musashi.*;
import axeBots.util.*;

/** 
 * AxeBot - 10/06/2004
 * @author Axe
 * 
 * This code is released under the RoboWiki Public Code Licence (RWPCL),
 * datailed on:
 * http://robowiki.net/?RWPCL
 * (Basically it means you must keep the code public if you base any code on
 * it.)
 * Not basically, i think it means that the knowledge should not be 
 * retained, but shared. We must all remember that the veins of the Knowledge 
 * must flow. Quoting(or some) PEZs comment about OpenSouce: "At least is a 
 * good Karma".
 */
public abstract class AxeBot extends AdvancedRobot {
    private int totBots= 0;
    private double botDim= 0;
    private boolean re= false;
    private int moveStrat= 0;
    private boolean mvChange= false;
	
    private Rectangle2D.Double field= null;

    /////// BEHAVIOUR CONSTANTS //////////
    public static final boolean TC= false;
    public static final boolean MC= false;
    
    
    public static final boolean SAVE_PMGUN_DATA= false;
    public static final boolean SAVE_WS_DATA= true;
    public static final boolean LOAD_WS_DATA = true;
    
    public static final boolean GL= false;

    public static final boolean DEBUG_HITS= false;
    public static final boolean DEBUG_GRAPHS = false;
    
    public static final boolean BEE= false;
    public static final boolean UMBRELLA = false;
    public static final boolean LITE_CANNON = BEE | UMBRELLA | MC | false;
    /////// BEHAVIOUR CONSTANTS //////////
    
    public static final double MAX_VEL= 8;
    public static final double BOT_DIM= 36;
    
    private Point2D.Double fieldUpLft= null;
    private Point2D.Double fieldDwnLft= null;
    private Point2D.Double fieldUpRit= null;
    private Point2D.Double fieldDwnRit= null;

    private static AxeBot singleton= null;
	
    private Point2D.Double botPos=new Point2D.Double();

    /**
     * 
     */
    void setIt(AxeBot at) {
        singleton= at;

    }

    

    public int getMoveStrat() {
        return moveStrat;
    } /**
          																																																												  * @param i
          																																																												  */
    void setMoveStrat(int i) {
        if (moveStrat != i) {
            this.setMvChange(true);
        }
        moveStrat= i;
    }

    public boolean isRe() {
        return re;
    }
    
    

    /**
    	* @param b
    	*/
    void setRe(boolean b) {
        re= b;
    }

    public double getMoveHeading() {
        if (!re) {
            return RoboMath.normalAbsoluteAngle(getHeading());
        } else {
            return RoboMath.normalAbsoluteAngle(getHeading() - 180);
        }

    }

    public Arc2D.Double getAimingArc(double ang, double ext) {
        ang= RoboMath.normalRelativeAngle((Math.toDegrees(ang) - 90));
        Arc2D.Double arc= new Arc2D.Double();
        arc.setArcByCenter(
            singleton.getX(),
            (singleton.getY()),
            1200,
            (ang - (ext / 2)),
            (ext * 2),
            Arc2D.PIE);
        return arc;
    }

    public Point2D.Double pos() {
    	botPos.setLocation (singleton.getX(), singleton.getY());
        return (Point2D.Double)botPos.clone();
    }

    public double getBotDim() {
        return botDim;
    }

    void setBotDim(double dim) {
        botDim= dim;
    }

    public static SilverSurfer getIt() {
        return (SilverSurfer)singleton;
    }

    public int getTotBots() {
        return totBots;
    }

    void setTotBots(int bots) {
        totBots= bots;
    }

    /**
     * @return
     */
    public boolean isMvChange() {
        return mvChange;
    }

    /**
     * @param b
     */
    public void setMvChange(boolean b) {
        mvChange= b;
    }

    /**
     * @return
     */
    public Rectangle2D.Double getField() {
        return field;
    }

    /**
     * @param double1
     */
    public void setField(Rectangle2D.Double double1) {
        field= double1;
        fieldUpLft= new Point2D.Double(field.getMinX(), field.getMaxY());
        fieldDwnLft= new Point2D.Double(field.getMinX(), field.getMinY());
        fieldUpRit= new Point2D.Double(field.getMaxX(), field.getMaxY());
        fieldDwnRit= new Point2D.Double(field.getMaxX(), field.getMinY());
    }

    /**
     * @return
     */
    public Point2D.Double getFieldDwnLft() {
        return fieldDwnLft;
    }

    /**
     * @return
     */
    public Point2D.Double getFieldDwnRit() {
        return fieldDwnRit;
    }

    /**
     * @return
     */
    public Point2D.Double getFieldUpLft() {
        return fieldUpLft;
    }

    /**
     * @return
     */
    public Point2D.Double getFieldUpRit() {
        return fieldUpRit;
    }

}
