package axeBots.pilot;

import axeBots.AxeBot;
import axeBots.data.SegmentedGFs;
import axeBots.silversurfer.AxeVector;
import axeBots.util.RoboMath;
import axeBots.pilot.navigator.Course;
import axeBots.pilot.navigator.WaveNavigator;
import axeBots.pilot.waves.EnemyWave;
import java.awt.Color;
import java.awt.geom.*;
import java.text.DecimalFormat;

/**
 * WaveSurferPilot - 12/06/2004
 * 
 * @author Axe
 * 
 * This code is released under the RoboWiki Public Code Licence (RWPCL),
 * datailed on: http://robowiki.net/?RWPCL (Basically it means you must keep the
 * code public if you base any code on it.) Not basically, i think it means that
 * the knowledge should not be retained, but shared. We must all remember that
 * the veins of the Knowledge must flow. Quoting(or some) PEZ�s comment about
 * OpenSouce: "At least is a good Karma".
 */
public class WaveSurferPilot extends FlatPilot {

	public static final double MIN_DIST = 200;
	public static final double RUN_DIST = 150;//150;//150;
	public static final double[] DIST_SEG_FLAT_FACTORS = {2.5, 1.25, 2.25, 4, 4};
	private Color centerCl = new Color(255, 0, 0);
	private Color wallPtCl = new Color(255, 255, 0);
	private Color wallCl = new Color(64, 64, 0);
	private Color trajCl = new Color(0, 64, 0);
	private Color gfOK = Color.green;//new Color(0, 128, 0);

	private EnemyWave wave = null;
	private WaveNavigator navigator;
	private boolean starting;
	private AxeVector trace = new AxeVector();
	private int ramDodgeDir = 1;
	private int mod;
	private boolean firstDirChoose = true;
	private AxeVector meToHimVec = new AxeVector();
	private AxeVector wavToMe = new AxeVector();
	private AxeVector wavToGf = new AxeVector();
	
	
	/**
	 * JamPilot, by Axe. This class based in Jamougha's ideas of how achieving a
	 * flat profile. Credits goes to him, whow implemented that equation on
	 * Raiko bots.
	 */
	public WaveSurferPilot() {
		super();
		navigator = new WaveNavigator(this);
		starting = true;
	}

	public void invert() {
		super.invert();
	}

	public void move() {
		super.setHim(getMe().getMyTarget());
		if (super.getHim() == null) {
			return;
		}
		Point2D.Double myPos = super.getMe().pos();
		Point2D.Double hisPos = getHim().pos();
		meToHimVec.set(myPos, hisPos);

		//		HISTORY v.2.42: 2004/09/20 INICIALIZA DIRECCAO
		if (firstDirChoose) {
			firstDirChoose = false;
			AxeVector reVec = (AxeVector) meToHimVec.clone();
			AxeVector fwdVec = (AxeVector) meToHimVec.clone();

			reVec.addTheta(-90);
			fwdVec.addTheta(+90);

			reVec.setModule(20);
			fwdVec.setModule(20);

			int reDistToWall = RoboMath.getDistanceToWall(reVec.getEndPoint());
			int fwdDistToWall = RoboMath
					.getDistanceToWall(fwdVec.getEndPoint());

			if (reDistToWall > fwdDistToWall) {
				getMe().doRe(true);
			} else {
				getMe().doRe(false);
			}

		}

		boolean readyToGo = ((Math.abs(getMe()
				.getVelocity()) <= 1) &&
				 (Math.abs(mod) <= 3)) || ((getHim().getDistance() <MIN_DIST )&&(Math.abs(mod) <= 3));

		boolean doneThisWave = (wave == null) ? false : !wave
				.incoming(readyToGo);

		if (wave == null || doneThisWave) {
			EnemyWave newWave = null;
			if (wave != null && doneThisWave) {
				EnemyWave.markWaveAsDone(wave);
				do {
					newWave = EnemyWave.getCurrentWave(myPos, readyToGo);

					doneThisWave = (newWave == null) ? false : !newWave
							.incoming(readyToGo);
					if (doneThisWave) {
						EnemyWave.markWaveAsDone(newWave);
					}
				} while (doneThisWave && (newWave != null));
			}
			if (newWave == null) {
				newWave = EnemyWave.getCurrentWave(myPos, false);
				if (newWave == null) {
					newWave = EnemyWave.getCurrentWave(myPos);
				}
			}
			if (wave != null) {
				wave.setReferenceWave(false);
			}
			wave = newWave;
			if (wave != null) {
				wave.setReferenceWave(true);
			}
			if (wave != null) {
				starting = false;
			}
		}


		
			if (getHim().isRamming() &&(getHim().getDistance() > 100) &&(Math.random() < 0.02)) {
				//getMe().doRe(); 
				ramDodgeDir *= -1;
			}

		if (!getHim().isRamming()) {
			navigator.setWave(wave);
		} else {
			//System.out.println(" DAMN RAMMER!!!!!");
		}
		wave = WaveNavigator.getWave();

		super.setFlat(false);
		setUseSynchro(false);
		super.setWallsFear(true);
		
		//ALTERADO: RETIREI O RUN DISTANCE() DA CONDICCAO.
		if (wave == null || starting || getHim().isRamming()
				|| ((getHim().getDistance() < RUN_DIST) )) {
			int meToWall = RoboMath.getDistanceToWall(myPos);
			int heToWall = RoboMath.getDistanceToWall(hisPos);
			boolean wallAvoiding = /* getMe().getWallAlert().test(); */!((getHim()
					.getDistance() < 200) && (meToWall > heToWall))
					&& getMe().getWallAlert().test();

			if (getHim().isRamming()) {
				wallAvoiding =  getMe().getWallAlert().test();
				double dodgeAmt = (getHim().getDistance() < 80)
						? ramDodgeDir * 155
						: ramDodgeDir * 140;
				double t = wallAvoiding ? 90 : dodgeAmt;
				
				
				meToHimVec.addTheta(getMe().isRe() ? -t : t);
			} else if (getHim().getDistance() < RUN_DIST) {
				double t = wallAvoiding ? 90 : 130;
				meToHimVec.addTheta(getMe().isRe() ? -t : t);
			} else {
				meToHimVec.addTheta(getMe().isRe() ? -90 : 90);
			}
			double ang = RoboMath.normalRelativeAngle(meToHimVec.getTheta()
					- (getMe().isRe() ? 180 : 0));
			double diff = RoboMath.normalRelativeAngle(getMe().getHeading()
					- ang);
			getMe().setTurnLeft(diff);

			if (Math.abs(diff) > 50 && starting) {
				super.walk(0);
			} else {
				super.walk(50);
			}
			return;
		}
		double mygf = wave.getPreciseGF(myPos);
		Point2D.Double gfPt = wave.getWaveGfPoint(myPos, Course.getChosen());
		trace.set(myPos, gfPt);//Course.getChosenRoute().getEndPoint());
		mod = (int)Math.round(trace.getModule());
		double timeToEye = (getHim().isHeadOn()) ? wave.getDangerStartTime(0,
				myPos) : wave.getDangerEyeTime(0, myPos);
		int distLeft = mod;
		double vel = Math.abs(getMe().getVelocity());
		while (vel > 0 && distLeft > 0 && timeToEye > 0) {
			vel -= 2;
			timeToEye--;
			distLeft -= vel;

		}

		//ALTERADO:NOVO STOP
//		wavToMe.set(wave.getCenter(),myPos );
//		wavToGf.set(wave.getCenter(),gfPt  );
//		mod *= Course.getCourse().dirToGf(wavToMe ,wavToGf );
//		
//		
//		if(mod>0) {
//			if (/* !getHim() .isHeadOn()&& */timeToEye == 0) {
//				//HISTORY v2.43:REMOVIDO O BALANCO NO FINAL.
//				//ALTERADO: REATIVADO O BALANCO NO FINAL.
//				mod += distLeft;
//			}
//		}
		
		if (Course.getCourse().stop(mygf)) {
			//			System.out.println("Passou. voltando.");
			mod *= -1;
		} else {
			if (/* !getHim() .isHeadOn()&& */timeToEye == 0) {
				//HISTORY v2.43:REMOVIDO O BALANCO NO FINAL.
				//ALTERADO: REATIVADO O BALANCO NO FINAL.
				mod += distLeft;
			}
		}
		
		if (Math.abs(mod) > 0) {

			double ang = RoboMath.normalRelativeAngle(Course.getChosenRoute()
					.getTheta()//trace.getTheta()
					- (getMe().isRe() ? 180 : 0));


			double diff = RoboMath.normalRelativeAngle(getMe().getHeading()
					- ang);
			getMe().setTurnLeft(diff);
			this.walk(mod);
		} else {
			double ang = RoboMath.normalRelativeAngle(Course.getChosenRoute()
					.getTheta()
					- (getMe().isRe() ? 180 : 0));
			double diff = RoboMath.normalRelativeAngle(getMe().getHeading()
					- ang);
			getMe().setTurnLeft(diff);
			this.walk(0);
		}
		this.draw();
	}

	public void walk(double dist) {
		double walkAmt = dist;
		walkAmt *= (getMe().isRe()) ? -1 : 1;
		getMe().setAhead(walkAmt);
		
//		getMe().setFuturePos(); 
	}
	
	

	public void hitByBullet(double pw) {
	}

	private void draw() {

	}
	
	
	
	public EnemyWave getWave() {
		return wave;
	}
	public String toString() {
		return "WaveSuffererPilot";
	}
}