package jgap;

import robocode.*;
import java.awt.Color;
import java.awt.geom.*;

public class JGAP7958
    extends AdvancedRobot {
  static double lastEnemyHeading;
  static double radarturn = 1;
  static double[] memory = new double[50];

  public void run() {
    setColors(Color.red, Color.blue, Color.green);
    setAdjustRadarForGunTurn(true);
    do {
      turnRadarRightRadians(Double.POSITIVE_INFINITY);
    }
    while (true);
  }

  public void onScannedRobot(ScannedRobotEvent e) {
    {
      setFireBullet(e.getHeading());
      {
        if ( (e.getHeading() > getY())) {
          setFire( (e.getDistance() - getGunTurnRemaining()));
        }
        else {
          setAhead( (int) getTime());
        }
        if ( (getGunTurnRemaining() > getX())) {
          setTurnRadarRight(getDistanceRemaining());
        }
        else {
          {
            setAhead(1000 / Math.sin(e.getEnergy() / 2));
            scan();
            setTurnRadarLeft(getGunTurnRemaining());
          }
        }
      }

      radarturn = -radarturn;
      double w = e.getHeadingRadians() - lastEnemyHeading;
      lastEnemyHeading = e.getHeadingRadians();
      double absbearing = e.getBearingRadians() + getHeadingRadians();
      double eX = e.getDistance() * Math.sin(absbearing);
      double eY = e.getDistance() * Math.cos(absbearing);
      double db = 0;
      double ww = lastEnemyHeading;
      do {
        db += 11;
        double dx = e.getVelocity() * Math.sin(ww);
        double dy = e.getVelocity() * Math.cos(ww);
        ww += w;
        eX += dx;
        eY += dy;
      }
      while (db < Point2D.distance(0, 0, eX, eY));
      setTurnGunRightRadians(Math.asin(Math.sin(Math.atan2(eX, eY) -
                                                getGunHeadingRadians())));
      setTurnRightRadians(e.getBearingRadians() + .5 * Math.PI);
    }
  }

  public void onHitByBullet(HitByBulletEvent e) {
    {
      setAhead(getRadarHeading());
      setFireBullet( (int) getTime());
    }
  }

  public void onHitWall(HitWallEvent e) {
    {
      setBack( (135.0d));
      setBack( (135.0d));
    }
  }

  public void onHitRobot(HitRobotEvent e) {
    {
      setTurnGunRight(getGunTurnRemaining());
      setFireBullet(getY());
      setTurnGunLeft( (getGunHeat() + getGunHeading()));
    }
  }

}
