package m3thos;

import robocode.*;
import java.awt.Color;

/**
 * Eva00 - a robot by Miguel Sousa Filipe
 * 
 * Simple behavior. meant to be fast & simple. The Goal of this bot was to make
 * a minimalistic bot, and still being able to beat and to be head to head with
 * mutch more complex robots. Geracao 3. (the evolution of the specie) 
 * 
 * v1.1		codesize (715) 
 * + "stuck in corners" fix v1 (should be better specially on 1on1)
 * + code restructure that reduced codesize 
 * 
 * v1.0 codesize (722) (at last..) + little fix in onHitBullet
 * 
 * v0.11 codesize (710) (good diets do wonders) + first attempt to
 * solve/minorate the "bounce in corners" bug - don't ram anymore - remove
 * execute()s, setAhead()s that aren't needed + only change target if scanned
 * target is 50 pixels closer than current target
 * 
 * v0.10.2 codesize (733) (working out now..) - uses my targeting for distances
 * >230 even if target is stopped (before NanoGeeks dealled with all stopped
 * targets) - fix in NanoGeek's targeting, only fire if gunHeat = 0.
 * 
 * v0.10.1 codesize (742) (hurrey.. microbot again) - Removed bloat code.. thanx
 * dummy! + tweaked the randoms to do a little more "bullet dodging"
 * 
 * v0.10 codesize (750) !!! FATEST + ANTI-WALL implemented - removed variable
 * lenghts of aheads - other tricks to reduce codesize since after the anti-wall
 * codesize was 821!!! Yup. this version was REALLY FAT!
 * 
 * v0.9 codesize (634) (Fater) (I've should named this version 1.1 or something
 * because it had very dramatic changes) + Now attacks closer bots first
 * (improved for melee) + added NanoGeek's targeting made by Grafi and tuned for
 * my needs (it's faster and better than my targeting when it comes to close
 * range shots) + Independent radar movement (needed for selecting best target) -
 * tuned the onScannedRobot method - full of code clean ups and tweaks It looks
 * faster... but I'm not shure
 * 
 * v0.8 codesize (552) (slim and light) + Inserted some randoms to reverse
 * direction sometimes, this way it's harder to hit! + tweaked some constants. a
 * bit smaller than 0.7, and better.
 * 
 * I don't have changelogs of even older versions... (it would go all the way to
 * v0.3)
 */
public class Eva00 extends AdvancedRobot {
    static private final double FOURTH_PI = (Math.PI / 4);
    static private final double HALF_PI = (Math.PI / 2);

    static private final double SAFE = 38; // mimimal allowed distance to walls

    static private boolean avoid = false; // tells if we're avoid walls ATM

    static private boolean avancar = true; // ve if we are walking ahead or back

    static private double dist = 300; // distance used has reference in almost

    // all movements (varies troughout a
    // fight)

    static private double _distance = 5000; // Distance of the nearest target

    static private double lsTime; // last seen target time.

    static private double energy_before; // Variable for NanoGeek targeting

    static private double speed_before; // Variable for NanoGeek targeting

    static private double dwall_before; // distance from walls in the last run

    static private int wallCount;

    /**
     * run: Eva00's default behavior
     */
    public void run() {
        setColors(Color.red, Color.white, Color.white);
        // move independently
        setAdjustGunForRobotTurn(true);
        setAdjustGunForRobotTurn(true);
        setAdjustRadarForGunTurn(true);
        setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
        lsTime = getTime();
        do {
            antiWall();
            setAhead(dist);
            execute();
        } while (true);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double absoluteBearing = getHeadingRadians() + e.getBearingRadians();
        double gunBearing = normalizeBearing(absoluteBearing - getGunHeadingRadians());
        double dAngle;

        // The new code: select closer bots in case of melles.
        // The 50 is so that we don't change target so ofen, since changing
        // makes us loose time turning the gun
        if (getOthers() > 1 && (_distance + 50) < e.getDistance()) {
            if (getTime() - lsTime > 3) {
                _distance += 50;
                lsTime = getTime();
            }
            setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
            return;
        }
        _distance = e.getDistance();
        lsTime = getTime();
        // If its more than 230 units away, use my targeting
        if (_distance > 230) {
            dAngle = normalizeBearing(e.getHeadingRadians() - getHeadingRadians()
                    - e.getBearingRadians());
            gunBearing += Math.atan(e.getVelocity() * Math.sin(dAngle) / e.getDistance());

            turnGunRightRadians(gunBearing);
            // If it's close enough, fire!
            if (Math.abs(gunBearing) <= 3.5 && getGunHeat() == 0)
                fire(Math.min(3.5 - Math.abs(gunBearing), getEnergy() - .2));
        } else { // ATTENTON THIS CODE BELONGS TO NanoGeek 1.40 by Thomas Graf
            // <<--
            // i still use the famous precise linear prediction formula invented
            // (at least) by Stuart Holliday and Michael Dorgan aka miked0801,
            // only this time using averaged speed
            setTurnGunRightRadians(normalizeBearing(absoluteBearing
                    - getGunHeadingRadians()
                    + Math.asin((e.getVelocity() + speed_before)
                            * Math.sin(e.getHeadingRadians() - absoluteBearing) / 22)));
            // memorize target's speed, used for averaging next shot
            if (getGunHeat() == 0) {
                speed_before = e.getVelocity();
                // fire 3 or 0.1, if 0.1 aiming will be wrong (precisely the
                // division by 22 is wrong), but that doesn't really matter ;-)
                fire(230 - _distance);
            }
        } // End of Grafi code block
        antiWall();
        //			 Reactive movements to Target
        if (!avoid) {
            if ( Math.random() < .08)
                reverseDirection();
           /*
            if (_distance > 300) // still experimenting with this value.
                _distance += ((avancar && e.getBearingRadians() < 0) ? -FOURTH_PI
                        : ((avancar || e.getBearingRadians() < 0) ? FOURTH_PI : -FOURTH_PI));
            */
        }
        setTurnPerpendicularTo(e.getBearingRadians());

    }

    public void onHitByBullet(HitByBulletEvent e) {
        if (!avoid && Math.random() < .5)
            setTurnPerpendicularTo(e.getBearingRadians());
        if (!avoid && Math.random() < .13)
            reverseDirection();
    }

    public void onHitWall(HitWallEvent e) {
        avoid = true;
        reverseDirection();
        dwall_before = distanceToWall();
    }

    public void onHitRobot(HitRobotEvent e) {
        setTurnGunTo(e.getBearingRadians());
        _distance = 20;
        lsTime = getTime();
        if (getGunHeat() == 0)
            fire(3);
    }

    // +++++++++++++FUNCOES AUXILIARES+++++++++++++++

    // Wall avoidance
    private void antiWall() {
        double wall_dist;
        if ((wall_dist = distanceToWall()) < SAFE) {
            if (wallCount++ > 50) {
                //out.println("Estou num canto.. vou tentar sair!");
                setTurnPerpendicularTo(getHeadingRadians());
                wallCount = 0;
            }
            if (dwall_before > (dwall_before = wall_dist) && !avoid) {
                avoid = true;
                reverseDirection();
            }
        } else {
            wallCount = 0;
            avoid = false;
        }
    }

    static void reverseDirection() {
        dist *= -1;
        avancar = ((avancar) ? false : true);
    }

    // setTurnTo: turns to a given Bearing, the fastest way possible.
    private void setTurnTo(double angle) {
        if (Math.abs(angle) > HALF_PI) {
            reverseDirection();
            angle += Math.PI;
        }
        setTurnRightRadians(normalizeBearing(angle));
    }

    // setTurnPerpendicularTo: Turn perpendicular to a given Bearing.
    private void setTurnPerpendicularTo(double angle) {
        angle += ((angle > 0) ? -HALF_PI : HALF_PI);
        setTurnRightRadians(angle);
    }

    // setTurnGunTo: turns gun to a given Bearing, ..the rest you know
    private void setTurnGunTo(double angle) {
        angle += getHeadingRadians() - getGunHeadingRadians();
        setTurnGunRightRadians(normalizeBearing(angle));
    }

    // yes.. it gives the distance from nearest wall.
    private double distanceToWall() {
        return Math.min(Math.min(getBattleFieldWidth() - getX(), getX()), Math.min(
                getBattleFieldHeight() - getY(), getY()));
    }

    //if a bearing is not within the -pi to pi range, alters it to provide the
    // shortest angle
    static double normalizeBearing(double angle) {
        return (angle + (9 * Math.PI)) % (2 * Math.PI) - Math.PI;
    }
}