package davidalves.net.radar.strategies;

//Imports for all classes
import robocode.*;
import davidalves.net.*;
import davidalves.net.targeting.*;
import davidalves.net.data.*;
import davidalves.net.math.*;
import davidalves.net.movement.*;
import davidalves.net.radar.RadarInterface;
import davidalves.net.util.*;
import java.util.*;
import java.awt.Color;
import java.io.*;


/**
 * @author David Alves
 *
 */
public class MeleeStrategy implements RadarInterface, Serializable {
	
	AbstractAdvancedBot me;
	EnvironmentInterface environment;
	
	public MeleeStrategy(AbstractAdvancedBot myBot, EnvironmentInterface e){
		me = myBot;
		environment = e;
	}
	
	/**
	 * @see davidalves.net.scan.RadarMethodInterface#scanTo(DaveBot, Hashtable)
	 */
	public double scan() {
		
		double radarOffset;
		RobocodeRobot trackingTarget = environment.getEnemyScannedLongestAgo();
		
		radarOffset = DaveMath.angularDifferenceBetween(me.getRadarHeading(),me.getAbsoluteAngleTo(trackingTarget));
		if (radarOffset < 0){
			radarOffset -= DaveMath.QUARTERCIRCLE / 8;
		} else {
			radarOffset += DaveMath.QUARTERCIRCLE / 8;
		}
		if (me.getTime() - trackingTarget.getLastScannedTime() > 16){
			return 720;
		}
		//turn right by this amount
		return radarOffset;
	}

}
