package franzor;

import robocode.*;
import java.awt.geom.Point2D;
import java.util.*;

import robocode.util.Utils;

/**
 * MyClass - a class by (your name here)
 */
public class StatPack {
	private List data[][];
	private List startLocations;
	private long statHitRate[][][];
	private long linearHitRate[][][];
	
	public StatPack() {
		data = new LinkedList[9][100];
		startLocations = new LinkedList();
		
		statHitRate = new long[26][5][2]; // [distance][velo][hits/shots]
		linearHitRate = new long[26][5][2]; //[distance][velo][hits/shots]
	}
	
	public void addLinearHitData(double dist, boolean hit, double velocity) {
		int modDist = (int)(dist/100);
		if(modDist > 50 || modDist < 0) return;
				
		if(hit) linearHitRate[modDist/2][(int)Math.abs(velocity/2)][0]++;
		linearHitRate[modDist/2][(int)Math.abs(velocity/2)][1]++;
	}
	
	public double getLinearHitRate(double dist, double velocity) {
		int modDist = (int)(dist/100);
		if(modDist > 50 || modDist < 0) return 0;
		if(linearHitRate[modDist/2][(int)Math.abs(velocity/2)][1] == 0) return 0;
		
		return (double)linearHitRate[modDist/2][(int)Math.abs(velocity/2)][0]/(double)linearHitRate[modDist/2][(int)Math.abs(velocity/2)][1];
	}
	
	public void addStatHitData(double dist, boolean hit, double velocity) {
		int modDist = (int)(dist/100);
		if(modDist > 50 || modDist < 0) return;
		
		if(hit) statHitRate[modDist/2][(int)Math.abs(velocity/2)][0]++;
		statHitRate[modDist/2][(int)Math.abs(velocity/2)][1]++;
	}
	
	public double getStatHitRate(double dist, double velocity) {
		int modDist = (int)(dist/100);
		if(modDist > 50 || modDist < 0) return 0;
		if(statHitRate[modDist/2][(int)Math.abs(velocity/2)][1] == 0) return 0;
		
		return (double)statHitRate[modDist/2][(int)Math.abs(velocity/2)][0]/(double)statHitRate[modDist/2][(int)Math.abs(velocity/2)][1];
	}
	
	public MathVector getAverageDisplacement(long time, double speed) {
		return getAverageDisplacement(time, speed, true);
	}
	
	private MathVector getAverageDisplacement(long time, double speed, boolean interpolate) {
		if(time >= 99 || time < 0)
			return null;
		
		List lst = data[Math.abs((int)Math.round(speed))][(int)time];
		
		if(lst == null || lst.size() < 2) 
			if(interpolate) { //no double interpolations please
				return interpolate(time, speed);
			} else {
				return null;
			}
		
		Iterator iter = lst.iterator();
		int mag[] = new int[1000]; //mean magnitude
		int theta[] = new int[33]; //mode theta
		
		while(iter.hasNext()) {
			MathVector mv = (MathVector)iter.next();
			double dir = robocode.util.Utils.normalAbsoluteAngle(mv.getDirection());
			if(mv.getMagnitude() < 1000 && mv.getMagnitude() > 0){
				mag[(int)mv.getMagnitude()]++;
				theta[(int)Math.round(dir*16/Math.PI)]++;
			}
		}
		
		int index = 0;
		for(int i = 0; i < theta.length; i++)
			index = (theta[i] > theta[index])?i:index;
		int mIndex = 0;
		for(int i = 0; i < mag.length; i++)
			mIndex = (mag[i] > mag[index])?i:mIndex;
		
		double angle = index*Math.PI/16;
		
		return new MathVector(mIndex, robocode.util.Utils.normalRelativeAngle(angle));
	}
	
	private MathVector interpolate(long time, double speed) {
		//find first within 5 each way
		int less, greater; //coefficients
		less = greater = 0;
		MathVector lMV, gMV;
		lMV = gMV = null;
		for(int i = 1; i <= 5; i++) {
			if(lMV == null) {
				less = i;
				lMV = getAverageDisplacement(time - i, speed, false);
			}
			
			if(gMV == null) {
				greater = i;
				gMV = getAverageDisplacement(time + i, speed, false);
			}
		}
		
		if(lMV == null || gMV == null)
			return null;
			
		double mag = (less*lMV.getMagnitude() + greater*gMV.getMagnitude())/(less + greater);
		double dir = less*robocode.util.Utils.normalAbsoluteAngle(lMV.getDirection());
		dir += greater*robocode.util.Utils.normalAbsoluteAngle(gMV.getDirection());
		dir /= less + greater;
		dir = robocode.util.Utils.normalRelativeAngle(dir);
		
		return new MathVector(mag, dir);
	}
	
	public void addData(long time, Point2D location, MathVector velocity) {
		Iterator iter = startLocations.iterator();
		while(iter.hasNext()) {
			StartLoc sl = (StartLoc)iter.next();
			int timediff = (int)(time - sl.time);
			
			if(timediff > 99 || timediff < 0) {
				iter.remove();
			} else {
				double mag = location.distance(sl.location);
				double theta = Math.atan2(location.getX()-sl.location.getX(), location.getY()-sl.location.getY());
				theta = robocode.util.Utils.normalAbsoluteAngle(theta);
				theta -= robocode.util.Utils.normalAbsoluteAngle(sl.velocity.getDirection());
				
				if(data[Math.abs((int)Math.round(sl.velocity.getMagnitude()))][timediff] == null) {
					data[Math.abs((int)Math.round(sl.velocity.getMagnitude()))][timediff] = new LinkedList();
				}
				
				List lst = data[Math.abs((int)Math.round(sl.velocity.getMagnitude()))][timediff];
				lst.add(new MathVector(mag, theta));
				if(lst.size() > 25)
					lst.remove(0);
			}
		}
		
		startLocations.add(new StartLoc(time, location, velocity));
	}
	
	private class StartLoc {
		public long time;
		public Point2D location;
		public MathVector velocity;
		
		public StartLoc(long t, Point2D loc, MathVector velo) {
			time = t;
			location = loc;
			velocity = velo;
		}
	}
}
