package ntc.Lasers;
import java.awt.geom.*;
import robocode.util.Utils;

public class WaveBullet
{
	private double startx, starty, startBearing, power;
	private long fireTime;
	private int direction;
	private float[] returnSegment;
	
	public WaveBullet(double x, double y, double bearing, double power, int direction, long time, float[] segment)
	{
		this.startx = x;
		this.starty = y;
		this.startBearing = bearing;
		this.power = power;
		this.direction = direction;
		this.fireTime = time;
		this.returnSegment = segment;
	}

	public double getBulletSpeed()
	{
		return 20-this.power*3;
	}
	
	public double maxEscapeAngle()
	{
		return Math.asin(8/(this.getBulletSpeed()));
	}

	public boolean checkHit(double enemyX, double enemyY, long currentTime, boolean canFire)
	{
		if (Point2D.distance(startx, starty, enemyX, enemyY) <= (currentTime-fireTime)*this.getBulletSpeed())
		{
			double desiredDirection = Math.atan2(enemyX-startx, enemyY-starty);
			double angleOffset = Utils.normalRelativeAngle(desiredDirection-startBearing);
			double guessFactor = Math.max(-1, Math.min(1, angleOffset/maxEscapeAngle()))*direction;
			int index = (int)Math.round((returnSegment.length-1)/2*(guessFactor+1));
			returnSegment[index]=(float)rollingAverage(returnSegment[index],1,150,canFire ? 1:0.2);
			return true;
		}
		return false;
	}

	private double rollingAverage(double value, double newEntry, double n, double weighting ) {
    	return (value * n + newEntry * weighting)/(n + weighting);
	}

}