package rc.yoda.utils;

import robocode.*;
import java.awt.Graphics2D;

/** 
 * Movement - by Robert Codd (Gorded) 
 *
 * This code is here by released under the RoboWiki Public Code Licence (RWPCL),
 * datailed on: http://robowiki.net/?RWPCL
 * (Basically it means you must keep the code public if you base any bot on it)
 *
 * Movement.java : v1.0 -- 2007/05/12
 */ 

/**
 * Movement - A class that defines the
 * events a robocode movement can use
 *
 * @author Robert Codd
 * @version v 1.1
 * @edited 04/04/07
 */
public class Movement
{
	protected AdvancedRobot robot;
	
	public Movement(AdvancedRobot robot) {
		this.robot = robot;
	}

	/**
	 * onRobotFire - called by the robot
	 * when the enemy fires a bullet
	 *
	 * @param deltaEnergy - the power of the bullet fired
	 */
	public void onRobotFire(double deltaEnergy) {
	}

	/**
	 * onScannedRobot - called by robocode when 
	 * our robot scans the enemy
	 *
	 * @param ScannedRobotEvent - enemy information
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
	}

	/**
	 * onHitByBullet - called by robocode when 
	 * our robot gets hit by a bullet
	 *
	 * @param HitByBulletEvent - bullet information
	 */
	public void onHitByBullet(HitByBulletEvent e) {
	}

	/**
	 * onBulletHitBullet - called by robocode when one of 
	 * our bullets hits an enemy bullet
	 *
	 * @param BulletHitBulletEvent - colliding bullet information
	 */
	public void onBulletHitBullet(BulletHitBulletEvent e) {	
	}

	/**
	 * onHitWall - called by robocode when 
	 * our robot hits a wall 
	 *
	 * @param HitWallEvent - wall information
	 */
	public void onHitWall(HitWallEvent e) {
	}
	
	/**
	 * onHitRobot - called by robocode when 
	 * our robot hits another robot
	 *
	 * @param HitRobotEvent - collision information
	 */
	public void onHitRobot(HitRobotEvent e) {
	}		
		
	/**
	 * onDeath - called by robocode when our robot dies
	 *
	 * @param DeathEvent 
	 */
	public void onDeath(DeathEvent e) {
	}	

	/**
	 * onWin - called by robocode when our robot
	 * wins a round
	 *
	 * @param onWin
	 */
	public void onWin(WinEvent e) {
	}

	/**
	 * onPaint - called by robocode when our 
	 * robot can draw to the screen
	 *
	 * @param Graphic2D - painting tool
	 */
	public void onPaint(Graphics2D g) {
	}	
}
