/*
 * Created on 2004-10-11
 */
package tide.pear.statistic;

import tide.util.Statist;

/**
 * All tree buffer statist manager of enemy bot's.
 * @author iiley(Chen Jing)
 */
public class EnemyStatistManager {

	public static final int DIST_D = 5;
	public static final int VELOCITY_D = 4;
	public static final int WALL_D = 4;
	public static final int BEARING_D = 5; //if this changed method getBearingIndex should change too
	public static final int MOVETIME_D = 7;

	protected int FACTORS;
	
	protected Statist[]           fastBuffer;
	protected Statist[][]         distVeloBuffer;
	protected Statist[][][]       normalBuffer;
	protected Statist[][][][]     dvbwBuffer;
	protected Statist[][][][][]   slowBuffer;
	protected Statist[][][][][][] bigSlowBuffer;
	
	public EnemyStatistManager(){};
	
	/**
	 * Create a StatistManager with a certain factors size
	 * @param FACTORS factors size
	 */
	public EnemyStatistManager(int FACTORS){
		this.FACTORS   = FACTORS;
		fastBuffer     = new Statist[DIST_D];
		distVeloBuffer = new Statist[DIST_D][VELOCITY_D];
		normalBuffer   = new Statist[DIST_D][VELOCITY_D][BEARING_D];
		dvbwBuffer     = new Statist[DIST_D][VELOCITY_D][BEARING_D][WALL_D];
		slowBuffer     = new Statist[DIST_D][VELOCITY_D][BEARING_D][WALL_D][MOVETIME_D];
		bigSlowBuffer  = new Statist[DIST_D][VELOCITY_D][BEARING_D][WALL_D][MOVETIME_D][WALL_D];
		//init statists
		for (int dd = 0; dd < DIST_D; dd++) {
			fastBuffer[dd] = new BasicStatist(FACTORS, VELOCITY_D * BEARING_D
					* WALL_D * MOVETIME_D);
			for (int vd = 0; vd < VELOCITY_D; vd++) {
				distVeloBuffer[dd][vd] = new BasicStatist(FACTORS, BEARING_D
						* WALL_D * MOVETIME_D);
				for (int bd = 0; bd < BEARING_D; bd++) {
					normalBuffer[dd][vd][bd] = new BasicStatist(FACTORS, WALL_D
							* MOVETIME_D);
					for (int wd = 0; wd < WALL_D; wd++) {
						dvbwBuffer[dd][vd][bd][wd] = new BasicStatist(FACTORS, MOVETIME_D);
						for (int md = 0; md < MOVETIME_D; md++) {
							slowBuffer[dd][vd][bd][wd][md] = new BasicStatist(
									FACTORS, 1);
							for(int rwd=0; rwd<WALL_D; rwd++){
								bigSlowBuffer[dd][vd][bd][wd][md][rwd] = new BasicStatist(
										FACTORS, 1f/WALL_D);
							}
						}
					}
				}
			}
		}
	}
	
	/**
	 * return the statist of given division
	 * @param distIndex
	 * @param veloIndex
	 * @param bearIndex
	 * @param wallIndex
	 * @param mtIndex
	 * @return the statist of given division
	 */
	public Statist getStatists(int distIndex, int veloIndex, int lastVeloIndex, 
			int bearIndex, int wallIndex, int mtIndex, int reversWallIndex){
		CombinStatist combinStatist = new CombinStatist();
		
		combinStatist.add(fastBuffer[distIndex]);
		combinStatist.add(distVeloBuffer[distIndex][veloIndex]);
		combinStatist.add(normalBuffer[distIndex][veloIndex][bearIndex]);
		combinStatist.add(dvbwBuffer[distIndex][veloIndex][bearIndex][wallIndex]);
		combinStatist.add(slowBuffer[distIndex][veloIndex][bearIndex][wallIndex][mtIndex]);
		combinStatist.add(bigSlowBuffer[distIndex][veloIndex][bearIndex][wallIndex][mtIndex][reversWallIndex]);
		
		return combinStatist;
	}
}
