package lechu;

import robocode.AdvancedRobot;
import robocode.*;

public class Lechu extends AdvancedRobot
{
	static double radarTurn;		
	static double previousEnemyVelocity;
	static double previousEnemyHeading;
	static double previousEnergy;
	static double move = 58;

	public void run() 
	{		
		// cay czas aktywny
		setAdjustRadarForGunTurn(true);
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForRobotTurn(true);		
		
		//PETLA GWNA
		radarTurn = 0.39269;
		while (true) 
		{				
			setTurnRadarRightRadians(radarTurn);
			radarTurn = (radarTurn >= 0 ? 0.39269 : -0.39269); 
			execute();
		}
	}

	public void onScannedRobot(ScannedRobotEvent e) 
	{					
		double x = getX();
		double y = getY();		
		double heading = getHeadingRadians();		
		double distance = e.getDistance();
		double bearing = e.getBearingRadians();			
	
		//wysterowanie radarem
		double setRadar = heading + bearing + (radarTurn > 0 ? -0.3926 : 0.3926);
		if (setRadar > 6.283184) setRadar -= 6.283184;
		if (setRadar < 0) setRadar += 6.283184;	
		setRadar -= getRadarHeadingRadians();
		if (radarTurn < 0)
			radarTurn = (setRadar < 0 ? setRadar + 6.283184 : setRadar);
		else
			radarTurn = (setRadar > 0 ? setRadar - 6.283184 : setRadar);

		//Obrcenie robota
		double robotTurn = bearing + 1.570796;
		if (robotTurn >= 3.141592) robotTurn -= 6.283184;
		if (robotTurn <= -3.141592) robotTurn += 6.283184;			
		setTurnRightRadians(robotTurn);	
	
		//Detekcja strzalu
		double currentEnergy = e.getEnergy();
		double buletEnergy = previousEnergy - currentEnergy;
		if (buletEnergy >= 0.1 && buletEnergy <= 3)
		{
			double xx = x + Math.sin(heading) * move;
			double yy = y + Math.cos(heading) * move;
			if (xx < 30 || xx > getBattleFieldWidth() - 30 || yy < 30 || yy > getBattleFieldHeight() - 30) move = -move;
			setAhead(move);			
		}
		previousEnergy = currentEnergy;
								
		//przygotowanie strzalu
		double robotX = x + Math.sin(heading + bearing) * distance;
		double robotY = y + Math.cos(heading + bearing) * distance;
		double currentVelocity = e.getVelocity();
		double currentHeading = e.getHeadingRadians();
		//Uprzaszczam schemat - zakadam ze radar bedzie w kazdej turze utrzymywal przeciwnika w polu widzenia,
		//w zwiazku z czym predykcja polozenia przeciwnika moze obdywac sie bez troski o liczbe tur
		double energy = getEnergy();
		if (energy > 5 || distance < 180)
		{
			
			double firePower = 1;
			if (energy > 16) firePower = (distance < 180 ? 2.8 : 2.1);
			double fireSpeed = Rules.getBulletSpeed(firePower);
			double buletDistance = 0;
			double predictedTurn = currentHeading;
			double predictedAngleChange = (predictedTurn - previousEnemyHeading);
			double robotSpeed = currentVelocity;
			double robotAcceleration = (currentVelocity - previousEnemyVelocity);
			while (Math.pow(x - robotX, 2) + Math.pow(y - robotY, 2) >= (buletDistance * buletDistance))
			{				
				robotX += robotSpeed * Math.sin(predictedTurn);
				robotY += robotSpeed * Math.cos(predictedTurn);
				//nastepna tura
				robotSpeed += robotAcceleration;
				if (8 < robotSpeed) robotSpeed = 8;
				if (-8 > robotSpeed) robotSpeed = -8;
				predictedTurn += predictedAngleChange;
				buletDistance += fireSpeed;
			}
			//Znana jest juz pozycja robota i nalezy w niego strzelic
			double kat = Math.atan2(robotX - x, robotY - y) - getGunHeadingRadians();
			if (kat > 3.1415926) kat -= 6.283185;
			if (kat < -3.1415926) kat += 6.283185;
			setTurnGunRightRadians(kat);
			if (getGunHeat() == 0) setFire(firePower);			
		}		
		previousEnemyVelocity = currentVelocity;
		previousEnemyHeading = currentHeading;		
	}
	
}
