package apv.test;
import java.util.*;
import java.awt.geom.*;
import robocode.robocodeGL.EllipseGL;


/**
 * Wave - a class by Albert Perez
 * Another wave implementation. 
 */
public class Wave {
	
	Point2D origin, destination;
	double power, t0;
	double direction;
	double distance;
	String segment;
	
	//EllipseGL graph;
	
	public Wave(Point2D origin, Point2D destination, double power, double time, double distance, double direction, String segment) {
		//time is when you fired (ie. bullet is at 20-3*power pixels from origin
		//if you are using waves to surf the enemy, then you should take into consideration that you detect the bullet
		//a tick later, so time is -1, origin position is the previous, and target position is -1 also.
		//direction is 1 if target moves clockwise or -1 if moves counter-clockwise
		this.origin = (Point2D) origin.clone(); this.destination = (Point2D) destination.clone(); 
		this.power = power; this.t0 = time;
		this.distance = distance;
		this.direction = direction;
		this.segment = segment;
		//graph = new EllipseGL(origin.getX()-8, origin.getY()+8, 16, 16);
	} 
	
	public boolean bulletHits(Point2D target, double time) { return bulletHits(target.getX(), target.getY(), time); }
	
	public boolean bulletHits(double X, double Y, double time) {	
		//the center of the circle es origin
		//the radius of the circle is (time-t0+1) * (20-3*power)
		//the position of the target is target
		//the width of the target is 36 x 36
		double radius = (time-t0+1) * (20-3*power);
		Ellipse2D.Double wave = new Ellipse2D.Double(origin.getX() - radius, origin.getY() - radius, radius*2, radius*2);
		//Ellipse2D.Double wave = new Ellipse2D.Double(origin.getX(), origin.getY(), radius*2, radius*2);
		return wave.intersects(X-18, Y-18, 36, 36);
	}
	
	public boolean bulletMisses(Point2D target, double time) { return bulletMisses(target.getX(), target.getY(), time); }
	
	public boolean bulletMisses(double X, double Y, double time) {
		double radius = (time-t0+1) * (20-3*power);
		Ellipse2D.Double wave = new Ellipse2D.Double(origin.getX() - radius, origin.getY() - radius, radius*2, radius*2);
		//Ellipse2D.Double wave = new Ellipse2D.Double(origin.getX(), origin.getY(), radius*2, radius*2);
		return wave.contains(X-18, Y-18, 36, 36);
	}
	
	public double guessFactor(Point2D target) { return guessFactor(target.getX(), target.getY()); }
	
	public double guessFactor(double X, double Y) {
	//doesn't take into consideration direction of the target when the wave was fired.
	//to consider it (ie. make guessFactor relative to target direction) multiply guessFactor by Direction
		return normalRelativeAngle( Math.atan2(X-origin.getX(), Y-origin.getY()) -
		                            Math.atan2(destination.getX()-origin.getX(), destination.getY()-origin.getY()) );
	}
	
	public double getDistance(Point2D target, double time) {
		return target.distance(origin) - (time-t0+1) * (20-3*power);
	}
	
	
	public void updateGraph(EllipseGL graph, double time) {
		double radius = (time-t0+1) * (20-3*power);
		Ellipse2D.Double wave = new Ellipse2D.Double(origin.getX() - radius, origin.getY() - radius, radius*2, radius*2);
		graph.setFrame(wave.getCenterX() - radius, wave.getCenterY() + radius, radius*2, radius*2);
	}
	
	/* 
	public EllipseGL getGraph() { return graph; }
	*/
	
	public static int getWaveToSurf(ArrayList waves, Point2D myPos, long myTime) {
	//given an ArrayList of waves, and a current time and position, returns the INDEX of the closest wave (this is the wave to surf)
		Wave waveToSurf = null; 
		int iWaveToSurf = -1; 
		double waveDistance = Double.POSITIVE_INFINITY;
		for (int i=0; i<waves.size(); i++) {
			Wave wm = (Wave) waves.get(i);
			double distance = wm.getDistance(myPos, myTime);
			if (distance < waveDistance && distance > 15 && !wm.bulletHits(myPos, myTime)) {
				waveToSurf = wm; waveDistance = distance;
				iWaveToSurf = i;
			} 
		}
		return iWaveToSurf;
	}
	
	public Point2D getOrigin() { return origin; }
		
	public double getDirection() { return direction; }
		
	public double getDistance() { return distance; }
		
	public double getPower() { return power; }
		
	public double getTime() { return t0; }	
		
	public String getSegment() { return segment; }			
	
	
	
	//********************************************* PRIVATE FUNCTIONS 
	
	private double normalRelativeAngle(double angle) { return ((angle + 5*Math.PI) % (2*Math.PI)) - Math.PI; }
	
	
}
