package suh.targeting;

import java.awt.geom.Point2D;
import robocode.*;
import suh.util.Utility;

public class GuessFactorTargeting extends Targeting {
    public static final int BINS = Wave.BINS;
    public static final int POWER_INDEX = 4;
    public static final int VELOCITY_INDEX = 5;
    public static final int DISTANCE_INDEX = 5;
    
    public double lastEnemyVelocity;
    public double lateralDirection;
    public static int[][][][][] stats = new int[POWER_INDEX][VELOCITY_INDEX][VELOCITY_INDEX][DISTANCE_INDEX][BINS];

    public GuessFactorTargeting(AdvancedRobot self, FireManager fireManager) {
	super(self, fireManager);
    }
    
    @Override
    public void init() {
	Wave.target = new Point2D.Double();
    }
    
    @Override
    public String getName() {
	return "Guess Factor";
    }

    @Override
    public double getAngle(ScannedRobotEvent e) {
	double bearing;
	double lateralVelocity = e.getVelocity() * Math.sin(e.getHeadingRadians() - (bearing = self.getHeadingRadians() + e.getBearingRadians()));
	
	if(e.getVelocity() != 0) {
	    lateralDirection = Utility.sign(lateralVelocity);
	}
	
	Wave wave;
	self.addCustomEvent(wave = new Wave(
		self, 
		new Point2D.Double(self.getX(), self.getY()), 
		lateralDirection, 
		bearing, 
		Rules.getBulletSpeed(power), 
		Utility.maxEscapeAngle(Rules.getBulletSpeed(Math.min(Math.ceil(power), 3.0))), 
		stats[(int)power][(int)(Math.abs(e.getVelocity())/2.0)][(int)(Math.abs(lastEnemyVelocity)/2.0)][(int)Math.min(e.getDistance()/200.0, 4)]));
	Wave.target = Utility.project(wave.origin, bearing, e.getDistance());
	
	lastEnemyVelocity = e.getVelocity();
	
	return bearing + wave.mostVisitedBearingOffset();
    }
}
