package bayen.nut;
import robocode.*;
import davidalves.sample.DrawingBot;
import java.awt.Color;
import robocode.util.*;
import java.util.*;
import java.awt.geom.*;
import java.awt.Graphics2D;

/**
 *   _________            .__                      .__   
 *  /   _____/ ________ __|__|_____________   ____ |  |  
 *  \_____  \ / ____/  |  \  \_  __ \_  __ \_/ __ \|  |  
 *  /        < <_|  |  |  /  ||  | \/|  | \/\  ___/|  |__
 * /_______  /\__   |____/|__||__|   |__|    \___  >____/
 *         \/    |__|                            \/      
 *                           ii....;;..iiii..        
 *                        ffLLffGGffLLff..          
 *                      iiGGLLffLLffLLffffttii..    
 *                  ..ttffjjttiiiiiittttLLLLtt      
 *                  ttGGttttii;;;;;;;;;;;;ttLLLL..  
 *                ..LLttiiii,,..........;;;;ttfftt  
 *                ttttii;;;;;;......;;::;;;;iiLLLL  
 *      ..      ..ii;;;;;;;;;;::;;iiiiiiii;;iiffDDii
 *  ..iittiitt;;iitttt;;;;;;;;;;LLttttLLLLttttttGGff
 *  iiiittiitt;;;;ffii....;;;;ff..    ..ffLLGGLLDDtt
 *  ;;ttiiii;;tt;;ttii::..;;;;LL,,        ;;DDDDEE;;
 *  ttiiiiiittttii;;ff;;......jjii          LLKKGG  
 *  ;;LLiiffLLiitt,,LL;;;;....;;iiff..      ;;DDjj  
 *  ;;ffttiiiiLLtt;;LL;;,,......;;iiGG;;      ff..  
 *    iiffttKK##LL;;iiffjj;;....::;;ttjjtt..  ;;    
 *      ttff##WWffii....;;LL;;......iiLLGGii        
 *    ..iiKKLLLLGGii......tttt;;......iijjtt        
 *  ;;iiffLLLLttjjtt..;;..,,ttii......;;iiff        
 *  ffffffLLLLtt..ttiiffttii;;tt,,......;;LL        
 *  iiffLLffjjiiLLffttff;;::tttt;;....,,;;jj..      
 *  jjjjLLiiffjj;;ttLL......;;ffjj....;;;;ff..      
 *  ..ttjj;;......iiii......,,iiff;;,,;;ttLL        
 *    ttiiii......tt;;......,,ttffttiittffff        
 *    tt;;tt......tt;;......::ttLLffffLLGG;;        
 *    iiiiff;;....tttt;;..;;;;jjDDGGGGGGii          
 *    ..jjGGLLttiittGGttiiGGLLLLGGKKEE;;            
 *    ;;ttttLLGGii;;......iijj;;                    
 *    ffLLLLGGttii;;ttii;;;;                        
 *    ....;;ttjjffii..                              
 *          ......                                  
 *
 * __________         __________                             
 * \______   \___.__. \______   \_____  ___.__. ____   ____  
 *  |    |  _<   |  |  |    |  _/\__  \<   |  |/ __ \ /    \ 
 *  |    |   \\___  |  |    |   \ / __ \\___  \  ___/|   |  \
 *  |______  // ____|  |______  /(____  / ____|\___  >___|  /
 *         \/ \/              \/      \/\/         \/     \/ 
 *
 * Version 1.615
 *  - rollback to 1.61
 *  - added new corner movement for melee instead of wall movement
 *  - added GF seperation for melee
 * Version 1.611
 *  - testing new energy management (shoot higher power)
 * Version 1.61
 *  - fixed the perception of firing/nonfiring waves in my GF guns
 *  - fixed the depth bug in the antisurf GF gun
 *  - a bit of code cleaning
 * Version 1.60
 *  - added some test energy management
 * Version 1.59
 *  - saves GF data between matches
 *  - removed several virtual guns:  now only main GF and antisuf GF
 * Version 1.58
 *  - new segmentations
 * Version 1.57
 *  - worked on WaveSurfing (still)
 *  - fixed bug in VG array that made it select bad guns
 * Version 1.55
 *  - worked with Anti Surfer guns
 *  - tried to improve GF guns
 *  - rollingAverages and improved flattening to WaveSurfing
 * Version 1.50
 *  - improved WaveSurfing (I think)
 *  - added more guns to VG array
 * Version 1.42
 *  - improved GF gun (with RollingAverages)
 *  - added WaveSurfing
 * Version 1.35
 *  - reverted to 1.24
 *  - tweaked VirtualGuns array implemenation
 *  - added a basic GF gun to VirtualGuns array
 *  - added energy management
 * Version 1.26
 *  - fixed melee to one-on-one movement transition
 * Version 1.25
 *  - fixed melee targeting system (it was really bad)
 * Version 1.24
 *  - tweaked VirtualGuns array code
 *  - reverted back to "buzzing" movement
 *  - added a random movement that will activate
 *    if I am being hit more than 70% of the time
 *  - added Melee capability (since 1.17's melee broke)
 * Version 1.17
 *  - implemented a VirtualGuns array with HOT, CT, LT, and RT
 *  - changed movement to a multi-mode type with different plans
 *    for HOT, CT & LT, and ST.
 * Version 1.05
 *  - gun updated to stop firing if energy is low
 *  - minor movement tweaking
 * Version 1.0
 *  - initial release
 *  - uses a basic CT gun
 *  - uses a "buzzing" movement to change direction when they fire
 */
public class Squirrel extends DrawingBot
{
	boolean alliances = true;
	static  boolean MC = false; // Good idea, Voidious!
	static boolean TC = false; // Good idea, Voidious!
	double others = 1;
	String target;
	
	AcornSlingshot slingshot;
	FleetFeet feet;
	ScannedRobotEvent lastScan;
	static Score score;
	static int mytotalScore;
	static int enemytotalScore;
	
	public void setChallenges() {
		
	}
	
	/**
	 * run: Squirrel's default behavior
	 */
	public void run() {
		//others = getOthers();
		setColors(Color.lightGray,Color.lightGray,Color.darkGray);
		setChallenges();
		slingshot = new AcornSlingshot(this, TC);
		feet = new FleetFeet(this);
		//if(getRoundNum() == 1)
		score = new Score(this);
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		slingshot.run();
		while(true) turnRadarRight(Double.POSITIVE_INFINITY);
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		score.onScannedRobot(e);
		others = getOthers();
		if(getTime() < 30)
		lastScan = e;
		if(e.getName().length() >= 18 && alliances && getOthers() != 1){
        	if("bayen.nut.Squirrel".equals(
	           e.getName().subSequence(0,18))){
        	return;
        	}
        }
		//select the target
		if(e.getDistance() < lastScan.getDistance()) target = null;
		if(target == null) target = e.getName();
		if(e.getName() != target) return;
		
		
		if(!MC) slingshot.onScannedRobot(e);
		if(!TC) feet.onScannedRobot(e);
		//drawCircle(new Point2D.Double(getX(),getY()), 100, Color.blue);
		setTurnRadarRightRadians(Utils.normalRelativeAngle(e.getBearingRadians() + getHeadingRadians() - getRadarHeadingRadians())*2.2);
	}

	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent e) {
		score.onHitByBullet(e);
		feet.onHitByBullet(e);
	}

	public void onHitWall(HitWallEvent e) {
		feet.onHitWall(e);
	}
	public void onHitRobot(HitRobotEvent e) {
		target = e.getName();
		feet.onHitRobot(e);
	}
	public void onWin(WinEvent e) {
		score.onWin(e);
		endRound(true);
		slingshot.onWin(e);
	}
	public void onDeath(DeathEvent e) {
		score.onDeath(e);
		endRound(false);
		slingshot.onDeath(e);
	}
	public void onRobotDeath(RobotDeathEvent e) {
		if(e.getName() == target)
		target = null;
	}
	public void onPaint(Graphics2D g) {
		if(getTime() > 30){
		Iterator i = renderables.iterator();
		while(i.hasNext()){
			Renderable r = (Renderable) i.next();
			r.render(g);
		}
		renderables.clear();
		feet.onPaint(g);
		slingshot.onPaint(g);}
	}
	public void onBulletHit(BulletHitEvent e) {
		score.onBulletHit(e);
		slingshot.onBulletHit(e);
	}
	public void onBulletMissed(BulletMissedEvent e) {
		slingshot.onBulletMissed(e);
	}
	public void endRound(boolean win) {
		if(others == 1){
		double accuracy = slingshot.hits/slingshot.shots;
		double dodge = (feet.eShots - feet.eHits) / feet.eShots;
		if(feet.eShots == 0) dodge = 1;
		out.println();
		out.println("Accuracy %: " + accuracy);
		out.println("Dodge %: " + dodge);
		out.println((win?"WON":"LOST"));
		out.println("My score: " + score.getScore(0));
		out.println("Enemy score: " + score.getScore(1));
		}
	}
	public void onSkippedTurn(SkippedTurnEvent e) {
		System.out.println("SKIPPED TURN AT " + getTime());
	}
}