package dummy.micro;

import robocode.*;
import java.awt.geom.Point2D;
import java.awt.Color;

/**
 *
 * HummingBird, a micro-class Robot by Kwok-Cheung Li (Dummy)
 * A 1-on-1 robot written to participate in Robotobe's MiniBot Challenge
 * http://tobe.homelinux.net/robocode/
 * 
 * Features:
 *  - Very simple bullet tracker that reports a "should-have-hit" when 
 *    the distance that fired bullet travelled exceeds the distance between
 *    the opponent and the origin of the bullet, and notes the change in
 *    position, relative to the direction at the time of fireing.
 *    HummingBird then assumes that the opponent will have the same displacement
 *    after the next shot.
 *  - A very crude feedback-control helps hitting bots that alternate
 *    between moving forward- and backward to dodge bullets.
 *  - "As-good-as-random" movement.
 *  - HummingBird tries to stay at a fixed distance to the opponent.
 *  - no melee capabilities at all.
 *  (HummingBird's gun should be similar to Robotobe's Laser-firing, if I
 *  understood his explanation correctly ;-) )
 * 
 * Current CodeSize : 729 (MicroBot)
 * 
 * VERSION HISTORY
 * 
 * (2.14)
 *  - a futile attempt at improving HummingBird's survival in melee ;-)
 *  - somewhat more randomness
 * 
 * (2.12)
 *  - just some minor tweaks...
 * 
 * (2.11)
 *  - Squeezed Codesize
 *  - Minor bugfix
 *  - COLOURS!!! WOOHOOOOO!!!!:-)
 * 
 * 
 * (2.1)
 *  - Squeezed Codesize a bit
 *  - uses the radar-control that I use in Parakeet, wich a bit more reliable
 *  - added a bit more randomness to the movement
 *  - cleaned up the code a bit...
 *  - added some comments
 * 
 * (2.0)
 *  - Completely rewritten HummingBird
 *  - implemented my experimental BulletTracker
 *  - HummingBird is a MicroBot once again! Yippee!
 *  - pseudo-random movement.
 * 
 * (1.2) 
 *  - ditched the 'alternating bulletpower' feature
 *  - using Parakeet's gun now
 *  - decreased desired fighting distance from 200 to 150
 *  - codesize is now 979, becoming a MiniBot, instead of MicroBot 
 * 
 * (1.1)
 *  - changed movement behaviour
 *  - should have slightly better aim
 *  - slightly better detection of incoming shots.
 *  - codesize is now 703 (yup... gained a LOT of weight ;-) )
 * 
 * (1.03) 
 *  - HummingBird now tries to stay close to the enemy.
 *  - Slightly better detection of incoming shots.
 * 
 * (1.01)
 *  - Changed the random direction behaviour a bit, HummingBird gained a little bit weight ; Codesize 556
 *    (with 'random direction, I mean:"HummingBird either goes Forward, or Backward" ;-) )
 * 
 */
public class HummingBird extends AdvancedRobot
{
	// These probes are used to do some simple bullet-tracking :-)
	public class probe
	{
		double originX;
		double originY;
		double enemyOriginX;
		double enemyOriginY;
		double originalBearing;
		double guess;
		double firetime;
		
		public probe(double origX, double origY, double eOrigX, double eOrigY, double origB, double guess)
		{
			this.originX = origX;				// originX and originY are the x- and y- coordinates of the 
			this.originY = origY;				// origin of the bullet that we are tracking
			this.originalBearing = origB;		// 

			this.enemyOriginX = eOrigX;		// eOriginX and eOriginY are the x- and y- coordinates of the
			this.enemyOriginY = eOrigY;		// opponent at the time the bullet was fired.

			this.firetime=getTime();			// this is the time at wich the bullet was fired.

			this.guess=guess;					// 
		}
		
		public boolean hit(double enemyX, double enemyY)
		{
			return ((Point2D.distance(enemyX, enemyY, originX, originY)-18)<11*(getTime()-firetime)); // 11 is the velocity of a fire(3) bullet;
		}
	}
	////////
	
	// Some variables 
	final static int probeArraySize = 5;
	final static double fightingDistance=260;
	static double absbearing;
	static double enemyDistance;
	static double enemyBulletSpeed=14;
	static double mov;	
	static double radarturn=1;
	static boolean found;
	static double displacement=0;
	static double scanTime;
	////////
	
	
	// Helper Methods
	public double angle_180(double ang)
	{
		return Math.atan2(Math.sin(ang), Math.cos(ang));
	}
	
	public double sign(double val)
	{
		if (val == 0)
			return 1;
		else
			return Math.abs(val)/val;
	}
	
	public void nextmove()
	{
		mov=(mov+100+400*Math.random())%610;
		setAhead((mov-305)*(enemyDistance/340));
	}
	////////
	
	
	// The run() method... makes the world go 'round :-)
	public void run()
	{
		setColors(new Color(64*256*256+160*256+255), new Color(255*256*256+255*256+160), Color.yellow);
		probe[] P;
		int arraycounter=0;
		int stop=0;
		double feedback=1;
		//int changecount=0;
		//int nextchange=(int)(7*Math.random());
		
		P = new probe[probeArraySize];
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		do
		{
			stop=Math.max(0, (stop-1));
			setTurnRadarRightRadians(radarturn);
			double enemyx=(enemyDistance*Math.sin(absbearing)+getX());
			double enemyy=(enemyDistance*Math.cos(absbearing)+getY());
			if (found)
			{
				// - radar control
				radarturn=absbearing - getRadarHeadingRadians();
				setTurnRadarRightRadians(angle_180(radarturn + sign(radarturn)*(Math.PI/8)));
				////////

				// - add probe when a bullet is fired
				if (setFireBullet(3) != null)
				{
					P[arraycounter]=new probe(getX(), getY(), enemyx, enemyy, absbearing, (feedback*displacement));
					arraycounter=(arraycounter+1)%probeArraySize;
				}
				////////

				// check for should-be-hits!
				for (int index=0; index<probeArraySize; index++)
				{
					if (P[index]!=null)
					{
						if (P[index].hit(enemyx, enemyy)) // see if the time has come that a bullet should have int
						{
							double relativeBearing=Math.atan2((enemyx-P[index].enemyOriginX), (enemyy-P[index].enemyOriginY)) 
														- P[index].originalBearing;
							displacement = Point2D.distance(enemyx, enemyy, P[index].enemyOriginX, P[index].enemyOriginY)
											* Math.sin(relativeBearing)
											/ Point2D.distance(P[index].originX, P[index].originY, P[index].enemyOriginX, P[index].enemyOriginY);
							feedback=feedback*sign(P[index].guess*displacement); 	// this crude feedback controls wether we should
																					// aim using +/-displacement
							P[index] = null;
						}
					}
				}
				////////
			}
			else
			{
				setTurnRadarRightRadians(1);
			}


			//setTurnGunRightRadians(angle_180(absbearing - getGunHeadingRadians() + feedback*Math.atan(displacement)));
			setTurnGunRightRadians(angle_180(absbearing - getGunHeadingRadians() + feedback*Math.atan(displacement)));
			if (getDistanceRemaining() == 0  && stop==0)
			{
				stop=Math.max(((int)((enemyDistance/enemyBulletSpeed) - 10 - mov%19)), 1);
			}
			if (stop == 1)
				nextmove();
			setTurnRightRadians(angle_180(absbearing-getHeadingRadians() - ((enemyDistance-fightingDistance)/300)*sign(mov-305) + .5*Math.PI));
			found=false;
			execute();
		} while(true);
	}
	////////
	
	
	// Event Handlers...
	public void onScannedRobot(ScannedRobotEvent e)
	{
		if (getTime()!=scanTime)
		{
			found=true;
			absbearing=e.getBearingRadians()+getHeadingRadians();
			enemyDistance=e.getDistance();
			scanTime=getTime();
		}
	}
	
	public void onHitWall(HitWallEvent e)
	{
		nextmove();
	}
	
	public void onHitByBullet(HitByBulletEvent e)
	{
		enemyBulletSpeed=e.getVelocity();
		absbearing=e.getHeadingRadians()+Math.PI;
	}
	////////
}
