package kawigi.sbf.utils;
import java.io.*;

public class Stats implements Serializable
{
	private Object stats;
	protected int gfs;
	
	public Stats(int[] segments, int[] meleesegments, int gfs)
	{
		this.gfs = gfs;
		Object[] tempstats = new Object[2];
		tempstats[0] = init(segments, 0);
		tempstats[1] = init(meleesegments, 0);
		stats = tempstats;
	}
	
	private Object init(int[] segments, int index)
	{
		if (index == segments.length)
		{
			return new int[gfs];
		}
		else
		{
			Object[] ret = new Object[segments[index]];
			for (int i=0; i<segments[index]; i++)
				ret[i] = init(segments, index+1);
			return ret;
		}
	}
	
	public int[] getSegment(int[] indexes)
	{
		return getSegment(stats, indexes, 0);
	}
	
	protected int[] getSegment(Object stats, int[] indexes, int ind)
	{
		if (ind == indexes.length)
			return (int[])stats;
		else
		{
			Object[] array = (Object[])stats;
			return getSegment(array[indexes[ind]], indexes, ind+1);
		}
	}
	
	public int getGFCount()
	{
		return gfs;
	}
	
	private void writeObject(ObjectOutputStream out) throws IOException
	{
		write(out);
	}
	
	public void write(ObjectOutputStream out) throws IOException
	{
		write(out, stats);
	}
	
	private void write(ObjectOutputStream out, Object current) throws IOException
	{
		if (current instanceof int[])
		{
			int[] segment = (int[])current;
			out.writeByte(-1);
			out.writeByte(segment.length);
			int cribLength = Math.min(Utils.CRIB_LENGTH, segment.length);
			out.writeByte(cribLength);
			int[] crib = new int[cribLength+1];
			int cur = 0;
			for (int i=0; i<segment.length; i++)
			{
				crib[cur] = i;
				int tempi = cur;
				while (tempi > 0 && segment[i] >= segment[crib[tempi-1]])
				{
					crib[tempi] = crib[tempi-1];
					crib[tempi-1] = i;
					tempi--;
				}
				if (cur < cribLength)
					cur++;
			}
			for (int i=0; i<cribLength; i++)
				out.writeByte(crib[i]);
		}
		else
		{
			Object[] array = (Object[])current;
			out.writeByte(array.length);
			for (int i=0; i<array.length; i++)
				write(out, array[i]);
		}
	}
	
 	private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException
 	{
		System.out.println("Reading Data");
		read(in);
 	}
	
	public void read(ObjectInputStream in) throws IOException
	{
		stats = readPart(in);
	}
	
	private Object readPart(ObjectInputStream in) throws IOException
	{
		byte first = in.readByte();
		if (first == -1)
		{
			int[] ret = new int[in.readByte()];
			int cribSize = in.readByte();
			for (int i=0; i<cribSize; i++)
				ret[in.readByte()] = (int)(100*(1-(i+1.0)/cribSize));
			return ret;
		}
		else
		{
			Object[] ret = new Object[first];
			for (int i=0; i<first; i++)
				ret[i] = readPart(in);
			return ret;
		}
	}
}
