package brainfade;

import robocode.*;
import java.awt.*;
import java.awt.geom.*;
import java.util.*;
import java.io.*;
import java.util.zip.*;

import brainfade.gun.*;
import brainfade.utils.*;
import brainfade.move.*;

import pez.tests.pgun.PugilistPunch;

public class Fallen extends AdvancedRobot
{
    //My Variables
    static Enemy target = new Enemy();
    static Muggins me = null;
    long nextMoveTime = -1;
    //static int[] stats = new int[25];
    static Guess[] stats = new Guess[25];
    static PugilistPunch pezGun;
    
    Shape battlefield;
    
    double pi = Math.PI;
    Point2D position = new Point2D.Double(); 
    double firepower = 3;
    static Learning learning;
    

    public void run()
    {
        if(getRoundNum()==0)
        {
            //learning = readObject();
            target.init(this, me);
            //System.out.println(learning.getBestValue());
        }
        
        if(getRoundNum()==0) pezGun = new PugilistPunch(this);
        
        target.isAlive = true;
        
        battlefield = new RoundRectangle2D.Double(35,35,getBattleFieldWidth()-70,getBattleFieldHeight()-70,75,75);        
        setAdjustGunForRobotTurn(true);
        setAdjustRadarForGunTurn(true);
        
        turnRadarRightRadians(2*pi);
        
        
        while(target.isAlive)
        {
            me.setLocation(getX(), getY());
            doRadar();
            doGun();
            doMove();
            execute();
            //if(me.nextDestination!=null&&me.distance(me.nextDestination)<5) setAhead(0);
            if((getGunTurnRemaining()==0)&&(getEnergy()>2||getEnergy()>target.energy||(!target.isFiring()&&getEnergy()<target.energy))&&(getGunHeat()==0))
            {
                //setFire(me.firepower);
                //setTurnGunRight(0);
            }
        }
    }
    
    public void doRadar()
    {
        if((getTime()-target.time) > 2) setTurnRadarRightRadians(2*pi);
        else setTurnRadarRightRadians(Math.sin(target.bearing - getRadarHeadingRadians())*1.5);
    }
    
    public void doGun()
    {
        //me.firepower = Math.min(Math.min(me.bulletPowers[target.getDistanceIndex(target.distance)], target.energy/4), getEnergy()/3);
        //setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(target.getShootAngle() - getGunHeadingRadians()));   
    }
    
    public void doMove()
    {                 
        goTo(me.doMove());
    }
    
    void goTo(Point2D destination) 
    {
        double angle = robocode.util.Utils.normalRelativeAngle(absoluteBearing(me, destination) - getHeadingRadians());
	double turnAngle = Math.atan(Math.tan(angle));
        setTurnRightRadians(turnAngle);
        setAhead(me.distance(destination) * (angle == turnAngle ? 1 : -1));
	setMaxVelocity(Math.abs(getTurnRemaining()) > 30 ? 8 : 8);
    }
    
    double absoluteBearing(Point2D source, Point2D target)
    {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    }
    
    public void onScannedRobot(ScannedRobotEvent e)
    {
        //learning.onScannedRobot(e, this);
        if(me==null)
        {
            me = new Muggins();
            me.init(this, 0, 0, target);
            //System.out.println(learning.getCurrentValue());
        }
        
        target.update(e);   
        me.update();
        pezGun.onScannedRobot(e);
    }
    
    public Point2D vectorToLocation(double angle, double length, Point2D sourceLocation) 
    {
	return vectorToLocation(angle, length, sourceLocation, new Point2D.Double());
    }

    public Point2D vectorToLocation(double angle, double length, Point2D sourceLocation, Point2D targetLocation) 
    {
        targetLocation.setLocation(sourceLocation.getX() + Math.sin(angle) * length,
            sourceLocation.getY() + Math.cos(angle) * length);
        return targetLocation;
    }
    
    public double bulletVelocity(double power) 
    {
        return 20 - 3 * power;
    }

    public void onRobotDeath(RobotDeathEvent e)
    {
        target.isAlive = false; 
        target.reset();
        me.reset();
        out.println(getTime());
    }
    
    public void onDeath(DeathEvent e)
    {
        atEnd();    
        //learning.onDeath(e);
    }
    
    public void onWin(WinEvent e)
    {
        atEnd();  
        //learning.onWin(e);
    } 
    
    public void atEnd()
    {
        target.reset();
        me.reset();
        
        if(getRoundNum()==(getNumRounds()-1))
        {
            //learning.atEnd();
            //writeObject(learning);
            //System.out.println(learning.getBestValue());
        }
    }
    
    public void onBulletHit(BulletHitEvent e)
    {
        target.hitByBullet(e);
        //learning.onBulletHit(e);
    }
    
    public void onHitByBullet(HitByBulletEvent e)
    {
        me.hitByBullet(e);
        target.bulletHit(e);
        //learning.onHitByBullet(e);
        System.out.println("BULLET HIT");
    }
    
    public void onSkippedTurn(SkippedTurnEvent e)
    {
        out.println("Skipped Turn");
    }
    
    public void writeObject(Object toWrite)
    {
        try
        {
            ObjectOutputStream out = new ObjectOutputStream(new GZIPOutputStream(new RobocodeFileOutputStream(getDataFile("vector"))));
            out.writeObject(toWrite);
            out.close();
        }
        catch (IOException ex)
        {
            System.out.println("FAILED WHILE TRYING TO WRITE " + ex);
        }
    }
    
    public Learning readObject()
    {
        try
        {
            ObjectInputStream in = new ObjectInputStream(new GZIPInputStream(new FileInputStream(getDataFile("vector"))));
            Learning temp = (Learning)in.readObject();
            in.close();
            return temp;
        }
        catch (Exception ex)
        {
            System.out.println("FAILED WHILE TRYING TO READ " + ex);
            Learning temp =  new Learning();
            writeObject(temp);
            return temp;
        }
    }
}


