package fromHell.targeting;

import robocode.*;
import robocode.util.Utils;
import java.awt.geom.*;

import fromHell.utils.*;

public class GFTGun {
    private static final double BULLET_POWER = 1.9;
    private static final double GUN_TURNING_BONUS_FOR_BULLET_HITTING_BOTS = 0.0035;
    private static Rectangle2D _battlefieldRectangle;
    private double _enemyLastVelocity;
    private double _enemyTimeSinceAccelerationChanged;
    private double _enemyTimeSinceDecelerationChanged;
    private double _lastBearingDirection;
    private long _lastScanTime;
    private static AdvancedRobot _robot;
    private double _numberOfBulletsHitEnemy = 0;
    private double _numberOfBulletsMissedEnemy = 0;
    private double _numberOfBulletsHitBullets = 0;
    private boolean _enemyIsBulletCatcher = false;

    public GFTGun(AdvancedRobot robot) {
	_robot = robot;
	GFTWave.init();
	_battlefieldRectangle = FHUtils.getBattlefieldRectangle(robot);
    }

    public void onScannedRobot(ScannedRobotEvent scannedRobotEvent) {
	long actualTime = _robot.getTime();
	if (actualTime > _lastScanTime) {
	    Point2D myLocation = new Point2D.Double(_robot.getX(), _robot.getY());
	    double myHeading = _robot.getHeadingRadians();
	    double myVelocity = _robot.getVelocity();
	    double enemyBearing = myHeading + scannedRobotEvent.getBearingRadians();
	    double myEnergy = _robot.getEnergy();
	    double enemyEnergy = scannedRobotEvent.getEnergy();
	    double enemyHeading = scannedRobotEvent.getHeadingRadians();
	    double enemyVelocity = scannedRobotEvent.getVelocity();
	    double enemyDistance = scannedRobotEvent.getDistance();
	    Point2D enemyLocation = FHUtils.project(myLocation, enemyBearing, enemyDistance);
	    double myBulletPower = updateBulletPower(enemyDistance, enemyEnergy, myEnergy);
	    double enemyLateralVelocity = enemyVelocity * Math.sin(enemyHeading - enemyBearing);
	    double enemyAbsoluteVelocity = Math.abs(enemyVelocity);
	    double enemyAbsoluteLateralVelocity = Math.abs(enemyLateralVelocity);
	    double enemyAcceleration = enemyAbsoluteVelocity - Math.abs(_enemyLastVelocity);
	    _enemyTimeSinceAccelerationChanged++;
	    _enemyTimeSinceDecelerationChanged++;
	    if (enemyAcceleration > 0.5) {
		_enemyTimeSinceAccelerationChanged = 0;
	    }
	    if (enemyAcceleration < -0.5) {
		_enemyTimeSinceDecelerationChanged = 0;
	    }
	    double timeSinceVelocityChanged = Math.min(_enemyTimeSinceAccelerationChanged, _enemyTimeSinceDecelerationChanged);
	    GFTWave wave = new GFTWave(_robot);
	    wave.setStartTime(actualTime);
	    wave.setBulletVelocity(FHUtils.bulletVelocity(myBulletPower));
	    wave.setGunLocation(myLocation);
	    wave.setStartBearing(enemyBearing);
	    wave.setTargetLocation(enemyLocation);
	    if (enemyAbsoluteVelocity > 0) {
		_lastBearingDirection = wave.maxEscapeAngle() * FHUtils.sign(enemyLateralVelocity);
	    }
	    double orbitDirection = _lastBearingDirection / (double) GFTWave.MIDDLE_BIN;
	    wave.setOrbitDirection(orbitDirection);
	    double wallDistance = wave.wallDistance(1, _battlefieldRectangle);
	    double reverseWallDistance = wave.wallDistance(-1, _battlefieldRectangle);
	    wave.accelIndex = _enemyTimeSinceAccelerationChanged == 0 ? 0 : _enemyTimeSinceDecelerationChanged == 0 ? 1 : 2;
	    wave.distanceIndex = FHUtils.index(GFTWave.DISTANCE_SLICES, enemyDistance);
	    wave.distanceIndexFaster = FHUtils.index(GFTWave.DISTANCE_SLICES_FASTER, enemyDistance);
	    wave.velocityIndex = FHUtils.index(GFTWave.VELOCITY_SLICES, enemyAbsoluteLateralVelocity);
	    wave.velocityIndexFaster = FHUtils.index(GFTWave.VELOCITY_SLICES_FASTER, enemyAbsoluteVelocity);
	    wave.velocityChangedIndex = FHUtils.index(GFTWave.TIMER_SLICES, timeSinceVelocityChanged / wave.travelTime());
	    wave.velocityChangedIndexFaster = FHUtils.index(GFTWave.TIMER_SLICES_FASTER, timeSinceVelocityChanged / wave.travelTime());
	    wave.wallIndex = FHUtils.index(GFTWave.WALL_SLICES, wallDistance);
	    wave.wallIndexFaster = FHUtils.index(GFTWave.WALL_SLICES_FASTER, wallDistance);
	    wave.reverseWallIndex = FHUtils.index(GFTWave.WALL_SLICES_REVERSE, reverseWallDistance);
	    wave.reverseWallIndexFaster = FHUtils.index(GFTWave.WALL_SLICES_REVERSE_FASTER, reverseWallDistance);
	    if (_robot.getOthers() > 0 && _lastBearingDirection != 0) {
		GFTWave.waves.add(wave);
	    }
	    GFTWave.updateWaves();
	    Point2D nextRobotLocation = FHUtils.project(myLocation, myHeading, myVelocity);
	    Point2D nextEnemyLocation = FHUtils.project(enemyLocation, enemyHeading, enemyVelocity);
	    double nextBearing = FHUtils.absoluteBearing(nextRobotLocation, nextEnemyLocation);
	    double guessedBearing = nextBearing + orbitDirection * (wave.mostVisited() - GFTWave.MIDDLE_BIN);
	    _robot.setTurnGunRightRadians(Utils.normalRelativeAngle(guessedBearing - _robot.getGunHeadingRadians()));
	    if (myEnergy >= 0.3 || enemyEnergy < myEnergy / 5 || enemyDistance < 120) {
		if (Math.abs(_robot.getGunTurnRemainingRadians()) < FHUtils.botWidthAngle(enemyDistance) / 2 && _robot.setFireBullet(myBulletPower) != null) {
		    wave.weight = 4;
		}
	    }
	    _enemyLastVelocity = enemyVelocity;
	    _lastScanTime = actualTime;
	    if (_enemyIsBulletCatcher) {
		_robot.turnGunRightRadians(_robot.getGunTurnRemainingRadians() + GUN_TURNING_BONUS_FOR_BULLET_HITTING_BOTS);
	    }
	}
    }

    public void onBulletHit(BulletHitEvent bulletHitEvent) {
	_numberOfBulletsHitEnemy++;
    }

    public void onBulletHitBullet(BulletHitBulletEvent bulletHitBulletEvent) {
	_numberOfBulletsHitBullets++;
	double numberOfFiredBullets = _numberOfBulletsHitBullets + _numberOfBulletsHitEnemy + _numberOfBulletsMissedEnemy;
	if (numberOfFiredBullets > 4) {
	    double ratioOfBulletsHitBullet = _numberOfBulletsHitBullets / numberOfFiredBullets;
	    if (ratioOfBulletsHitBullet > 0.5) {
		_enemyIsBulletCatcher = true;
	    } else {
		_enemyIsBulletCatcher = false;
	    }
	}
    }

    public void onBulletMissed(BulletMissedEvent bulletMissedEvent) {
	_numberOfBulletsMissedEnemy++;
    }

    double updateBulletPower(double distance, double enemyEnergy, double myEnergy) {
	double bulletPower = BULLET_POWER;
	double divisor = 5;
	if (distance < 130) {
	    bulletPower = Rules.MAX_BULLET_POWER;
	    divisor = 1;
	}
	bulletPower = Math.min(Math.min(enemyEnergy / 4, myEnergy / divisor), bulletPower);
	return bulletPower;
    }
}