package Krabb.sliNk;
import java.io.*;
import robocode.*;

class Network extends Data
{
	boolean solo=false;
	
	public void run()
	{
		super.run();
		if(getTeammates()==null)
			solo=true;
	}
	
	public void onMessageReceived(MessageEvent e)
	{
		Message m = (Message) e.getMessage();
		if(m.type == Message.MS_SCAN)
		{
			Stats s = (Stats) m.object;
			newEnemyStats(s);
//			System.out.println(getTime()+"new Enemy Scan"+s.name);
		}
		if(m.type == Message.MS_BULLET_NEW)
		{
//			System.out.println(getTime()+"new Mate Bullet from "+((MyBullet) m.object).getName());
			MyBullet b = (MyBullet) m.object;
			newMateBullet(b);
		}
		if(m.type == Message.MS_BULLET_HIT)
		{
			MyBullet b = (MyBullet) m.object;
			Mate ma = getMate(b.getName());
			ma.bulletHit(b);
		}
		if(m.type == Message.MS_HIT_BY_BULLET)
		{
			HitPar par = (HitPar) m.object;
			Enemy en = getEnemy(par.name);
			en.newHit(par);
		}
						//			newEnemyStats((Stats)m.object);
		if(m.type == Message.MS_MATE)
		{
			Stats s = (Stats) m.object;
			newMateStats(s);
//			System.out.println(getTime()+"new Mate Stats "+s.name);
		}
	}
	
	protected void step()
	{
		super.step();
		boadcast(Message.MS_MATE,getMate(getName()).getStats(0));
	}
	
	public void onScannedRobot(ScannedRobotEvent e) 
	{
		if(!isTeammate(e.getName()))
		{
			super.onScannedRobot(e);
			boadcast(Message.MS_SCAN,getEnemy(e.getName()).getStats(0));
//			System.out.println(getTime()+" Scaned Robot "+e.getName());
		}
	}
	
	public Bullet setFireBullet(double p)
	{
		Bullet b = super.setFireBullet(p);
		if(b!=null)
		{
//			System.out.println("bla");
			boadcast(Message.MS_BULLET_NEW,new MyBullet(b,this));
		}
		return b;
	}
	
	public void onBulletHitBullet(BulletHitBulletEvent e)
	{
		super.onBulletHitBullet(e);
		Mate m = getMate(getName());
		MyBullet b= m.getOwnBullet(e.getBullet());
		m.bulletHit(b);
		boadcast(Message.MS_BULLET_HIT,new MyBullet((MyOwnBullet)b));
	}
	
	public void onBulletHit(BulletHitEvent e)
	{
		super.onBulletHit(e);
		Mate m = getMate(getName());
		MyBullet b= m.getOwnBullet(e.getBullet());
		m.bulletHit(b);
		boadcast(Message.MS_BULLET_HIT,new MyBullet((MyOwnBullet)b));
	}
	
	public void onHitByBullet(HitByBulletEvent ev)
	{
		super.onHitByBullet(ev);
		if(isTeammate(ev.getName()))
			return;
		Enemy e = (Enemy)enemies.get(ev.getName());
		if(e==null)
		{
			System.out.println("blaopwei");
			return;
		}
		HitPar par = new HitPar(this,e,ev);
		e.newHit(par);
		//fr tote mates mssten stats gespeichert werden und in nchster runde zugeschickt werden
		boadcast(Message.MS_HIT_BY_BULLET,par);
	}
	
	protected void boadcast(int typ, Serializable o)
	{
		if(solo)
			return;
		try{
			broadcastMessage(new Message(typ,o));}
		catch (IOException ex){
			System.out.println("Error sending Object:" + ex);}
	}
}



class Message implements Serializable
{
	int type;
	static final int MS_NONE = 0;
	static final int MS_SCAN = 1;
	static final int MS_MATE = 2;
	static final int MS_BULLET_NEW = 3;
	static final int MS_BULLET_HIT = 4;
	static final int MS_HIT_BY_BULLET = 5;
		Serializable object;	
	
	Message(int type, Serializable object)
	{
		this.type = type;
		this.object = object;	
	}
}