package bvh.hdr;

/**********************************************************************
** Constanten zijn apart vastgelegd in interface
**********************************************************************/
interface Constanten {
// Goniometrische constanten:
   static final double TWEEPI               = 2*Math.PI; // 360 graden
   static final double PI                   =   Math.PI; // 180 graden
   static final double HALFPI               =   Math.PI/2D; // 90 graden
   static final double KWARTPI              = Math.PI/4D;// 45 graden
   static final double EENZESTIENDEPI       = Math.PI/16D;// 11.25 graden
//
   static final double MAXIMUM_SNELHEID     = 8D; 
   static final double BOTGROOTTE           = 36D; 
   static final double STANDAARDSTRAAL      = 190D;     // straal van de draaicirkel
   static final double WANDAFSTAND          = 36D;      // minimale afstand tot wand: anders bewegingsrichting omkeren
   static final double RONDING              = 108D;     // ronding van slagveld
   
   static final long   KORTEPROBEERTIJD     = 30;       // tijd waarna verzamelde doel-info wordt verondersteld verouderd te zijn.
   static final long   LANGEPROBEERTIJD     = 90;       // tijd waarna verzamelde doel-info wordt verondersteld verouderd te zijn.
   
   static final int    DEBUGMODE            = 1;        // 0: geen debug meldingen, 1: doel/schiet-info, 2: incl. bewegingsinfo, 3: alle info
}
