package dam.movement;

import java.util.Random;

import dam.MasterBot;

public abstract class MovementStrategy
{
	private long moveCount = 0;
	protected MasterBot bot;
	protected int direction = 1;
	protected Random rand = new Random();
	public static double PI = Math.PI;
	
	public MovementStrategy(){}
	
	public void setBot(MasterBot bot){ this.bot = bot; }
	
	public MovementStrategy(MasterBot bot){
		this.bot = bot;
	}
	
	public double getBattleFieldWidth(){ return bot.getBattleFieldWidth(); }
	public double getBattleFieldHeight(){ return bot.getBattleFieldHeight(); }
	public double getX(){ return bot.getX(); }
	public double getY(){ return bot.getY(); }
	
	public long getTime(){ return bot.getTime(); }
	
	public void setTurnRightRadians(double rads){ bot.setTurnRightRadians(rads); }
	public void setAhead(double dist){ bot.setAhead(dist); }
	
	public boolean isMoveDone(){ return moveCount < getTime(); }
	
	/**
	* Set the amount of time before the move is due to end. Usually
	* called at the end of the doMove() function
	*/
	public void setMoveCount(long count){ moveCount = count; }
	public long getMoveCount(){ return moveCount; }
	public void setDirection(int dir){ direction = dir; }
	public int getDirection(){ return direction; }
	public MasterBot getBot(){ return bot; }
	
	/**
	* Default implementation sets the speed of the bot to 8 when you have finished turning
	*/
	public void onTurnComplete(){
		bot.setMaxVelocity(8);
	}
	
	/**
	* You probably want to change direction at this point, but you might want to do
	* anything else
	*/
	public void onNearWall(){
		doMove();
	}
	
	/**
	* When you have finished your move, doMove is called by default, so that you
	* will move again
	*/
	public void onMoveComplete(){
		doMove();
	}
	
	public abstract void doMove();
	

}