package dam.util;

import java.io.*;

/**
 * GridPoint.java
 * Holds an x coordinate and a y coordinate, along with an extra variable such
 * as power - useful for tracking bullets, and for using with the AntiGravity class
 * 
 * @author David Mold
 *
 * Jun 28, 2002
 */
public class GridPoint extends BotPoint
{
	public double power = 0;
	
	public GridPoint(double x, double y)
	{
		super(x, y);
	}
	
	public GridPoint(double x, double y, double power)
	{
		super(x, y);
		this.power = power;
	}
	
	public void setPower(double d){ power = d; }
	public double getPower(){ return power; }
}