package dft;
import robocode.*;
import java.awt.Color;
import java.awt.geom.*;
import java.util.*;
/*
 * Krazy - a robot by Alcatraz271
 * Released under the RWPCL (robowiki.net)
 */
public class Krazy extends Robot {
	
	int dir = 1;
	int work = 1;
	String enemyName;	
	double enemyDistance;
	double enemyDirection = 1;
	double moveTime = 0;
	static int[][][][][] stats = new int[3][4][5][10][25];
	ArrayList waves = new ArrayList();
	double e_x,e_y,m_x,m_y;
	Rectangle2D battleField;
	double finAng;
	double length;

public void run() {
		enemyName = null;		
		enemyDistance = 10000;
		battleField = new Rectangle2D.Double(18, 18, getBattleFieldWidth()-36,  getBattleFieldHeight()-36);		
		setAdjustGunForRobotTurn(true);
		setColors(new Color(50,150,250), new Color(0,100,200), new Color(0,50,250));
		turnRadarRight(Double.POSITIVE_INFINITY);//PEZ		
}
public void onScannedRobot(ScannedRobotEvent e) {	
	double absBearing = R(e.getBearing()+getHeading());		
	if (e.getDistance() < enemyDistance - 100) {
		enemyName = e.getName();	
		enemyDistance = e.getDistance();
	}	
if (enemyName == e.getName()) {		
	enemyDistance = e.getDistance();
	e_x = (m_x = getX()) + Math.sin(absBearing) * e.getDistance();
	e_y = (m_y = getY()) + Math.cos(absBearing) * e.getDistance();
	Point2D my_location = new Point2D.Double(getX(),getY());
	Point2D enemy_location = project(my_location,absBearing,e.getDistance());
	
		double bulletPower = 2.4;
		if (e.getDistance() < 360) bulletPower = 3.0;
	
		bulletPower = Math.min(e.getEnergy() / 4-0.5, Math.min(getEnergy() / 3, bulletPower));
		double bulletSpeed = 20 - (3*bulletPower);		
		double latVelocity = Math.sin(R(e.getHeading())-absBearing)*e.getVelocity();
		
		if (latVelocity != 0)
		enemyDirection = (latVelocity < 0)?-1:1;
		double realDirection = Math.asin(9/bulletSpeed)*enemyDirection;
		
		int wall = battleField.contains(project(my_location, absBearing + realDirection, e.getDistance())) ? 0 : battleField.contains(project(my_location, absBearing + .5*realDirection, e.getDistance())) ? 1 : 2;
	
		int latv = (int)(Math.min(3,Math.abs(latVelocity/2)));
				
				
		int vel = (int)(Math.abs(e.getVelocity()))/2;
		int distance = Math.min(8,(int)(e.getDistance()/180));
		
		int i=0;
		while (i < waves.size()) {
			Wave b = (Wave)waves.get(i);
			int ind;
			if ((ind = Math.min(24, b.update(e_x, e_y, getTime()))) >= 0) {
				stats[b.wall][b.latv][b.vel][b.distance][ind]++;
				waves.remove(i);
			}
			else
				i++;			
		}
	if ((getEnergy() > 3 || getEnergy() > e.getEnergy()) && e.getEnergy() > 0) {
		Wave w;
		waves.add(w = new Wave());
		w.distance = distance;
		w.latv = latv;
		w.wall = wall;
		w.vel = vel;
		w.bearing = absBearing;
		w.direction = realDirection;
		w.x1 = m_x;
		w.y1 = m_y;
		w.x2 = e_x;
		w.y2 = e_y;
		w.fire_time = w.last_time = getTime();
		w.velocity = bulletSpeed;
	}	
	if (getGunHeat() <= 0 || work == 1) {
		work = 0;	
		int[] current;
		current = stats[wall][latv][vel][distance];
		
		int best_index = 12; 
		do	{
			if (current[i]>current[best_index]) {
				best_index = i;
			}
			i++;
		}
		while(i<25);
		double gunAngle = D(robocode.util.Utils.normalRelativeAngle(absBearing-R(getGunHeading())+realDirection*((double)best_index/12.0-1)));
		if (gunAngle > 0) setAdjustRadarForGunTurn(false);
		else setAdjustRadarForGunTurn(true);
		if ((getEnergy() > 0.1 || getEnergy() > e.getEnergy())) {
			turnGunRight(gunAngle);
			fire(bulletPower);		
		}
		if (moveTime < 10) {	
			if (0.1 > (Math.random()*Math.sqrt(e.getDistance())/120)||(90-Math.abs(90-Math.abs(e.getBearing()))<30)) dir = -dir;	
			Point2D destination;	
			double angle = Math.PI/2+Math.PI/12; //Jamougha
			while (!battleField.contains(destination = project(my_location, absBearing + dir*(angle-=0.002), 200)));
			finAng = absoluteBearing(my_location, destination) - R(getHeading());		 
			if (D(Math.tan(finAng)) > 0) setAdjustRadarForRobotTurn(false);
			else setAdjustRadarForRobotTurn(true);
			turnRight((Math.max(-45,Math.min(45,D(Math.tan(finAng))))));
			moveTime += 5;
		}
		else {
			doTheAhead(e);
		}
	}
	else {
		doTheAhead(e);
	}
}
}
public void doTheAhead(ScannedRobotEvent e) {
	moveTime = 0;
	length = .6*(10+Math.random()*40)+.45*(Math.random()*400);		
	ahead(Math.cos(finAng)*length);
}
public void onRobotDeath(RobotDeathEvent e) {
	if (e.getName() == enemyName) enemyDistance = 10000;
}
public void onWin(WinEvent e) {
	
}
public void onDeath(DeathEvent e) {
		
}
public Point2D project(Point2D location, double angle, double distance) {
	return new Point2D.Double(location.getX() + Math.sin(angle) * distance, location.getY() + Math.cos(angle) * distance);
}
private static double absoluteBearing(Point2D source, Point2D target) {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
   }
public void onHitWall(HitWallEvent e) {		
		ahead((dir = -dir)*50);
		moveTime += 2;
}
public double nd(double angle) {	
		return ((angle + 900) % 360) - 180;
} 
public double D(double angle) {
		return angle*180/Math.PI;
}
public double R(double angle) {
		return angle/180*Math.PI;
}
}
class Wave { //Kawigi
		double x1, y1, x2, y2;
		double bearing, velocity, direction;	
		double fire_time, last_time;		
		int wall, latv, distance, vel;		
		public int update(double x, double y, double time)	{
			double dtime = time - last_time;
			double dx = (x-x2)/dtime;
			double dy = (y-y2)/dtime;
			do	{
				if (Point2D.distance(x2, y2, x1, y1) <= velocity*(last_time-fire_time))  	
					return (int)(Math.round((1+robocode.util.Utils.normalRelativeAngle(Math.atan2(x2-x1, y2-y1)-bearing)/direction)*12));
				last_time++;
				x2+=dx;
				y2+=dy;
			}
			while (last_time < time);			
			return -1;
		}
}