package blr;
import robocode.*;
import java.awt.Color;
import java.awt.Shape;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import static robocode.util.Utils.normalRelativeAngle;
import static robocode.util.Utils.normalRelativeAngleDegrees;

// API help : http://robocode.sourceforge.net/docs/robocode/robocode/Robot.html

/**
 * MyTestRobot - a robot by yauheni martman
 */
public class Chicken001 extends AdvancedRobot
{
	private static int RADAR_IDLE_TIME=33;
	private static int WALL_HIT_TIME=33;
	private static double FIRE_NORMAL_DISTANSE=100;
	private static double FIRE_MAX_DISTANSE=300;
	private static int FIRE_MINIUM_DISTANSE=20;
	private double gunHead;
	private double bodyHead;
	private double radarHead, xPos, yPos, bfWidth, bfHeight,bearingAlpha;
	private long hitTime,hitWallTime,missCount,fireTime;
	private String agressor;
	
	private boolean EnemyDetected;

	/**
	 * Resolve statistics about tank
	 */
	private void getStat(){
		 //position
		 xPos=getX();
		 yPos=getY();		
		 //rotation
	     gunHead=getGunHeading(); 
		 bodyHead=getHeading();
		 radarHead=getRadarHeading();
	}

	public void initialization(){
		 //Tank visualization
		 setColors(Color.red,Color.black,Color.green); // body,gun,radar
		 setScanColor(Color.orange);	
		 //Flag initialization
		 EnemyDetected=false;	
		 
		 bfHeight=getBattleFieldHeight();
		 bfWidth=getBattleFieldWidth();		 
    	 hitTime=0;
		 fireTime=0;
		 hitWallTime=0;
		 bearingAlpha=0;
		 missCount=0;
		 //robot settings
		 setAdjustGunForRobotTurn(true);
         setAdjustRadarForGunTurn(true);
         setAdjustRadarForRobotTurn(true);		 
 
		 getStat();
		 logBasicInfo();
	}
	
	/**
	 * run: MyTestRobot's default behavior
	 */
	public void run() {
		 out.println("Here is test bot");
		 initialization();
		while(true) {
			movement();
			detection();
			getStat();
			execute();
		}
	}
	
	public void detection(){	
		if ((getTime()-hitTime)>RADAR_IDLE_TIME){
			EnemyDetected=false;
		}
		if (!EnemyDetected){
			turnRadarRight(45);
			turnRadarLeft(90);
		}
	}
	
	public void movement(){
		ahead(10);
		turnRight(10);
		if (missCount>1){
			out.println("relocation!!");
			setAhead(Double.POSITIVE_INFINITY);
		}

	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		if (e.getName().equalsIgnoreCase(agressor)||agressor==null){		

		double angleToEnemy = getHeadingRadians() + e.getBearingRadians();
		double radarTurn = normalRelativeAngle( angleToEnemy - getRadarHeadingRadians() );
		double gunTurn = normalRelativeAngle( angleToEnemy - getGunHeadingRadians() );
		bearingAlpha=getHeadingRadians()-e.getBearingRadians();
		setTurnRadarRightRadians(radarTurn);
		setTurnGunRightRadians(gunTurn);
		out.println("alpha = "+bearingAlpha);
		if (Math.abs(bearingAlpha)>Math.PI/10)
		if(e.getDistance() < FIRE_NORMAL_DISTANSE){
			setTurnRightRadians(e.getBearingRadians()-(Math.PI/2));
		}else{
			setTurnRightRadians(e.getBearingRadians());
		}
		if (e.getVelocity()>6||(e.getDistance() > FIRE_MAX_DISTANSE)||getVelocity()<0.1){
			setAhead(200);
			setMaxVelocity(e.getVelocity()+1);
			}
		if ((e.getDistance() < FIRE_MAX_DISTANSE)&&fireTime==getTime())
		if(e.getDistance() < FIRE_NORMAL_DISTANSE && (getEnergy() > 40 || e.getEnergy() < 40 )){
			setFire(3);
			}else setFire(1);
;
		EnemyDetected=true;
		manageEnemyInfo(e);
		fireTime=getTime()+1;
		}
	}
	
	public void onBulletMissed(BulletMissedEvent event) {
       EnemyDetected=false;
	   missCount++;
   	}
	
	public void onBulletHit(BulletHitEvent event) {
       hitTime=getTime();
	   missCount=0;
   }

	/**
	 * onHitWall: What to do when you hit a wall
	 */
	public void onHitWall(HitWallEvent e) {
		// Replace the next line with any behavior you would like
		if ((getTime()-hitWallTime)>WALL_HIT_TIME){
			setTurnRightRadians(e.getBearingRadians()-(Math.PI/2));
			setBack(50);
		}else{
			setTurnLeftRadians(e.getBearingRadians()-(Math.PI/2));
			setBack(50);	
		}
		hitWallTime=getTime();
	}
	
	public void onHitByBullet(HitByBulletEvent event) {
       agressor = event.getName();
    }
	
	/**
	 * onHitRobot:  Aim at it.  Fire Hard!
	 */
	public void onHitRobot(HitRobotEvent e) {
		double turnGunAmt = normalRelativeAngleDegrees(e.getBearing() + getHeading() - getGunHeading());

		turnGunRight(turnGunAmt);
		fire(3);
	}
	
	 public void onPaint(Graphics2D g) {
    	 // Set the paint color to red
    	 g.setColor(java.awt.Color.RED);
	     //FIRE_NORMAL_DISTANSE
		 drawCircle(g,FIRE_NORMAL_DISTANSE,xPos,yPos);
		 g.setColor(java.awt.Color.BLUE);
		 drawCircle(g,FIRE_MAX_DISTANSE,xPos,yPos);
	 }	
	 
	public void drawCircle(Graphics2D g, double radius,double x, double y){
		Shape shape = new Ellipse2D.Double(x-radius,y-radius,
						radius*2,radius*2);
	    g.draw(shape);
	}
	
	/**
	 * Get Details about robot state into log
	 */
	public void logBasicInfo(){
		out.println("Body heading : "+bodyHead);
		out.println("Gun heading  : "+gunHead);
		out.println("Radar heading: "+radarHead);
		out.println("Position : "+xPos+", "+yPos);
	}
	
	public void manageEnemyInfo(ScannedRobotEvent e){
		out.println("Enemy Name: "+e.getName());
		out.println("Enemy speed: "+e.getVelocity());
		out.println("Enemy heading: "+e.getHeading());		
	}
}
																   			 						   					