package nat.nano;

import robocode.AdvancedRobot;
import robocode.HitWallEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class OcnirpPM extends AdvancedRobot {

	/**
	 * Size of pattern to match. 45 is the maximum value or robot will skip a
	 * turn in unacceptable rate. 30 is a standard value.
	 * 
	 * ^ With old subtract-by-1 method, new one with divide-by-2 has no bound in 35 rounds game.
	 */
	private static final int PATTERN_DEPTH = 512;
	
	/**
	 * If Math.random() exceed this number, the robot will change the direction.
	 */
	private static final double CHANGE_INTERVAL = 0.92;

	/**
	 * Fire power, it used to be 2.5, but my crazy part of my brain told me to
	 * reduce this a bit.
	 */
	private static final double FIRE_POWER = 2.5d;
	
	/**
	 * Bullet velocity. It should be {@code 20 - 3 * FIRE_POWER}, but my crazy
	 * part of my brain told me to leave this 12.5
	 */
	private static final double BULLET_VELOCITY = 12.5d;
	
	/**
	 * A static variable to keep which direction it is moving.
	 */
	private static int dir = 100;
	
	/**
	 * Main robot method. For nanobot, this contains only radar control.
	 */
	public void run() {
		setAdjustGunForRobotTurn(true);
		// setAdjustRadarForGunTurn(true);
		turnRadarRightRadians(Double.POSITIVE_INFINITY);
	}
	
	/**
	 * What to do when you see another robot.
	 * 
	 * Main robot operation method for almost all nano/micro/mini robots.
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		/*
		 * Variable order here is important. We can save ~3-4 bytes here. since
		 * all math operation must be done on registers. Java virtual machine
		 * has 4 register slot. First register will be taken by {@code this}
		 * object. Then each parameters will take the rest of registers. If
		 * there are any registers left, the variables defined in the method is
		 * filled the register until it full. Every type will take 1 registers
		 * except double, which take 2. If double is the fourth variable
		 * defined, it will overflow to the extra fifth register.
		 * 
		 * So, the most
		 * used variable should define first, which will be enemy absolute
		 * bearing in most cases. In this case, we define most used int before
		 * and make double overflow its register.
		 */
		//int matchLen = Math.min(PATTERN_DEPTH, (int)getTime());	// PM Stuff
		int matchLen = PATTERN_DEPTH;	// PM Stuff
		double angle;					// enemy absolute bearing
		double dist;					// enemy distance
		int matchPos;					// PM Stuff
		
// ///////////////////////////////////////////////////////////////////////////////
// Radar
//
// Do infinity lock
		setTurnRadarLeftRadians(getRadarTurnRemaining());
// ///////////////////////////////////////////////////////////////////////////////

// ///////////////////////////////////////////////////////////////////////////////
// Movement (Perpendicular and Random)
//
		setTurnRightRadians(Math.cos(angle = e.getBearingRadians()));
//
// Move ahead
//
		setAhead(dir);
//
// If random() exceed the change interval
//
		if (Math.random() > CHANGE_INTERVAL) {
//
// Reverse direction
// Optimize to
//
			onHitWall(null);
//			
// Velocity trick
			//setMaxVelocity(Math.random() * VELOCITY_MULTIPILER + 1);
//
		}
//
// ///////////////////////////////////////////////////////////////////////////////

// ///////////////////////////////////////////////////////////////////////////////
// Lateral Velocity & Advancing Velocity Pattern Matching Gun
// Based on Eric Simonton's and Julien Kent's gun
//
// Define counter
//
		int i;
//		double v;
//
// Append enemy log
// (dist store Angle Offset here)
//
		enemyHistory = String.valueOf((char) (((int) Math
				.round(e.getVelocity()
						* Math.sin(dist = e.getHeadingRadians()
								- (angle += getHeadingRadians()))) << 8) | (0xFF & ((byte) Math
				.round(e.getVelocity() * Math.cos(dist)))))).concat(
				enemyHistory);
//
// Match the history
//
		while ((matchPos = enemyHistory.indexOf(enemyHistory.substring(0,
				matchLen /= 2), i = (int) (((dist = e.getDistance()) / BULLET_VELOCITY)-1))) < 0)
			;
//
// Get the firing angle
//
		//char currentChar;
		// angleOffset now store the bullet distance
		//v = 0;
		do {
			angle += (byte) ((/*currentChar = */enemyHistory.charAt(--matchPos)) >> 8)
					/ dist;
			//dist += (byte) (currentChar & 0xFF);
		} while (/*(v += BULLET_VELOCITY) < dist &&*/ --i > 0);
//
// Turn the gun
//
		setTurnGunRightRadians(Utils.normalRelativeAngle(angle
				- getGunHeadingRadians()));
//
// Fire
//
		//if (dist < 140) setFire(3d);
		//else
		setFire(FIRE_POWER);
//
// ///////////////////////////////////////////////////////////////////////////////
	}
	
	/**
	 * When hit wall, reverse direction
	 */
	public void onHitWall(HitWallEvent e) {
		dir = -dir;
	}
	
	/**
	 * Enemy history string. Preload to prevent StringIndexOutOfBoundException.
	 */

	private static String enemyHistory = "" + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 256 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 512 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) -256 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) 0
			+ (char) 0 + (char) 0 + (char) 0 + (char) 0 + (char) -256 + (char) -1024
			+ (char) -1536 + (char) -2048 + (char) -2048 + (char) -2048 + (char) -2048
			+ (char) -2048 + (char) -2048 + (char) -2048 + (char) -2048 + (char) -2048
			+ (char) -2048 + (char) -2048 + (char) -2048 + (char) -2048 + (char) -2048
			+ (char) -2048 + (char) -2048 + (char) -2048 + (char) -2048 + (char) -2048
			+ (char) -2048 + (char) -2048 + (char) -2048 + (char) -2048 + (char) -2048
			+ (char) -2048 + (char) -2048 + (char) -2048 + (char) -2048 + (char) -2048
			+ (char) -2048 + (char) -2048 + (char) -2048 + (char) -2048 + (char) -2048
			+ (char) -2048 + (char) -2048 + (char) -2048 + (char) -2048 + (char) -2048
			+ (char) -2048 + (char) -1792 + (char) -1536 + (char) -1280 + (char) -1024
			+ (char) -768 + (char) -512 + (char) -256 + (char) 0 + (char) 512
			+ (char) 1024 + (char) 1536 + (char) 2048 + (char) 2048 + (char) 2048 + (char) 2048
			+ (char) 2048 + (char) 2048 + (char) 2048 + (char) 2048 + (char) 2048 + (char) 2048
			+ (char) 2048 + (char) 2048 + (char) 2048 + (char) 2048 + (char) 2048 + (char) 2048
			+ (char) 2048 + (char) 2048 + (char) 2048 + (char) 2048 + (char) 2048 + (char) 2048
			+ (char) 2048 + (char) 2048 + (char) 2048 + (char) 2048 + (char) 2048 + (char) 2048
			+ (char) 2048 + (char) 2048 + (char) 2048 + (char) 2048 + (char) 2048 + (char) 2048
			+ (char) 2048 + (char) 2048 + (char) 2048 + (char) 2048 + (char) 2048 + (char) 2048
			+ (char) 2048 + (char) 1762 + (char) 1536 + (char) 1280 + (char) 1024 + (char) 768
			+ (char) 512 + (char) 256 + (char) 0;
}
