package maribo;

import java.awt.geom.Point2D;
import java.util.ArrayList;

import maribo.utils.MoveSimStat;

class VirtualBullet extends Point2D.Double {
	private static final long serialVersionUID = 5543275718954784509L;
	public Gun gunUsed;
	double heading;
	double velocity;
	public VirtualBullet() {}
	public VirtualBullet(VirtualBullet old) {
		this.setLocation(new Point2D.Double(old.x, old.y));
		this.gunUsed = old.gunUsed;
		this.heading = old.heading;
		this.velocity = old.velocity;
	}
}

class Enemy extends Point2D.Double {
	private static final long serialVersionUID = 2073938759775539565L;
	double deltaHeading;
	double energy;
	long timeSeen;
	double heading;
	double velocity;
	public void updateAll(Point2D.Double pos, double heading,
			double velocity, long timeSeen, double energy) {
		this.setLocation(pos);
		this.deltaHeading = (this.heading - (this.heading = heading))/(this.timeSeen - (this.timeSeen = timeSeen));
		this.velocity = velocity;
		this.energy = energy;
	}
	public Enemy() {}
	public Enemy(Enemy old) {
		this.setLocation(old.x, old.y);
		this.heading = old.heading;
		this.velocity = old.velocity;
	}
}

class TestPoint extends Point2D.Double {
	private static final long serialVersionUID = 2263287342279170190L;
	double eval;
	ArrayList<MoveSimStat> move;
	boolean moveHitWall;
}