package jgap;

import robocode.*;
import java.awt.Color;
import java.awt.geom.*;

public class JGAP23423
    extends AdvancedRobot {
  private double global1 = 3.0;
  static double x = 2.0;
  static double y = 1.0;
  static double distance = -1.0;
  static double[] memory = new double[50];

  public void run() {
    setColors(Color.red, Color.blue, Color.green);
    setAdjustRadarForGunTurn(true);
    do {
      turnRadarRightRadians(Double.POSITIVE_INFINITY);
    }
    while (true);
  }

  public void onScannedRobot(ScannedRobotEvent e) {
    x = getHeading() + e.getBearing();
    y = getRadarTurnRemaining();
    distance = e.getDistance();
    double z = 1.0d;
    {
      {
        turnGunRight(getHeading() + e.getBearing() - getGunHeading());
        setAhead(1000 / Math.sin(e.getEnergy() / 2));
      }

      setTurnRadarRight(getGunHeading());
      {
        {
          setAhead(e.getHeading());
          setTurnLeft(getRadarHeading());
          setTurnRight(getGunTurnRemaining());
          setFireBullet( (9.237308502197266d));
          setTurnGunLeft( (memory[ (getRoundNum() + (2))] * getHeading()));
        }

        global1 = getHeading();
      }

      setFire(memory[ (0)]);
    }
  }

  public void onHitByBullet(HitByBulletEvent e) {
    {
      setTurnRight( ( ( -45d) - getGunCoolingRate()));
      setFireBullet(getGunTurnRemaining());
      setFireBullet(getGunHeading());
    }
  }

  public void onHitWall(HitWallEvent e) {
    {
      setTurnLeft( (10.0d));
      setAhead( (10.0d));
    }
  }

  public void onHitRobot(HitRobotEvent e) {
    setTurnLeft( (getGunHeat() + (getHeading() - getRadarHeading())));
  }

}
