package tm;

import java.util.*;

/********************************************************************
* EnemyHistory4.java -- Gʒu̗pOobt@
*                       MogBot ̃p^[}b`O
*
* Date:		2002/Dec/05
* Author:	Matunaga Takateru@RISE, Eng, Kagawa Univ.
*
********************************************************************/
public class EnemyHistory4 {
//	Point[] po;
	double[] heading;				//Gheading
//	double[] distance;
//	double[] absoluteBearing;		//猩G̐Ε
	long[] time;
	double[] velocity;
	double[] diffHeading;			//Headingω
	int startIndex = -1;
	int endIndex = -1;
//	double maxAngle, minAngle;
//	int maxIndex, minIndex;
	int size;
	int dataSize = 0;			//ۂ̃f[^
	
	//------------------------------------------------------------------
	// constructor
	//
	//
	//------------------------------------------------------------------
	public EnemyHistory4(int n) {
//		po = new Point[n];
		heading = new double[n];
//		distance = new double[n];
		time = new long[n];
//		absoluteBearing = new double[n];
		velocity = new double[n];
		diffHeading = new double[n];
		size = n;
	}

	
	//------------------------------------------------------------------
	//
	//
	//
	//------------------------------------------------------------------
	void put(double x, double y, double distance, double velocity, double heading, double bearing, long t) {
		int lastIndex = endIndex;
		
		if (dataSize < size) dataSize++;
			
		if (startIndex == -1 && endIndex == -1) {
			startIndex = endIndex = 0;
		} else {
			if (t - time[endIndex] != 1) {
//M.print("currTime = " + t);
//M.print("endIndex time[endIndex] = " + endIndex + " " + this.time[endIndex]);
//if (endIndex > 0)
//	M.print("endIndex-1 time[endIndex-1] = " + (endIndex-1) + " " + this.time[endIndex-1]);
//M.print("currH V = " + heading + " " + velocity);

				//L^ԂsA̎CL^
				double dt = t - time[endIndex];
				double dh = (heading - this.heading[endIndex]) / dt;
				double dv = (velocity - this.velocity[endIndex]) / dt;
				for (int i = 0; i < dt - 1; i++) {
					endIndex = (endIndex+1) % size;
					if (endIndex == startIndex) {
						startIndex = (startIndex+1) % size;
					}
					this.time[endIndex] = this.time[lastIndex] + 1;
					this.diffHeading[endIndex] = dh;
					this.heading[endIndex] = this.heading[lastIndex] + dh;
					this.velocity[endIndex] = this.velocity[lastIndex] + dv;
					lastIndex = (lastIndex + 1) % size;
					if (dataSize < size) dataSize++;
//M.print("idx time dHead head velo = " + endIndex + " " + this.time[endIndex] + " " + this.diffHeading[endIndex] + " " + this.heading[endIndex] + " " + this.velocity[endIndex]);
				}
			}
			
			endIndex = (endIndex+1) % size;
			if (endIndex == startIndex) {
				startIndex = (startIndex+1) % size;
			}
		}
					
//		this.po[endIndex] = new Point(x, y);
//		this.distance[endIndex] = distance;
		this.time[endIndex] = t;
//		this.absoluteBearing[endIndex] = bearing;
//		if (velocity >= 0) {
//			this.heading[endIndex] = heading;
//		} else {
//			this.heading[endIndex] = (heading + 180) % 360;		
//		}
		this.velocity[endIndex] = velocity;
		this.heading[endIndex] = heading;
		if (lastIndex < 0)
			this.diffHeading[endIndex] = 0;
		else
			this.diffHeading[endIndex] = heading - this.heading[lastIndex];
	}
}