/*
 * Created on 01-nov-2004
 * $Id: SurferBot.java,v 1.1.2.1 2004/11/01 14:31:12 lolo Exp $
 */
package mnt;

import robocode.*;

import mnt.utils.*;

import java.util.*;
import java.awt.Color;

/**
 * @author lolo
 */
public class SurferBot extends AdvancedRobot {
	WaveGun wg;

	MovimientoMinimoRiesgo mmr;

	Radar r = new Radar(this);

	Random rn = new Random();

	public void run() {
		wg = new WaveGun(this);
		mmr = new MovimientoMinimoRiesgo(this);
		setColors(new Color(rn.nextInt(255), rn.nextInt(255), rn.nextInt(255)),
				new Color(rn.nextInt(255), rn.nextInt(255), rn.nextInt(255)),
				new Color(rn.nextInt(255), rn.nextInt(255), rn.nextInt(255)));
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		addCustomEvent(new CondicionDeGiroDeRadarCompleto(this));
		setTurnRadarRight(360);
		while (true)
			execute();
	}

	public void onScannedRobot(ScannedRobotEvent e) {
		Enemigo en = new Enemigo(e, this);
		r.setObjetivo(en);
		mmr.onScannedRobot(e);
		wg.onScannedRobot(e);
		mmr.hacerMovimiento();
	}

	public void onHitByBullet(HitByBulletEvent e) {
		mmr.onHitByBullet(e);
	}

	public void onSkippedTurn(SkippedTurnEvent e) {
		System.out.println("Skipped turn");
	}

	public void onCustomEvent(CustomEvent e) {
		if (e.getCondition() instanceof CondicionDeGiroDeRadarCompleto)
			r.hacerGiro();
	}
}