/*
 * 
 * davidalves.net presents:
 * ________                  .__   .__           __    _______                           
 * \______ \   __ __   ____  |  |  |__|  _______/  |_  \      \  _____     ____    ____  
 *  |    |  \ |  |  \_/ __ \ |  |  |  | /  ___/\   __\ /   |   \ \__  \   /    \  /  _ \ 
 *  |    `   \|  |  /\  ___/ |  |__|  | \___ \  |  |  /    |    \ / __ \_|   |  \(  <_> )
 * /_______  /|____/  \___  >|____/|__|/____  > |__|  \____|__  /(____  /|___|  / \____/ 
 *         \/             \/                \/                \/      \/      \/         
 * 
 * 
 * The aim sucks, but good luck targeting it with a nano-sized gun. :-)
 * Gets firing assistance since the radar and gun are aligned (due to a bug in Robocode).
 * It won't win the minibot challenge since it can't hit the bullet dodgers, but it should
 * do quite well in the Eternal Rumble.
 * 
 */


package davidalves.net;

import java.awt.Color;
import java.awt.geom.Point2D;

import robocode.*;

public class DuelistNano extends AdvancedRobot{
	
	static double timer;
	
	/*
	 * Must be between 1 and PI/2. Values closer to PI/2 will
	 * make us stay more perpendicular but might cause skipped turns.
	 */
	static final double ANGULAR_TOLERANCE = 1.45;
	
	public void run(){
		
		setColors(Color.darkGray, Color.darkGray, Color.cyan);
		
		setTurnGunRight(Double.POSITIVE_INFINITY);
	}
	
	public void onScannedRobot(ScannedRobotEvent e){
		double distRemaining, absoluteBearing, destinationX, destinationY, myX, myY, normalizedTurnAngle=0, turnAngle=0, attackAngle = Double.NEGATIVE_INFINITY;
		
		//Aiming... who needs it? Just wiggle the gun back and forth.
		setTurnGunLeft(getGunTurnRemaining());
		
		/*
		 * This next line is my entry for the Nanobot hall of fame in the category "Biggest, fattest,
		 * ugliest compound statement ever." It has in it 6 different assignments and a while loop,
		 * and saves over 20 bytes from the previous version where all of these things were done cleanly.
		 * Oh, did I mention that it's 326 bytes long? Hey, I've gotta get those colors somehow. :-)
		 */
		while((attackAngle = Math.abs((Math.tan(Math.atan2((destinationX = 50.0 + Math.random() * (getBattleFieldWidth() - 100.0)) - (myX = getX()), (destinationY = 50.0 + Math.random() * (getBattleFieldHeight() - 100.0)) - (myY = getY())) - ((absoluteBearing = getHeadingRadians() + e.getBearingRadians())))))) < ANGULAR_TOLERANCE);
		
		//If our movement timer is 0, move to a new destination
		if(timer-- < 0){
			setTurnRightRadians(normalizedTurnAngle = Math.atan(Math.tan(turnAngle = ((Math.atan2(destinationX - myX, destinationY - myY) - getHeadingRadians()) + (7.0 * Math.PI)) % (2.0 * Math.PI) - Math.PI)));
			
			setAhead((normalizedTurnAngle == turnAngle ? 1.0 : -1.0) * (Point2D.distance(myX, myY, destinationX, destinationY)));
			
			//Set the movement timer to a random number between 0 and the time a medium power bullet would
			//reach us.
			timer = Math.random() * e.getDistance() / 15.0;
		}
		
		//End our turn by calling fire()... cheaper than execute()
		fire(3);
	}
}
