package kawigi.sbf;
import robocode.*;
import java.awt.geom.*;
import java.awt.*;
/**
 * FloodMicro - SandBoxFlattener with the code size cut down.
 * As of version 1.4, a symbolic pattern matcher is included, fused in from FunkyChicken.
 * If this version does better than Teancum, I need to rethink Teancum...  Actually, I need to do that anyways.
**/
public class FloodMicro extends AdvancedRobot
{
	static int currentDirection;
	static double currentEnergy;
	static int distanceindex;
	static int nextTime;
	static double[] benefit = new double[30], penalty = new double[30];
	//initialize pattern string so that it always will find a match of at least length 1
	//(and will aim close to head on if that's all it finds).  It will not be likely to find these parts
	//of the pattern when it shouldn't, because they'll be pushed to the end of the string, and it will search for the first occurence.
	static StringBuffer pattern = new StringBuffer("" + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)0 + (char)-8 + (char)-7 + (char)-6 + (char)-5 + (char)-4 + (char)-3 + (char)-2 + (char)-1 + (char)1 + (char)2 + (char)3 + (char)4 + (char)5 + (char)6 + (char)7 + (char)8);
	
	public boolean out(double angle, double c)
	{
		//If it weren't for Rozu, I'd probably still be hitting the right and top walls with this
		return !(new Rectangle2D.Double(18, 18, getBattleFieldWidth()-36D,  getBattleFieldHeight()-36D)).contains(Math.sin(angle)*c+getX(), Math.cos(angle)*c+getY());
	}

	public void run()
	{
		setAdjustGunForRobotTurn(true);
		turnRadarRight(Double.POSITIVE_INFINITY);
	}
	
	
	public void onScannedRobot(ScannedRobotEvent e)
	{
		int distance;
		distanceindex = (distance = (int)e.getDistance())/50;
		nextTime--;
		double denergy;
		if ((denergy = currentEnergy-(currentEnergy = e.getEnergy())) > 0 && denergy <= 3)
		{
			benefit[distanceindex] += denergy;
			if (0 >= nextTime)
			{
				setMaxVelocity(2+Math.random()*20);
				currentDirection = (Math.random() < .5)?-30:30;
				nextTime = (int)(distance/(40-denergy*6));
			}
		}
		//I really managed to cut down my Distancing implementation here:
		int rel = 90;
		//denergy was the change in energy, now it's the absolute bearing to target.
		if (distance < findDistanceBracket()-120)
			rel = 90+currentDirection;
		if (out((denergy=getHeadingRadians()+e.getBearingRadians())+Math.PI, 50) || distance > findDistanceBracket() || closeToCorner() || getEnergy()/currentEnergy > 7)
			rel = 90-currentDirection;
		if (nextTime < distance/-11 && currentEnergy == 0)
			rel = 90-currentDirection*3;
		setTurnRight(e.getBearing()-rel);
		
		//collect information for the pattern:
		pattern.insert(0, (char)(Math.round(Math.sin(e.getHeadingRadians() - denergy)*e.getVelocity())));
		//This is essentially FunkyChicken's aiming algorithm.  Putting a nano gun with a micro movement worked for Avipes!
		int index;
		//rel, the amazing reusable int!  Now it's searchlength...
		rel = 30;
		while ((index = pattern.indexOf(pattern.substring(0, rel--), 1)) < 0);
		
		double power;
		//and now rel is the index to project back to.
		rel =  Math.max(index - (int)(distance/(20-3*(power = Math.min(Math.min(getEnergy(), currentEnergy)/4, 3)))), 0);
		
		do
		{
			denergy += Math.asin(((byte)pattern.charAt(index--))/distance);
		}
		while (index >= rel);
		setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(denergy-getGunHeadingRadians()));
		Bullet b = setFireBullet(power);
		if (b != null)
			penalty[distanceindex] += power;
		
		//this is where all my movement went:
		if (out(getHeadingRadians(), currentDirection))
			currentDirection = -currentDirection;
		setAhead(currentDirection);
		setTurnRadarLeft(getRadarTurnRemaining());
	}

	private boolean closeToCorner()
	{
		int i=0;
		do
		{
			if (Point2D.distance(getX(), getY(), (i&1)*getBattleFieldWidth(), (i>>1)*getBattleFieldHeight()) < 200)
				return true;
			i++;
		}
		while (i < 4);
		return false;
	}
	
	public void onHitByBullet(HitByBulletEvent e)
	{
		double power = e.getPower();
		currentEnergy += power*3;
		penalty[distanceindex] += Math.max(power*7, power*9-2);
	}
	
	public void onBulletHit(BulletHitEvent e)
	{
		double power = e.getBullet().getPower();
		double damage;
		currentEnergy -= (damage = Math.max(4*power, 6*power-2));
		benefit[distanceindex] += damage+power*3;
	}
	
	public int findDistanceBracket()
	{
		int bestindex;
		int i = bestindex = 4;
		do
		{
			if (findBenefit(i) > findBenefit(bestindex))
				bestindex = i;
			i++;
		}
		while (i <= 14);
		return bestindex*50+85;
	}
	
	public double findBenefit(int index)
	{
		return (benefit[index]-penalty[index])/(benefit[index]+penalty[index]);
	}
}
