package staticline.whiskey.utils;



public class Alphabet {
    private double[] dHead_steps;
    
    //SYMBOLS
    char none = '0';//no turn && no delta velocity
    /*
     * delta heading values (pos. values, negative are capitalized)
     */
    char a = 'a';//low turn rates == high speed
    char b = 'b';
    char c = 'c';
    char d = 'd';
    char e = 'e';
    char f = 'f';
    char g = 'g';
    char h = 'h';
    char i = 'i';//high turn rates == low speed
    /*
     * delta velocity values
     */
    char dv1 = 'A';//delta velocity -1
    char dv2 = 'a';//delta velocity 1
    char dv3 = 'b';//delta velocity 2
    
    
    public Alphabet(){
        //prepare delta heading handling
        this.dHead_steps = new double[8];
        for(int step=0;step<this.dHead_steps.length;++step){
            this.dHead_steps[step] = Math.toRadians(10-.75*(step));//robocode turn rule
        }
    }
    
    
    public char handleDHeading(double dH){
    	double dHeading = dH;
        char character = '?';
        boolean negative = false;
        if(dHeading<0){
            //negative value -> capital letters
            negative = true;
            dHeading = Math.abs(dHeading);
        }
        if(dHeading == 0){
            character=this.none;
        }else if( dHeading<this.dHead_steps[7] ){
            character=this.a;
        }else if( (dHeading<this.dHead_steps[6]) && (dHeading>=this.dHead_steps[7]) ){
            character=this.b;
        }else if( (dHeading<this.dHead_steps[5]) && (dHeading>=this.dHead_steps[6]) ){
            character=this.c;
        }else if( (dHeading<this.dHead_steps[4]) && (dHeading>=this.dHead_steps[5]) ){
            character=this.d;
        }else if( (dHeading<this.dHead_steps[3]) && (dHeading>=this.dHead_steps[4]) ){
            character=this.e;
        }else if( (dHeading<this.dHead_steps[2]) && (dHeading>=this.dHead_steps[3]) ){
            character=this.f;
        }else if( (dHeading<this.dHead_steps[1]) && (dHeading>=this.dHead_steps[2]) ){
            character=this.g;
        }else if( (dHeading<this.dHead_steps[0]) && (dHeading>=this.dHead_steps[1]) ){
            character=this.h;
        }else if( (dHeading >= this.dHead_steps[0]) ){
            character=this.i;
        }
        //capitalize?
        if(negative){
            character = Character.toUpperCase(character); 
        }
        return character;
    }
    
    public char handleDVelocity(double dVelocity){
    	char character = '?';
    	if(dVelocity<0){
    		character=this.dv1;
    	}else if(dVelocity>0 && dVelocity<=1){
    		character=this.dv2;
    	}else if(dVelocity>1){
    		character=this.dv3;
    	}else if(dVelocity==0){
    		character=this.none;
    	}
    	return character;
    }
}
