package ags.rougedc.movement;

import ags.utils.kdtree.HyperPoint;
import ags.utils.kdtree.KDEntry;

/**
 * Stores a KDTree entry about the enemy's targeting
 * 
 * @author Alexander Schultz
 */
public class EnemyTargetingEntry implements KDEntry {
    private static final long serialVersionUID = 1L;
    private final HyperPoint position;
    private final double guessfactor;
    
    public EnemyTargetingEntry(double guessfactor, double... position) {
        this.position = new HyperPoint(position); 
        this.guessfactor = guessfactor;
    }
    
    public double getGuessFactor() {
        return guessfactor;
    }

    public HyperPoint getPosition() {
        return position;
    }

}
