/*
 * Decompiled with CFR 0.152.
 */
package rdt.Wraith.Guns;

import rdt.Wraith.Guns.FiringData;
import rdt.Wraith.Guns.FiringSolutions;
import rdt.Wraith.Guns.Gun;
import rdt.Wraith.Guns.IClassifiedBulletListener;
import rdt.Wraith.Utils.MathUtils;
import robocode.util.Utils;

final class BulletClassifier {
    private final Gun[] _guns;
    private final int _numGuns;
    private final FiringSolutions _firingSolutions = new FiringSolutions();

    BulletClassifier(Gun[] guns) {
        this._guns = guns;
        this._numGuns = guns.length;
    }

    void Classify(double hitX, double hitY, FiringData firingData, IClassifiedBulletListener listener, double angleMatchRadians) {
        double actualBulletAngle = MathUtils.GetAngle(firingData.SourceX, firingData.SourceY, hitX, hitY);
        boolean anyGunClassified = false;
        for (int gunIndex = 0; gunIndex < this._numGuns; ++gunIndex) {
            Gun gun = this._guns[gunIndex];
            this._firingSolutions.Reset();
            gun.GetFiringSolutions(firingData, this._firingSolutions);
            if (this._firingSolutions.GetNumSolutions() <= 0) {
                listener.OnBulletClassified(gun, gunIndex, false, Math.PI);
                continue;
            }
            boolean anyHit = false;
            double bestAngleDiff = Math.PI;
            for (int firingSolutionIndex = 0; firingSolutionIndex < 1; ++firingSolutionIndex) {
                double gunAngle = this._firingSolutions.GetSolution((int)firingSolutionIndex).AbsoluteAngle;
                double angleDiff = Math.abs(Utils.normalRelativeAngle((double)(gunAngle - actualBulletAngle)));
                boolean hit = angleDiff <= angleMatchRadians;
                bestAngleDiff = Math.min(angleDiff, bestAngleDiff);
                anyHit |= hit;
            }
            listener.OnBulletClassified(gun, gunIndex, anyHit, bestAngleDiff);
            anyGunClassified |= anyHit;
        }
        if (!anyGunClassified) {
            listener.NoClassificationAvailable();
        }
    }
}

