/*
 * Decompiled with CFR 0.152.
 */
package rdt.Wraith.Guns;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import rdt.Wraith.Guns.FiringSolution;
import rdt.Wraith.Guns.Gun;

public final class FiringSolutions {
    private static final int MaxNumFiringSolutions = 200;
    private final ArrayList<FiringSolution> Solutions = new ArrayList(200);
    private int NumSolutions = 0;

    public FiringSolutions() {
        for (int index = 0; index < 200; ++index) {
            this.Solutions.add(new FiringSolution());
        }
        this.Reset();
    }

    public void Reset() {
        this.NumSolutions = 0;
        for (int index = 0; index < 200; ++index) {
            this.Solutions.get((int)index).Valid = false;
        }
    }

    public int GetNumSolutions() {
        return this.NumSolutions;
    }

    public FiringSolution GetSolution(int index) {
        assert (index < this.NumSolutions);
        return this.Solutions.get(index);
    }

    public void WriteSolution(double absAngle, double gunWeight, Gun gun) {
        assert (this.NumSolutions < 200);
        FiringSolution solution = this.Solutions.get(this.NumSolutions);
        solution.AbsoluteAngle = absAngle;
        solution.GunWeighting = gunWeight;
        solution.Gun = gun;
        solution.Valid = true;
        ++this.NumSolutions;
    }

    public void Sort(Comparator<FiringSolution> comparer) {
        Collections.sort(this.Solutions, comparer);
    }
}

