/*
 * Decompiled with CFR 0.152.
 */
package lazarecki.robot.strategy;

import lazarecki.robot.ModularRobot;
import lazarecki.robot.RobotInfo;
import lazarecki.robot.strategy.StrategicModule;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class RadarLockModule
extends StrategicModule {
    private long lastLockTime;

    @Override
    public void onRun() {
        ModularRobot robot = this.getRobot();
        if (Math.abs(this.lastLockTime - robot.getTime()) != 0L) {
            robot.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
        }
    }

    @Override
    public void onScannedRobot(ScannedRobotEvent event) {
        ModularRobot robot = this.getRobot();
        RobotInfo myInfo = new RobotInfo(robot);
        RobotInfo targetInfo = new RobotInfo(event, robot);
        robot.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(myInfo.absoluteAngle(targetInfo) - robot.getRadarHeadingRadians())) * 2.0);
        this.lastLockTime = robot.getTime();
    }
}

