/*
 * Decompiled with CFR 0.152.
 */
package ak;

import ak.Fermat;
import ak.OtherBot;
import java.awt.geom.Point2D;
import java.util.Vector;

public class RobotBody {
    static int turnDirection = -1;
    static double turnAngle = 90.0;
    static int modValue = 20;
    public static Vector dodgeBullets = new Vector();

    public Point2D.Double getDirection(Vector otherBots, Fermat robot, int target) {
        int j;
        double ang;
        double force;
        OtherBot bot;
        int numOthers = robot.getOthers();
        Point2D.Double pos = new Point2D.Double();
        double forceX = 0.0;
        double forceY = 0.0;
        double fieldWidth = robot.getBattleFieldWidth();
        double fieldHeight = robot.getBattleFieldHeight();
        double robotWidth = robot.getWidth();
        double robotHeight = robot.getHeight();
        long currTime = robot.getTime();
        pos.x = robot.getX();
        pos.y = robot.getY();
        int i = 0;
        while (i < otherBots.size()) {
            bot = (OtherBot)otherBots.elementAt(i);
            if (bot.alive) {
                force = -1.0 * (fieldWidth + fieldHeight) / Math.pow(this.getDistance(pos.x, pos.y, bot.X, bot.Y), 2);
                ang = this.normalRelativeAngle(90.0 - Math.toDegrees(Math.atan2(pos.y - bot.Y, pos.x - bot.X)));
                forceX += Math.sin(Math.toRadians(ang)) * force;
                forceY += Math.cos(Math.toRadians(ang)) * force;
            }
            ++i;
        }
        double wallForce = robot.getOthers() == 1 ? (double)5 * (fieldWidth + fieldHeight) : 15.0 * (fieldWidth + fieldHeight);
        forceX += wallForce / Math.pow(fieldWidth - pos.x, 3);
        forceX -= wallForce / Math.pow(pos.x, 3);
        forceY += wallForce / Math.pow(fieldHeight - pos.y, 3);
        forceY -= wallForce / Math.pow(pos.y, 3);
        if (numOthers == 1) {
            double cornerForce = -0.005 * (fieldWidth + fieldHeight) / Math.pow(this.getDistance(pos.x, pos.y, 0.0, 0.0), 1.0);
            ang = this.normalRelativeAngle(90.0 - Math.toDegrees(Math.atan2(pos.y, pos.x)));
            forceX += Math.sin(Math.toRadians(ang)) * cornerForce;
            forceY += Math.cos(Math.toRadians(ang)) * cornerForce;
            cornerForce = -0.005 * (fieldWidth + fieldHeight) / Math.pow(this.getDistance(pos.x, pos.y, fieldWidth, 0.0), 1.0);
            ang = this.normalRelativeAngle(90.0 - Math.toDegrees(Math.atan2(pos.y, pos.x - fieldWidth)));
            forceX += Math.sin(Math.toRadians(ang)) * cornerForce;
            forceY += Math.cos(Math.toRadians(ang)) * cornerForce;
            cornerForce = -0.005 * (fieldWidth + fieldHeight) / Math.pow(this.getDistance(pos.x, pos.y, fieldWidth, fieldHeight), 1.0);
            ang = this.normalRelativeAngle(90.0 - Math.toDegrees(Math.atan2(pos.y - fieldHeight, pos.x - fieldWidth)));
            forceX += Math.sin(Math.toRadians(ang)) * cornerForce;
            forceY += Math.cos(Math.toRadians(ang)) * cornerForce;
            cornerForce = -0.005 * (fieldWidth + fieldHeight) / Math.pow(this.getDistance(pos.x, pos.y, 0.0, fieldHeight), 1.0);
            ang = this.normalRelativeAngle(90.0 - Math.toDegrees(Math.atan2(pos.y - fieldHeight, pos.x)));
            forceX += Math.sin(Math.toRadians(ang)) * cornerForce;
            forceY += Math.cos(Math.toRadians(ang)) * cornerForce;
        }
        int[] botArray = new int[robot.otherBots.size()];
        i = 0;
        while (i < robot.otherBots.size()) {
            botArray[i] = i;
            ++i;
        }
        i = 0;
        while (i < robot.otherBots.size() - 1) {
            OtherBot botA = (OtherBot)robot.otherBots.elementAt(botArray[i]);
            j = i + 1;
            while (j < robot.otherBots.size()) {
                OtherBot botB = (OtherBot)robot.otherBots.elementAt(botArray[j]);
                if (botB.lastAttackTime > botA.lastAttackTime) {
                    int temp = botArray[i];
                    botArray[i] = botArray[j];
                    botArray[j] = temp;
                }
                ++j;
            }
            ++i;
        }
        j = 0;
        while (j < robot.otherBots.size()) {
            bot = (OtherBot)robot.otherBots.elementAt(botArray[j]);
            double diffEnergy = bot.prevEnergy - bot.energy;
            if (bot.scanTime - bot.previousScanTime <= 8L && bot.attacking && diffEnergy > 0.09 && diffEnergy < 3.01) {
                long fireTime = bot.previousScanTime - 1L;
                while (fireTime <= currTime) {
                    if (!((double)currTime - robot.updateTime[(int)(fireTime % 50L)] > 25.0) && !((double)currTime - robot.updateTime[(int)((fireTime + 49L) % 50L)] > 25.0)) {
                        Point2D.Double currPos = robot.pastPositions[(int)(fireTime % 50L)];
                        double currHeading = robot.pastHeadings[(int)(fireTime % 50L)];
                        double prevHeading = robot.pastHeadings[(int)((fireTime + 49L) % 50L)];
                        double currVelocity = robot.pastVelocities[(int)(fireTime % 50L)];
                        Point2D.Double botPos = new Point2D.Double(bot.prevX + (double)(fireTime - bot.previousScanTime) * (bot.X - bot.prevX) / (double)(bot.scanTime - bot.previousScanTime), bot.prevY + (double)(fireTime - bot.previousScanTime) * (bot.Y - bot.prevY) / (double)(bot.scanTime - bot.previousScanTime));
                        DodgeBullet dBullet = new DodgeBullet(botPos.x, botPos.y, currPos, diffEnergy, fireTime, botArray[j]);
                        dodgeBullets.add(dBullet);
                        if (Math.abs(currVelocity) > 0.0) {
                            double headingChange;
                            double diff;
                            long time;
                            long nextTime;
                            Point2D.Double p = new Point2D.Double(currPos.x, currPos.y);
                            double velocity = robot.avgVelocity;
                            if (currVelocity < 0.0) {
                                velocity *= -1.0;
                            }
                            i = 0;
                            while (i < 10) {
                                nextTime = Math.round(Math.sqrt((botPos.x - p.x) * (botPos.x - p.x) + (botPos.y - p.y) * (botPos.y - p.y)) / (20.0 - (double)3 * diffEnergy));
                                time = fireTime + nextTime;
                                diff = time - fireTime;
                                p.x = currPos.x + Math.sin(Math.toRadians(this.normalRelativeAngle(currHeading))) * currVelocity * diff;
                                p.y = currPos.y + Math.cos(Math.toRadians(this.normalRelativeAngle(currHeading))) * currVelocity * diff;
                                ++i;
                            }
                            dBullet = new DodgeBullet(botPos.x, botPos.y, p, diffEnergy, fireTime, botArray[j]);
                            dodgeBullets.add(dBullet);
                            if (numOthers == 1) {
                                p = new Point2D.Double(currPos.x, currPos.y);
                                i = 0;
                                while (i < 10) {
                                    nextTime = Math.round(Math.sqrt((botPos.x - p.x) * (botPos.x - p.x) + (botPos.y - p.y) * (botPos.y - p.y)) / (20.0 - (double)3 * diffEnergy));
                                    time = fireTime + nextTime;
                                    diff = time - fireTime;
                                    p.x = currPos.x + Math.sin(Math.toRadians(this.normalRelativeAngle(currHeading))) * velocity * diff;
                                    p.y = currPos.y + Math.cos(Math.toRadians(this.normalRelativeAngle(currHeading))) * velocity * diff;
                                    ++i;
                                }
                                dBullet = new DodgeBullet(botPos.x, botPos.y, p, diffEnergy, fireTime, botArray[j]);
                                dodgeBullets.add(dBullet);
                            }
                            if (Math.abs(headingChange = Math.toRadians(this.normalRelativeAngle(currHeading - prevHeading))) > 1.0E-5) {
                                double radius;
                                double tothead;
                                double diff2;
                                p = new Point2D.Double(currPos.x, currPos.y);
                                i = 0;
                                while (i < 10) {
                                    nextTime = Math.round(Math.sqrt((botPos.x - p.x) * (botPos.x - p.x) + (botPos.y - p.y) * (botPos.y - p.y)) / (20.0 - (double)3 * diffEnergy));
                                    time = fireTime + nextTime;
                                    diff2 = time - fireTime;
                                    tothead = Math.toDegrees(diff2 * headingChange);
                                    radius = currVelocity / headingChange;
                                    p.y = currPos.y + Math.sin(Math.toRadians(this.normalRelativeAngle(currHeading + tothead))) * radius - Math.sin(Math.toRadians(this.normalRelativeAngle(currHeading))) * radius;
                                    p.x = currPos.x + Math.cos(Math.toRadians(this.normalRelativeAngle(currHeading))) * radius - Math.sin(Math.toRadians(this.normalRelativeAngle(currHeading + tothead))) * radius;
                                    ++i;
                                }
                                dBullet = new DodgeBullet(botPos.x, botPos.y, p, diffEnergy, fireTime, botArray[j]);
                                dodgeBullets.add(dBullet);
                                if (numOthers == 1) {
                                    p = new Point2D.Double(currPos.x, currPos.y);
                                    i = 0;
                                    while (i < 10) {
                                        nextTime = Math.round(Math.sqrt((botPos.x - p.x) * (botPos.x - p.x) + (botPos.y - p.y) * (botPos.y - p.y)) / (20.0 - (double)3 * diffEnergy));
                                        time = fireTime + nextTime;
                                        diff2 = time - fireTime;
                                        tothead = Math.toDegrees(diff2 * headingChange);
                                        radius = velocity / headingChange;
                                        p.y = currPos.y + Math.sin(Math.toRadians(this.normalRelativeAngle(currHeading + tothead))) * radius - Math.sin(Math.toRadians(this.normalRelativeAngle(currHeading))) * radius;
                                        p.x = currPos.x + Math.cos(Math.toRadians(this.normalRelativeAngle(currHeading))) * radius - Math.sin(Math.toRadians(this.normalRelativeAngle(currHeading + tothead))) * radius;
                                        ++i;
                                    }
                                    dBullet = new DodgeBullet(botPos.x, botPos.y, p, diffEnergy, fireTime, botArray[j]);
                                    dodgeBullets.add(dBullet);
                                }
                            }
                        }
                    }
                    ++fireTime;
                }
            }
            ++j;
        }
        i = 0;
        while (i < dodgeBullets.size()) {
            DodgeBullet dBullet = (DodgeBullet)dodgeBullets.elementAt(i);
            Point2D.Double currPos = dBullet.getCurrentPosition(currTime);
            if (this.getDistance(currPos.x, currPos.y, dBullet.source.x, dBullet.source.y) > this.getDistance(pos.x, pos.y, dBullet.source.x, dBullet.source.y) + 0.5 * Math.sqrt(Math.pow(robot.getWidth(), 2) + Math.pow(robot.getHeight(), 2))) {
                dodgeBullets.remove(i);
                --i;
            }
            ++i;
        }
        while (numOthers > 1 && dodgeBullets.size() > 70) {
            double minDamage = 1.0E30;
            double minDistance = 1.0E30;
            int minBullet = -1;
            i = 0;
            while (i < dodgeBullets.size()) {
                DodgeBullet dBullet = (DodgeBullet)dodgeBullets.elementAt(i);
                Point2D.Double currPos = dBullet.getCurrentPosition(currTime);
                double distance = this.getDistance(pos.x, pos.y, currPos.x, currPos.y);
                double damage = (20.0 - dBullet.velocity) / (double)3 < 1.0 ? (20.0 - dBullet.velocity) / (double)3 * (double)4 : (20.0 - dBullet.velocity) / (double)3 * 6.0 - (double)2;
                if (damage < minDamage || damage == minDamage && distance < minDistance) {
                    minDamage = damage;
                    minDistance = distance;
                    minBullet = i;
                }
                ++i;
            }
            dodgeBullets.remove(minBullet);
        }
        i = 0;
        while (i < dodgeBullets.size()) {
            DodgeBullet dBullet = (DodgeBullet)dodgeBullets.elementAt(i);
            if (!(dBullet.startTime > (double)currTime)) {
                Point2D.Double projPos = dBullet.getProjectedPosition(pos);
                double threshDist = Math.max(robotWidth, robotHeight);
                int wallCount = 0;
                if (projPos.x <= threshDist) {
                    ++wallCount;
                    Point2D.Double wallPos = new Point2D.Double(0.0, pos.y);
                    turnDirection = this.triangleArea(pos, dBullet.source, wallPos) > 0.0 ? -1 : 1;
                }
                if (projPos.y <= threshDist) {
                    ++wallCount;
                    Point2D.Double wallPos = new Point2D.Double(pos.x, 0.0);
                    turnDirection = this.triangleArea(pos, dBullet.source, wallPos) > 0.0 ? -1 : 1;
                }
                if (projPos.y >= fieldHeight - threshDist) {
                    ++wallCount;
                    Point2D.Double wallPos = new Point2D.Double(pos.x, fieldHeight);
                    turnDirection = this.triangleArea(pos, dBullet.source, wallPos) > 0.0 ? -1 : 1;
                }
                if (projPos.x >= fieldWidth - threshDist) {
                    ++wallCount;
                    Point2D.Double wallPos = new Point2D.Double(fieldWidth, pos.y);
                    turnDirection = this.triangleArea(pos, dBullet.source, wallPos) > 0.0 ? -1 : 1;
                }
                Point2D.Double currPos = dBullet.getCurrentPosition(currTime);
                if (wallCount != 1) {
                    turnDirection = this.triangleArea(dBullet.target, dBullet.source, pos) > 0.0 ? 1 : -1;
                }
                double distance = this.getDistance(pos.x, pos.y, currPos.x, currPos.y);
                force = -12.5 * (fieldWidth + fieldHeight) / Math.pow(distance, 3.5);
                force = (20.0 - dBullet.velocity) / (double)3 < 1.0 ? (force *= (20.0 - dBullet.velocity) / (double)3 * (double)4) : (force *= (20.0 - dBullet.velocity) / (double)3 * 6.0 - (double)2);
                ang = this.normalRelativeAngle((double)(turnDirection * 90 + 90) - Math.toDegrees(Math.atan2(pos.y - dBullet.source.y, pos.x - dBullet.source.x)));
                forceX += Math.sin(Math.toRadians(ang)) * force;
                forceY += Math.cos(Math.toRadians(ang)) * force;
            }
            ++i;
        }
        return new Point2D.Double(forceX, forceY);
    }

    double getDistance(double x1, double y1, double x2, double y2) {
        double x = x2 - x1;
        double y = y2 - y1;
        return Math.sqrt(x * x + y * y);
    }

    double triangleArea(Point2D.Double a, Point2D.Double b, Point2D.Double c) {
        return (b.x - a.x) * (c.y - a.y) - (c.x - a.x) * (b.y - a.y);
    }

    public double normalRelativeAngle(double angle) {
        if (angle > 180.0) {
            return (angle + 180.0) % 360.0 - 180.0;
        }
        if (angle < -180.0) {
            return (angle - 180.0) % 360.0 + 180.0;
        }
        return angle;
    }

    class DodgeBullet {
        Point2D.Double source;
        Point2D.Double target;
        double velocity;
        double startTime;
        int bot;

        Point2D.Double getCurrentPosition(double time) {
            double distance = this.velocity * (time - this.startTime);
            return new Point2D.Double(this.source.x + distance * (this.target.x - this.source.x) / RobotBody.this.getDistance(this.target.x, this.target.y, this.source.x, this.source.y), this.source.y + distance * (this.target.y - this.source.y) / RobotBody.this.getDistance(this.target.x, this.target.y, this.source.x, this.source.y));
        }

        Point2D.Double getProjectedPosition(Point2D.Double botPos) {
            double distance = Math.max(RobotBody.this.getDistance(botPos.x, botPos.y, this.source.x, this.source.y), RobotBody.this.getDistance(this.target.x, this.target.y, this.source.x, this.source.y));
            return new Point2D.Double(this.source.x + distance * (this.target.x - this.source.x) / RobotBody.this.getDistance(this.target.x, this.target.y, this.source.x, this.source.y), this.source.y + distance * (this.target.y - this.source.y) / RobotBody.this.getDistance(this.target.x, this.target.y, this.source.x, this.source.y));
        }

        DodgeBullet(double sourceX, double sourceY, Point2D.Double target, double power, double startTime, int bot) {
            this.source = new Point2D.Double(sourceX, sourceY);
            this.target = new Point2D.Double(target.x, target.y);
            this.startTime = startTime;
            this.velocity = 20.0 - (double)3 * power;
            this.bot = bot;
        }
    }
}

