/*
 * Decompiled with CFR 0.152.
 */
package ags.muse.gun;

import ags.muse.base.Rules;
import ags.muse.gun.SWave;
import ags.muse.recon.Enemy;
import ags.muse.recon.EnemyList;
import ags.muse.recon.SelfStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.Event;

public class SWaveManager {
    private final Rules rules;
    private final SelfStatus status;
    private final EnemyList enemyList;
    private final List<SWave> waves = new ArrayList<SWave>();
    private final List<SWave> dyingWaves = new ArrayList<SWave>();
    private final List<SWave> newWaves = new ArrayList<SWave>();
    private final List<SWave> hitWaves = new ArrayList<SWave>();
    private final List<SWave> hitBulletWaves = new ArrayList<SWave>();
    private int collide_count = 0;

    public int getCollideCount() {
        return this.collide_count;
    }

    public SWaveManager(Rules rules, SelfStatus status, EnemyList enemyList) {
        this.rules = rules;
        this.status = status;
        this.enemyList = enemyList;
    }

    public void runWaves(List<Event> events, double newWavePower) {
        this.hitWaves.clear();
        this.hitBulletWaves.clear();
        for (Event e : events) {
            SWave wave;
            BulletHitEvent b;
            if (e instanceof BulletHitEvent) {
                b = (BulletHitEvent)e;
                wave = this.getBulletWave(b.getBullet());
                if (wave == null) continue;
                this.hitWaves.add(wave);
                this.collide_count = 0;
                continue;
            }
            if (!(e instanceof BulletHitBulletEvent) || (wave = this.getBulletWave((b = (BulletHitBulletEvent)e).getBullet())) == null) continue;
            this.hitBulletWaves.add(wave);
            this.waves.remove(wave);
            ++this.collide_count;
        }
        this.newWaves.clear();
        if (newWavePower > 0.0) {
            for (Enemy enemy : this.enemyList.getBots()) {
                if (enemy.getScanAge() > 0) continue;
                SWave newWave = new SWave(this.rules, this.status.getNextLocation(), newWavePower, 0.0, enemy);
                this.newWaves.add(newWave);
                this.waves.add(newWave);
            }
        }
        this.dyingWaves.clear();
        Iterator<SWave> iter = this.waves.iterator();
        while (iter.hasNext()) {
            SWave w = iter.next();
            if (!this.enemyList.getBots().contains(w.target) && !this.hitWaves.contains(w)) {
                iter.remove();
                continue;
            }
            if (w.target.getEnergy() == 0.0) {
                iter.remove();
                continue;
            }
            w.checkHit(w.target.getLocation());
            w.move();
            if (!w.expired()) continue;
            iter.remove();
            this.dyingWaves.add(w);
            if (w.getBullet() == null) continue;
            this.collide_count = 0;
        }
    }

    public List<SWave> getNewWaves() {
        return Collections.unmodifiableList(this.newWaves);
    }

    public List<SWave> getDyingWaves() {
        return Collections.unmodifiableList(this.dyingWaves);
    }

    public List<SWave> getHitWaves() {
        return Collections.unmodifiableList(this.hitWaves);
    }

    public List<SWave> getHitBulletWaves() {
        return Collections.unmodifiableList(this.hitBulletWaves);
    }

    public List<SWave> getWaves() {
        return Collections.unmodifiableList(this.waves);
    }

    public SWave getBulletWave(Bullet bullet) {
        for (SWave w : this.waves) {
            if (!bullet.equals(w.getBullet())) continue;
            return w;
        }
        for (SWave w : this.dyingWaves) {
            if (!bullet.equals(w.getBullet())) continue;
            return w;
        }
        return null;
    }

    public SWave getAimingWave(Enemy target) {
        for (SWave w : this.newWaves) {
            if (!w.target.equals(target)) continue;
            return w;
        }
        return null;
    }
}

