/*
 * Decompiled with CFR 0.152.
 */
package xander.core.drive;

import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import xander.core.drive.DrivePrediction;
import xander.core.drive.DriveState;
import xander.core.math.RCMath;
import xander.core.math.RCPhysics;
import xander.core.track.Wave;

public class DirectDrivePredictor {
    private Rectangle2D.Double battlefieldBounds;
    private Path2D.Double driveBounds;
    private double lastHeading = 370.0;
    private double cosPheta = 0.0;
    private double sinPheta = 0.0;

    public DirectDrivePredictor(Rectangle2D.Double battlefieldBounds, Path2D.Double driveBounds) {
        if (battlefieldBounds == null) {
            throw new IllegalArgumentException("Battlefield Bounds cannot be null");
        }
        if (driveBounds == null) {
            throw new IllegalArgumentException("Drive Bounds cannot be null");
        }
        this.battlefieldBounds = battlefieldBounds;
        this.driveBounds = driveBounds;
    }

    public Path2D.Double getDriveBounds() {
        return this.driveBounds;
    }

    public DrivePrediction predictPathUntilWaveHits(Wave wave, DriveState driveState, double targetHeading, double targetSpeed, long currentTime) {
        driveState = new DriveState(driveState);
        long time = currentTime;
        double adjustedTargetSpeed = targetSpeed;
        long tup = wave.getTimeUntilHit(driveState.getPosition().x, driveState.getPosition().y, time);
        ArrayList<Point2D.Double> drivePath = new ArrayList<Point2D.Double>();
        drivePath.add(new Point2D.Double(driveState.position.x, driveState.position.y));
        while (tup > 0L && (adjustedTargetSpeed > 0.0 || Math.abs(driveState.velocity) > 0.0)) {
            adjustedTargetSpeed = this.shouldStop(driveState, targetHeading, targetSpeed) ? 0.0 : targetSpeed;
            this.advanceDriveState(driveState, targetHeading, adjustedTargetSpeed);
            drivePath.add(new Point2D.Double(driveState.position.x, driveState.position.y));
            tup = wave.getTimeUntilHit(driveState.position.x, driveState.position.y, ++time);
        }
        return new DrivePrediction(driveState, drivePath);
    }

    public DriveState predictDriveStateUntilWaveHits(Wave wave, DriveState driveState, double targetHeading, double targetSpeed, long currentTime) {
        driveState = new DriveState(driveState);
        long time = currentTime;
        double adjustedTargetSpeed = targetSpeed;
        long tup = wave.getTimeUntilHit(driveState.getPosition().x, driveState.getPosition().y, time);
        while (tup > 0L && (adjustedTargetSpeed > 0.0 || Math.abs(driveState.velocity) > 0.0)) {
            adjustedTargetSpeed = this.shouldStop(driveState, targetHeading, targetSpeed) ? 0.0 : targetSpeed;
            this.advanceDriveState(driveState, targetHeading, adjustedTargetSpeed);
            tup = wave.getTimeUntilHit(driveState.position.x, driveState.position.y, ++time);
        }
        return driveState;
    }

    public boolean shouldStop(Wave wave, double targetFactorAngle, DriveState driveState, double targetHeading, double targetSpeed, long currentTime) {
        DriveState testDriveState = new DriveState(driveState);
        long time = currentTime;
        double speed = Math.abs(testDriveState.velocity);
        long tup = wave.getTimeUntilHit(testDriveState.getPosition().x, testDriveState.getPosition().y, time);
        while (speed > 0.0 && tup > 0L) {
            this.advanceDriveState(testDriveState, targetHeading, 0.0);
            speed = Math.abs(testDriveState.velocity);
            tup = wave.getTimeUntilHit(testDriveState.getPosition().x, testDriveState.getPosition().y, ++time);
        }
        double defenderBearing = RCMath.getRobocodeAngle(wave.getOrigin(), testDriveState.position);
        double stopNowFactorAngle = RCMath.getTurnAngle(wave.getInitialDefenderBearing(), defenderBearing);
        testDriveState = new DriveState(driveState);
        time = currentTime;
        tup = wave.getTimeUntilHit(testDriveState.getPosition().x, testDriveState.getPosition().y, time);
        if (tup > 0L) {
            this.advanceDriveState(testDriveState, targetHeading, targetSpeed);
            ++time;
        }
        speed = Math.abs(testDriveState.velocity);
        tup = wave.getTimeUntilHit(testDriveState.getPosition().x, testDriveState.getPosition().y, time);
        while (speed > 0.0 && tup > 0L) {
            this.advanceDriveState(testDriveState, targetHeading, 0.0);
            speed = Math.abs(testDriveState.velocity);
            tup = wave.getTimeUntilHit(testDriveState.getPosition().x, testDriveState.getPosition().y, ++time);
        }
        defenderBearing = RCMath.getRobocodeAngle(wave.getOrigin(), testDriveState.position);
        double stopNextTickFactorAngle = RCMath.getTurnAngle(wave.getInitialDefenderBearing(), defenderBearing);
        double stopNowFactorAngleDiff = RCMath.getTurnAngle(targetFactorAngle, stopNowFactorAngle);
        double stopNextTickFactorAngleDiff = RCMath.getTurnAngle(targetFactorAngle, stopNextTickFactorAngle);
        return Math.abs(stopNowFactorAngleDiff) < Math.abs(stopNextTickFactorAngleDiff);
    }

    private boolean beyondWallLimits(Point2D.Double position) {
        double hardLimit = 17.0;
        return position.x < this.battlefieldBounds.getMinX() + hardLimit || position.x > this.battlefieldBounds.getMaxX() - hardLimit || position.y < this.battlefieldBounds.getMinY() + hardLimit || position.y > this.battlefieldBounds.getMaxY() - hardLimit;
    }

    public boolean shouldStop(DriveState driveState, double targetHeading, double targetSpeed) {
        driveState = new DriveState(driveState);
        double speed = Math.abs(driveState.velocity);
        boolean initialInBounds = this.driveBounds.contains(driveState.position);
        if (initialInBounds) {
            this.advanceDriveState(driveState, targetHeading, targetSpeed);
            while (speed > 0.0) {
                this.advanceDriveState(driveState, targetHeading, 0.0);
                speed = Math.abs(driveState.velocity);
            }
            boolean stoppedInBounds = this.driveBounds.contains(driveState.position);
            if (stoppedInBounds) {
                return false;
            }
        }
        int i = 1;
        while (i < 13) {
            this.advanceDriveState(driveState, targetHeading, 8.0);
            if (i % 4 == 0) {
                if (this.beyondWallLimits(driveState.position)) {
                    return true;
                }
                if (this.driveBounds.contains(driveState.position)) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public void advanceDriveState(DriveState driveState, double targetHeading, double targetSpeed) {
        double targetVelocity = targetSpeed;
        double targetTurnAngle = RCMath.getTurnAngle(driveState.heading, targetHeading);
        if (Math.abs(targetTurnAngle) > 90.0) {
            targetHeading = RCMath.normalizeDegrees(targetHeading + 180.0);
            targetVelocity = -targetSpeed;
            targetTurnAngle = RCMath.getTurnAngle(driveState.heading, targetHeading);
        }
        double turnThisTick = targetTurnAngle;
        double maxTurnRate = RCPhysics.getMaxTurnRate(driveState.getVelocity());
        if (targetTurnAngle > maxTurnRate) {
            turnThisTick = maxTurnRate;
        } else if (targetTurnAngle < -maxTurnRate) {
            turnThisTick = -maxTurnRate;
        }
        double velocityChangeThisTick = targetVelocity - driveState.velocity;
        double maxChangeRate = 1.0;
        if (driveState.velocity > 0.0 && targetVelocity < driveState.velocity || driveState.velocity < 0.0 && targetVelocity > driveState.velocity) {
            maxChangeRate = 2.0;
        }
        if (Math.abs(velocityChangeThisTick) > maxChangeRate) {
            velocityChangeThisTick = velocityChangeThisTick > 0.0 ? maxChangeRate : -maxChangeRate;
        }
        driveState.heading += turnThisTick;
        driveState.velocity += velocityChangeThisTick;
        if (driveState.heading != this.lastHeading) {
            double pheta = Math.toRadians(RCMath.convertDegrees(driveState.heading));
            this.cosPheta = Math.cos(pheta);
            this.sinPheta = Math.sin(pheta);
            this.lastHeading = driveState.heading;
        }
        driveState.position.x += driveState.velocity * this.cosPheta;
        driveState.position.y += driveState.velocity * this.sinPheta;
        ++driveState.time;
    }
}

