/*
 * Decompiled with CFR 0.152.
 */
package xander.core.drive;

import xander.core.drive.Drive;
import xander.core.drive.DriveController;
import xander.core.drive.DriveSelector;
import xander.core.track.Snapshot;

public class DriveArray
implements Drive {
    private DriveSelector driveSelector;
    private Drive[] drives;
    private int activeDriveIndex;

    public DriveArray(DriveSelector driveSelector, Drive ... drives) {
        this.driveSelector = driveSelector;
        this.drives = drives;
    }

    @Override
    public String getName() {
        return this.drives[this.activeDriveIndex].getName();
    }

    @Override
    public void onRoundBegin() {
        Drive[] driveArray = this.drives;
        int n = this.drives.length;
        int n2 = 0;
        while (n2 < n) {
            Drive drive = driveArray[n2];
            drive.onRoundBegin();
            ++n2;
        }
    }

    @Override
    public void driveTo(Snapshot opponentSnapshot, DriveController driveController) {
        this.activeDriveIndex = this.driveSelector.selectDrive(this.drives, opponentSnapshot);
        this.drives[this.activeDriveIndex].driveTo(opponentSnapshot, driveController);
    }

    @Override
    public void drive(DriveController driveController) {
        this.activeDriveIndex = this.driveSelector.selectDrive(this.drives, null);
        this.drives[this.activeDriveIndex].drive(driveController);
    }
}

