/*
 * Decompiled with CFR 0.152.
 */
package ghent.modules.artillery;

import ghent.common.Target;
import ghent.modules.Module;
import ghent.modules.artillery.Ballistics;
import ghent.modules.artillery.TimestampedLocation;
import ghent.modules.artillery.events.VirtualBulletExpiredCondition;
import ghent.modules.artillery.strategies.CircularTargeting;
import ghent.modules.artillery.strategies.HeadOnTargeting;
import ghent.modules.artillery.strategies.ITargetingStrategy;
import ghent.modules.artillery.strategies.LinearTargeting;
import java.awt.Color;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.RobocodeFileOutputStream;
import robocode.WinEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Gunner
extends Module {
    private static final double VIRTUAL_BULLET_POWER = 0.1;
    private static final double VIRTUAL_BULLET_LOCATION_DELTA = 10.0;
    private static final int VIRTUAL_BULLET_RELEVANT_SUCCESS = 3;
    private final Map<String, ITargetingStrategy> targetingStrategies = new HashMap<String, ITargetingStrategy>();
    private static Map<String, Map<String, Long>> stats;
    private ITargetingStrategy targetingStrategy;

    public Gunner(AdvancedRobot robot) {
        super(robot);
        this.targetingStrategies.put("HEAD-ON", new HeadOnTargeting(robot));
        this.targetingStrategies.put("LINEAR", new LinearTargeting(robot));
        this.targetingStrategies.put("CIRCULAR", new CircularTargeting(robot));
        this.targetingStrategy = this.targetingStrategies.get("HEAD-ON");
    }

    @Override
    public void init() {
        stats = this.loadStats();
    }

    public boolean canFire() {
        return this._robot.getGunHeat() == 0.0;
    }

    public void setFire(Ballistics ballistics) {
        if (this.canFire()) {
            this._robot.setFireBullet(ballistics.getPower());
        }
    }

    public void fireVirtualBullets(Target target) {
        if (target == null) {
            return;
        }
        for (String strategy : this.targetingStrategies.keySet()) {
            TimestampedLocation tl = this.targetingStrategies.get(strategy).getEstimatedLocation(target, 0.1);
            this._robot.addCustomEvent((Condition)new VirtualBulletExpiredCondition(this._robot, target, tl.getTime(), tl.getLocation(), strategy));
        }
    }

    public void prepareFire(Ballistics ballistics) {
        this._robot.setTurnGunRight(ballistics.getRotation());
    }

    public void prepareFire(Target target) {
        Ballistics ballistics = this.getBallistics(target);
        if (ballistics == null) {
            return;
        }
        this._robot.setTurnGunRight(ballistics.getRotation());
    }

    public Ballistics getBallistics(Target target) {
        this.chooseStrategy(target);
        return this.targetingStrategy.getBallistics(target);
    }

    private void chooseStrategy(Target target) {
        if (target == null) {
            return;
        }
        String tName = target.getName();
        if (!stats.containsKey(tName)) {
            stats.put(tName, new HashMap());
            for (String strategy : this.targetingStrategies.keySet()) {
                stats.get(tName).put(strategy, 0L);
            }
        }
        String strategy = null;
        for (String key : stats.get(tName).keySet()) {
            if (strategy == null) {
                strategy = key;
                continue;
            }
            if (stats.get(tName).get(key) <= stats.get(tName).get(strategy)) continue;
            strategy = key;
        }
        if (stats.get(tName).get(strategy) < 3L) {
            strategy = Math.abs(target.getHeadingChange()) < 1.0 ? "LINEAR" : "CIRCULAR";
        }
        this.setStrategy(strategy);
    }

    private void setStrategy(String strategy) {
        this.targetingStrategy = this.targetingStrategies.get(strategy);
        if ("HEAD-ON".equals(strategy) || "HEAD-ON MIN".equals(strategy)) {
            this._robot.setBulletColor(Color.YELLOW);
        } else if ("LINEAR".equals(strategy) || "LINEAR MIN".equals(strategy)) {
            this._robot.setBulletColor(Color.WHITE);
        } else if ("CIRCULAR".equals(strategy) || "CIRCULAR MIN".equals(strategy)) {
            this._robot.setBulletColor(Color.GREEN);
        } else {
            this._robot.setBulletColor(Color.RED);
        }
    }

    @Override
    public void onCustomEvent(CustomEvent event) {
        if (event.getCondition() instanceof VirtualBulletExpiredCondition) {
            VirtualBulletExpiredCondition vbec = (VirtualBulletExpiredCondition)event.getCondition();
            Target t = vbec.getTarget();
            String strategy = vbec.getStrategyName();
            if (t == null) {
                return;
            }
            String tName = t.getName();
            if (t.getLocation().distance(vbec.getEndLocation()) < 10.0) {
                Long count = stats.get(tName).get(strategy);
                if (count == null) {
                    stats.get(tName).put(strategy, 1L);
                } else {
                    if (count == Long.MAX_VALUE) {
                        for (String k : stats.get(tName).keySet()) {
                            stats.get(tName).put(k, stats.get(tName).get(k) / 1000000000L);
                        }
                    }
                    stats.get(tName).put(strategy, count + 1L);
                }
            }
        }
    }

    private void printStats(String tName) {
        Map<String, Long> s = stats.get(tName);
        for (String key : s.keySet()) {
            this._robot.out.printf("%s : %s : %d\n", tName, key, s.get(key));
        }
    }

    @Override
    public void onWin(WinEvent event) {
        this.saveStats();
    }

    @Override
    public void onDeath(DeathEvent event) {
        this.saveStats();
    }

    private void saveStats() {
        ObjectOutputStream w = null;
        try {
            w = new ObjectOutputStream((OutputStream)new RobocodeFileOutputStream(this._robot.getDataFile("gunner.dat")));
            w.writeObject(stats);
            w.close();
        }
        catch (IOException e) {
            this._robot.out.println("IOException trying to write: ");
            e.printStackTrace(this._robot.out);
        }
    }

    private Map<String, Map<String, Long>> loadStats() {
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(this._robot.getDataFile("gunner.dat")));
            Object o = ois.readObject();
            ois.close();
            return (Map)o;
        }
        catch (Exception e) {
            this._robot.out.println("Exception trying to read: ");
            e.printStackTrace(this._robot.out);
            return new HashMap<String, Map<String, Long>>();
        }
    }
}

