/*
 * Decompiled with CFR 0.152.
 */
package muf.utils;

import java.awt.geom.Point2D;
import java.util.Iterator;
import muf.utils.GameData;
import muf.utils.IndexMaker;
import muf.utils.RollingAverage;
import muf.utils.Targeting;
import muf.utils.TargetingEvaluator;
import muf.utils.VirtualBullet;

public class AdvancedTargetingEvaluator
extends TargetingEvaluator {
    protected IndexMaker distanceIM;
    protected IndexMaker bulletPowerIM;
    protected RollingAverage[][] successRateArray;
    protected double lastAimEnemyDistance;

    public AdvancedTargetingEvaluator(Targeting targeting, GameData gameData, IndexMaker indexMaker, IndexMaker indexMaker2) {
        this(targeting, gameData, indexMaker, indexMaker2, 0);
    }

    public AdvancedTargetingEvaluator(Targeting targeting, GameData gameData, IndexMaker indexMaker, IndexMaker indexMaker2, int n) {
        super(targeting, gameData, n);
        this.distanceIM = indexMaker;
        this.bulletPowerIM = indexMaker2;
        this.successRateArray = new RollingAverage[indexMaker.getMaxIndex() + 1][indexMaker2.getMaxIndex() + 1];
        int n2 = 0;
        while (n2 <= indexMaker.getMaxIndex()) {
            int n3 = 0;
            while (n3 <= indexMaker2.getMaxIndex()) {
                this.successRateArray[n2][n3] = new RollingAverage(n);
                ++n3;
            }
            ++n2;
        }
    }

    public void virtualAim(double d) {
        super.virtualAim(d);
        this.lastAimEnemyDistance = this.gameData.enemyDistance;
    }

    public void virtualFire(double d) {
        this.targeting.notifyFire(d);
        DataVirtualBullet dataVirtualBullet = new DataVirtualBullet(0, this.gameData.time, this.gameData.myX, this.gameData.myY, d, this.angle, this.lastAimEnemyDistance);
        this.virtualBullets.add(dataVirtualBullet);
    }

    public void evaluateBullets() {
        Iterator iterator = this.virtualBullets.iterator();
        while (iterator.hasNext()) {
            DataVirtualBullet dataVirtualBullet = (DataVirtualBullet)iterator.next();
            Point2D point2D = dataVirtualBullet.virtualBullet.position(this.gameData.time);
            int n = this.distanceIM.getIndex(dataVirtualBullet.enemyDistance);
            int n2 = this.bulletPowerIM.getIndex(dataVirtualBullet.bulletPower);
            if (dataVirtualBullet.virtualBullet.hit(this.gameData.time, this.gameData.enemyX, this.gameData.enemyY)) {
                this.successRateArray[n][n2].add(100.0);
                iterator.remove();
                continue;
            }
            if (!dataVirtualBullet.virtualBullet.missed(this.gameData.time, this.gameData.enemyX, this.gameData.enemyY)) continue;
            this.successRateArray[n][n2].add(0.0);
            iterator.remove();
        }
    }

    public double getSuccessRate(double d, double d2) {
        int n = this.distanceIM.getIndex(d);
        int n2 = this.bulletPowerIM.getIndex(d2);
        return this.successRateArray[n][n2].getValue();
    }

    protected class DataVirtualBullet {
        public VirtualBullet virtualBullet;
        public double enemyDistance;
        public double bulletPower;

        public DataVirtualBullet(int n, long l, double d, double d2, double d3, double d4, double d5) {
            this.virtualBullet = new VirtualBullet(n, l, d, d2, d3, d4);
            this.enemyDistance = d5;
            this.bulletPower = d3;
        }
    }
}

