/*
 * Decompiled with CFR 0.152.
 */
package gre.svman4.guns.LearningGuns.guessFactorGun;

import gre.svman4.attack.Attack;
import gre.svman4.attack.AttackLog;
import gre.svman4.guns.GunInformation;
import gre.svman4.guns.LearningGuns.LearningGun;
import gre.svman4.guns.LearningGuns.guessFactorGun.IEnemyInfo;
import gre.svman4.useful.FieldPoint;
import gre.svman4.useful.MotionState;
import gre.svman4.useful.RobotState;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import robocode.AdvancedRobot;
import robocode.RobocodeFileOutputStream;
import robocode.Rules;
import robocode.util.Utils;

public class GuessFactorGun
extends LearningGun {
    private AdvancedRobot _mineAdvancedRobot;
    private static final HashMap<String, EnemyInfo> enemies = new HashMap();
    private Rectangle2D.Double _battlefield;

    public GuessFactorGun(AdvancedRobot advRobot, RobotState mineRobot) {
        this(mineRobot);
        this._mineAdvancedRobot = advRobot;
    }

    @Override
    public void onPaint(Graphics2D paint) {
        super.onPaint(paint);
        paint.setColor(Color.GREEN);
        FieldPoint tempPoint = new FieldPoint();
        double temp = this._mineRobot.distance(this._target);
        paint.setColor(this.getColor(-100.0, -temp + 100.0, 100.0));
        paint.drawLine((int)this._mineRobot.x, (int)this._mineRobot.y, (int)this._target.x, (int)this._target.y);
        tempPoint.setLocation(this._mineRobot.getMeanPoint(this._target));
        paint.drawString(String.format("%.0fpx", temp), (int)tempPoint.x, (int)tempPoint.y);
    }

    public GuessFactorGun(RobotState mineRobot) {
        super(mineRobot);
        this._mineRobot = mineRobot;
    }

    private void insertEnemy(RobotState enemy) {
        EnemyInfo info = new EnemyInfo();
        info.loadFactorsFromFile(this._mineAdvancedRobot, enemy.name);
        enemies.put(enemy.name, info);
    }

    public double calculateBulletPower() {
        if (this._target == null) {
            return 0.0;
        }
        double distance = this._target.distance(this._mineRobot);
        double answer = Math.min(2.0 * (300.0 / distance), this._target.energy / 3.0);
        return answer;
    }

    @Override
    public void setTarget(RobotState enemy) {
        this._target = enemy;
    }

    @Override
    public GunInformation getFiringInformation() {
        if (!this._target.alive) {
            return null;
        }
        EnemyInfo info = enemies.get(this._target.name);
        if (info == null) {
            this.insertEnemy(this._target);
        }
        GunInformation shootingInfo = new GunInformation();
        shootingInfo.bulletPower = this.calculateBulletPower();
        int wallDistanceIndex = this.getIndex(this.calculateTargetDistanceFromWall(this._target), 100.0, 5);
        int distanceIndex = this.getIndex(this._mineRobot.distance(this._target), 600.0, 6);
        int velocityIndex = this.getIndex(this._target.velocity, 8.0, 4);
        int mostVisitedBin = 22;
        double bestValue = info.factors[velocityIndex][wallDistanceIndex][distanceIndex][mostVisitedBin];
        int i = 0;
        while (i < 45) {
            if (info.factors[velocityIndex][wallDistanceIndex][distanceIndex][i] > bestValue) {
                bestValue = info.factors[velocityIndex][wallDistanceIndex][distanceIndex][i];
                mostVisitedBin = i;
            }
            ++i;
        }
        double directAngle = this._mineRobot.getAngleTo(this._target);
        double binWidth = this._target.getMaxEscapeAngle(Rules.getBulletSpeed((double)shootingInfo.bulletPower)) / 22.0;
        double angle = (double)this._mineRobot.getLateralDirection(this._target) * binWidth * (double)(mostVisitedBin - 22);
        shootingInfo.shootingAngle = directAngle + angle;
        return shootingInfo;
    }

    @Override
    public String getName() {
        return "GuessFactorGun";
    }

    private double calculateTargetDistanceFromWall(MotionState target) {
        FieldPoint temp;
        if (target.velocity == 0.0) {
            return 2000.0;
        }
        int i = 0;
        while (this._battlefield.contains(temp = target.project((double)(++i) * target.velocity, target.heading))) {
        }
        return Math.abs((double)(i - 1) * target.velocity);
    }

    @Override
    public void learn(Attack attack) {
        AttackLog shooterLog = attack._shooterLog;
        AttackLog targetLog = attack._targetLog;
        AttackLog hitTargetLog = attack._hitTargetLog;
        double directAngle = shooterLog.robotPoint.getAngleTo(targetLog.robotPoint);
        double offsetAngle = shooterLog.robotPoint.getAngleTo(hitTargetLog.robotPoint) - directAngle;
        double factor = Utils.normalRelativeAngle((double)offsetAngle) / shooterLog.robotPoint.getMaxEscapeAngle(attack._velocity) * (double)shooterLog.robotPoint.getLateralDirection(targetLog.robotPoint);
        int factorIndex = (int)GuessFactorGun.limit(0.0, factor * 22.0 + 22.0, 44.0);
        int distanceIndex = this.getIndex(shooterLog.robotPoint.distance(targetLog.robotPoint), 600.0, 6);
        int wallDistanceIndex = this.getIndex(this.calculateTargetDistanceFromWall(targetLog.robotPoint), 100.0, 5);
        int velocityIndex = this.getIndex(Math.abs(targetLog.robotPoint.velocity), 8.0, 4);
        EnemyInfo info = enemies.get(attack._targetRobot.name);
        if (info == null) {
            info = new EnemyInfo();
            enemies.put(attack._targetRobot.name, info);
        }
        int velocityCount = 0;
        while (velocityCount < 4) {
            int wallDistanceCount = 0;
            while (wallDistanceCount < 5) {
                int distanceCount = 0;
                while (distanceCount < 6) {
                    int offsetCount = 0;
                    while (offsetCount < 45) {
                        info.factors[velocityCount][wallDistanceCount][distanceCount][offsetCount] = GuessFactorGun.rollingAvg(info.factors[velocityCount][wallDistanceCount][distanceCount][offsetCount], 1.0 / (Math.pow(factorIndex - offsetCount, 2.0) + Math.pow(distanceIndex - distanceCount, 2.0) + Math.pow(velocityIndex - velocityCount, 2.0) + Math.pow(wallDistanceIndex - wallDistanceCount, 2.0) + 1.0), Math.min(info.rollingAverageCounter, 50L), 1.0);
                        ++offsetCount;
                    }
                    ++distanceCount;
                }
                ++wallDistanceCount;
            }
            ++velocityCount;
        }
        ++info.rollingAverageCounter;
    }

    private int getIndex(double value, double maxValue, int bins) {
        double index = value * (double)bins / maxValue;
        return (int)Math.floor(GuessFactorGun.limit(1.0, index, bins) - 1.0);
    }

    public void setBattleField(Rectangle2D.Double _battleField) {
        this._battlefield = _battleField;
    }

    @Override
    public void onBattleEnd() {
        for (IEnemyInfo iEnemyInfo : enemies.values()) {
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private class EnemyInfo
    implements IEnemyInfo {
        public long rollingAverageCounter = 0L;
        public double[][][][] factors;

        private EnemyInfo() {
        }

        public void saveFactorsToFile(AdvancedRobot mineRobot, String enemyName) {
            try {
                ZipOutputStream zipout = new ZipOutputStream((OutputStream)new RobocodeFileOutputStream(mineRobot.getDataFile(String.valueOf(enemyName) + ".gun.zip")));
                zipout.putNextEntry(new ZipEntry(enemyName));
                ObjectOutputStream out = new ObjectOutputStream(zipout);
                out.writeObject(this.factors);
                out.flush();
                zipout.closeEntry();
                out.close();
            }
            catch (IOException e) {
                System.out.println("Error saving factors:" + e);
            }
        }

        public void loadFactorsFromFile(AdvancedRobot mineRobot, String enemyName) {
            try {
                ZipInputStream zipInput = new ZipInputStream(new FileInputStream(mineRobot.getDataFile(String.valueOf(enemyName) + ".gun.zip")));
                zipInput.getNextEntry();
                ObjectInputStream oi = new ObjectInputStream(zipInput);
                this.factors = (double[][][][])oi.readObject();
                oi.close();
            }
            catch (IOException | ClassNotFoundException ex) {
                this.factors = new double[4][5][6][45];
                System.out.println("New enemy found. Create new index");
            }
        }
    }
}

