/*
 * Decompiled with CFR 0.152.
 */
package vStar;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.RobotDeathEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.StatusEvent;
import vStar.AttractionType;
import vStar.EnergyDeltaStatistics;
import vStar.HistoryBullet;
import vStar.LinearEquation;
import vStar.MathMethods;
import vStar.PointCommon;
import vStar.PointOfAttraction;
import vStar.PointSuggest2Move;
import vStar.PointThatMoves;
import vStar.SensorGroup;
import vStar.SensorRelativeCircle;
import vStar.SensorStaticCircle;
import vStar.TankCommon;
import vStar.TankEnemy;

public class RAFzilla
extends AdvancedRobot {
    final int FULL_POWER_RADIUS = 150;
    final int PVP_RADIUS = 200;
    final int MIDDLE_RADIUS = 400;
    final int FAR_PSEUDO_RADIUS = 600;
    final int BORDER_PVP_MID = 250;
    final int BORDER_MID_FAR = 500;
    private int last_get_others = 20;
    private int my_fault_hits_count = 0;
    private boolean does_fault_hit_this_frame;
    private int turn_right_if_hits = 1;
    private int lucky_bullet_hits = 0;
    public Map<Long, PointCommon> movement_history = new TreeMap<Long, PointCommon>();
    static Map<String, EnergyDeltaStatistics> history_of_stat_per_distance = new HashMap<String, EnergyDeltaStatistics>();
    final int SURFING_MAX_TURN_COUNT = 100;
    ArrayList<PointOfAttraction> attraction_points = new ArrayList();
    SensorGroup safe_field_center;
    public Map<String, TankEnemy> enemy_list = new HashMap<String, TankEnemy>();
    private ArrayList<HistoryBullet> moving_bullet_pool = new ArrayList();
    private PointSuggest2Move[] move_variants;
    private int going_forward = 0;
    private int going_turn_right = 0;

    public TankCommon as_common_tank() {
        double acceleration;
        double d = acceleration = this.going_forward > 0 == 0.0 < this.getVelocity() ? 1.0 : 2.0;
        if (this.getVelocity() == 0.0 && this.going_forward != 0) {
            acceleration = 1.0;
        }
        acceleration = this.going_forward > 0 ? acceleration : -acceleration;
        return new TankCommon(this.getX(), this.getY(), this.getVelocity(), this.getHeadingRadians(), acceleration, (double)this.going_turn_right * Rules.getTurnRateRadians((double)Math.abs(this.getVelocity())));
    }

    public void onPaint(Graphics2D frameGraf) {
        PointSuggest2Move[] pointSuggest2MoveArray = this.move_variants;
        int n = this.move_variants.length;
        int n2 = 0;
        while (n2 < n) {
            PointSuggest2Move point = pointSuggest2MoveArray[n2];
            point.draw_point(frameGraf);
            ++n2;
        }
        for (Map.Entry<String, TankEnemy> enemy : this.enemy_list.entrySet()) {
            enemy.getValue().draw_point(frameGraf);
        }
        for (PointOfAttraction attr_point : this.attraction_points) {
            attr_point.draw_point(frameGraf, Color.pink, 15);
        }
        this.safe_field_center.draw(frameGraf);
        frameGraf.setColor(Color.cyan);
        int temp_rad = 400;
        frameGraf.drawOval((int)(this.getX() - (double)temp_rad), (int)(this.getY() - (double)temp_rad), temp_rad * 2, temp_rad * 2);
        frameGraf.setColor(Color.cyan);
        temp_rad = 250;
        frameGraf.drawOval((int)(this.getX() - (double)temp_rad), (int)(this.getY() - (double)temp_rad), temp_rad * 2, temp_rad * 2);
        frameGraf.setColor(Color.cyan);
        temp_rad = 500;
        frameGraf.drawOval((int)(this.getX() - (double)temp_rad), (int)(this.getY() - (double)temp_rad), temp_rad * 2, temp_rad * 2);
    }

    public void onStatus(StatusEvent e) {
        if (this.move_variants == null) {
            SensorRelativeCircle frontSensor = new SensorRelativeCircle(this, 0.0, this.getWidth(), this.getWidth() + 2.0);
            SensorRelativeCircle leftSensor = new SensorRelativeCircle(this, -1.5707963267948966, this.getWidth(), this.getWidth() / 2.0 + 2.0);
            SensorRelativeCircle backSensor = new SensorRelativeCircle(this, 0.0, -this.getWidth(), this.getWidth() + 2.0);
            SensorRelativeCircle rightSensor = new SensorRelativeCircle(this, 1.5707963267948966, this.getWidth(), this.getWidth() / 2.0 + 2.0);
            this.move_variants = new PointSuggest2Move[]{new PointSuggest2Move(this, 100.0, 0.7853981633974483, new SensorGroup(rightSensor, new SensorRelativeCircle(this, 0.7853981633974483, this.getWidth() * 1.41421, this.getWidth() / 2.0 + 2.0), frontSensor)), new PointSuggest2Move(this, 100.0, 0.0, frontSensor), new PointSuggest2Move(this, 100.0, -0.7853981633974483, new SensorGroup(frontSensor, new SensorRelativeCircle(this, -0.7853981633974483, this.getWidth() * 1.41421, this.getWidth() / 2.0 + 2.0), leftSensor)), new PointSuggest2Move(this, -100.0, 0.7853981633974483, new SensorGroup(leftSensor, new SensorRelativeCircle(this, 0.7853981633974483, this.getWidth() * -1.41421, this.getWidth() / 2.0 + 2.0), backSensor)), new PointSuggest2Move(this, -100.0, 0.0, backSensor), new PointSuggest2Move(this, -100.0, -0.7853981633974483, new SensorGroup(backSensor, new SensorRelativeCircle(this, -0.7853981633974483, this.getWidth() * -1.41421, this.getWidth() / 2.0 + 2.0), rightSensor))};
            double sens_radius = this.getBattleFieldHeight() / 4.0;
            double left_right_padding = this.getBattleFieldHeight() / 2.0 - sens_radius;
            double vertical_center = this.getBattleFieldHeight() / 2.0;
            this.safe_field_center = new SensorGroup(new SensorStaticCircle(left_right_padding + sens_radius, vertical_center, sens_radius), new SensorStaticCircle(this.getBattleFieldWidth() / 2.0, vertical_center, sens_radius), new SensorStaticCircle(this.getBattleFieldWidth() - left_right_padding - sens_radius, vertical_center, sens_radius));
        }
        this.movement_history.put(e.getTime(), new PointCommon(this.getX(), this.getY()));
        if (this.last_get_others < this.enemy_list.size()) {
            this.out.println("Clear list of all robots.");
            this.enemy_list.clear();
        }
        this.last_get_others = this.getOthers();
        int maxWarn = 0;
        int rotateRight = 0;
        for (Map.Entry<String, TankEnemy> enemy : this.enemy_list.entrySet()) {
            enemy.getValue().rotate_accelerate_move(e.getTime());
            if (enemy.getValue().get_time_not_refresh() > maxWarn) {
                maxWarn = enemy.getValue().get_time_not_refresh();
            }
            rotateRight += enemy.getValue().reason_rotate_radar_right();
        }
        if (this.enemy_list.size() < this.getOthers() || maxWarn > 10) {
            this.setTurnRadarRight(45.0);
        } else if (rotateRight > 0) {
            this.setTurnRadarRight(45.0);
        } else {
            this.setTurnRadarLeft(45.0);
        }
        Iterator<PointOfAttraction> point_iter = this.attraction_points.iterator();
        while (point_iter.hasNext()) {
            PointOfAttraction attr_point = point_iter.next();
            if (!attr_point.should_be_removed(e.getTime())) continue;
            point_iter.remove();
        }
        boolean clamp_avoidance_found = false;
        boolean surfing_or_delay_found = false;
        for (PointOfAttraction attr_point : this.attraction_points) {
            if (attr_point.type == AttractionType.clamp_avoidance) {
                clamp_avoidance_found = true;
            }
            if (attr_point.type != AttractionType.surfing && attr_point.type != AttractionType.surfing_delay) continue;
            surfing_or_delay_found = true;
        }
        if (!clamp_avoidance_found && 1 < this.enemy_list.size()) {
            TankCommon my_tank = this.as_common_tank();
            ArrayList<TankEnemy> enemyes_near = new ArrayList<TankEnemy>();
            for (TankEnemy enemy : this.enemy_list.values()) {
                if (!enemy.is_in_circle(my_tank, 400.0)) continue;
                enemyes_near.add(enemy);
            }
            if (1 < enemyes_near.size() && !this.safe_field_center.is_in_sensor(my_tank).booleanValue()) {
                double max_heading_delta = 0.0;
                while (1 < enemyes_near.size()) {
                    TankEnemy cur_enemy = (TankEnemy)enemyes_near.get(0);
                    enemyes_near.remove(cur_enemy);
                    double cur_heading = my_tank.get_heading(cur_enemy);
                    for (TankEnemy enemy : enemyes_near) {
                        double heading_delta = Math.abs(MathMethods.normalize_rads(my_tank.get_heading(enemy) - cur_heading));
                        if (!(max_heading_delta < heading_delta)) continue;
                        max_heading_delta = heading_delta;
                    }
                }
                if (1.0471975511965976 < max_heading_delta) {
                    long frames2live = (long)(my_tank.get_distance_to(new PointCommon(this.getBattleFieldWidth() / 2.0, this.getBattleFieldHeight() / 2.0)) / 8.0 * 0.8);
                    this.attraction_points.add(new PointOfAttraction(this.getBattleFieldWidth() / 2.0, this.getBattleFieldHeight() / 2.0, AttractionType.clamp_avoidance, e.getTime() + frames2live, false));
                }
            }
        }
        if (!surfing_or_delay_found) {
            long surfing_end_time = e.getTime() + (long)((int)(Math.random() * 101.0));
            this.attraction_points.add(new PointOfAttraction(Math.random() * (this.getBattleFieldWidth() + 1.0), Math.random() * (this.getBattleFieldHeight() + 1.0), AttractionType.surfing, surfing_end_time, false));
            this.attraction_points.add(new PointOfAttraction(0.0, 0.0, AttractionType.surfing_delay, surfing_end_time + (long)((int)(Math.random() * 101.0) * 2), false));
        }
        this.my_fault_hits_count = !this.does_fault_hit_this_frame ? 0 : ++this.my_fault_hits_count;
        this.does_fault_hit_this_frame = false;
        this.going_turn_right = 0;
        this.going_forward = 0;
        int turnType = 0;
        double maxReason = -1.0E12;
        int i = 0;
        while (i < this.move_variants.length) {
            this.move_variants[i].refresh_reason();
            if (this.move_variants[i].get_reason() > maxReason) {
                maxReason = this.move_variants[i].get_reason();
                turnType = i;
            }
            ++i;
        }
        if (5 < this.my_fault_hits_count && this.my_fault_hits_count % 3 == 0) {
            this.turn_right_if_hits = -this.turn_right_if_hits;
        }
        if (this.move_variants[turnType].get_reason() < -100000.0 || this.my_fault_hits_count > 3) {
            this.setStop();
            this.setTurnRight(this.turn_right_if_hits * 10);
            this.going_turn_right = this.turn_right_if_hits;
            this.going_forward = 0;
        } else {
            this.move_variants[turnType].set_choosen(true);
            switch (turnType) {
                case 0: {
                    this.going_turn_right = 1;
                    this.going_forward = 1;
                    break;
                }
                case 1: {
                    this.going_turn_right = 0;
                    this.going_forward = 1;
                    break;
                }
                case 2: {
                    this.going_turn_right = -1;
                    this.going_forward = 1;
                    break;
                }
                case 3: {
                    this.going_turn_right = 1;
                    this.going_forward = -1;
                    break;
                }
                case 4: {
                    this.going_turn_right = 0;
                    this.going_forward = -1;
                    break;
                }
                case 5: {
                    this.going_turn_right = -1;
                    this.going_forward = -1;
                }
            }
            this.setTurnRightRadians((double)this.going_turn_right * Rules.MAX_TURN_RATE_RADIANS);
            this.setAhead(this.going_forward * 100);
        }
        double shotPow = 1.0;
        double rot = 1.0E9;
        double tempRot = 0.0;
        double minRast = 1.0E9;
        double minRastRot = 1.0E9;
        for (Map.Entry<String, TankEnemy> enemy : this.enemy_list.entrySet()) {
            if (!(minRast > enemy.getValue().get_distance2main())) continue;
            minRast = enemy.getValue().get_distance2main();
        }
        if (minRast < 150.0) {
            shotPow = 3.0;
        } else {
            double FAR_AWAY_SHOT_POW = 0.3;
            int FAR_AWAY_DISTANCE = 700;
            shotPow = 3.0 + (FAR_AWAY_SHOT_POW - 3.0) / (double)(FAR_AWAY_DISTANCE - 150) * (minRast - 150.0);
            if (shotPow < 0.1) {
                shotPow = 0.1;
            }
        }
        for (Map.Entry<String, TankEnemy> enemy : this.enemy_list.entrySet()) {
            if (!(enemy.getValue().get_distance2main() < minRast * 2.0)) continue;
            tempRot = enemy.getValue().reason_rotate_gun_right(shotPow, e.getTime());
            if (enemy.getValue().get_distance2main() == minRast) {
                if (Math.abs(tempRot) < 0.3490658503988659) {
                    rot = tempRot;
                    break;
                }
                minRastRot = tempRot;
            }
            if (!(Math.abs(rot) > Math.abs(tempRot))) continue;
            rot = tempRot;
        }
        if (Math.abs(rot) > 0.3490658503988659) {
            rot = minRastRot;
        }
        this.setTurnGunRightRadians(rot);
        if (0.2 <= this.getEnergy() && this.getGunHeat() == 0.0) {
            String enemy_target = "";
            double distance = 1000000.0;
            double reasonShot = -100.0;
            for (Map.Entry<String, TankEnemy> enemy : this.enemy_list.entrySet()) {
                double distance2current = enemy.getValue().get_distance2main();
                double tempPower = 0.0;
                if (distance2current < 150.0) {
                    tempPower = enemy.getValue().reason_shot_with_power(shotPow, e.getTime(), true);
                }
                if (tempPower == 0.0) {
                    tempPower = enemy.getValue().reason_shot_with_power(shotPow, e.getTime());
                }
                if (!(0.1 <= tempPower) || !(tempPower <= 3.0) || !(Math.abs(reasonShot - shotPow) > Math.abs(tempPower - shotPow))) continue;
                enemy_target = enemy.getKey();
                distance = distance2current;
                reasonShot = tempPower;
            }
            double max_energy_shot = this.getEnergy() - 0.2;
            if (max_energy_shot < reasonShot) {
                reasonShot = max_energy_shot;
            }
            if (reasonShot != -100.0) {
                if (reasonShot < 0.75) {
                    this.setBulletColor(Color.red);
                } else if (reasonShot < 1.25) {
                    this.setBulletColor(Color.yellow);
                } else if (reasonShot < 2.25) {
                    this.setBulletColor(Color.blue);
                } else if (reasonShot < 3.0) {
                    this.setBulletColor(Color.black);
                }
                this.moving_bullet_pool.add(new HistoryBullet(enemy_target, distance, this.setFireBullet(reasonShot)));
            }
        }
        if (this.getEnergy() < 15.0) {
            this.setBodyColor(Color.red);
            this.setGunColor(Color.red);
            this.setRadarColor(Color.white);
        } else if (this.getOthers() == 1) {
            this.setBodyColor(new Color(255, 215, 0));
            this.setGunColor(new Color(192, 192, 192));
            this.setRadarColor(new Color(192, 192, 192));
        }
    }

    public void run() {
        this.setColors(new Color(60, 53, 49), new Color(228, 81, 63), Color.red, Color.red, Color.yellow);
        while (true) {
            this.execute();
        }
    }

    public void onRobotDeath(RobotDeathEvent e) {
        if (this.enemy_list.containsKey(e.getName())) {
            this.save_all_stats();
            this.enemy_list.remove(e.getName());
        }
    }

    public void onHitRobot(HitRobotEvent e) {
        String enemy_hit_name = e.getName();
        if (e.isMyFault()) {
            this.does_fault_hit_this_frame = true;
        }
        if (!this.enemy_list.containsKey(enemy_hit_name)) {
            this.enemy_list.put(enemy_hit_name, new TankEnemy(this, history_of_stat_per_distance.get(enemy_hit_name)));
        }
        this.enemy_list.get(enemy_hit_name).renew_movement_data(e.getBearingRadians(), this.getWidth(), 0.0, 0.0, e.getTime());
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        String enemy_scanned_name = e.getName();
        if (!this.enemy_list.containsKey(enemy_scanned_name)) {
            this.enemy_list.put(enemy_scanned_name, new TankEnemy(this, history_of_stat_per_distance.get(enemy_scanned_name)));
        }
        this.enemy_list.get(enemy_scanned_name).renew_movement_data(e.getBearingRadians(), e.getDistance(), e.getHeadingRadians(), e.getVelocity(), e.getTime());
    }

    HistoryBullet extract_history_bullet(Bullet bullet2find) {
        HistoryBullet history_rec = null;
        for (HistoryBullet cur_history_rec : this.moving_bullet_pool) {
            if (!cur_history_rec.linked_bullet.equals((Object)bullet2find)) continue;
            history_rec = cur_history_rec;
            break;
        }
        this.moving_bullet_pool.remove(history_rec);
        return history_rec;
    }

    void register_bullet_succes(String enemy_name, double points, double distance) {
        TankEnemy cur_enemy;
        if (this.getOthers() == 1 && (cur_enemy = this.enemy_list.get(enemy_name)) != null) {
            cur_enemy.stat_per_distance.register_bullet_succes(points, distance);
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        if (this.getOthers() == 1) {
            double opposite_radians = MathMethods.normalize_rads(e.getHeadingRadians() + Math.PI);
            PointThatMoves bullet = new PointThatMoves(e.getBullet().getX(), e.getBullet().getY(), e.getVelocity(), opposite_radians);
            LinearEquation bullet_way = new LinearEquation(bullet, this);
            TankEnemy enemy_shot_me = this.enemy_list.get(e.getName());
            if (enemy_shot_me != null) {
                Long cur_time = e.getTime();
                HashMap<Long, PointCommon> points_can_shoot_from = bullet_way.filter_points_in_distance(enemy_shot_me.movement_history, 0.1);
                PointCommon point_shoot_from = null;
                Long time_shoot_from = -1L;
                for (Map.Entry<Long, PointCommon> time_n_location : points_can_shoot_from.entrySet()) {
                    PointThatMoves temp_bullet = new PointThatMoves(bullet);
                    Long candidate_shoot_at = time_n_location.getKey();
                    PointCommon candidate_shoot_from = time_n_location.getValue();
                    temp_bullet.move_x_times(cur_time - candidate_shoot_at);
                    if (!(temp_bullet.get_distance_to(candidate_shoot_from) < 0.1)) continue;
                    point_shoot_from = candidate_shoot_from;
                    time_shoot_from = candidate_shoot_at;
                    break;
                }
                if (point_shoot_from == null) {
                    double smallest_error = 1000000.0;
                    points_can_shoot_from = bullet_way.filter_points_in_distance(enemy_shot_me.movement_history, 50.0);
                    for (Map.Entry<Long, PointCommon> time_n_location : points_can_shoot_from.entrySet()) {
                        PointThatMoves temp_bullet = new PointThatMoves(bullet);
                        Long candidate_shoot_at = time_n_location.getKey();
                        PointCommon candidate_shoot_from = time_n_location.getValue();
                        temp_bullet.move_x_times(cur_time - candidate_shoot_at);
                        double cur_location_error = temp_bullet.get_distance_to(candidate_shoot_from);
                        if (!(cur_location_error < smallest_error)) continue;
                        point_shoot_from = candidate_shoot_from;
                        time_shoot_from = candidate_shoot_at;
                        smallest_error = cur_location_error;
                    }
                }
                double shot_distance = point_shoot_from.get_distance_to(this.movement_history.get(time_shoot_from));
                this.register_bullet_succes(e.getName(), -Rules.getBulletDamage((double)e.getPower()), shot_distance);
            }
        }
    }

    public void onBulletHit(BulletHitEvent event) {
        HistoryBullet history_rec = this.extract_history_bullet(event.getBullet());
        if (history_rec.enemy_target == event.getName()) {
            this.register_bullet_succes(history_rec.enemy_target, Rules.getBulletHitBonus((double)history_rec.linked_bullet.getPower()), history_rec.distance);
        } else {
            ++this.lucky_bullet_hits;
        }
    }

    public void onBulletHitBullet(BulletHitBulletEvent event) {
        this.extract_history_bullet(event.getBullet());
        ++this.lucky_bullet_hits;
    }

    public void onBulletMissed(BulletMissedEvent event) {
        HistoryBullet history_rec = this.extract_history_bullet(event.getBullet());
        this.register_bullet_succes(history_rec.enemy_target, -history_rec.linked_bullet.getPower(), history_rec.distance);
    }

    void save_all_stats() {
        if (this.enemy_list.size() == 1) {
            String last_enemy_name = (String)this.enemy_list.keySet().toArray()[0];
            history_of_stat_per_distance.put(last_enemy_name, this.enemy_list.get((Object)last_enemy_name).stat_per_distance);
        }
    }

    public void onDeath(DeathEvent e) {
        this.save_all_stats();
    }
}

