/*
 * Decompiled with CFR 0.152.
 */
package amarok;

import amarok.Arena;
import amarok.BotConstants;
import amarok.BotMath;
import amarok.FireDisabled;
import amarok.FireSelected;
import amarok.FireWinner;
import amarok.GuiLogger;
import amarok.LineCirclePrediction;
import amarok.LinearPrediction;
import amarok.Manager;
import amarok.MoveAntiGravity;
import amarok.MoveMelee;
import amarok.MoveWinner;
import amarok.NarrowScan;
import amarok.SelectNearest;
import amarok.SelectOne2One;
import amarok.SittingDuckPrediction;
import amarok.WallsPrediction;
import amarok.WideScan;
import amarok.WinnerPrediction;
import java.awt.Color;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitWallEvent;
import robocode.Robot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;

public class Rookie
extends AdvancedRobot
implements BotConstants {
    private Arena arena;

    public void run() {
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setColors(Color.black, Color.black, new Color(255, 0, 0));
        this.setMaxVelocity(8.0);
        this.arena = new Arena(this, this.getBattleFieldWidth(), this.getBattleFieldHeight());
        new BotMath(this.arena);
        new GuiLogger(this, this.getBattleFieldHeight(), false);
        WideScan wideScan = new WideScan(this.arena);
        NarrowScan narrowScan = new NarrowScan(this.arena);
        FireSelected fireSelected = new FireSelected(this.arena);
        FireWinner fireWinner = new FireWinner(this.arena);
        FireDisabled fireDisabled = new FireDisabled(this.arena);
        MoveAntiGravity moveAntiGravity = new MoveAntiGravity(this.arena);
        MoveMelee moveMelee = new MoveMelee(this.arena);
        MoveWinner moveWinner = new MoveWinner(this.arena);
        SelectNearest selectNearest = new SelectNearest(this.arena);
        SelectOne2One selectOne2One = new SelectOne2One(this.arena);
        LineCirclePrediction lineCirclePrediction = new LineCirclePrediction(this.arena);
        SittingDuckPrediction sittingDuckPrediction = new SittingDuckPrediction(this.arena);
        WallsPrediction wallsPrediction = new WallsPrediction(this.arena);
        LinearPrediction linearPrediction = new LinearPrediction(this.arena);
        WinnerPrediction winnerPrediction = new WinnerPrediction(this.arena);
        Manager scanManager = new Manager();
        scanManager.addStrategy(wideScan);
        scanManager.addStrategy(narrowScan);
        Manager fireManager = new Manager();
        fireManager.addStrategy(fireSelected);
        fireManager.addStrategy(fireWinner);
        fireManager.addStrategy(fireDisabled);
        Manager moveManager = new Manager();
        moveManager.addStrategy(moveAntiGravity);
        moveManager.addStrategy(moveWinner);
        moveManager.addStrategy(moveMelee);
        Manager targettingManager = new Manager();
        targettingManager.addStrategy(selectNearest);
        targettingManager.addStrategy(selectOne2One);
        Manager predictingManager = new Manager();
        predictingManager.addStrategy(wallsPrediction);
        predictingManager.addStrategy(winnerPrediction);
        predictingManager.addStrategy(linearPrediction);
        while (true) {
            moveManager.doOneTurn();
            scanManager.doOneTurn();
            fireManager.doOneTurn();
            if (!this.arena.getFireSolution().isSolved()) {
                targettingManager.doOneTurn();
                predictingManager.doOneTurn();
            }
            if (this.arena.isFired()) {
                this.arena.setFired(false);
                continue;
            }
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.arena.onScannedRobot(e);
    }

    public void onRobotDeath(RobotDeathEvent e) {
        this.arena.onRobotDeath(e);
    }

    public void onDeath(DeathEvent e) {
        this.arena.onDeath(e);
    }

    public void onWin(WinEvent e) {
        this.arena.onWin(e);
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.arena.onHitByBullet(e);
    }

    public void onBulletHit(BulletHitEvent e) {
        this.arena.onBulletHit(e);
    }

    public void onHitWall(HitWallEvent e) {
        System.out.println("hit the wall!!! " + this.getEnergy() + "|" + this.getEnergy());
    }

    public void onSkippedTurnEvent(SkippedTurnEvent e) {
        ((Robot)this).out.println("skipped turn!!!");
    }
}

